﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/codecatalyst/model/UpdateDevEnvironmentResult.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::CodeCatalyst::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

UpdateDevEnvironmentResult::UpdateDevEnvironmentResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

UpdateDevEnvironmentResult& UpdateDevEnvironmentResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("id")) {
    m_id = jsonValue.GetString("id");
    m_idHasBeenSet = true;
  }
  if (jsonValue.ValueExists("spaceName")) {
    m_spaceName = jsonValue.GetString("spaceName");
    m_spaceNameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("projectName")) {
    m_projectName = jsonValue.GetString("projectName");
    m_projectNameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("alias")) {
    m_alias = jsonValue.GetString("alias");
    m_aliasHasBeenSet = true;
  }
  if (jsonValue.ValueExists("ides")) {
    Aws::Utils::Array<JsonView> idesJsonList = jsonValue.GetArray("ides");
    for (unsigned idesIndex = 0; idesIndex < idesJsonList.GetLength(); ++idesIndex) {
      m_ides.push_back(idesJsonList[idesIndex].AsObject());
    }
    m_idesHasBeenSet = true;
  }
  if (jsonValue.ValueExists("instanceType")) {
    m_instanceType = InstanceTypeMapper::GetInstanceTypeForName(jsonValue.GetString("instanceType"));
    m_instanceTypeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("inactivityTimeoutMinutes")) {
    m_inactivityTimeoutMinutes = jsonValue.GetInteger("inactivityTimeoutMinutes");
    m_inactivityTimeoutMinutesHasBeenSet = true;
  }
  if (jsonValue.ValueExists("clientToken")) {
    m_clientToken = jsonValue.GetString("clientToken");
    m_clientTokenHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
