// This is free and unencumbered software released into the public domain.
//
// Anyone is free to copy, modify, publish, use, compile, sell, or
// distribute this software, either in source code form or as a compiled
// binary, for any purpose, commercial or non-commercial, and by any
// means.
//
// In jurisdictions that recognize copyright laws, the author or authors
// of this software dedicate any and all copyright interest in the
// software to the public domain. We make this dedication for the benefit
// of the public at large and to the detriment of our heirs and
// successors. We intend this dedication to be an overt act of
// relinquishment in perpetuity of all present and future rights to this
// software under copyright law.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
// IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
// OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// OTHER DEALINGS IN THE SOFTWARE.
//
// For more information, please refer to <https://unlicense.org>

package verkle

import (
	"errors"

	"github.com/crate-crypto/go-ipa/banderwagon"
)

type (
	Fr                        = banderwagon.Fr
	Point                     = banderwagon.Element
	SerializedPoint           = []byte
	SerializedPointCompressed = []byte
)

func FromLEBytes(fr *Fr, data []byte) error {
	if len(data) > LeafValueSize {
		return errors.New("data is too long")
	}
	var aligned [LeafValueSize]byte
	copy(aligned[:], data)
	fr.SetBytesLE(aligned[:])
	return nil
}

func StemFromLEBytes(fr *Fr, data []byte) error {
	if len(data) != StemSize {
		return errors.New("data length must be StemSize")
	}
	return FromLEBytes(fr, data)
}

func FromBytes(fr *Fr, data []byte) {
	var aligned [32]byte
	copy(aligned[32-len(data):], data)
	fr.SetBytes(aligned[:])
}

func HashPointToBytes(point *Point) [32]byte {
	var hashedPoint Fr
	point.MapToScalarField(&hashedPoint)
	return hashedPoint.BytesLE()
}
