// Copyright 2020-2025 Consensys Software Inc.
// Licensed under the Apache License, Version 2.0. See the LICENSE file for details.

// Code generated by consensys/gnark-crypto DO NOT EDIT

package kzg

import (
	"github.com/consensys/gnark-crypto/ecc/bw6-633"
	"io"

	"github.com/consensys/gnark-crypto/utils/unsafe"
)

// WriteTo writes binary encoding of the ProvingKey
func (pk *ProvingKey) WriteTo(w io.Writer) (int64, error) {
	return pk.writeTo(w)
}

// WriteRawTo writes binary encoding of ProvingKey to w without point compression
func (pk *ProvingKey) WriteRawTo(w io.Writer) (int64, error) {
	return pk.writeTo(w, bw6633.RawEncoding())
}

func (pk *ProvingKey) writeTo(w io.Writer, options ...func(*bw6633.Encoder)) (int64, error) {
	// encode the ProvingKey
	enc := bw6633.NewEncoder(w, options...)
	if err := enc.Encode(pk.G1); err != nil {
		return enc.BytesWritten(), err
	}
	return enc.BytesWritten(), nil
}

// WriteRawTo writes binary encoding of VerifyingKey to w without point compression
func (vk *VerifyingKey) WriteRawTo(w io.Writer) (int64, error) {
	return vk.writeTo(w, bw6633.RawEncoding())
}

// WriteTo writes binary encoding of the VerifyingKey
func (vk *VerifyingKey) WriteTo(w io.Writer) (int64, error) {
	return vk.writeTo(w)
}

func (vk *VerifyingKey) writeTo(w io.Writer, options ...func(*bw6633.Encoder)) (int64, error) {
	// encode the VerifyingKey
	enc := bw6633.NewEncoder(w, options...)
	nLines := 158
	toEncode := make([]interface{}, 0, 4*nLines+3)
	toEncode = append(toEncode, &vk.G2[0])
	toEncode = append(toEncode, &vk.G2[1])
	toEncode = append(toEncode, &vk.G1)
	for k := 0; k < 2; k++ {
		for j := 0; j < 2; j++ {
			for i := nLines - 1; i >= 0; i-- {
				toEncode = append(toEncode, &vk.Lines[k][j][i].R0)
				toEncode = append(toEncode, &vk.Lines[k][j][i].R1)
			}
		}
	}

	for _, v := range toEncode {
		if err := enc.Encode(v); err != nil {
			return enc.BytesWritten(), err
		}
	}

	return enc.BytesWritten(), nil
}

// WriteDump writes the binary encoding of the entire SRS memory representation
// It is meant to be use to achieve fast serialization/deserialization and
// is not compatible with WriteTo / ReadFrom. It does not do any validation
// and doesn't encode points in a canonical form.
// @unsafe: this is platform dependent and may not be compatible with other platforms
// @unstable: the format may change in the future
// If maxPkPoints is provided, the number of points in the ProvingKey will be limited to maxPkPoints
func (srs *SRS) WriteDump(w io.Writer, maxPkPoints ...int) error {
	maxG1 := len(srs.Pk.G1)
	if len(maxPkPoints) > 0 && maxPkPoints[0] < maxG1 && maxPkPoints[0] > 0 {
		maxG1 = maxPkPoints[0]
	}
	// first we write the VerifyingKey; it is small so we re-use WriteTo

	if _, err := srs.Vk.writeTo(w, bw6633.RawEncoding()); err != nil {
		return err
	}

	// write the marker
	if err := unsafe.WriteMarker(w); err != nil {
		return err
	}

	// write the slice
	return unsafe.WriteSlice(w, srs.Pk.G1[:maxG1])
}

// ReadDump deserializes the SRS from a reader, as written by WriteDump
func (srs *SRS) ReadDump(r io.Reader, maxPkPoints ...int) error {
	// first we read the VerifyingKey; it is small so we re-use ReadFrom
	_, err := srs.Vk.ReadFrom(r)
	if err != nil {
		return err
	}

	// read the marker
	if err := unsafe.ReadMarker(r); err != nil {
		return err
	}

	// read the slice
	srs.Pk.G1, _, err = unsafe.ReadSlice[[]bw6633.G1Affine](r, maxPkPoints...)
	return err
}

// WriteTo writes binary encoding of the entire SRS
func (srs *SRS) WriteTo(w io.Writer) (int64, error) {
	// encode the SRS
	var pn, vn int64
	var err error
	if pn, err = srs.Pk.WriteTo(w); err != nil {
		return pn, err
	}
	vn, err = srs.Vk.WriteTo(w)
	return pn + vn, err
}

// WriteRawTo writes binary encoding of the entire SRS without point compression
func (srs *SRS) WriteRawTo(w io.Writer) (int64, error) {
	// encode the SRS
	var pn, vn int64
	var err error
	if pn, err = srs.Pk.WriteRawTo(w); err != nil {
		return pn, err
	}
	vn, err = srs.Vk.WriteRawTo(w)
	return pn + vn, err
}

// ReadFrom decodes ProvingKey data from reader.
func (pk *ProvingKey) ReadFrom(r io.Reader) (int64, error) {
	// decode the ProvingKey
	dec := bw6633.NewDecoder(r)
	if err := dec.Decode(&pk.G1); err != nil {
		return dec.BytesRead(), err
	}
	return dec.BytesRead(), nil
}

// UnsafeReadFrom decodes ProvingKey data from reader without checking
// that point are in the correct subgroup.
func (pk *ProvingKey) UnsafeReadFrom(r io.Reader) (int64, error) {
	// decode the ProvingKey
	dec := bw6633.NewDecoder(r, bw6633.NoSubgroupChecks())
	if err := dec.Decode(&pk.G1); err != nil {
		return dec.BytesRead(), err
	}
	return dec.BytesRead(), nil
}

// ReadFrom decodes VerifyingKey data from reader.
func (vk *VerifyingKey) ReadFrom(r io.Reader) (int64, error) {
	// decode the VerifyingKey
	dec := bw6633.NewDecoder(r)
	nLines := 158
	toDecode := make([]interface{}, 0, 4*nLines+3)
	toDecode = append(toDecode, &vk.G2[0])
	toDecode = append(toDecode, &vk.G2[1])
	toDecode = append(toDecode, &vk.G1)
	for k := 0; k < 2; k++ {
		for j := 0; j < 2; j++ {
			for i := nLines - 1; i >= 0; i-- {
				toDecode = append(toDecode, &vk.Lines[k][j][i].R0)
				toDecode = append(toDecode, &vk.Lines[k][j][i].R1)
			}
		}
	}

	for _, v := range toDecode {
		if err := dec.Decode(v); err != nil {
			return dec.BytesRead(), err
		}
	}

	return dec.BytesRead(), nil
}

// ReadFrom decodes SRS data from reader.
func (srs *SRS) ReadFrom(r io.Reader) (int64, error) {
	// decode the VerifyingKey
	var pn, vn int64
	var err error
	if pn, err = srs.Pk.ReadFrom(r); err != nil {
		return pn, err
	}
	vn, err = srs.Vk.ReadFrom(r)
	return pn + vn, err
}

// UnsafeReadFrom decodes SRS data from reader without sub group checks
func (srs *SRS) UnsafeReadFrom(r io.Reader) (int64, error) {
	// decode the VerifyingKey
	var pn, vn int64
	var err error
	if pn, err = srs.Pk.UnsafeReadFrom(r); err != nil {
		return pn, err
	}
	vn, err = srs.Vk.ReadFrom(r)
	return pn + vn, err
}

// WriteTo writes binary encoding of a OpeningProof
func (proof *OpeningProof) WriteTo(w io.Writer) (int64, error) {
	enc := bw6633.NewEncoder(w)

	toEncode := []interface{}{
		&proof.H,
		&proof.ClaimedValue,
	}

	for _, v := range toEncode {
		if err := enc.Encode(v); err != nil {
			return enc.BytesWritten(), err
		}
	}

	return enc.BytesWritten(), nil
}

// ReadFrom decodes OpeningProof data from reader.
func (proof *OpeningProof) ReadFrom(r io.Reader) (int64, error) {
	dec := bw6633.NewDecoder(r)

	toDecode := []interface{}{
		&proof.H,
		&proof.ClaimedValue,
	}

	for _, v := range toDecode {
		if err := dec.Decode(v); err != nil {
			return dec.BytesRead(), err
		}
	}

	return dec.BytesRead(), nil
}

// WriteTo writes binary encoding of a BatchOpeningProof
func (proof *BatchOpeningProof) WriteTo(w io.Writer) (int64, error) {
	enc := bw6633.NewEncoder(w)

	toEncode := []interface{}{
		&proof.H,
		proof.ClaimedValues,
	}

	for _, v := range toEncode {
		if err := enc.Encode(v); err != nil {
			return enc.BytesWritten(), err
		}
	}

	return enc.BytesWritten(), nil
}

// ReadFrom decodes BatchOpeningProof data from reader.
func (proof *BatchOpeningProof) ReadFrom(r io.Reader) (int64, error) {
	dec := bw6633.NewDecoder(r)
	toDecode := []interface{}{
		&proof.H,
		&proof.ClaimedValues,
	}

	for _, v := range toDecode {
		if err := dec.Decode(v); err != nil {
			return dec.BytesRead(), err
		}
	}

	return dec.BytesRead(), nil
}
