/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ascii2image.core;

import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.text.html.HTMLEditorKit;
import net.htmlparser.jericho.Attribute;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.OutputDocument;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import org.stathissideris.ascii2image.core.ConversionOptions;
import org.stathissideris.ascii2image.graphics.BitmapRenderer;
import org.stathissideris.ascii2image.graphics.Diagram;
import org.stathissideris.ascii2image.text.TextGrid;

public class HTMLConverter
extends HTMLEditorKit {
    private static final String TAG_CLASS = "textdiagram";
    private static final String testDir = "tests/html-converter/";

    public static void main(String[] stringArray) {
        new HTMLConverter().convertHTMLFile("tests/html-converter/index.html", "tests/html-converter/index2.html", "ditaa_diagram", "images", null);
    }

    public boolean convertHTMLFile(String string, String string2, String string3, String string4, ConversionOptions conversionOptions) {
        String string5;
        Object object;
        String string6;
        if (conversionOptions == null) {
            conversionOptions = new ConversionOptions();
        }
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Error: cannot read file " + string);
            return false;
        }
        String string7 = "";
        try {
            while (bufferedReader.ready()) {
                string7 = string7 + bufferedReader.readLine() + "\n";
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            System.err.println("Error while reading file " + string);
            return false;
        }
        System.out.print("Convering HTML file (" + string + " -> " + string2 + ")... ");
        Source source = new Source(string7);
        OutputDocument outputDocument = new OutputDocument(source);
        int n = 1;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Element comparable2 : source.getAllElements("pre")) {
            StartTag startTag = comparable2.getStartTag();
            CharSequence charSequence = startTag.getAttributes().get("class");
            if (charSequence == null || !charSequence.hasValue() || !charSequence.getValue().equals(TAG_CLASS)) continue;
            string6 = string3;
            object = startTag.getAttributes().get("id");
            if (object != null && ((Attribute)object).hasValue()) {
                string6 = this.makeFilenameFromTagName(((Attribute)object).getValue());
                string5 = string4 + "/" + string6 + ".png";
            } else {
                string5 = string4 + "/" + string6 + "_" + n + ".png";
                ++n;
            }
            outputDocument.replace(comparable2, "<img src=\"" + string5 + "\" />");
            hashMap.put(string5, comparable2.getContent().toString());
        }
        if (hashMap.isEmpty()) {
            System.out.println("\nHTML document does not contain any <pre> tags with their class attribute set to \"textdiagram\". Nothing to do.");
            System.exit(0);
        }
        try {
            FileWriter fileWriter = new FileWriter(string2);
            outputDocument.writeTo(fileWriter);
        }
        catch (IOException iOException) {
            System.err.println("Error while writing to file " + string2);
            return false;
        }
        System.out.println("done");
        System.out.println("Generating diagrams... ");
        File file = new File(new File(string2).getParent() + File.separator + string4);
        if (!file.exists() && !file.mkdir()) {
            System.err.println("Could not create directory " + string4);
            return false;
        }
        for (CharSequence charSequence : hashMap.keySet()) {
            string6 = (String)hashMap.get(charSequence);
            string5 = new File(string2).getParent() + File.separator + (String)charSequence;
            if (new File(string5).exists() && !conversionOptions.processingOptions.overwriteFiles()) {
                System.out.println("Error: Cannot overwrite file " + (String)charSequence + ", file already exists." + " Use the --overwrite option if you would like to allow file overwrite.");
                continue;
            }
            object = new TextGrid();
            ((TextGrid)object).addToMarkupTags(conversionOptions.processingOptions.getCustomShapes().keySet());
            try {
                ((TextGrid)object).initialiseWithText(string6, conversionOptions.processingOptions);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                System.err.println("Error: " + unsupportedEncodingException.getMessage());
                System.exit(1);
            }
            Diagram unsupportedEncodingException = new Diagram((TextGrid)object, conversionOptions);
            RenderedImage renderedImage = new BitmapRenderer().renderToImage(unsupportedEncodingException, conversionOptions.renderingOptions);
            try {
                File iOException = new File(string5);
                ImageIO.write(renderedImage, "png", iOException);
            }
            catch (IOException iOException) {
                System.err.println("Error: Cannot write to file " + string + " -- skipping");
                continue;
            }
            System.out.println("\t" + string5);
        }
        System.out.println("\n...done");
        return true;
    }

    private String makeFilenameFromTagName(String string) {
        string = string.replace(' ', '_');
        return string;
    }
}

