/*
 * MP3/MPlayer plugin to VDR (C++)
 *
 * (C) 2001-2005 Stefan Huelswitt <s.huelswitt@gmx.de>
 *
 * This code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * Or, point your browser to http://www.gnu.org/copyleft/gpl.html
 */

#include <string.h>

#include "common.h"
#include "setup-mp3.h"

cMP3Setup MP3Setup;

// --- cMP3Setup ---------------------------------------------------------------

cMP3Setup::cMP3Setup(void)
{
  InitLoopMode = 0;
  InitShuffleMode = 0;
  AudioMode = 1;
  BgrScan = 1;
  EditorMode = 1;
  DisplayMode = 2;
  BackgrMode = 1;
  MenuMode = 2;
  TargetLevel = DEFAULT_TARGET_LEVEL;
  LimiterLevel = DEFAULT_LIMITER_LEVEL;
  Only48kHz = 0;
  UseProxy = 0;
  strcpy(ProxyHost,"localhost");
  ProxyPort = 8080;
  UseCddb = 1;
  strcpy(CddbHost,"freedb.freedb.org");
  CddbPort = 888;
  AudioOutMode = 0;
  AbortAtEOL = 1;
  ReplayDisplay = 0;
  HideMainMenu = 0;
  KeepSelect = 0;
  ExitClose = 0;
  strcpy(CopyDir,"/tmp");
  strcpy(RecordDir,"/video/mp3/Recordings");
  osdtheme = 0;
  CanScroll = 1;
  CanSkip = 0;
  Skiptime = 30;
  Jumptime = 30;
  OSDoffsetx = 0;
  OSDoffsety = 0;
  Rowcount = 9;
}

const cMP3Theme mp3Theme[eMP3ThemeMaxNumber] =
{
  {
    // Moronimo NextGen
    0xEF2D435A, //clrBackground                ok
    0xEF416E97, //clrBackground2               ok
    0xFFCE7B00, //clrNormalText                ok
    0xFF9BBAD7, //clrTrackListText             ok
    0xFF26303A, //clrListItemActiveBackground  ok
    0xFF9BBAD7, //clrListItemActiveText        ok
    0xEFCE7B00, //clrProgress                  ok
    0xDF000000, //clrProgressBackground      ok
  },
  {
    // Moronimo NextGen Opaque
    0xFF2D435A, //clrBackground                ok
    0xFF416E97, //clrBackground2               ok
    0xFFCE7B00, //clrNormalText                ok
    0xFF9BBAD7, //clrTrackListText             ok
    0xFF26303A, //clrListItemActiveBackground  ok
    0xFF9BBAD7, //clrListItemActiveText        ok
    0xFFCE7B00, //clrProgress                  ok
    0xFF000000, //clrProgressBackground      ok
  },
  {
    // Moronimo NextGen Transcluent
    0xBC2D435A, //clrBackground                ok
    0xBC416E97, //clrBackground2               ok
    0xBCCE7B00, //clrNormalText                ok
    0xBC9BBAD7, //clrTrackListText             ok
    0xBC26303A, //clrListItemActiveBackground  ok
    0xBC9BBAD7, //clrListItemActiveText        ok
    0xBCCE7B00, //clrProgress                  ok
    0xBC000000, //clrProgressBackground      ok
  },
  {
    // Enigma
    0xD0415bBC, //clrBackground                ok
    0xD0DEE5FA, //clrBackground2               ok
    0xFF000000, //clrNormalText                ok
    0xFF000000, //clrTrackListText             ok
    0xD0BFC9E6, //clrListItemActiveBackground  ok
    0xFF000000, //clrListItemActiveText        ok
    0xFF20C100, //clrProgress                  ok
    0xFFFFFFFF, //clrProgressBackground      ok
  },
  {
    // DeepBlue
    0xC832557A, //clrBackground                ok
    0xC80C0C0C, //clrBackground2               ok
    0xFF9A9A9A, //clrNormalText                ok
    0xFF9A9A9A, //clrTrackListText             ok
    0xC832557A, //clrListItemActiveBackground  ok
    0xFF9A9A9A, //clrListItemActiveText        ok
    0xFFCE7B00, //clrProgress                  ok
    0xC832557A, //clrProgressBackground      ok
  },
};
