package utils

import (
	"encoding/json"
)

func IsHexDigit(ch byte) bool {
	return (ch >= '0' && ch <= '9') || (ch >= 'a' && ch <= 'f') || (ch >= 'A' && ch <= 'F')
}

func IsDigit(ch byte) bool {
	return ch >= '0' && ch <= '9'
}

func Contains(needle int, haystack []int) bool {
	for _, i := range haystack {
		if needle == i {
			return true
		}
	}
	return false
}

func Unquote(s string) (string, error) {
	var unquoted string
	err := json.Unmarshal([]byte(s), &unquoted)
	return unquoted, err
}
