/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.net.ssl.SSLProtocolException;
import sun.security.ssl.RandomCookie;
import sun.security.ssl.Utilities;

final class SessionId {
    private static final int MAX_LENGTH = 32;
    private final byte[] sessionId;

    SessionId(boolean bl, SecureRandom secureRandom) {
        this.sessionId = bl && secureRandom != null ? new RandomCookie((SecureRandom)secureRandom).randomBytes : new byte[0];
    }

    SessionId(byte[] byArray) {
        this.sessionId = (byte[])byArray.clone();
    }

    int length() {
        return this.sessionId.length;
    }

    byte[] getId() {
        return (byte[])this.sessionId.clone();
    }

    public String toString() {
        if (this.sessionId.length == 0) {
            return "";
        }
        return Utilities.toHexString(this.sessionId);
    }

    public int hashCode() {
        return Arrays.hashCode(this.sessionId);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SessionId) {
            SessionId sessionId = (SessionId)object;
            return MessageDigest.isEqual(this.sessionId, sessionId.sessionId);
        }
        return false;
    }

    void checkLength(int n) throws SSLProtocolException {
        if (this.sessionId.length > 32) {
            throw new SSLProtocolException("Invalid session ID length (" + this.sessionId.length + " bytes)");
        }
    }
}

