(*++

Copyright (C) 2019 Numbers developers

All rights reserved.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.6.0.

Abstract: This is an autogenerated Pascal export implementation file in order to allow easy
development of Numbers library. The functions in this file need to be implemented. It needs to be generated only once.

Interface version: 1.0.0

*)

{$MODE DELPHI}
unit numbers_exports;

interface

uses
  numbers_impl,
  numbers_types,
  numbers_interfaces,
  numbers_exception,
  Classes,
  sysutils;

(*************************************************************************************************************************
 Class export definition of Base 
**************************************************************************************************************************)

(*************************************************************************************************************************
 Class export definition of Variable 
**************************************************************************************************************************)

(**
* Returns the current value of this Variable
*
* @param[in] pVariable - Variable instance.
* @param[out] pValue - The current value of this Variable
* @return error code or 0 (success)
*)
function numbers_variable_getvalue(pVariable: TNumbersHandle; pValue: PDouble): TNumbersResult; cdecl;

(**
* Set the numerical value of this Variable
*
* @param[in] pVariable - Variable instance.
* @param[in] dValue - The new value of this Variable
* @return error code or 0 (success)
*)
function numbers_variable_setvalue(pVariable: TNumbersHandle; dValue: Double): TNumbersResult; cdecl;

(*************************************************************************************************************************
 Global function export definition
**************************************************************************************************************************)

(**
* Creates a new Variable instance
*
* @param[in] dInitialValue - Initial value of the new Variable
* @param[out] pInstance - New Variable instance
* @return error code or 0 (success)
*)
function numbers_createvariable(dInitialValue: Double; pInstance: PNumbersHandle): TNumbersResult; cdecl;

(**
* retrieves the binary version of this library.
*
* @param[out] pMajor - returns the major version of this library
* @param[out] pMinor - returns the minor version of this library
* @param[out] pMicro - returns the micro version of this library
* @return error code or 0 (success)
*)
function numbers_getversion(pMajor: PCardinal; pMinor: PCardinal; pMicro: PCardinal): TNumbersResult; cdecl;

(**
* Returns the last error recorded on this object
*
* @param[in] pInstance - Instance Handle
* @param[in] nErrorMessageBufferSize - size of the buffer (including trailing 0)
* @param[out] pErrorMessageNeededChars - will be filled with the count of the written bytes, or needed buffer size.
* @param[out] pErrorMessageBuffer -  buffer of Message of the last error, may be NULL
* @param[out] pHasError - Is there a last error to query
* @return error code or 0 (success)
*)
function numbers_getlasterror(pInstance: TNumbersHandle; nErrorMessageBufferSize: Cardinal; pErrorMessageNeededChars: PCardinal; pErrorMessageBuffer: PAnsiChar; pHasError: PByte): TNumbersResult; cdecl;

(**
* Releases shared ownership of an Instance
*
* @param[in] pInstance - Instance Handle
* @return error code or 0 (success)
*)
function numbers_releaseinstance(pInstance: TNumbersHandle): TNumbersResult; cdecl;

(**
* Acquires shared ownership of an Instance
*
* @param[in] pInstance - Instance Handle
* @return error code or 0 (success)
*)
function numbers_acquireinstance(pInstance: TNumbersHandle): TNumbersResult; cdecl;

(**
* Returns the address of the SymbolLookupMethod
*
* @param[out] pSymbolLookupMethod - Address of the SymbolAddressMethod
* @return error code or 0 (success)
*)
function numbers_getsymbollookupmethod(pSymbolLookupMethod: PPointer): TNumbersResult; cdecl;


(*************************************************************************************************************************
 Function table lookup implementation
**************************************************************************************************************************)

function _numbers_getprocaddress_internal(pProcName: PAnsiChar; out ppProcAddress: Pointer): TNumbersResult cdecl;

implementation

function numbers_variable_getvalue(pVariable: TNumbersHandle; pValue: PDouble): TNumbersResult; cdecl;
var
  ResultValue: Double;
  ObjectVariable: TObject;
  IntfVariable: INumbersVariable;
begin
  try
    if not Assigned(pValue) then
      raise ENumbersException.Create(NUMBERS_ERROR_INVALIDPARAM);
    if not Assigned(pVariable) then
      raise ENumbersException.Create(NUMBERS_ERROR_INVALIDPARAM);

    ObjectVariable := TObject(pVariable);
    if Supports(ObjectVariable, INumbersVariable) then begin
      IntfVariable := ObjectVariable as INumbersVariable;
      ResultValue := IntfVariable.GetValue();

      pValue^ := ResultValue;
    end else
      raise ENumbersException.Create(NUMBERS_ERROR_INVALIDCAST);

    Result := NUMBERS_SUCCESS;
  except
    On E: ENumbersException do begin
      Result := HandleNumbersException(ObjectVariable , E);
    end;
    On E: Exception do begin
      Result := HandleStdException(ObjectVariable , E);
    end
    else begin
      Result := HandleUnhandledException(ObjectVariable);
    end;
  end;
end;

function numbers_variable_setvalue(pVariable: TNumbersHandle; dValue: Double): TNumbersResult; cdecl;
var
  ObjectVariable: TObject;
  IntfVariable: INumbersVariable;
begin
  try
    if not Assigned(pVariable) then
      raise ENumbersException.Create(NUMBERS_ERROR_INVALIDPARAM);

    ObjectVariable := TObject(pVariable);
    if Supports(ObjectVariable, INumbersVariable) then begin
      IntfVariable := ObjectVariable as INumbersVariable;
      IntfVariable.SetValue(dValue);

    end else
      raise ENumbersException.Create(NUMBERS_ERROR_INVALIDCAST);

    Result := NUMBERS_SUCCESS;
  except
    On E: ENumbersException do begin
      Result := HandleNumbersException(ObjectVariable , E);
    end;
    On E: Exception do begin
      Result := HandleStdException(ObjectVariable , E);
    end
    else begin
      Result := HandleUnhandledException(ObjectVariable);
    end;
  end;
end;

function numbers_createvariable(dInitialValue: Double; pInstance: PNumbersHandle): TNumbersResult; cdecl;
var
  ResultInstance: TObject;
begin
  try
    if not Assigned(pInstance) then
      raise ENumbersException.Create(NUMBERS_ERROR_INVALIDPARAM);

    ResultInstance := TNumbersWrapper.CreateVariable(dInitialValue);

    pInstance^ := ResultInstance;
    Result := NUMBERS_SUCCESS;
  except
    On E: ENumbersException do begin
      Result := E.ErrorCode;
    end
    else begin
      Result := NUMBERS_ERROR_GENERICEXCEPTION;
    end
  end;
end;

function numbers_getversion(pMajor: PCardinal; pMinor: PCardinal; pMicro: PCardinal): TNumbersResult; cdecl;
begin
  try
    if (not Assigned(pMajor)) then
      raise ENumbersException.Create(NUMBERS_ERROR_INVALIDPARAM);

    if (not Assigned(pMinor)) then
      raise ENumbersException.Create(NUMBERS_ERROR_INVALIDPARAM);

    if (not Assigned(pMicro)) then
      raise ENumbersException.Create(NUMBERS_ERROR_INVALIDPARAM);


    TNumbersWrapper.GetVersion(pMajor^, pMinor^, pMicro^);

    Result := NUMBERS_SUCCESS;
  except
    On E: ENumbersException do begin
      Result := E.ErrorCode;
    end
    else begin
      Result := NUMBERS_ERROR_GENERICEXCEPTION;
    end
  end;
end;

function numbers_getlasterror(pInstance: TNumbersHandle; nErrorMessageBufferSize: Cardinal; pErrorMessageNeededChars: PCardinal; pErrorMessageBuffer: PAnsiChar; pHasError: PByte): TNumbersResult; cdecl;
var
  ObjectInstance: TObject;
  ResultErrorMessage: String;
  LenErrorMessage: Cardinal;
  ResultHasError: Boolean;
begin
  try
    ObjectInstance := TObject(pInstance);
    if (not Supports(ObjectInstance, INumbersBase)) then
      raise ENumbersException.Create(NUMBERS_ERROR_INVALIDCAST);
    
    if ((not Assigned(pErrorMessageBuffer)) and (not Assigned(pErrorMessageNeededChars))) then
      raise ENumbersException.Create(NUMBERS_ERROR_INVALIDPARAM);
    if not Assigned(pHasError) then
      raise ENumbersException.Create(NUMBERS_ERROR_INVALIDPARAM);

    ResultHasError := TNumbersWrapper.GetLastError(ObjectInstance, ResultErrorMessage);

    LenErrorMessage := Length(ResultErrorMessage);
    if Assigned(pErrorMessageNeededChars) then
      pErrorMessageNeededChars^ := LenErrorMessage + 1;
    if Assigned(pErrorMessageBuffer) then begin
      if (LenErrorMessage >= nErrorMessageBufferSize) then
        raise ENumbersException.Create(NUMBERS_ERROR_BUFFERTOOSMALL);
      Move(PAnsiChar(ResultErrorMessage)^, pErrorMessageBuffer^, LenErrorMessage);
      pErrorMessageBuffer[LenErrorMessage] := Char(0);
    end;
    pHasError^ := Ord(ResultHasError);
    Result := NUMBERS_SUCCESS;
  except
    On E: ENumbersException do begin
      Result := E.ErrorCode;
    end
    else begin
      Result := NUMBERS_ERROR_GENERICEXCEPTION;
    end
  end;
end;

function numbers_releaseinstance(pInstance: TNumbersHandle): TNumbersResult; cdecl;
var
  ObjectInstance: TObject;
begin
  try
    ObjectInstance := TObject(pInstance);
    if (not Supports(ObjectInstance, INumbersBase)) then
      raise ENumbersException.Create(NUMBERS_ERROR_INVALIDCAST);
    

    TNumbersWrapper.ReleaseInstance(ObjectInstance);

    Result := NUMBERS_SUCCESS;
  except
    On E: ENumbersException do begin
      Result := E.ErrorCode;
    end
    else begin
      Result := NUMBERS_ERROR_GENERICEXCEPTION;
    end
  end;
end;

function numbers_acquireinstance(pInstance: TNumbersHandle): TNumbersResult; cdecl;
var
  ObjectInstance: TObject;
begin
  try
    ObjectInstance := TObject(pInstance);
    if (not Supports(ObjectInstance, INumbersBase)) then
      raise ENumbersException.Create(NUMBERS_ERROR_INVALIDCAST);
    

    TNumbersWrapper.AcquireInstance(ObjectInstance);

    Result := NUMBERS_SUCCESS;
  except
    On E: ENumbersException do begin
      Result := E.ErrorCode;
    end
    else begin
      Result := NUMBERS_ERROR_GENERICEXCEPTION;
    end
  end;
end;

function numbers_getsymbollookupmethod(pSymbolLookupMethod: PPointer): TNumbersResult; cdecl;
begin
  try
    if not Assigned(pSymbolLookupMethod) then
      raise ENumbersException.Create(NUMBERS_ERROR_INVALIDPARAM);

    pSymbolLookupMethod^ := @_numbers_getprocaddress_internal;
    Result := NUMBERS_SUCCESS;
  except
    On E: ENumbersException do begin
      Result := E.ErrorCode;
    end
    else begin
      Result := NUMBERS_ERROR_GENERICEXCEPTION;
    end
  end;
end;



(*************************************************************************************************************************
 Function table lookup implementation
**************************************************************************************************************************)

function _numbers_getprocaddress_internal(pProcName: PAnsiChar; out ppProcAddress: Pointer): TNumbersResult cdecl;

begin
  result := NUMBERS_SUCCESS;
  ppProcAddress := nil;
  
  if (pProcName = 'numbers_variable_getvalue') then
    ppProcAddress := @numbers_variable_getvalue
  else if (pProcName = 'numbers_variable_setvalue') then
    ppProcAddress := @numbers_variable_setvalue
  else if (pProcName = 'numbers_createvariable') then
    ppProcAddress := @numbers_createvariable
  else if (pProcName = 'numbers_getversion') then
    ppProcAddress := @numbers_getversion
  else if (pProcName = 'numbers_getlasterror') then
    ppProcAddress := @numbers_getlasterror
  else if (pProcName = 'numbers_releaseinstance') then
    ppProcAddress := @numbers_releaseinstance
  else if (pProcName = 'numbers_acquireinstance') then
    ppProcAddress := @numbers_acquireinstance
  else if (pProcName = 'numbers_getsymbollookupmethod') then
    ppProcAddress := @numbers_getsymbollookupmethod
  else
    result := NUMBERS_ERROR_COULDNOTFINDLIBRARYEXPORT;
end;

end.

