/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.LoggingEvent;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.Socket;
import java.net.SocketException;
import org.slf4j.LoggerFactory;

public class SocketNode
implements Runnable {
    Socket socket;
    LoggerContext context;
    ObjectInputStream ois;
    static Logger logger = (Logger)LoggerFactory.getLogger(SocketNode.class);

    public SocketNode(Socket socket, LoggerContext context) {
        this.socket = socket;
        this.context = context;
        try {
            this.ois = new ObjectInputStream(new BufferedInputStream(socket.getInputStream()));
        }
        catch (Exception e) {
            logger.error("Could not open ObjectInputStream to " + socket, e);
        }
    }

    public void run() {
        try {
            while (true) {
                LoggingEvent event;
                Logger remoteLogger;
                if (!(remoteLogger = this.context.getLogger((event = (LoggingEvent)this.ois.readObject()).getLoggerRemoteView().getName())).isEnabledFor(event.getLevel())) {
                    continue;
                }
                remoteLogger.callAppenders(event);
            }
        }
        catch (EOFException e) {
            logger.info("Caught java.io.EOFException closing connection.");
        }
        catch (SocketException e) {
            logger.info("Caught java.net.SocketException closing connection.");
        }
        catch (IOException e) {
            logger.info("Caught java.io.IOException: " + e);
            logger.info("Closing connection.");
        }
        catch (Exception e) {
            logger.error("Unexpected exception. Closing connection.", e);
        }
        try {
            this.ois.close();
        }
        catch (Exception e) {
            logger.info("Could not close connection.", e);
        }
    }
}

