# -*- ruby -*-
# encoding: utf-8
$LOAD_PATH.push File.expand_path('../src/ruby/lib', __FILE__)
require 'grpc/version'

Gem::Specification.new do |s|
  s.name          = 'grpc'
  s.version       = GRPC::VERSION
  s.authors       = ['gRPC Authors']
  s.email         = 'grpc-io@googlegroups.com'
  s.homepage      = 'https://github.com/google/grpc/tree/master/src/ruby'
  s.summary       = 'GRPC system in Ruby'
  s.description   = 'Send RPCs from Ruby using GRPC'
  s.license       = 'Apache-2.0'

  s.required_ruby_version = '>= 2.5.0'

  s.files = %w( Makefile .yardopts )
  s.files += %w( etc/roots.pem )
  s.files += Dir.glob('src/ruby/bin/**/*')
  s.files += Dir.glob('src/ruby/ext/**/*')
  s.files += Dir.glob('src/ruby/lib/**/*')
  s.files += Dir.glob('src/ruby/pb/**/*').reject do |f|
    f.match(%r{^src/ruby/pb/test})
  end
  s.files += Dir.glob('include/grpc/**/*')
  s.test_files = Dir.glob('src/ruby/spec/**/*')
  s.test_files += Dir.glob('src/ruby/pb/test/**/*')
  s.bindir = 'src/ruby/bin'
  s.require_paths = %w( src/ruby/lib src/ruby/bin src/ruby/pb )
  s.platform      = Gem::Platform::RUBY

  s.add_dependency 'google-protobuf', '~> 3.21'
  s.add_dependency 'googleapis-common-protos-types', '~> 1.0'

  s.add_development_dependency 'bundler',            '>= 1.9'
  s.add_development_dependency 'facter',             '~> 2.4'
  s.add_development_dependency 'logging',            '~> 2.0'
  s.add_development_dependency 'simplecov',          '~> 0.22'
  s.add_development_dependency 'rake',               '~> 13.0'
  s.add_development_dependency 'rake-compiler',      '~> 1.2.1'
  s.add_development_dependency 'rake-compiler-dock', '~> 1.3'
  s.add_development_dependency 'rspec',              '~> 3.6'
  s.add_development_dependency 'rubocop',            '~> 1.41.0'
  s.add_development_dependency 'signet',             '~> 0.7'
  s.add_development_dependency 'googleauth',         '>= 0.5.1', '< 0.10'

  s.extensions = %w(src/ruby/ext/grpc/extconf.rb)

  s.files += %w( include/grpc/byte_buffer.h )
  s.files += %w( include/grpc/byte_buffer_reader.h )
  s.files += %w( include/grpc/census.h )
  s.files += %w( include/grpc/compression.h )
  s.files += %w( include/grpc/event_engine/endpoint_config.h )
  s.files += %w( include/grpc/event_engine/event_engine.h )
  s.files += %w( include/grpc/event_engine/internal/memory_allocator_impl.h )
  s.files += %w( include/grpc/event_engine/internal/slice_cast.h )
  s.files += %w( include/grpc/event_engine/memory_allocator.h )
  s.files += %w( include/grpc/event_engine/memory_request.h )
  s.files += %w( include/grpc/event_engine/port.h )
  s.files += %w( include/grpc/event_engine/slice.h )
  s.files += %w( include/grpc/event_engine/slice_buffer.h )
  s.files += %w( include/grpc/fork.h )
  s.files += %w( include/grpc/grpc.h )
  s.files += %w( include/grpc/grpc_posix.h )
  s.files += %w( include/grpc/grpc_security.h )
  s.files += %w( include/grpc/grpc_security_constants.h )
  s.files += %w( include/grpc/impl/codegen/atm.h )
  s.files += %w( include/grpc/impl/codegen/atm_gcc_atomic.h )
  s.files += %w( include/grpc/impl/codegen/atm_gcc_sync.h )
  s.files += %w( include/grpc/impl/codegen/atm_windows.h )
  s.files += %w( include/grpc/impl/codegen/byte_buffer.h )
  s.files += %w( include/grpc/impl/codegen/byte_buffer_reader.h )
  s.files += %w( include/grpc/impl/codegen/compression_types.h )
  s.files += %w( include/grpc/impl/codegen/connectivity_state.h )
  s.files += %w( include/grpc/impl/codegen/fork.h )
  s.files += %w( include/grpc/impl/codegen/gpr_types.h )
  s.files += %w( include/grpc/impl/codegen/grpc_types.h )
  s.files += %w( include/grpc/impl/codegen/log.h )
  s.files += %w( include/grpc/impl/codegen/port_platform.h )
  s.files += %w( include/grpc/impl/codegen/propagation_bits.h )
  s.files += %w( include/grpc/impl/codegen/slice.h )
  s.files += %w( include/grpc/impl/codegen/status.h )
  s.files += %w( include/grpc/impl/codegen/sync.h )
  s.files += %w( include/grpc/impl/codegen/sync_abseil.h )
  s.files += %w( include/grpc/impl/codegen/sync_custom.h )
  s.files += %w( include/grpc/impl/codegen/sync_generic.h )
  s.files += %w( include/grpc/impl/codegen/sync_posix.h )
  s.files += %w( include/grpc/impl/codegen/sync_windows.h )
  s.files += %w( include/grpc/impl/compression_types.h )
  s.files += %w( include/grpc/impl/connectivity_state.h )
  s.files += %w( include/grpc/impl/grpc_types.h )
  s.files += %w( include/grpc/impl/propagation_bits.h )
  s.files += %w( include/grpc/impl/slice_type.h )
  s.files += %w( include/grpc/load_reporting.h )
  s.files += %w( include/grpc/slice.h )
  s.files += %w( include/grpc/slice_buffer.h )
  s.files += %w( include/grpc/status.h )
  s.files += %w( include/grpc/support/alloc.h )
  s.files += %w( include/grpc/support/atm.h )
  s.files += %w( include/grpc/support/atm_gcc_atomic.h )
  s.files += %w( include/grpc/support/atm_gcc_sync.h )
  s.files += %w( include/grpc/support/atm_windows.h )
  s.files += %w( include/grpc/support/cpu.h )
  s.files += %w( include/grpc/support/log.h )
  s.files += %w( include/grpc/support/log_windows.h )
  s.files += %w( include/grpc/support/port_platform.h )
  s.files += %w( include/grpc/support/string_util.h )
  s.files += %w( include/grpc/support/sync.h )
  s.files += %w( include/grpc/support/sync_abseil.h )
  s.files += %w( include/grpc/support/sync_custom.h )
  s.files += %w( include/grpc/support/sync_generic.h )
  s.files += %w( include/grpc/support/sync_posix.h )
  s.files += %w( include/grpc/support/sync_windows.h )
  s.files += %w( include/grpc/support/thd_id.h )
  s.files += %w( include/grpc/support/time.h )
  s.files += %w( include/grpc/support/workaround_list.h )
  s.files += %w( src/core/ext/filters/census/grpc_context.cc )
  s.files += %w( src/core/ext/filters/channel_idle/channel_idle_filter.cc )
  s.files += %w( src/core/ext/filters/channel_idle/channel_idle_filter.h )
  s.files += %w( src/core/ext/filters/channel_idle/idle_filter_state.cc )
  s.files += %w( src/core/ext/filters/channel_idle/idle_filter_state.h )
  s.files += %w( src/core/ext/filters/client_channel/backend_metric.cc )
  s.files += %w( src/core/ext/filters/client_channel/backend_metric.h )
  s.files += %w( src/core/ext/filters/client_channel/backup_poller.cc )
  s.files += %w( src/core/ext/filters/client_channel/backup_poller.h )
  s.files += %w( src/core/ext/filters/client_channel/channel_connectivity.cc )
  s.files += %w( src/core/ext/filters/client_channel/client_channel.cc )
  s.files += %w( src/core/ext/filters/client_channel/client_channel.h )
  s.files += %w( src/core/ext/filters/client_channel/client_channel_channelz.cc )
  s.files += %w( src/core/ext/filters/client_channel/client_channel_channelz.h )
  s.files += %w( src/core/ext/filters/client_channel/client_channel_factory.cc )
  s.files += %w( src/core/ext/filters/client_channel/client_channel_factory.h )
  s.files += %w( src/core/ext/filters/client_channel/client_channel_plugin.cc )
  s.files += %w( src/core/ext/filters/client_channel/client_channel_service_config.cc )
  s.files += %w( src/core/ext/filters/client_channel/client_channel_service_config.h )
  s.files += %w( src/core/ext/filters/client_channel/config_selector.cc )
  s.files += %w( src/core/ext/filters/client_channel/config_selector.h )
  s.files += %w( src/core/ext/filters/client_channel/connector.h )
  s.files += %w( src/core/ext/filters/client_channel/dynamic_filters.cc )
  s.files += %w( src/core/ext/filters/client_channel/dynamic_filters.h )
  s.files += %w( src/core/ext/filters/client_channel/global_subchannel_pool.cc )
  s.files += %w( src/core/ext/filters/client_channel/global_subchannel_pool.h )
  s.files += %w( src/core/ext/filters/client_channel/health/health_check_client.cc )
  s.files += %w( src/core/ext/filters/client_channel/health/health_check_client.h )
  s.files += %w( src/core/ext/filters/client_channel/http_proxy.cc )
  s.files += %w( src/core/ext/filters/client_channel/http_proxy.h )
  s.files += %w( src/core/ext/filters/client_channel/lb_call_state_internal.h )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy/address_filtering.cc )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy/address_filtering.h )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy/backend_metric_data.h )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy/child_policy_handler.cc )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy/child_policy_handler.h )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy/grpclb/client_load_reporting_filter.cc )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy/grpclb/client_load_reporting_filter.h )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy/grpclb/grpclb.cc )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy/grpclb/grpclb.h )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy/grpclb/grpclb_balancer_addresses.cc )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy/grpclb/grpclb_balancer_addresses.h )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy/grpclb/grpclb_client_stats.cc )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy/grpclb/grpclb_client_stats.h )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy/grpclb/load_balancer_api.cc )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy/grpclb/load_balancer_api.h )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy/oob_backend_metric.cc )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy/oob_backend_metric.h )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy/outlier_detection/outlier_detection.cc )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy/outlier_detection/outlier_detection.h )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy/pick_first/pick_first.cc )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy/priority/priority.cc )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy/ring_hash/ring_hash.cc )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy/ring_hash/ring_hash.h )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy/rls/rls.cc )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy/round_robin/round_robin.cc )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy/subchannel_list.h )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy/weighted_target/weighted_target.cc )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy/xds/cds.cc )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy/xds/xds_attributes.cc )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy/xds/xds_attributes.h )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy/xds/xds_channel_args.h )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy/xds/xds_cluster_impl.cc )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy/xds/xds_cluster_manager.cc )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy/xds/xds_cluster_resolver.cc )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy/xds/xds_override_host.cc )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy/xds/xds_override_host.h )
  s.files += %w( src/core/ext/filters/client_channel/lb_policy/xds/xds_wrr_locality.cc )
  s.files += %w( src/core/ext/filters/client_channel/local_subchannel_pool.cc )
  s.files += %w( src/core/ext/filters/client_channel/local_subchannel_pool.h )
  s.files += %w( src/core/ext/filters/client_channel/resolver/binder/binder_resolver.cc )
  s.files += %w( src/core/ext/filters/client_channel/resolver/dns/c_ares/dns_resolver_ares.cc )
  s.files += %w( src/core/ext/filters/client_channel/resolver/dns/c_ares/grpc_ares_ev_driver.h )
  s.files += %w( src/core/ext/filters/client_channel/resolver/dns/c_ares/grpc_ares_ev_driver_posix.cc )
  s.files += %w( src/core/ext/filters/client_channel/resolver/dns/c_ares/grpc_ares_ev_driver_windows.cc )
  s.files += %w( src/core/ext/filters/client_channel/resolver/dns/c_ares/grpc_ares_wrapper.cc )
  s.files += %w( src/core/ext/filters/client_channel/resolver/dns/c_ares/grpc_ares_wrapper.h )
  s.files += %w( src/core/ext/filters/client_channel/resolver/dns/c_ares/grpc_ares_wrapper_posix.cc )
  s.files += %w( src/core/ext/filters/client_channel/resolver/dns/c_ares/grpc_ares_wrapper_windows.cc )
  s.files += %w( src/core/ext/filters/client_channel/resolver/dns/dns_resolver_selection.cc )
  s.files += %w( src/core/ext/filters/client_channel/resolver/dns/dns_resolver_selection.h )
  s.files += %w( src/core/ext/filters/client_channel/resolver/dns/native/dns_resolver.cc )
  s.files += %w( src/core/ext/filters/client_channel/resolver/fake/fake_resolver.cc )
  s.files += %w( src/core/ext/filters/client_channel/resolver/fake/fake_resolver.h )
  s.files += %w( src/core/ext/filters/client_channel/resolver/google_c2p/google_c2p_resolver.cc )
  s.files += %w( src/core/ext/filters/client_channel/resolver/polling_resolver.cc )
  s.files += %w( src/core/ext/filters/client_channel/resolver/polling_resolver.h )
  s.files += %w( src/core/ext/filters/client_channel/resolver/sockaddr/sockaddr_resolver.cc )
  s.files += %w( src/core/ext/filters/client_channel/resolver/xds/xds_resolver.cc )
  s.files += %w( src/core/ext/filters/client_channel/resolver/xds/xds_resolver.h )
  s.files += %w( src/core/ext/filters/client_channel/retry_filter.cc )
  s.files += %w( src/core/ext/filters/client_channel/retry_filter.h )
  s.files += %w( src/core/ext/filters/client_channel/retry_service_config.cc )
  s.files += %w( src/core/ext/filters/client_channel/retry_service_config.h )
  s.files += %w( src/core/ext/filters/client_channel/retry_throttle.cc )
  s.files += %w( src/core/ext/filters/client_channel/retry_throttle.h )
  s.files += %w( src/core/ext/filters/client_channel/service_config_channel_arg_filter.cc )
  s.files += %w( src/core/ext/filters/client_channel/subchannel.cc )
  s.files += %w( src/core/ext/filters/client_channel/subchannel.h )
  s.files += %w( src/core/ext/filters/client_channel/subchannel_interface_internal.h )
  s.files += %w( src/core/ext/filters/client_channel/subchannel_pool_interface.cc )
  s.files += %w( src/core/ext/filters/client_channel/subchannel_pool_interface.h )
  s.files += %w( src/core/ext/filters/client_channel/subchannel_stream_client.cc )
  s.files += %w( src/core/ext/filters/client_channel/subchannel_stream_client.h )
  s.files += %w( src/core/ext/filters/deadline/deadline_filter.cc )
  s.files += %w( src/core/ext/filters/deadline/deadline_filter.h )
  s.files += %w( src/core/ext/filters/fault_injection/fault_injection_filter.cc )
  s.files += %w( src/core/ext/filters/fault_injection/fault_injection_filter.h )
  s.files += %w( src/core/ext/filters/fault_injection/fault_injection_service_config_parser.cc )
  s.files += %w( src/core/ext/filters/fault_injection/fault_injection_service_config_parser.h )
  s.files += %w( src/core/ext/filters/http/client/http_client_filter.cc )
  s.files += %w( src/core/ext/filters/http/client/http_client_filter.h )
  s.files += %w( src/core/ext/filters/http/client_authority_filter.cc )
  s.files += %w( src/core/ext/filters/http/client_authority_filter.h )
  s.files += %w( src/core/ext/filters/http/http_filters_plugin.cc )
  s.files += %w( src/core/ext/filters/http/message_compress/compression_filter.cc )
  s.files += %w( src/core/ext/filters/http/message_compress/compression_filter.h )
  s.files += %w( src/core/ext/filters/http/server/http_server_filter.cc )
  s.files += %w( src/core/ext/filters/http/server/http_server_filter.h )
  s.files += %w( src/core/ext/filters/message_size/message_size_filter.cc )
  s.files += %w( src/core/ext/filters/message_size/message_size_filter.h )
  s.files += %w( src/core/ext/filters/rbac/rbac_filter.cc )
  s.files += %w( src/core/ext/filters/rbac/rbac_filter.h )
  s.files += %w( src/core/ext/filters/rbac/rbac_service_config_parser.cc )
  s.files += %w( src/core/ext/filters/rbac/rbac_service_config_parser.h )
  s.files += %w( src/core/ext/filters/server_config_selector/server_config_selector.h )
  s.files += %w( src/core/ext/filters/server_config_selector/server_config_selector_filter.cc )
  s.files += %w( src/core/ext/filters/server_config_selector/server_config_selector_filter.h )
  s.files += %w( src/core/ext/filters/stateful_session/stateful_session_filter.cc )
  s.files += %w( src/core/ext/filters/stateful_session/stateful_session_filter.h )
  s.files += %w( src/core/ext/filters/stateful_session/stateful_session_service_config_parser.cc )
  s.files += %w( src/core/ext/filters/stateful_session/stateful_session_service_config_parser.h )
  s.files += %w( src/core/ext/transport/chttp2/alpn/alpn.cc )
  s.files += %w( src/core/ext/transport/chttp2/alpn/alpn.h )
  s.files += %w( src/core/ext/transport/chttp2/client/chttp2_connector.cc )
  s.files += %w( src/core/ext/transport/chttp2/client/chttp2_connector.h )
  s.files += %w( src/core/ext/transport/chttp2/server/chttp2_server.cc )
  s.files += %w( src/core/ext/transport/chttp2/server/chttp2_server.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/bin_decoder.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/bin_decoder.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/bin_encoder.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/bin_encoder.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/chttp2_transport.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/chttp2_transport.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/context_list.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/context_list.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/decode_huff.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/decode_huff.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/flow_control.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/flow_control.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/frame.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/frame_data.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/frame_data.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/frame_goaway.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/frame_goaway.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/frame_ping.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/frame_ping.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/frame_rst_stream.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/frame_rst_stream.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/frame_settings.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/frame_settings.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/frame_window_update.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/frame_window_update.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/hpack_constants.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/hpack_encoder.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/hpack_encoder.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/hpack_encoder_table.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/hpack_encoder_table.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/hpack_parser.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/hpack_parser.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/hpack_parser_table.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/hpack_parser_table.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/http2_settings.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/http2_settings.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/http_trace.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/http_trace.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/huffsyms.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/huffsyms.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/internal.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/parsing.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/stream_lists.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/stream_map.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/stream_map.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/varint.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/varint.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/writing.cc )
  s.files += %w( src/core/ext/transport/inproc/inproc_plugin.cc )
  s.files += %w( src/core/ext/transport/inproc/inproc_transport.cc )
  s.files += %w( src/core/ext/transport/inproc/inproc_transport.h )
  s.files += %w( src/core/ext/upb-generated/envoy/admin/v3/certs.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/admin/v3/certs.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/admin/v3/clusters.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/admin/v3/clusters.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/admin/v3/config_dump.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/admin/v3/config_dump.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/admin/v3/config_dump_shared.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/admin/v3/config_dump_shared.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/admin/v3/init_dump.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/admin/v3/init_dump.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/admin/v3/listeners.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/admin/v3/listeners.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/admin/v3/memory.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/admin/v3/memory.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/admin/v3/metrics.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/admin/v3/metrics.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/admin/v3/mutex_stats.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/admin/v3/mutex_stats.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/admin/v3/server_info.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/admin/v3/server_info.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/admin/v3/tap.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/admin/v3/tap.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/annotations/deprecation.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/annotations/deprecation.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/annotations/resource.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/annotations/resource.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/config/accesslog/v3/accesslog.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/config/accesslog/v3/accesslog.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/config/bootstrap/v3/bootstrap.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/config/bootstrap/v3/bootstrap.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/config/cluster/v3/circuit_breaker.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/config/cluster/v3/circuit_breaker.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/config/cluster/v3/cluster.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/config/cluster/v3/cluster.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/config/cluster/v3/filter.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/config/cluster/v3/filter.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/config/cluster/v3/outlier_detection.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/config/cluster/v3/outlier_detection.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/config/common/matcher/v3/matcher.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/config/common/matcher/v3/matcher.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/config/core/v3/address.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/config/core/v3/address.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/config/core/v3/backoff.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/config/core/v3/backoff.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/config/core/v3/base.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/config/core/v3/base.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/config/core/v3/config_source.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/config/core/v3/config_source.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/config/core/v3/event_service_config.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/config/core/v3/event_service_config.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/config/core/v3/extension.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/config/core/v3/extension.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/config/core/v3/grpc_method_list.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/config/core/v3/grpc_method_list.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/config/core/v3/grpc_service.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/config/core/v3/grpc_service.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/config/core/v3/health_check.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/config/core/v3/health_check.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/config/core/v3/http_uri.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/config/core/v3/http_uri.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/config/core/v3/protocol.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/config/core/v3/protocol.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/config/core/v3/proxy_protocol.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/config/core/v3/proxy_protocol.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/config/core/v3/resolver.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/config/core/v3/resolver.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/config/core/v3/socket_option.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/config/core/v3/socket_option.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/config/core/v3/substitution_format_string.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/config/core/v3/substitution_format_string.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/config/core/v3/udp_socket_config.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/config/core/v3/udp_socket_config.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/config/endpoint/v3/endpoint.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/config/endpoint/v3/endpoint.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/config/endpoint/v3/endpoint_components.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/config/endpoint/v3/endpoint_components.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/config/endpoint/v3/load_report.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/config/endpoint/v3/load_report.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/config/listener/v3/api_listener.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/config/listener/v3/api_listener.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/config/listener/v3/listener.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/config/listener/v3/listener.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/config/listener/v3/listener_components.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/config/listener/v3/listener_components.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/config/listener/v3/quic_config.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/config/listener/v3/quic_config.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/config/listener/v3/udp_listener_config.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/config/listener/v3/udp_listener_config.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/config/metrics/v3/metrics_service.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/config/metrics/v3/metrics_service.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/config/metrics/v3/stats.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/config/metrics/v3/stats.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/config/overload/v3/overload.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/config/overload/v3/overload.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/config/rbac/v3/rbac.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/config/rbac/v3/rbac.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/config/route/v3/route.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/config/route/v3/route.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/config/route/v3/route_components.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/config/route/v3/route_components.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/config/route/v3/scoped_route.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/config/route/v3/scoped_route.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/config/tap/v3/common.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/config/tap/v3/common.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/config/trace/v3/datadog.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/config/trace/v3/datadog.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/config/trace/v3/dynamic_ot.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/config/trace/v3/dynamic_ot.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/config/trace/v3/http_tracer.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/config/trace/v3/http_tracer.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/config/trace/v3/lightstep.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/config/trace/v3/lightstep.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/config/trace/v3/opencensus.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/config/trace/v3/opencensus.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/config/trace/v3/opentelemetry.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/config/trace/v3/opentelemetry.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/config/trace/v3/service.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/config/trace/v3/service.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/config/trace/v3/skywalking.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/config/trace/v3/skywalking.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/config/trace/v3/trace.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/config/trace/v3/trace.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/config/trace/v3/xray.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/config/trace/v3/xray.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/config/trace/v3/zipkin.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/config/trace/v3/zipkin.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/extensions/clusters/aggregate/v3/cluster.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/extensions/clusters/aggregate/v3/cluster.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/extensions/filters/common/fault/v3/fault.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/extensions/filters/common/fault/v3/fault.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/extensions/filters/http/fault/v3/fault.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/extensions/filters/http/fault/v3/fault.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/extensions/filters/http/rbac/v3/rbac.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/extensions/filters/http/rbac/v3/rbac.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/extensions/filters/http/router/v3/router.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/extensions/filters/http/router/v3/router.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/extensions/filters/http/stateful_session/v3/stateful_session.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/extensions/filters/http/stateful_session/v3/stateful_session.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/extensions/filters/network/http_connection_manager/v3/http_connection_manager.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/extensions/filters/network/http_connection_manager/v3/http_connection_manager.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/extensions/http/stateful_session/cookie/v3/cookie.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/extensions/http/stateful_session/cookie/v3/cookie.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/extensions/load_balancing_policies/ring_hash/v3/ring_hash.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/extensions/load_balancing_policies/ring_hash/v3/ring_hash.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/extensions/load_balancing_policies/wrr_locality/v3/wrr_locality.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/extensions/load_balancing_policies/wrr_locality/v3/wrr_locality.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/extensions/transport_sockets/tls/v3/cert.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/extensions/transport_sockets/tls/v3/cert.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/extensions/transport_sockets/tls/v3/common.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/extensions/transport_sockets/tls/v3/common.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/extensions/transport_sockets/tls/v3/secret.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/extensions/transport_sockets/tls/v3/secret.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/extensions/transport_sockets/tls/v3/tls.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/extensions/transport_sockets/tls/v3/tls.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/extensions/transport_sockets/tls/v3/tls_spiffe_validator_config.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/extensions/transport_sockets/tls/v3/tls_spiffe_validator_config.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/service/discovery/v3/ads.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/service/discovery/v3/ads.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/service/discovery/v3/discovery.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/service/discovery/v3/discovery.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/service/load_stats/v3/lrs.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/service/load_stats/v3/lrs.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/service/status/v3/csds.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/service/status/v3/csds.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/type/http/v3/cookie.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/type/http/v3/cookie.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/type/http/v3/path_transformation.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/type/http/v3/path_transformation.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/type/matcher/v3/http_inputs.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/type/matcher/v3/http_inputs.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/type/matcher/v3/metadata.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/type/matcher/v3/metadata.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/type/matcher/v3/node.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/type/matcher/v3/node.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/type/matcher/v3/number.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/type/matcher/v3/number.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/type/matcher/v3/path.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/type/matcher/v3/path.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/type/matcher/v3/regex.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/type/matcher/v3/regex.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/type/matcher/v3/string.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/type/matcher/v3/string.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/type/matcher/v3/struct.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/type/matcher/v3/struct.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/type/matcher/v3/value.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/type/matcher/v3/value.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/type/metadata/v3/metadata.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/type/metadata/v3/metadata.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/type/tracing/v3/custom_tag.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/type/tracing/v3/custom_tag.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/type/v3/hash_policy.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/type/v3/hash_policy.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/type/v3/http.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/type/v3/http.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/type/v3/http_status.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/type/v3/http_status.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/type/v3/percent.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/type/v3/percent.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/type/v3/range.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/type/v3/range.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/type/v3/ratelimit_strategy.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/type/v3/ratelimit_strategy.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/type/v3/ratelimit_unit.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/type/v3/ratelimit_unit.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/type/v3/semantic_version.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/type/v3/semantic_version.upb.h )
  s.files += %w( src/core/ext/upb-generated/envoy/type/v3/token_bucket.upb.c )
  s.files += %w( src/core/ext/upb-generated/envoy/type/v3/token_bucket.upb.h )
  s.files += %w( src/core/ext/upb-generated/google/api/annotations.upb.c )
  s.files += %w( src/core/ext/upb-generated/google/api/annotations.upb.h )
  s.files += %w( src/core/ext/upb-generated/google/api/expr/v1alpha1/checked.upb.c )
  s.files += %w( src/core/ext/upb-generated/google/api/expr/v1alpha1/checked.upb.h )
  s.files += %w( src/core/ext/upb-generated/google/api/expr/v1alpha1/syntax.upb.c )
  s.files += %w( src/core/ext/upb-generated/google/api/expr/v1alpha1/syntax.upb.h )
  s.files += %w( src/core/ext/upb-generated/google/api/http.upb.c )
  s.files += %w( src/core/ext/upb-generated/google/api/http.upb.h )
  s.files += %w( src/core/ext/upb-generated/google/api/httpbody.upb.c )
  s.files += %w( src/core/ext/upb-generated/google/api/httpbody.upb.h )
  s.files += %w( src/core/ext/upb-generated/google/protobuf/any.upb.c )
  s.files += %w( src/core/ext/upb-generated/google/protobuf/any.upb.h )
  s.files += %w( src/core/ext/upb-generated/google/protobuf/descriptor.upb.c )
  s.files += %w( src/core/ext/upb-generated/google/protobuf/descriptor.upb.h )
  s.files += %w( src/core/ext/upb-generated/google/protobuf/duration.upb.c )
  s.files += %w( src/core/ext/upb-generated/google/protobuf/duration.upb.h )
  s.files += %w( src/core/ext/upb-generated/google/protobuf/empty.upb.c )
  s.files += %w( src/core/ext/upb-generated/google/protobuf/empty.upb.h )
  s.files += %w( src/core/ext/upb-generated/google/protobuf/struct.upb.c )
  s.files += %w( src/core/ext/upb-generated/google/protobuf/struct.upb.h )
  s.files += %w( src/core/ext/upb-generated/google/protobuf/timestamp.upb.c )
  s.files += %w( src/core/ext/upb-generated/google/protobuf/timestamp.upb.h )
  s.files += %w( src/core/ext/upb-generated/google/protobuf/wrappers.upb.c )
  s.files += %w( src/core/ext/upb-generated/google/protobuf/wrappers.upb.h )
  s.files += %w( src/core/ext/upb-generated/google/rpc/status.upb.c )
  s.files += %w( src/core/ext/upb-generated/google/rpc/status.upb.h )
  s.files += %w( src/core/ext/upb-generated/opencensus/proto/trace/v1/trace_config.upb.c )
  s.files += %w( src/core/ext/upb-generated/opencensus/proto/trace/v1/trace_config.upb.h )
  s.files += %w( src/core/ext/upb-generated/src/proto/grpc/gcp/altscontext.upb.c )
  s.files += %w( src/core/ext/upb-generated/src/proto/grpc/gcp/altscontext.upb.h )
  s.files += %w( src/core/ext/upb-generated/src/proto/grpc/gcp/handshaker.upb.c )
  s.files += %w( src/core/ext/upb-generated/src/proto/grpc/gcp/handshaker.upb.h )
  s.files += %w( src/core/ext/upb-generated/src/proto/grpc/gcp/transport_security_common.upb.c )
  s.files += %w( src/core/ext/upb-generated/src/proto/grpc/gcp/transport_security_common.upb.h )
  s.files += %w( src/core/ext/upb-generated/src/proto/grpc/health/v1/health.upb.c )
  s.files += %w( src/core/ext/upb-generated/src/proto/grpc/health/v1/health.upb.h )
  s.files += %w( src/core/ext/upb-generated/src/proto/grpc/lb/v1/load_balancer.upb.c )
  s.files += %w( src/core/ext/upb-generated/src/proto/grpc/lb/v1/load_balancer.upb.h )
  s.files += %w( src/core/ext/upb-generated/src/proto/grpc/lookup/v1/rls.upb.c )
  s.files += %w( src/core/ext/upb-generated/src/proto/grpc/lookup/v1/rls.upb.h )
  s.files += %w( src/core/ext/upb-generated/src/proto/grpc/lookup/v1/rls_config.upb.c )
  s.files += %w( src/core/ext/upb-generated/src/proto/grpc/lookup/v1/rls_config.upb.h )
  s.files += %w( src/core/ext/upb-generated/udpa/annotations/migrate.upb.c )
  s.files += %w( src/core/ext/upb-generated/udpa/annotations/migrate.upb.h )
  s.files += %w( src/core/ext/upb-generated/udpa/annotations/security.upb.c )
  s.files += %w( src/core/ext/upb-generated/udpa/annotations/security.upb.h )
  s.files += %w( src/core/ext/upb-generated/udpa/annotations/sensitive.upb.c )
  s.files += %w( src/core/ext/upb-generated/udpa/annotations/sensitive.upb.h )
  s.files += %w( src/core/ext/upb-generated/udpa/annotations/status.upb.c )
  s.files += %w( src/core/ext/upb-generated/udpa/annotations/status.upb.h )
  s.files += %w( src/core/ext/upb-generated/udpa/annotations/versioning.upb.c )
  s.files += %w( src/core/ext/upb-generated/udpa/annotations/versioning.upb.h )
  s.files += %w( src/core/ext/upb-generated/validate/validate.upb.c )
  s.files += %w( src/core/ext/upb-generated/validate/validate.upb.h )
  s.files += %w( src/core/ext/upb-generated/xds/annotations/v3/migrate.upb.c )
  s.files += %w( src/core/ext/upb-generated/xds/annotations/v3/migrate.upb.h )
  s.files += %w( src/core/ext/upb-generated/xds/annotations/v3/security.upb.c )
  s.files += %w( src/core/ext/upb-generated/xds/annotations/v3/security.upb.h )
  s.files += %w( src/core/ext/upb-generated/xds/annotations/v3/sensitive.upb.c )
  s.files += %w( src/core/ext/upb-generated/xds/annotations/v3/sensitive.upb.h )
  s.files += %w( src/core/ext/upb-generated/xds/annotations/v3/status.upb.c )
  s.files += %w( src/core/ext/upb-generated/xds/annotations/v3/status.upb.h )
  s.files += %w( src/core/ext/upb-generated/xds/annotations/v3/versioning.upb.c )
  s.files += %w( src/core/ext/upb-generated/xds/annotations/v3/versioning.upb.h )
  s.files += %w( src/core/ext/upb-generated/xds/core/v3/authority.upb.c )
  s.files += %w( src/core/ext/upb-generated/xds/core/v3/authority.upb.h )
  s.files += %w( src/core/ext/upb-generated/xds/core/v3/cidr.upb.c )
  s.files += %w( src/core/ext/upb-generated/xds/core/v3/cidr.upb.h )
  s.files += %w( src/core/ext/upb-generated/xds/core/v3/collection_entry.upb.c )
  s.files += %w( src/core/ext/upb-generated/xds/core/v3/collection_entry.upb.h )
  s.files += %w( src/core/ext/upb-generated/xds/core/v3/context_params.upb.c )
  s.files += %w( src/core/ext/upb-generated/xds/core/v3/context_params.upb.h )
  s.files += %w( src/core/ext/upb-generated/xds/core/v3/extension.upb.c )
  s.files += %w( src/core/ext/upb-generated/xds/core/v3/extension.upb.h )
  s.files += %w( src/core/ext/upb-generated/xds/core/v3/resource.upb.c )
  s.files += %w( src/core/ext/upb-generated/xds/core/v3/resource.upb.h )
  s.files += %w( src/core/ext/upb-generated/xds/core/v3/resource_locator.upb.c )
  s.files += %w( src/core/ext/upb-generated/xds/core/v3/resource_locator.upb.h )
  s.files += %w( src/core/ext/upb-generated/xds/core/v3/resource_name.upb.c )
  s.files += %w( src/core/ext/upb-generated/xds/core/v3/resource_name.upb.h )
  s.files += %w( src/core/ext/upb-generated/xds/data/orca/v3/orca_load_report.upb.c )
  s.files += %w( src/core/ext/upb-generated/xds/data/orca/v3/orca_load_report.upb.h )
  s.files += %w( src/core/ext/upb-generated/xds/service/orca/v3/orca.upb.c )
  s.files += %w( src/core/ext/upb-generated/xds/service/orca/v3/orca.upb.h )
  s.files += %w( src/core/ext/upb-generated/xds/type/matcher/v3/cel.upb.c )
  s.files += %w( src/core/ext/upb-generated/xds/type/matcher/v3/cel.upb.h )
  s.files += %w( src/core/ext/upb-generated/xds/type/matcher/v3/domain.upb.c )
  s.files += %w( src/core/ext/upb-generated/xds/type/matcher/v3/domain.upb.h )
  s.files += %w( src/core/ext/upb-generated/xds/type/matcher/v3/http_inputs.upb.c )
  s.files += %w( src/core/ext/upb-generated/xds/type/matcher/v3/http_inputs.upb.h )
  s.files += %w( src/core/ext/upb-generated/xds/type/matcher/v3/ip.upb.c )
  s.files += %w( src/core/ext/upb-generated/xds/type/matcher/v3/ip.upb.h )
  s.files += %w( src/core/ext/upb-generated/xds/type/matcher/v3/matcher.upb.c )
  s.files += %w( src/core/ext/upb-generated/xds/type/matcher/v3/matcher.upb.h )
  s.files += %w( src/core/ext/upb-generated/xds/type/matcher/v3/range.upb.c )
  s.files += %w( src/core/ext/upb-generated/xds/type/matcher/v3/range.upb.h )
  s.files += %w( src/core/ext/upb-generated/xds/type/matcher/v3/regex.upb.c )
  s.files += %w( src/core/ext/upb-generated/xds/type/matcher/v3/regex.upb.h )
  s.files += %w( src/core/ext/upb-generated/xds/type/matcher/v3/string.upb.c )
  s.files += %w( src/core/ext/upb-generated/xds/type/matcher/v3/string.upb.h )
  s.files += %w( src/core/ext/upb-generated/xds/type/v3/cel.upb.c )
  s.files += %w( src/core/ext/upb-generated/xds/type/v3/cel.upb.h )
  s.files += %w( src/core/ext/upb-generated/xds/type/v3/range.upb.c )
  s.files += %w( src/core/ext/upb-generated/xds/type/v3/range.upb.h )
  s.files += %w( src/core/ext/upb-generated/xds/type/v3/typed_struct.upb.c )
  s.files += %w( src/core/ext/upb-generated/xds/type/v3/typed_struct.upb.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/admin/v3/certs.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/admin/v3/certs.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/admin/v3/clusters.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/admin/v3/clusters.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/admin/v3/config_dump.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/admin/v3/config_dump.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/admin/v3/config_dump_shared.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/admin/v3/config_dump_shared.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/admin/v3/init_dump.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/admin/v3/init_dump.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/admin/v3/listeners.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/admin/v3/listeners.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/admin/v3/memory.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/admin/v3/memory.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/admin/v3/metrics.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/admin/v3/metrics.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/admin/v3/mutex_stats.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/admin/v3/mutex_stats.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/admin/v3/server_info.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/admin/v3/server_info.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/admin/v3/tap.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/admin/v3/tap.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/annotations/deprecation.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/annotations/deprecation.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/annotations/resource.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/annotations/resource.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/accesslog/v3/accesslog.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/accesslog/v3/accesslog.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/bootstrap/v3/bootstrap.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/bootstrap/v3/bootstrap.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/cluster/v3/circuit_breaker.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/cluster/v3/circuit_breaker.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/cluster/v3/cluster.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/cluster/v3/cluster.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/cluster/v3/filter.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/cluster/v3/filter.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/cluster/v3/outlier_detection.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/cluster/v3/outlier_detection.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/common/matcher/v3/matcher.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/common/matcher/v3/matcher.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/core/v3/address.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/core/v3/address.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/core/v3/backoff.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/core/v3/backoff.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/core/v3/base.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/core/v3/base.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/core/v3/config_source.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/core/v3/config_source.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/core/v3/event_service_config.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/core/v3/event_service_config.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/core/v3/extension.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/core/v3/extension.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/core/v3/grpc_method_list.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/core/v3/grpc_method_list.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/core/v3/grpc_service.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/core/v3/grpc_service.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/core/v3/health_check.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/core/v3/health_check.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/core/v3/http_uri.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/core/v3/http_uri.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/core/v3/protocol.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/core/v3/protocol.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/core/v3/proxy_protocol.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/core/v3/proxy_protocol.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/core/v3/resolver.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/core/v3/resolver.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/core/v3/socket_option.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/core/v3/socket_option.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/core/v3/substitution_format_string.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/core/v3/substitution_format_string.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/core/v3/udp_socket_config.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/core/v3/udp_socket_config.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/endpoint/v3/endpoint.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/endpoint/v3/endpoint.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/endpoint/v3/endpoint_components.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/endpoint/v3/endpoint_components.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/endpoint/v3/load_report.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/endpoint/v3/load_report.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/listener/v3/api_listener.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/listener/v3/api_listener.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/listener/v3/listener.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/listener/v3/listener.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/listener/v3/listener_components.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/listener/v3/listener_components.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/listener/v3/quic_config.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/listener/v3/quic_config.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/listener/v3/udp_listener_config.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/listener/v3/udp_listener_config.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/metrics/v3/metrics_service.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/metrics/v3/metrics_service.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/metrics/v3/stats.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/metrics/v3/stats.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/overload/v3/overload.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/overload/v3/overload.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/rbac/v3/rbac.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/rbac/v3/rbac.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/route/v3/route.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/route/v3/route.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/route/v3/route_components.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/route/v3/route_components.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/route/v3/scoped_route.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/route/v3/scoped_route.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/tap/v3/common.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/tap/v3/common.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/trace/v3/datadog.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/trace/v3/datadog.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/trace/v3/dynamic_ot.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/trace/v3/dynamic_ot.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/trace/v3/http_tracer.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/trace/v3/http_tracer.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/trace/v3/lightstep.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/trace/v3/lightstep.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/trace/v3/opencensus.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/trace/v3/opencensus.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/trace/v3/opentelemetry.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/trace/v3/opentelemetry.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/trace/v3/service.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/trace/v3/service.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/trace/v3/skywalking.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/trace/v3/skywalking.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/trace/v3/trace.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/trace/v3/trace.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/trace/v3/xray.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/trace/v3/xray.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/trace/v3/zipkin.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/config/trace/v3/zipkin.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/extensions/clusters/aggregate/v3/cluster.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/extensions/clusters/aggregate/v3/cluster.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/extensions/filters/common/fault/v3/fault.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/extensions/filters/common/fault/v3/fault.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/extensions/filters/http/fault/v3/fault.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/extensions/filters/http/fault/v3/fault.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/extensions/filters/http/rbac/v3/rbac.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/extensions/filters/http/rbac/v3/rbac.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/extensions/filters/http/router/v3/router.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/extensions/filters/http/router/v3/router.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/extensions/filters/http/stateful_session/v3/stateful_session.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/extensions/filters/http/stateful_session/v3/stateful_session.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/extensions/filters/network/http_connection_manager/v3/http_connection_manager.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/extensions/filters/network/http_connection_manager/v3/http_connection_manager.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/extensions/http/stateful_session/cookie/v3/cookie.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/extensions/http/stateful_session/cookie/v3/cookie.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/extensions/transport_sockets/tls/v3/cert.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/extensions/transport_sockets/tls/v3/cert.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/extensions/transport_sockets/tls/v3/common.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/extensions/transport_sockets/tls/v3/common.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/extensions/transport_sockets/tls/v3/secret.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/extensions/transport_sockets/tls/v3/secret.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/extensions/transport_sockets/tls/v3/tls.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/extensions/transport_sockets/tls/v3/tls.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/extensions/transport_sockets/tls/v3/tls_spiffe_validator_config.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/extensions/transport_sockets/tls/v3/tls_spiffe_validator_config.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/service/discovery/v3/ads.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/service/discovery/v3/ads.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/service/discovery/v3/discovery.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/service/discovery/v3/discovery.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/service/load_stats/v3/lrs.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/service/load_stats/v3/lrs.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/service/status/v3/csds.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/service/status/v3/csds.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/type/http/v3/cookie.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/type/http/v3/cookie.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/type/http/v3/path_transformation.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/type/http/v3/path_transformation.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/type/matcher/v3/http_inputs.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/type/matcher/v3/http_inputs.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/type/matcher/v3/metadata.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/type/matcher/v3/metadata.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/type/matcher/v3/node.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/type/matcher/v3/node.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/type/matcher/v3/number.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/type/matcher/v3/number.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/type/matcher/v3/path.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/type/matcher/v3/path.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/type/matcher/v3/regex.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/type/matcher/v3/regex.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/type/matcher/v3/string.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/type/matcher/v3/string.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/type/matcher/v3/struct.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/type/matcher/v3/struct.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/type/matcher/v3/value.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/type/matcher/v3/value.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/type/metadata/v3/metadata.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/type/metadata/v3/metadata.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/type/tracing/v3/custom_tag.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/type/tracing/v3/custom_tag.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/type/v3/hash_policy.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/type/v3/hash_policy.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/type/v3/http.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/type/v3/http.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/type/v3/http_status.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/type/v3/http_status.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/type/v3/percent.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/type/v3/percent.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/type/v3/range.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/type/v3/range.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/type/v3/ratelimit_strategy.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/type/v3/ratelimit_strategy.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/type/v3/ratelimit_unit.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/type/v3/ratelimit_unit.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/type/v3/semantic_version.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/type/v3/semantic_version.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/type/v3/token_bucket.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/envoy/type/v3/token_bucket.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/google/api/annotations.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/google/api/annotations.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/google/api/expr/v1alpha1/checked.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/google/api/expr/v1alpha1/checked.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/google/api/expr/v1alpha1/syntax.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/google/api/expr/v1alpha1/syntax.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/google/api/http.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/google/api/http.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/google/api/httpbody.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/google/api/httpbody.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/google/protobuf/any.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/google/protobuf/any.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/google/protobuf/descriptor.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/google/protobuf/descriptor.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/google/protobuf/duration.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/google/protobuf/duration.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/google/protobuf/empty.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/google/protobuf/empty.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/google/protobuf/struct.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/google/protobuf/struct.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/google/protobuf/timestamp.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/google/protobuf/timestamp.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/google/protobuf/wrappers.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/google/protobuf/wrappers.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/google/rpc/status.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/google/rpc/status.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/opencensus/proto/trace/v1/trace_config.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/opencensus/proto/trace/v1/trace_config.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/src/proto/grpc/lookup/v1/rls_config.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/src/proto/grpc/lookup/v1/rls_config.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/udpa/annotations/migrate.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/udpa/annotations/migrate.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/udpa/annotations/security.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/udpa/annotations/security.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/udpa/annotations/sensitive.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/udpa/annotations/sensitive.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/udpa/annotations/status.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/udpa/annotations/status.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/udpa/annotations/versioning.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/udpa/annotations/versioning.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/validate/validate.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/validate/validate.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/xds/annotations/v3/migrate.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/xds/annotations/v3/migrate.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/xds/annotations/v3/security.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/xds/annotations/v3/security.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/xds/annotations/v3/sensitive.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/xds/annotations/v3/sensitive.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/xds/annotations/v3/status.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/xds/annotations/v3/status.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/xds/annotations/v3/versioning.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/xds/annotations/v3/versioning.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/xds/core/v3/authority.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/xds/core/v3/authority.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/xds/core/v3/cidr.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/xds/core/v3/cidr.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/xds/core/v3/collection_entry.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/xds/core/v3/collection_entry.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/xds/core/v3/context_params.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/xds/core/v3/context_params.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/xds/core/v3/extension.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/xds/core/v3/extension.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/xds/core/v3/resource.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/xds/core/v3/resource.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/xds/core/v3/resource_locator.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/xds/core/v3/resource_locator.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/xds/core/v3/resource_name.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/xds/core/v3/resource_name.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/xds/type/matcher/v3/cel.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/xds/type/matcher/v3/cel.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/xds/type/matcher/v3/domain.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/xds/type/matcher/v3/domain.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/xds/type/matcher/v3/http_inputs.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/xds/type/matcher/v3/http_inputs.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/xds/type/matcher/v3/ip.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/xds/type/matcher/v3/ip.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/xds/type/matcher/v3/matcher.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/xds/type/matcher/v3/matcher.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/xds/type/matcher/v3/range.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/xds/type/matcher/v3/range.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/xds/type/matcher/v3/regex.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/xds/type/matcher/v3/regex.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/xds/type/matcher/v3/string.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/xds/type/matcher/v3/string.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/xds/type/v3/cel.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/xds/type/v3/cel.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/xds/type/v3/range.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/xds/type/v3/range.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-generated/xds/type/v3/typed_struct.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-generated/xds/type/v3/typed_struct.upbdefs.h )
  s.files += %w( src/core/ext/xds/certificate_provider_store.cc )
  s.files += %w( src/core/ext/xds/certificate_provider_store.h )
  s.files += %w( src/core/ext/xds/file_watcher_certificate_provider_factory.cc )
  s.files += %w( src/core/ext/xds/file_watcher_certificate_provider_factory.h )
  s.files += %w( src/core/ext/xds/upb_utils.h )
  s.files += %w( src/core/ext/xds/xds_api.cc )
  s.files += %w( src/core/ext/xds/xds_api.h )
  s.files += %w( src/core/ext/xds/xds_bootstrap.cc )
  s.files += %w( src/core/ext/xds/xds_bootstrap.h )
  s.files += %w( src/core/ext/xds/xds_bootstrap_grpc.cc )
  s.files += %w( src/core/ext/xds/xds_bootstrap_grpc.h )
  s.files += %w( src/core/ext/xds/xds_certificate_provider.cc )
  s.files += %w( src/core/ext/xds/xds_certificate_provider.h )
  s.files += %w( src/core/ext/xds/xds_channel_args.h )
  s.files += %w( src/core/ext/xds/xds_channel_stack_modifier.cc )
  s.files += %w( src/core/ext/xds/xds_channel_stack_modifier.h )
  s.files += %w( src/core/ext/xds/xds_client.cc )
  s.files += %w( src/core/ext/xds/xds_client.h )
  s.files += %w( src/core/ext/xds/xds_client_grpc.cc )
  s.files += %w( src/core/ext/xds/xds_client_grpc.h )
  s.files += %w( src/core/ext/xds/xds_client_stats.cc )
  s.files += %w( src/core/ext/xds/xds_client_stats.h )
  s.files += %w( src/core/ext/xds/xds_cluster.cc )
  s.files += %w( src/core/ext/xds/xds_cluster.h )
  s.files += %w( src/core/ext/xds/xds_cluster_specifier_plugin.cc )
  s.files += %w( src/core/ext/xds/xds_cluster_specifier_plugin.h )
  s.files += %w( src/core/ext/xds/xds_common_types.cc )
  s.files += %w( src/core/ext/xds/xds_common_types.h )
  s.files += %w( src/core/ext/xds/xds_endpoint.cc )
  s.files += %w( src/core/ext/xds/xds_endpoint.h )
  s.files += %w( src/core/ext/xds/xds_health_status.cc )
  s.files += %w( src/core/ext/xds/xds_health_status.h )
  s.files += %w( src/core/ext/xds/xds_http_fault_filter.cc )
  s.files += %w( src/core/ext/xds/xds_http_fault_filter.h )
  s.files += %w( src/core/ext/xds/xds_http_filters.cc )
  s.files += %w( src/core/ext/xds/xds_http_filters.h )
  s.files += %w( src/core/ext/xds/xds_http_rbac_filter.cc )
  s.files += %w( src/core/ext/xds/xds_http_rbac_filter.h )
  s.files += %w( src/core/ext/xds/xds_http_stateful_session_filter.cc )
  s.files += %w( src/core/ext/xds/xds_http_stateful_session_filter.h )
  s.files += %w( src/core/ext/xds/xds_lb_policy_registry.cc )
  s.files += %w( src/core/ext/xds/xds_lb_policy_registry.h )
  s.files += %w( src/core/ext/xds/xds_listener.cc )
  s.files += %w( src/core/ext/xds/xds_listener.h )
  s.files += %w( src/core/ext/xds/xds_resource_type.h )
  s.files += %w( src/core/ext/xds/xds_resource_type_impl.h )
  s.files += %w( src/core/ext/xds/xds_route_config.cc )
  s.files += %w( src/core/ext/xds/xds_route_config.h )
  s.files += %w( src/core/ext/xds/xds_routing.cc )
  s.files += %w( src/core/ext/xds/xds_routing.h )
  s.files += %w( src/core/ext/xds/xds_server_config_fetcher.cc )
  s.files += %w( src/core/ext/xds/xds_transport.h )
  s.files += %w( src/core/ext/xds/xds_transport_grpc.cc )
  s.files += %w( src/core/ext/xds/xds_transport_grpc.h )
  s.files += %w( src/core/lib/address_utils/parse_address.cc )
  s.files += %w( src/core/lib/address_utils/parse_address.h )
  s.files += %w( src/core/lib/address_utils/sockaddr_utils.cc )
  s.files += %w( src/core/lib/address_utils/sockaddr_utils.h )
  s.files += %w( src/core/lib/avl/avl.h )
  s.files += %w( src/core/lib/backoff/backoff.cc )
  s.files += %w( src/core/lib/backoff/backoff.h )
  s.files += %w( src/core/lib/channel/call_finalization.h )
  s.files += %w( src/core/lib/channel/call_tracer.h )
  s.files += %w( src/core/lib/channel/channel_args.cc )
  s.files += %w( src/core/lib/channel/channel_args.h )
  s.files += %w( src/core/lib/channel/channel_args_preconditioning.cc )
  s.files += %w( src/core/lib/channel/channel_args_preconditioning.h )
  s.files += %w( src/core/lib/channel/channel_fwd.h )
  s.files += %w( src/core/lib/channel/channel_stack.cc )
  s.files += %w( src/core/lib/channel/channel_stack.h )
  s.files += %w( src/core/lib/channel/channel_stack_builder.cc )
  s.files += %w( src/core/lib/channel/channel_stack_builder.h )
  s.files += %w( src/core/lib/channel/channel_stack_builder_impl.cc )
  s.files += %w( src/core/lib/channel/channel_stack_builder_impl.h )
  s.files += %w( src/core/lib/channel/channel_trace.cc )
  s.files += %w( src/core/lib/channel/channel_trace.h )
  s.files += %w( src/core/lib/channel/channelz.cc )
  s.files += %w( src/core/lib/channel/channelz.h )
  s.files += %w( src/core/lib/channel/channelz_registry.cc )
  s.files += %w( src/core/lib/channel/channelz_registry.h )
  s.files += %w( src/core/lib/channel/connected_channel.cc )
  s.files += %w( src/core/lib/channel/connected_channel.h )
  s.files += %w( src/core/lib/channel/context.h )
  s.files += %w( src/core/lib/channel/promise_based_filter.cc )
  s.files += %w( src/core/lib/channel/promise_based_filter.h )
  s.files += %w( src/core/lib/channel/status_util.cc )
  s.files += %w( src/core/lib/channel/status_util.h )
  s.files += %w( src/core/lib/compression/compression.cc )
  s.files += %w( src/core/lib/compression/compression_internal.cc )
  s.files += %w( src/core/lib/compression/compression_internal.h )
  s.files += %w( src/core/lib/compression/message_compress.cc )
  s.files += %w( src/core/lib/compression/message_compress.h )
  s.files += %w( src/core/lib/config/core_configuration.cc )
  s.files += %w( src/core/lib/config/core_configuration.h )
  s.files += %w( src/core/lib/debug/event_log.cc )
  s.files += %w( src/core/lib/debug/event_log.h )
  s.files += %w( src/core/lib/debug/histogram_view.cc )
  s.files += %w( src/core/lib/debug/histogram_view.h )
  s.files += %w( src/core/lib/debug/stats.cc )
  s.files += %w( src/core/lib/debug/stats.h )
  s.files += %w( src/core/lib/debug/stats_data.cc )
  s.files += %w( src/core/lib/debug/stats_data.h )
  s.files += %w( src/core/lib/debug/trace.cc )
  s.files += %w( src/core/lib/debug/trace.h )
  s.files += %w( src/core/lib/event_engine/channel_args_endpoint_config.cc )
  s.files += %w( src/core/lib/event_engine/channel_args_endpoint_config.h )
  s.files += %w( src/core/lib/event_engine/common_closures.h )
  s.files += %w( src/core/lib/event_engine/default_event_engine.cc )
  s.files += %w( src/core/lib/event_engine/default_event_engine.h )
  s.files += %w( src/core/lib/event_engine/default_event_engine_factory.cc )
  s.files += %w( src/core/lib/event_engine/default_event_engine_factory.h )
  s.files += %w( src/core/lib/event_engine/executor/executor.h )
  s.files += %w( src/core/lib/event_engine/forkable.cc )
  s.files += %w( src/core/lib/event_engine/forkable.h )
  s.files += %w( src/core/lib/event_engine/handle_containers.h )
  s.files += %w( src/core/lib/event_engine/memory_allocator.cc )
  s.files += %w( src/core/lib/event_engine/poller.h )
  s.files += %w( src/core/lib/event_engine/posix_engine/ev_epoll1_linux.cc )
  s.files += %w( src/core/lib/event_engine/posix_engine/ev_epoll1_linux.h )
  s.files += %w( src/core/lib/event_engine/posix_engine/ev_poll_posix.cc )
  s.files += %w( src/core/lib/event_engine/posix_engine/ev_poll_posix.h )
  s.files += %w( src/core/lib/event_engine/posix_engine/event_poller.h )
  s.files += %w( src/core/lib/event_engine/posix_engine/event_poller_posix_default.cc )
  s.files += %w( src/core/lib/event_engine/posix_engine/event_poller_posix_default.h )
  s.files += %w( src/core/lib/event_engine/posix_engine/internal_errqueue.cc )
  s.files += %w( src/core/lib/event_engine/posix_engine/internal_errqueue.h )
  s.files += %w( src/core/lib/event_engine/posix_engine/lockfree_event.cc )
  s.files += %w( src/core/lib/event_engine/posix_engine/lockfree_event.h )
  s.files += %w( src/core/lib/event_engine/posix_engine/posix_endpoint.cc )
  s.files += %w( src/core/lib/event_engine/posix_engine/posix_endpoint.h )
  s.files += %w( src/core/lib/event_engine/posix_engine/posix_engine.cc )
  s.files += %w( src/core/lib/event_engine/posix_engine/posix_engine.h )
  s.files += %w( src/core/lib/event_engine/posix_engine/posix_engine_closure.h )
  s.files += %w( src/core/lib/event_engine/posix_engine/posix_engine_listener.cc )
  s.files += %w( src/core/lib/event_engine/posix_engine/posix_engine_listener.h )
  s.files += %w( src/core/lib/event_engine/posix_engine/posix_engine_listener_utils.cc )
  s.files += %w( src/core/lib/event_engine/posix_engine/posix_engine_listener_utils.h )
  s.files += %w( src/core/lib/event_engine/posix_engine/tcp_socket_utils.cc )
  s.files += %w( src/core/lib/event_engine/posix_engine/tcp_socket_utils.h )
  s.files += %w( src/core/lib/event_engine/posix_engine/timer.cc )
  s.files += %w( src/core/lib/event_engine/posix_engine/timer.h )
  s.files += %w( src/core/lib/event_engine/posix_engine/timer_heap.cc )
  s.files += %w( src/core/lib/event_engine/posix_engine/timer_heap.h )
  s.files += %w( src/core/lib/event_engine/posix_engine/timer_manager.cc )
  s.files += %w( src/core/lib/event_engine/posix_engine/timer_manager.h )
  s.files += %w( src/core/lib/event_engine/posix_engine/traced_buffer_list.cc )
  s.files += %w( src/core/lib/event_engine/posix_engine/traced_buffer_list.h )
  s.files += %w( src/core/lib/event_engine/posix_engine/wakeup_fd_eventfd.cc )
  s.files += %w( src/core/lib/event_engine/posix_engine/wakeup_fd_eventfd.h )
  s.files += %w( src/core/lib/event_engine/posix_engine/wakeup_fd_pipe.cc )
  s.files += %w( src/core/lib/event_engine/posix_engine/wakeup_fd_pipe.h )
  s.files += %w( src/core/lib/event_engine/posix_engine/wakeup_fd_posix.h )
  s.files += %w( src/core/lib/event_engine/posix_engine/wakeup_fd_posix_default.cc )
  s.files += %w( src/core/lib/event_engine/posix_engine/wakeup_fd_posix_default.h )
  s.files += %w( src/core/lib/event_engine/resolved_address.cc )
  s.files += %w( src/core/lib/event_engine/slice.cc )
  s.files += %w( src/core/lib/event_engine/slice_buffer.cc )
  s.files += %w( src/core/lib/event_engine/socket_notifier.h )
  s.files += %w( src/core/lib/event_engine/tcp_socket_utils.cc )
  s.files += %w( src/core/lib/event_engine/tcp_socket_utils.h )
  s.files += %w( src/core/lib/event_engine/thread_pool.cc )
  s.files += %w( src/core/lib/event_engine/thread_pool.h )
  s.files += %w( src/core/lib/event_engine/time_util.cc )
  s.files += %w( src/core/lib/event_engine/time_util.h )
  s.files += %w( src/core/lib/event_engine/trace.cc )
  s.files += %w( src/core/lib/event_engine/trace.h )
  s.files += %w( src/core/lib/event_engine/utils.cc )
  s.files += %w( src/core/lib/event_engine/utils.h )
  s.files += %w( src/core/lib/event_engine/windows/iocp.cc )
  s.files += %w( src/core/lib/event_engine/windows/iocp.h )
  s.files += %w( src/core/lib/event_engine/windows/win_socket.cc )
  s.files += %w( src/core/lib/event_engine/windows/win_socket.h )
  s.files += %w( src/core/lib/event_engine/windows/windows_engine.cc )
  s.files += %w( src/core/lib/event_engine/windows/windows_engine.h )
  s.files += %w( src/core/lib/experiments/config.cc )
  s.files += %w( src/core/lib/experiments/config.h )
  s.files += %w( src/core/lib/experiments/experiments.cc )
  s.files += %w( src/core/lib/experiments/experiments.h )
  s.files += %w( src/core/lib/gpr/alloc.cc )
  s.files += %w( src/core/lib/gpr/alloc.h )
  s.files += %w( src/core/lib/gpr/atm.cc )
  s.files += %w( src/core/lib/gpr/cpu_iphone.cc )
  s.files += %w( src/core/lib/gpr/cpu_linux.cc )
  s.files += %w( src/core/lib/gpr/cpu_posix.cc )
  s.files += %w( src/core/lib/gpr/cpu_windows.cc )
  s.files += %w( src/core/lib/gpr/log.cc )
  s.files += %w( src/core/lib/gpr/log_android.cc )
  s.files += %w( src/core/lib/gpr/log_linux.cc )
  s.files += %w( src/core/lib/gpr/log_posix.cc )
  s.files += %w( src/core/lib/gpr/log_windows.cc )
  s.files += %w( src/core/lib/gpr/spinlock.h )
  s.files += %w( src/core/lib/gpr/string.cc )
  s.files += %w( src/core/lib/gpr/string.h )
  s.files += %w( src/core/lib/gpr/string_posix.cc )
  s.files += %w( src/core/lib/gpr/string_util_windows.cc )
  s.files += %w( src/core/lib/gpr/string_windows.cc )
  s.files += %w( src/core/lib/gpr/sync.cc )
  s.files += %w( src/core/lib/gpr/sync_abseil.cc )
  s.files += %w( src/core/lib/gpr/sync_posix.cc )
  s.files += %w( src/core/lib/gpr/sync_windows.cc )
  s.files += %w( src/core/lib/gpr/time.cc )
  s.files += %w( src/core/lib/gpr/time_posix.cc )
  s.files += %w( src/core/lib/gpr/time_precise.cc )
  s.files += %w( src/core/lib/gpr/time_precise.h )
  s.files += %w( src/core/lib/gpr/time_windows.cc )
  s.files += %w( src/core/lib/gpr/tmpfile.h )
  s.files += %w( src/core/lib/gpr/tmpfile_msys.cc )
  s.files += %w( src/core/lib/gpr/tmpfile_posix.cc )
  s.files += %w( src/core/lib/gpr/tmpfile_windows.cc )
  s.files += %w( src/core/lib/gpr/useful.h )
  s.files += %w( src/core/lib/gpr/wrap_memcpy.cc )
  s.files += %w( src/core/lib/gprpp/atomic_utils.h )
  s.files += %w( src/core/lib/gprpp/bitset.h )
  s.files += %w( src/core/lib/gprpp/chunked_vector.h )
  s.files += %w( src/core/lib/gprpp/construct_destruct.h )
  s.files += %w( src/core/lib/gprpp/cpp_impl_of.h )
  s.files += %w( src/core/lib/gprpp/crash.cc )
  s.files += %w( src/core/lib/gprpp/crash.h )
  s.files += %w( src/core/lib/gprpp/debug_location.h )
  s.files += %w( src/core/lib/gprpp/dual_ref_counted.h )
  s.files += %w( src/core/lib/gprpp/env.h )
  s.files += %w( src/core/lib/gprpp/env_linux.cc )
  s.files += %w( src/core/lib/gprpp/env_posix.cc )
  s.files += %w( src/core/lib/gprpp/env_windows.cc )
  s.files += %w( src/core/lib/gprpp/examine_stack.cc )
  s.files += %w( src/core/lib/gprpp/examine_stack.h )
  s.files += %w( src/core/lib/gprpp/fork.cc )
  s.files += %w( src/core/lib/gprpp/fork.h )
  s.files += %w( src/core/lib/gprpp/global_config.h )
  s.files += %w( src/core/lib/gprpp/global_config_custom.h )
  s.files += %w( src/core/lib/gprpp/global_config_env.cc )
  s.files += %w( src/core/lib/gprpp/global_config_env.h )
  s.files += %w( src/core/lib/gprpp/global_config_generic.h )
  s.files += %w( src/core/lib/gprpp/host_port.cc )
  s.files += %w( src/core/lib/gprpp/host_port.h )
  s.files += %w( src/core/lib/gprpp/load_file.cc )
  s.files += %w( src/core/lib/gprpp/load_file.h )
  s.files += %w( src/core/lib/gprpp/manual_constructor.h )
  s.files += %w( src/core/lib/gprpp/match.h )
  s.files += %w( src/core/lib/gprpp/memory.h )
  s.files += %w( src/core/lib/gprpp/mpscq.cc )
  s.files += %w( src/core/lib/gprpp/mpscq.h )
  s.files += %w( src/core/lib/gprpp/no_destruct.h )
  s.files += %w( src/core/lib/gprpp/notification.h )
  s.files += %w( src/core/lib/gprpp/orphanable.h )
  s.files += %w( src/core/lib/gprpp/overload.h )
  s.files += %w( src/core/lib/gprpp/packed_table.h )
  s.files += %w( src/core/lib/gprpp/per_cpu.h )
  s.files += %w( src/core/lib/gprpp/ref_counted.h )
  s.files += %w( src/core/lib/gprpp/ref_counted_ptr.h )
  s.files += %w( src/core/lib/gprpp/single_set_ptr.h )
  s.files += %w( src/core/lib/gprpp/sorted_pack.h )
  s.files += %w( src/core/lib/gprpp/stat.h )
  s.files += %w( src/core/lib/gprpp/stat_posix.cc )
  s.files += %w( src/core/lib/gprpp/stat_windows.cc )
  s.files += %w( src/core/lib/gprpp/status_helper.cc )
  s.files += %w( src/core/lib/gprpp/status_helper.h )
  s.files += %w( src/core/lib/gprpp/strerror.cc )
  s.files += %w( src/core/lib/gprpp/strerror.h )
  s.files += %w( src/core/lib/gprpp/sync.h )
  s.files += %w( src/core/lib/gprpp/table.h )
  s.files += %w( src/core/lib/gprpp/tchar.cc )
  s.files += %w( src/core/lib/gprpp/tchar.h )
  s.files += %w( src/core/lib/gprpp/thd.h )
  s.files += %w( src/core/lib/gprpp/thd_posix.cc )
  s.files += %w( src/core/lib/gprpp/thd_windows.cc )
  s.files += %w( src/core/lib/gprpp/time.cc )
  s.files += %w( src/core/lib/gprpp/time.h )
  s.files += %w( src/core/lib/gprpp/time_averaged_stats.cc )
  s.files += %w( src/core/lib/gprpp/time_averaged_stats.h )
  s.files += %w( src/core/lib/gprpp/time_util.cc )
  s.files += %w( src/core/lib/gprpp/time_util.h )
  s.files += %w( src/core/lib/gprpp/unique_type_name.h )
  s.files += %w( src/core/lib/gprpp/validation_errors.cc )
  s.files += %w( src/core/lib/gprpp/validation_errors.h )
  s.files += %w( src/core/lib/gprpp/work_serializer.cc )
  s.files += %w( src/core/lib/gprpp/work_serializer.h )
  s.files += %w( src/core/lib/handshaker/proxy_mapper.h )
  s.files += %w( src/core/lib/handshaker/proxy_mapper_registry.cc )
  s.files += %w( src/core/lib/handshaker/proxy_mapper_registry.h )
  s.files += %w( src/core/lib/http/format_request.cc )
  s.files += %w( src/core/lib/http/format_request.h )
  s.files += %w( src/core/lib/http/httpcli.cc )
  s.files += %w( src/core/lib/http/httpcli.h )
  s.files += %w( src/core/lib/http/httpcli_security_connector.cc )
  s.files += %w( src/core/lib/http/httpcli_ssl_credentials.h )
  s.files += %w( src/core/lib/http/parser.cc )
  s.files += %w( src/core/lib/http/parser.h )
  s.files += %w( src/core/lib/iomgr/block_annotate.h )
  s.files += %w( src/core/lib/iomgr/buffer_list.cc )
  s.files += %w( src/core/lib/iomgr/buffer_list.h )
  s.files += %w( src/core/lib/iomgr/call_combiner.cc )
  s.files += %w( src/core/lib/iomgr/call_combiner.h )
  s.files += %w( src/core/lib/iomgr/cfstream_handle.cc )
  s.files += %w( src/core/lib/iomgr/cfstream_handle.h )
  s.files += %w( src/core/lib/iomgr/closure.h )
  s.files += %w( src/core/lib/iomgr/combiner.cc )
  s.files += %w( src/core/lib/iomgr/combiner.h )
  s.files += %w( src/core/lib/iomgr/dualstack_socket_posix.cc )
  s.files += %w( src/core/lib/iomgr/dynamic_annotations.h )
  s.files += %w( src/core/lib/iomgr/endpoint.cc )
  s.files += %w( src/core/lib/iomgr/endpoint.h )
  s.files += %w( src/core/lib/iomgr/endpoint_cfstream.cc )
  s.files += %w( src/core/lib/iomgr/endpoint_cfstream.h )
  s.files += %w( src/core/lib/iomgr/endpoint_pair.h )
  s.files += %w( src/core/lib/iomgr/endpoint_pair_posix.cc )
  s.files += %w( src/core/lib/iomgr/endpoint_pair_windows.cc )
  s.files += %w( src/core/lib/iomgr/error.cc )
  s.files += %w( src/core/lib/iomgr/error.h )
  s.files += %w( src/core/lib/iomgr/error_cfstream.cc )
  s.files += %w( src/core/lib/iomgr/error_cfstream.h )
  s.files += %w( src/core/lib/iomgr/ev_apple.cc )
  s.files += %w( src/core/lib/iomgr/ev_apple.h )
  s.files += %w( src/core/lib/iomgr/ev_epoll1_linux.cc )
  s.files += %w( src/core/lib/iomgr/ev_epoll1_linux.h )
  s.files += %w( src/core/lib/iomgr/ev_poll_posix.cc )
  s.files += %w( src/core/lib/iomgr/ev_poll_posix.h )
  s.files += %w( src/core/lib/iomgr/ev_posix.cc )
  s.files += %w( src/core/lib/iomgr/ev_posix.h )
  s.files += %w( src/core/lib/iomgr/ev_windows.cc )
  s.files += %w( src/core/lib/iomgr/exec_ctx.cc )
  s.files += %w( src/core/lib/iomgr/exec_ctx.h )
  s.files += %w( src/core/lib/iomgr/executor.cc )
  s.files += %w( src/core/lib/iomgr/executor.h )
  s.files += %w( src/core/lib/iomgr/fork_posix.cc )
  s.files += %w( src/core/lib/iomgr/fork_windows.cc )
  s.files += %w( src/core/lib/iomgr/gethostname.h )
  s.files += %w( src/core/lib/iomgr/gethostname_fallback.cc )
  s.files += %w( src/core/lib/iomgr/gethostname_host_name_max.cc )
  s.files += %w( src/core/lib/iomgr/gethostname_sysconf.cc )
  s.files += %w( src/core/lib/iomgr/grpc_if_nametoindex.h )
  s.files += %w( src/core/lib/iomgr/grpc_if_nametoindex_posix.cc )
  s.files += %w( src/core/lib/iomgr/grpc_if_nametoindex_unsupported.cc )
  s.files += %w( src/core/lib/iomgr/internal_errqueue.cc )
  s.files += %w( src/core/lib/iomgr/internal_errqueue.h )
  s.files += %w( src/core/lib/iomgr/iocp_windows.cc )
  s.files += %w( src/core/lib/iomgr/iocp_windows.h )
  s.files += %w( src/core/lib/iomgr/iomgr.cc )
  s.files += %w( src/core/lib/iomgr/iomgr.h )
  s.files += %w( src/core/lib/iomgr/iomgr_fwd.h )
  s.files += %w( src/core/lib/iomgr/iomgr_internal.cc )
  s.files += %w( src/core/lib/iomgr/iomgr_internal.h )
  s.files += %w( src/core/lib/iomgr/iomgr_posix.cc )
  s.files += %w( src/core/lib/iomgr/iomgr_posix_cfstream.cc )
  s.files += %w( src/core/lib/iomgr/iomgr_windows.cc )
  s.files += %w( src/core/lib/iomgr/load_file.cc )
  s.files += %w( src/core/lib/iomgr/load_file.h )
  s.files += %w( src/core/lib/iomgr/lockfree_event.cc )
  s.files += %w( src/core/lib/iomgr/lockfree_event.h )
  s.files += %w( src/core/lib/iomgr/nameser.h )
  s.files += %w( src/core/lib/iomgr/polling_entity.cc )
  s.files += %w( src/core/lib/iomgr/polling_entity.h )
  s.files += %w( src/core/lib/iomgr/pollset.cc )
  s.files += %w( src/core/lib/iomgr/pollset.h )
  s.files += %w( src/core/lib/iomgr/pollset_set.cc )
  s.files += %w( src/core/lib/iomgr/pollset_set.h )
  s.files += %w( src/core/lib/iomgr/pollset_set_windows.cc )
  s.files += %w( src/core/lib/iomgr/pollset_set_windows.h )
  s.files += %w( src/core/lib/iomgr/pollset_windows.cc )
  s.files += %w( src/core/lib/iomgr/pollset_windows.h )
  s.files += %w( src/core/lib/iomgr/port.h )
  s.files += %w( src/core/lib/iomgr/python_util.h )
  s.files += %w( src/core/lib/iomgr/resolve_address.cc )
  s.files += %w( src/core/lib/iomgr/resolve_address.h )
  s.files += %w( src/core/lib/iomgr/resolve_address_impl.h )
  s.files += %w( src/core/lib/iomgr/resolve_address_posix.cc )
  s.files += %w( src/core/lib/iomgr/resolve_address_posix.h )
  s.files += %w( src/core/lib/iomgr/resolve_address_windows.cc )
  s.files += %w( src/core/lib/iomgr/resolve_address_windows.h )
  s.files += %w( src/core/lib/iomgr/resolved_address.h )
  s.files += %w( src/core/lib/iomgr/sockaddr.h )
  s.files += %w( src/core/lib/iomgr/sockaddr_posix.h )
  s.files += %w( src/core/lib/iomgr/sockaddr_utils_posix.cc )
  s.files += %w( src/core/lib/iomgr/sockaddr_windows.h )
  s.files += %w( src/core/lib/iomgr/socket_factory_posix.cc )
  s.files += %w( src/core/lib/iomgr/socket_factory_posix.h )
  s.files += %w( src/core/lib/iomgr/socket_mutator.cc )
  s.files += %w( src/core/lib/iomgr/socket_mutator.h )
  s.files += %w( src/core/lib/iomgr/socket_utils.h )
  s.files += %w( src/core/lib/iomgr/socket_utils_common_posix.cc )
  s.files += %w( src/core/lib/iomgr/socket_utils_linux.cc )
  s.files += %w( src/core/lib/iomgr/socket_utils_posix.cc )
  s.files += %w( src/core/lib/iomgr/socket_utils_posix.h )
  s.files += %w( src/core/lib/iomgr/socket_utils_windows.cc )
  s.files += %w( src/core/lib/iomgr/socket_windows.cc )
  s.files += %w( src/core/lib/iomgr/socket_windows.h )
  s.files += %w( src/core/lib/iomgr/systemd_utils.cc )
  s.files += %w( src/core/lib/iomgr/systemd_utils.h )
  s.files += %w( src/core/lib/iomgr/tcp_client.cc )
  s.files += %w( src/core/lib/iomgr/tcp_client.h )
  s.files += %w( src/core/lib/iomgr/tcp_client_cfstream.cc )
  s.files += %w( src/core/lib/iomgr/tcp_client_posix.cc )
  s.files += %w( src/core/lib/iomgr/tcp_client_posix.h )
  s.files += %w( src/core/lib/iomgr/tcp_client_windows.cc )
  s.files += %w( src/core/lib/iomgr/tcp_posix.cc )
  s.files += %w( src/core/lib/iomgr/tcp_posix.h )
  s.files += %w( src/core/lib/iomgr/tcp_server.cc )
  s.files += %w( src/core/lib/iomgr/tcp_server.h )
  s.files += %w( src/core/lib/iomgr/tcp_server_posix.cc )
  s.files += %w( src/core/lib/iomgr/tcp_server_utils_posix.h )
  s.files += %w( src/core/lib/iomgr/tcp_server_utils_posix_common.cc )
  s.files += %w( src/core/lib/iomgr/tcp_server_utils_posix_ifaddrs.cc )
  s.files += %w( src/core/lib/iomgr/tcp_server_utils_posix_noifaddrs.cc )
  s.files += %w( src/core/lib/iomgr/tcp_server_windows.cc )
  s.files += %w( src/core/lib/iomgr/tcp_windows.cc )
  s.files += %w( src/core/lib/iomgr/tcp_windows.h )
  s.files += %w( src/core/lib/iomgr/timer.cc )
  s.files += %w( src/core/lib/iomgr/timer.h )
  s.files += %w( src/core/lib/iomgr/timer_generic.cc )
  s.files += %w( src/core/lib/iomgr/timer_generic.h )
  s.files += %w( src/core/lib/iomgr/timer_heap.cc )
  s.files += %w( src/core/lib/iomgr/timer_heap.h )
  s.files += %w( src/core/lib/iomgr/timer_manager.cc )
  s.files += %w( src/core/lib/iomgr/timer_manager.h )
  s.files += %w( src/core/lib/iomgr/unix_sockets_posix.cc )
  s.files += %w( src/core/lib/iomgr/unix_sockets_posix.h )
  s.files += %w( src/core/lib/iomgr/unix_sockets_posix_noop.cc )
  s.files += %w( src/core/lib/iomgr/wakeup_fd_eventfd.cc )
  s.files += %w( src/core/lib/iomgr/wakeup_fd_nospecial.cc )
  s.files += %w( src/core/lib/iomgr/wakeup_fd_pipe.cc )
  s.files += %w( src/core/lib/iomgr/wakeup_fd_pipe.h )
  s.files += %w( src/core/lib/iomgr/wakeup_fd_posix.cc )
  s.files += %w( src/core/lib/iomgr/wakeup_fd_posix.h )
  s.files += %w( src/core/lib/json/json.h )
  s.files += %w( src/core/lib/json/json_args.h )
  s.files += %w( src/core/lib/json/json_channel_args.h )
  s.files += %w( src/core/lib/json/json_object_loader.cc )
  s.files += %w( src/core/lib/json/json_object_loader.h )
  s.files += %w( src/core/lib/json/json_reader.cc )
  s.files += %w( src/core/lib/json/json_util.cc )
  s.files += %w( src/core/lib/json/json_util.h )
  s.files += %w( src/core/lib/json/json_writer.cc )
  s.files += %w( src/core/lib/load_balancing/lb_policy.cc )
  s.files += %w( src/core/lib/load_balancing/lb_policy.h )
  s.files += %w( src/core/lib/load_balancing/lb_policy_factory.h )
  s.files += %w( src/core/lib/load_balancing/lb_policy_registry.cc )
  s.files += %w( src/core/lib/load_balancing/lb_policy_registry.h )
  s.files += %w( src/core/lib/load_balancing/subchannel_interface.h )
  s.files += %w( src/core/lib/matchers/matchers.cc )
  s.files += %w( src/core/lib/matchers/matchers.h )
  s.files += %w( src/core/lib/promise/activity.cc )
  s.files += %w( src/core/lib/promise/activity.h )
  s.files += %w( src/core/lib/promise/arena_promise.h )
  s.files += %w( src/core/lib/promise/context.h )
  s.files += %w( src/core/lib/promise/detail/basic_seq.h )
  s.files += %w( src/core/lib/promise/detail/promise_factory.h )
  s.files += %w( src/core/lib/promise/detail/promise_like.h )
  s.files += %w( src/core/lib/promise/detail/status.h )
  s.files += %w( src/core/lib/promise/detail/switch.h )
  s.files += %w( src/core/lib/promise/exec_ctx_wakeup_scheduler.h )
  s.files += %w( src/core/lib/promise/for_each.h )
  s.files += %w( src/core/lib/promise/intra_activity_waiter.h )
  s.files += %w( src/core/lib/promise/latch.h )
  s.files += %w( src/core/lib/promise/loop.h )
  s.files += %w( src/core/lib/promise/map.h )
  s.files += %w( src/core/lib/promise/map_pipe.h )
  s.files += %w( src/core/lib/promise/pipe.cc )
  s.files += %w( src/core/lib/promise/pipe.h )
  s.files += %w( src/core/lib/promise/poll.h )
  s.files += %w( src/core/lib/promise/promise.h )
  s.files += %w( src/core/lib/promise/race.h )
  s.files += %w( src/core/lib/promise/seq.h )
  s.files += %w( src/core/lib/promise/sleep.cc )
  s.files += %w( src/core/lib/promise/sleep.h )
  s.files += %w( src/core/lib/promise/try_concurrently.h )
  s.files += %w( src/core/lib/promise/try_seq.h )
  s.files += %w( src/core/lib/resolver/resolver.cc )
  s.files += %w( src/core/lib/resolver/resolver.h )
  s.files += %w( src/core/lib/resolver/resolver_factory.h )
  s.files += %w( src/core/lib/resolver/resolver_registry.cc )
  s.files += %w( src/core/lib/resolver/resolver_registry.h )
  s.files += %w( src/core/lib/resolver/server_address.cc )
  s.files += %w( src/core/lib/resolver/server_address.h )
  s.files += %w( src/core/lib/resource_quota/api.cc )
  s.files += %w( src/core/lib/resource_quota/api.h )
  s.files += %w( src/core/lib/resource_quota/arena.cc )
  s.files += %w( src/core/lib/resource_quota/arena.h )
  s.files += %w( src/core/lib/resource_quota/memory_quota.cc )
  s.files += %w( src/core/lib/resource_quota/memory_quota.h )
  s.files += %w( src/core/lib/resource_quota/periodic_update.cc )
  s.files += %w( src/core/lib/resource_quota/periodic_update.h )
  s.files += %w( src/core/lib/resource_quota/resource_quota.cc )
  s.files += %w( src/core/lib/resource_quota/resource_quota.h )
  s.files += %w( src/core/lib/resource_quota/thread_quota.cc )
  s.files += %w( src/core/lib/resource_quota/thread_quota.h )
  s.files += %w( src/core/lib/resource_quota/trace.cc )
  s.files += %w( src/core/lib/resource_quota/trace.h )
  s.files += %w( src/core/lib/security/authorization/authorization_engine.h )
  s.files += %w( src/core/lib/security/authorization/authorization_policy_provider.h )
  s.files += %w( src/core/lib/security/authorization/authorization_policy_provider_vtable.cc )
  s.files += %w( src/core/lib/security/authorization/evaluate_args.cc )
  s.files += %w( src/core/lib/security/authorization/evaluate_args.h )
  s.files += %w( src/core/lib/security/authorization/grpc_authorization_engine.cc )
  s.files += %w( src/core/lib/security/authorization/grpc_authorization_engine.h )
  s.files += %w( src/core/lib/security/authorization/grpc_server_authz_filter.cc )
  s.files += %w( src/core/lib/security/authorization/grpc_server_authz_filter.h )
  s.files += %w( src/core/lib/security/authorization/matchers.cc )
  s.files += %w( src/core/lib/security/authorization/matchers.h )
  s.files += %w( src/core/lib/security/authorization/rbac_policy.cc )
  s.files += %w( src/core/lib/security/authorization/rbac_policy.h )
  s.files += %w( src/core/lib/security/certificate_provider/certificate_provider_factory.h )
  s.files += %w( src/core/lib/security/certificate_provider/certificate_provider_registry.cc )
  s.files += %w( src/core/lib/security/certificate_provider/certificate_provider_registry.h )
  s.files += %w( src/core/lib/security/context/security_context.cc )
  s.files += %w( src/core/lib/security/context/security_context.h )
  s.files += %w( src/core/lib/security/credentials/alts/alts_credentials.cc )
  s.files += %w( src/core/lib/security/credentials/alts/alts_credentials.h )
  s.files += %w( src/core/lib/security/credentials/alts/check_gcp_environment.cc )
  s.files += %w( src/core/lib/security/credentials/alts/check_gcp_environment.h )
  s.files += %w( src/core/lib/security/credentials/alts/check_gcp_environment_linux.cc )
  s.files += %w( src/core/lib/security/credentials/alts/check_gcp_environment_no_op.cc )
  s.files += %w( src/core/lib/security/credentials/alts/check_gcp_environment_windows.cc )
  s.files += %w( src/core/lib/security/credentials/alts/grpc_alts_credentials_client_options.cc )
  s.files += %w( src/core/lib/security/credentials/alts/grpc_alts_credentials_options.cc )
  s.files += %w( src/core/lib/security/credentials/alts/grpc_alts_credentials_options.h )
  s.files += %w( src/core/lib/security/credentials/alts/grpc_alts_credentials_server_options.cc )
  s.files += %w( src/core/lib/security/credentials/call_creds_util.cc )
  s.files += %w( src/core/lib/security/credentials/call_creds_util.h )
  s.files += %w( src/core/lib/security/credentials/channel_creds_registry.h )
  s.files += %w( src/core/lib/security/credentials/channel_creds_registry_init.cc )
  s.files += %w( src/core/lib/security/credentials/composite/composite_credentials.cc )
  s.files += %w( src/core/lib/security/credentials/composite/composite_credentials.h )
  s.files += %w( src/core/lib/security/credentials/credentials.cc )
  s.files += %w( src/core/lib/security/credentials/credentials.h )
  s.files += %w( src/core/lib/security/credentials/external/aws_external_account_credentials.cc )
  s.files += %w( src/core/lib/security/credentials/external/aws_external_account_credentials.h )
  s.files += %w( src/core/lib/security/credentials/external/aws_request_signer.cc )
  s.files += %w( src/core/lib/security/credentials/external/aws_request_signer.h )
  s.files += %w( src/core/lib/security/credentials/external/external_account_credentials.cc )
  s.files += %w( src/core/lib/security/credentials/external/external_account_credentials.h )
  s.files += %w( src/core/lib/security/credentials/external/file_external_account_credentials.cc )
  s.files += %w( src/core/lib/security/credentials/external/file_external_account_credentials.h )
  s.files += %w( src/core/lib/security/credentials/external/url_external_account_credentials.cc )
  s.files += %w( src/core/lib/security/credentials/external/url_external_account_credentials.h )
  s.files += %w( src/core/lib/security/credentials/fake/fake_credentials.cc )
  s.files += %w( src/core/lib/security/credentials/fake/fake_credentials.h )
  s.files += %w( src/core/lib/security/credentials/google_default/credentials_generic.cc )
  s.files += %w( src/core/lib/security/credentials/google_default/google_default_credentials.cc )
  s.files += %w( src/core/lib/security/credentials/google_default/google_default_credentials.h )
  s.files += %w( src/core/lib/security/credentials/iam/iam_credentials.cc )
  s.files += %w( src/core/lib/security/credentials/iam/iam_credentials.h )
  s.files += %w( src/core/lib/security/credentials/insecure/insecure_credentials.cc )
  s.files += %w( src/core/lib/security/credentials/insecure/insecure_credentials.h )
  s.files += %w( src/core/lib/security/credentials/jwt/json_token.cc )
  s.files += %w( src/core/lib/security/credentials/jwt/json_token.h )
  s.files += %w( src/core/lib/security/credentials/jwt/jwt_credentials.cc )
  s.files += %w( src/core/lib/security/credentials/jwt/jwt_credentials.h )
  s.files += %w( src/core/lib/security/credentials/jwt/jwt_verifier.cc )
  s.files += %w( src/core/lib/security/credentials/jwt/jwt_verifier.h )
  s.files += %w( src/core/lib/security/credentials/local/local_credentials.cc )
  s.files += %w( src/core/lib/security/credentials/local/local_credentials.h )
  s.files += %w( src/core/lib/security/credentials/oauth2/oauth2_credentials.cc )
  s.files += %w( src/core/lib/security/credentials/oauth2/oauth2_credentials.h )
  s.files += %w( src/core/lib/security/credentials/plugin/plugin_credentials.cc )
  s.files += %w( src/core/lib/security/credentials/plugin/plugin_credentials.h )
  s.files += %w( src/core/lib/security/credentials/ssl/ssl_credentials.cc )
  s.files += %w( src/core/lib/security/credentials/ssl/ssl_credentials.h )
  s.files += %w( src/core/lib/security/credentials/tls/grpc_tls_certificate_distributor.cc )
  s.files += %w( src/core/lib/security/credentials/tls/grpc_tls_certificate_distributor.h )
  s.files += %w( src/core/lib/security/credentials/tls/grpc_tls_certificate_provider.cc )
  s.files += %w( src/core/lib/security/credentials/tls/grpc_tls_certificate_provider.h )
  s.files += %w( src/core/lib/security/credentials/tls/grpc_tls_certificate_verifier.cc )
  s.files += %w( src/core/lib/security/credentials/tls/grpc_tls_certificate_verifier.h )
  s.files += %w( src/core/lib/security/credentials/tls/grpc_tls_credentials_options.cc )
  s.files += %w( src/core/lib/security/credentials/tls/grpc_tls_credentials_options.h )
  s.files += %w( src/core/lib/security/credentials/tls/tls_credentials.cc )
  s.files += %w( src/core/lib/security/credentials/tls/tls_credentials.h )
  s.files += %w( src/core/lib/security/credentials/tls/tls_utils.cc )
  s.files += %w( src/core/lib/security/credentials/tls/tls_utils.h )
  s.files += %w( src/core/lib/security/credentials/xds/xds_credentials.cc )
  s.files += %w( src/core/lib/security/credentials/xds/xds_credentials.h )
  s.files += %w( src/core/lib/security/security_connector/alts/alts_security_connector.cc )
  s.files += %w( src/core/lib/security/security_connector/alts/alts_security_connector.h )
  s.files += %w( src/core/lib/security/security_connector/fake/fake_security_connector.cc )
  s.files += %w( src/core/lib/security/security_connector/fake/fake_security_connector.h )
  s.files += %w( src/core/lib/security/security_connector/insecure/insecure_security_connector.cc )
  s.files += %w( src/core/lib/security/security_connector/insecure/insecure_security_connector.h )
  s.files += %w( src/core/lib/security/security_connector/load_system_roots.h )
  s.files += %w( src/core/lib/security/security_connector/load_system_roots_fallback.cc )
  s.files += %w( src/core/lib/security/security_connector/load_system_roots_supported.cc )
  s.files += %w( src/core/lib/security/security_connector/load_system_roots_supported.h )
  s.files += %w( src/core/lib/security/security_connector/local/local_security_connector.cc )
  s.files += %w( src/core/lib/security/security_connector/local/local_security_connector.h )
  s.files += %w( src/core/lib/security/security_connector/security_connector.cc )
  s.files += %w( src/core/lib/security/security_connector/security_connector.h )
  s.files += %w( src/core/lib/security/security_connector/ssl/ssl_security_connector.cc )
  s.files += %w( src/core/lib/security/security_connector/ssl/ssl_security_connector.h )
  s.files += %w( src/core/lib/security/security_connector/ssl_utils.cc )
  s.files += %w( src/core/lib/security/security_connector/ssl_utils.h )
  s.files += %w( src/core/lib/security/security_connector/ssl_utils_config.cc )
  s.files += %w( src/core/lib/security/security_connector/ssl_utils_config.h )
  s.files += %w( src/core/lib/security/security_connector/tls/tls_security_connector.cc )
  s.files += %w( src/core/lib/security/security_connector/tls/tls_security_connector.h )
  s.files += %w( src/core/lib/security/transport/auth_filters.h )
  s.files += %w( src/core/lib/security/transport/client_auth_filter.cc )
  s.files += %w( src/core/lib/security/transport/secure_endpoint.cc )
  s.files += %w( src/core/lib/security/transport/secure_endpoint.h )
  s.files += %w( src/core/lib/security/transport/security_handshaker.cc )
  s.files += %w( src/core/lib/security/transport/security_handshaker.h )
  s.files += %w( src/core/lib/security/transport/server_auth_filter.cc )
  s.files += %w( src/core/lib/security/transport/tsi_error.cc )
  s.files += %w( src/core/lib/security/transport/tsi_error.h )
  s.files += %w( src/core/lib/security/util/json_util.cc )
  s.files += %w( src/core/lib/security/util/json_util.h )
  s.files += %w( src/core/lib/service_config/service_config.h )
  s.files += %w( src/core/lib/service_config/service_config_call_data.h )
  s.files += %w( src/core/lib/service_config/service_config_impl.cc )
  s.files += %w( src/core/lib/service_config/service_config_impl.h )
  s.files += %w( src/core/lib/service_config/service_config_parser.cc )
  s.files += %w( src/core/lib/service_config/service_config_parser.h )
  s.files += %w( src/core/lib/slice/b64.cc )
  s.files += %w( src/core/lib/slice/b64.h )
  s.files += %w( src/core/lib/slice/percent_encoding.cc )
  s.files += %w( src/core/lib/slice/percent_encoding.h )
  s.files += %w( src/core/lib/slice/slice.cc )
  s.files += %w( src/core/lib/slice/slice.h )
  s.files += %w( src/core/lib/slice/slice_buffer.cc )
  s.files += %w( src/core/lib/slice/slice_buffer.h )
  s.files += %w( src/core/lib/slice/slice_internal.h )
  s.files += %w( src/core/lib/slice/slice_refcount.h )
  s.files += %w( src/core/lib/slice/slice_string_helpers.cc )
  s.files += %w( src/core/lib/slice/slice_string_helpers.h )
  s.files += %w( src/core/lib/surface/api_trace.cc )
  s.files += %w( src/core/lib/surface/api_trace.h )
  s.files += %w( src/core/lib/surface/builtins.cc )
  s.files += %w( src/core/lib/surface/builtins.h )
  s.files += %w( src/core/lib/surface/byte_buffer.cc )
  s.files += %w( src/core/lib/surface/byte_buffer_reader.cc )
  s.files += %w( src/core/lib/surface/call.cc )
  s.files += %w( src/core/lib/surface/call.h )
  s.files += %w( src/core/lib/surface/call_details.cc )
  s.files += %w( src/core/lib/surface/call_log_batch.cc )
  s.files += %w( src/core/lib/surface/call_test_only.h )
  s.files += %w( src/core/lib/surface/call_trace.cc )
  s.files += %w( src/core/lib/surface/call_trace.h )
  s.files += %w( src/core/lib/surface/channel.cc )
  s.files += %w( src/core/lib/surface/channel.h )
  s.files += %w( src/core/lib/surface/channel_init.cc )
  s.files += %w( src/core/lib/surface/channel_init.h )
  s.files += %w( src/core/lib/surface/channel_ping.cc )
  s.files += %w( src/core/lib/surface/channel_stack_type.cc )
  s.files += %w( src/core/lib/surface/channel_stack_type.h )
  s.files += %w( src/core/lib/surface/completion_queue.cc )
  s.files += %w( src/core/lib/surface/completion_queue.h )
  s.files += %w( src/core/lib/surface/completion_queue_factory.cc )
  s.files += %w( src/core/lib/surface/completion_queue_factory.h )
  s.files += %w( src/core/lib/surface/event_string.cc )
  s.files += %w( src/core/lib/surface/event_string.h )
  s.files += %w( src/core/lib/surface/init.cc )
  s.files += %w( src/core/lib/surface/init.h )
  s.files += %w( src/core/lib/surface/init_internally.cc )
  s.files += %w( src/core/lib/surface/init_internally.h )
  s.files += %w( src/core/lib/surface/lame_client.cc )
  s.files += %w( src/core/lib/surface/lame_client.h )
  s.files += %w( src/core/lib/surface/metadata_array.cc )
  s.files += %w( src/core/lib/surface/server.cc )
  s.files += %w( src/core/lib/surface/server.h )
  s.files += %w( src/core/lib/surface/validate_metadata.cc )
  s.files += %w( src/core/lib/surface/validate_metadata.h )
  s.files += %w( src/core/lib/surface/version.cc )
  s.files += %w( src/core/lib/transport/bdp_estimator.cc )
  s.files += %w( src/core/lib/transport/bdp_estimator.h )
  s.files += %w( src/core/lib/transport/connectivity_state.cc )
  s.files += %w( src/core/lib/transport/connectivity_state.h )
  s.files += %w( src/core/lib/transport/error_utils.cc )
  s.files += %w( src/core/lib/transport/error_utils.h )
  s.files += %w( src/core/lib/transport/handshaker.cc )
  s.files += %w( src/core/lib/transport/handshaker.h )
  s.files += %w( src/core/lib/transport/handshaker_factory.h )
  s.files += %w( src/core/lib/transport/handshaker_registry.cc )
  s.files += %w( src/core/lib/transport/handshaker_registry.h )
  s.files += %w( src/core/lib/transport/http2_errors.h )
  s.files += %w( src/core/lib/transport/http_connect_handshaker.cc )
  s.files += %w( src/core/lib/transport/http_connect_handshaker.h )
  s.files += %w( src/core/lib/transport/metadata_batch.cc )
  s.files += %w( src/core/lib/transport/metadata_batch.h )
  s.files += %w( src/core/lib/transport/parsed_metadata.cc )
  s.files += %w( src/core/lib/transport/parsed_metadata.h )
  s.files += %w( src/core/lib/transport/pid_controller.cc )
  s.files += %w( src/core/lib/transport/pid_controller.h )
  s.files += %w( src/core/lib/transport/status_conversion.cc )
  s.files += %w( src/core/lib/transport/status_conversion.h )
  s.files += %w( src/core/lib/transport/tcp_connect_handshaker.cc )
  s.files += %w( src/core/lib/transport/tcp_connect_handshaker.h )
  s.files += %w( src/core/lib/transport/timeout_encoding.cc )
  s.files += %w( src/core/lib/transport/timeout_encoding.h )
  s.files += %w( src/core/lib/transport/transport.cc )
  s.files += %w( src/core/lib/transport/transport.h )
  s.files += %w( src/core/lib/transport/transport_fwd.h )
  s.files += %w( src/core/lib/transport/transport_impl.h )
  s.files += %w( src/core/lib/transport/transport_op_string.cc )
  s.files += %w( src/core/lib/uri/uri_parser.cc )
  s.files += %w( src/core/lib/uri/uri_parser.h )
  s.files += %w( src/core/plugin_registry/grpc_plugin_registry.cc )
  s.files += %w( src/core/plugin_registry/grpc_plugin_registry_extra.cc )
  s.files += %w( src/core/tsi/alts/crypt/aes_gcm.cc )
  s.files += %w( src/core/tsi/alts/crypt/gsec.cc )
  s.files += %w( src/core/tsi/alts/crypt/gsec.h )
  s.files += %w( src/core/tsi/alts/frame_protector/alts_counter.cc )
  s.files += %w( src/core/tsi/alts/frame_protector/alts_counter.h )
  s.files += %w( src/core/tsi/alts/frame_protector/alts_crypter.cc )
  s.files += %w( src/core/tsi/alts/frame_protector/alts_crypter.h )
  s.files += %w( src/core/tsi/alts/frame_protector/alts_frame_protector.cc )
  s.files += %w( src/core/tsi/alts/frame_protector/alts_frame_protector.h )
  s.files += %w( src/core/tsi/alts/frame_protector/alts_record_protocol_crypter_common.cc )
  s.files += %w( src/core/tsi/alts/frame_protector/alts_record_protocol_crypter_common.h )
  s.files += %w( src/core/tsi/alts/frame_protector/alts_seal_privacy_integrity_crypter.cc )
  s.files += %w( src/core/tsi/alts/frame_protector/alts_unseal_privacy_integrity_crypter.cc )
  s.files += %w( src/core/tsi/alts/frame_protector/frame_handler.cc )
  s.files += %w( src/core/tsi/alts/frame_protector/frame_handler.h )
  s.files += %w( src/core/tsi/alts/handshaker/alts_handshaker_client.cc )
  s.files += %w( src/core/tsi/alts/handshaker/alts_handshaker_client.h )
  s.files += %w( src/core/tsi/alts/handshaker/alts_shared_resource.cc )
  s.files += %w( src/core/tsi/alts/handshaker/alts_shared_resource.h )
  s.files += %w( src/core/tsi/alts/handshaker/alts_tsi_handshaker.cc )
  s.files += %w( src/core/tsi/alts/handshaker/alts_tsi_handshaker.h )
  s.files += %w( src/core/tsi/alts/handshaker/alts_tsi_handshaker_private.h )
  s.files += %w( src/core/tsi/alts/handshaker/alts_tsi_utils.cc )
  s.files += %w( src/core/tsi/alts/handshaker/alts_tsi_utils.h )
  s.files += %w( src/core/tsi/alts/handshaker/transport_security_common_api.cc )
  s.files += %w( src/core/tsi/alts/handshaker/transport_security_common_api.h )
  s.files += %w( src/core/tsi/alts/zero_copy_frame_protector/alts_grpc_integrity_only_record_protocol.cc )
  s.files += %w( src/core/tsi/alts/zero_copy_frame_protector/alts_grpc_integrity_only_record_protocol.h )
  s.files += %w( src/core/tsi/alts/zero_copy_frame_protector/alts_grpc_privacy_integrity_record_protocol.cc )
  s.files += %w( src/core/tsi/alts/zero_copy_frame_protector/alts_grpc_privacy_integrity_record_protocol.h )
  s.files += %w( src/core/tsi/alts/zero_copy_frame_protector/alts_grpc_record_protocol.h )
  s.files += %w( src/core/tsi/alts/zero_copy_frame_protector/alts_grpc_record_protocol_common.cc )
  s.files += %w( src/core/tsi/alts/zero_copy_frame_protector/alts_grpc_record_protocol_common.h )
  s.files += %w( src/core/tsi/alts/zero_copy_frame_protector/alts_iovec_record_protocol.cc )
  s.files += %w( src/core/tsi/alts/zero_copy_frame_protector/alts_iovec_record_protocol.h )
  s.files += %w( src/core/tsi/alts/zero_copy_frame_protector/alts_zero_copy_grpc_protector.cc )
  s.files += %w( src/core/tsi/alts/zero_copy_frame_protector/alts_zero_copy_grpc_protector.h )
  s.files += %w( src/core/tsi/fake_transport_security.cc )
  s.files += %w( src/core/tsi/fake_transport_security.h )
  s.files += %w( src/core/tsi/local_transport_security.cc )
  s.files += %w( src/core/tsi/local_transport_security.h )
  s.files += %w( src/core/tsi/ssl/key_logging/ssl_key_logging.cc )
  s.files += %w( src/core/tsi/ssl/key_logging/ssl_key_logging.h )
  s.files += %w( src/core/tsi/ssl/session_cache/ssl_session.h )
  s.files += %w( src/core/tsi/ssl/session_cache/ssl_session_boringssl.cc )
  s.files += %w( src/core/tsi/ssl/session_cache/ssl_session_cache.cc )
  s.files += %w( src/core/tsi/ssl/session_cache/ssl_session_cache.h )
  s.files += %w( src/core/tsi/ssl/session_cache/ssl_session_openssl.cc )
  s.files += %w( src/core/tsi/ssl_transport_security.cc )
  s.files += %w( src/core/tsi/ssl_transport_security.h )
  s.files += %w( src/core/tsi/ssl_transport_security_utils.cc )
  s.files += %w( src/core/tsi/ssl_transport_security_utils.h )
  s.files += %w( src/core/tsi/ssl_types.h )
  s.files += %w( src/core/tsi/transport_security.cc )
  s.files += %w( src/core/tsi/transport_security.h )
  s.files += %w( src/core/tsi/transport_security_grpc.cc )
  s.files += %w( src/core/tsi/transport_security_grpc.h )
  s.files += %w( src/core/tsi/transport_security_interface.h )
  s.files += %w( third_party/abseil-cpp/absl/algorithm/algorithm.h )
  s.files += %w( third_party/abseil-cpp/absl/algorithm/container.h )
  s.files += %w( third_party/abseil-cpp/absl/base/attributes.h )
  s.files += %w( third_party/abseil-cpp/absl/base/call_once.h )
  s.files += %w( third_party/abseil-cpp/absl/base/casts.h )
  s.files += %w( third_party/abseil-cpp/absl/base/config.h )
  s.files += %w( third_party/abseil-cpp/absl/base/const_init.h )
  s.files += %w( third_party/abseil-cpp/absl/base/dynamic_annotations.h )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/atomic_hook.h )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/cycleclock.cc )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/cycleclock.h )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/direct_mmap.h )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/dynamic_annotations.h )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/endian.h )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/errno_saver.h )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/fast_type_id.h )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/hide_ptr.h )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/identity.h )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/inline_variable.h )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/invoke.h )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/low_level_alloc.cc )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/low_level_alloc.h )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/low_level_scheduling.h )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/per_thread_tls.h )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/prefetch.h )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/raw_logging.cc )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/raw_logging.h )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/scheduling_mode.h )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/spinlock.cc )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/spinlock.h )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/spinlock_akaros.inc )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/spinlock_linux.inc )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/spinlock_posix.inc )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/spinlock_wait.cc )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/spinlock_wait.h )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/spinlock_win32.inc )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/strerror.cc )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/strerror.h )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/sysinfo.cc )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/sysinfo.h )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/thread_annotations.h )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/thread_identity.cc )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/thread_identity.h )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/throw_delegate.cc )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/throw_delegate.h )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/tsan_mutex_interface.h )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/unaligned_access.h )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/unscaledcycleclock.cc )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/unscaledcycleclock.h )
  s.files += %w( third_party/abseil-cpp/absl/base/log_severity.cc )
  s.files += %w( third_party/abseil-cpp/absl/base/log_severity.h )
  s.files += %w( third_party/abseil-cpp/absl/base/macros.h )
  s.files += %w( third_party/abseil-cpp/absl/base/optimization.h )
  s.files += %w( third_party/abseil-cpp/absl/base/options.h )
  s.files += %w( third_party/abseil-cpp/absl/base/policy_checks.h )
  s.files += %w( third_party/abseil-cpp/absl/base/port.h )
  s.files += %w( third_party/abseil-cpp/absl/base/thread_annotations.h )
  s.files += %w( third_party/abseil-cpp/absl/cleanup/cleanup.h )
  s.files += %w( third_party/abseil-cpp/absl/cleanup/internal/cleanup.h )
  s.files += %w( third_party/abseil-cpp/absl/container/fixed_array.h )
  s.files += %w( third_party/abseil-cpp/absl/container/flat_hash_map.h )
  s.files += %w( third_party/abseil-cpp/absl/container/flat_hash_set.h )
  s.files += %w( third_party/abseil-cpp/absl/container/inlined_vector.h )
  s.files += %w( third_party/abseil-cpp/absl/container/internal/common.h )
  s.files += %w( third_party/abseil-cpp/absl/container/internal/compressed_tuple.h )
  s.files += %w( third_party/abseil-cpp/absl/container/internal/container_memory.h )
  s.files += %w( third_party/abseil-cpp/absl/container/internal/hash_function_defaults.h )
  s.files += %w( third_party/abseil-cpp/absl/container/internal/hash_policy_traits.h )
  s.files += %w( third_party/abseil-cpp/absl/container/internal/hashtable_debug_hooks.h )
  s.files += %w( third_party/abseil-cpp/absl/container/internal/hashtablez_sampler.cc )
  s.files += %w( third_party/abseil-cpp/absl/container/internal/hashtablez_sampler.h )
  s.files += %w( third_party/abseil-cpp/absl/container/internal/hashtablez_sampler_force_weak_definition.cc )
  s.files += %w( third_party/abseil-cpp/absl/container/internal/inlined_vector.h )
  s.files += %w( third_party/abseil-cpp/absl/container/internal/layout.h )
  s.files += %w( third_party/abseil-cpp/absl/container/internal/raw_hash_map.h )
  s.files += %w( third_party/abseil-cpp/absl/container/internal/raw_hash_set.cc )
  s.files += %w( third_party/abseil-cpp/absl/container/internal/raw_hash_set.h )
  s.files += %w( third_party/abseil-cpp/absl/debugging/internal/address_is_readable.cc )
  s.files += %w( third_party/abseil-cpp/absl/debugging/internal/address_is_readable.h )
  s.files += %w( third_party/abseil-cpp/absl/debugging/internal/demangle.cc )
  s.files += %w( third_party/abseil-cpp/absl/debugging/internal/demangle.h )
  s.files += %w( third_party/abseil-cpp/absl/debugging/internal/elf_mem_image.cc )
  s.files += %w( third_party/abseil-cpp/absl/debugging/internal/elf_mem_image.h )
  s.files += %w( third_party/abseil-cpp/absl/debugging/internal/stacktrace_aarch64-inl.inc )
  s.files += %w( third_party/abseil-cpp/absl/debugging/internal/stacktrace_arm-inl.inc )
  s.files += %w( third_party/abseil-cpp/absl/debugging/internal/stacktrace_config.h )
  s.files += %w( third_party/abseil-cpp/absl/debugging/internal/stacktrace_emscripten-inl.inc )
  s.files += %w( third_party/abseil-cpp/absl/debugging/internal/stacktrace_generic-inl.inc )
  s.files += %w( third_party/abseil-cpp/absl/debugging/internal/stacktrace_powerpc-inl.inc )
  s.files += %w( third_party/abseil-cpp/absl/debugging/internal/stacktrace_riscv-inl.inc )
  s.files += %w( third_party/abseil-cpp/absl/debugging/internal/stacktrace_unimplemented-inl.inc )
  s.files += %w( third_party/abseil-cpp/absl/debugging/internal/stacktrace_win32-inl.inc )
  s.files += %w( third_party/abseil-cpp/absl/debugging/internal/stacktrace_x86-inl.inc )
  s.files += %w( third_party/abseil-cpp/absl/debugging/internal/symbolize.h )
  s.files += %w( third_party/abseil-cpp/absl/debugging/internal/vdso_support.cc )
  s.files += %w( third_party/abseil-cpp/absl/debugging/internal/vdso_support.h )
  s.files += %w( third_party/abseil-cpp/absl/debugging/stacktrace.cc )
  s.files += %w( third_party/abseil-cpp/absl/debugging/stacktrace.h )
  s.files += %w( third_party/abseil-cpp/absl/debugging/symbolize.cc )
  s.files += %w( third_party/abseil-cpp/absl/debugging/symbolize.h )
  s.files += %w( third_party/abseil-cpp/absl/debugging/symbolize_darwin.inc )
  s.files += %w( third_party/abseil-cpp/absl/debugging/symbolize_elf.inc )
  s.files += %w( third_party/abseil-cpp/absl/debugging/symbolize_emscripten.inc )
  s.files += %w( third_party/abseil-cpp/absl/debugging/symbolize_unimplemented.inc )
  s.files += %w( third_party/abseil-cpp/absl/debugging/symbolize_win32.inc )
  s.files += %w( third_party/abseil-cpp/absl/functional/any_invocable.h )
  s.files += %w( third_party/abseil-cpp/absl/functional/bind_front.h )
  s.files += %w( third_party/abseil-cpp/absl/functional/function_ref.h )
  s.files += %w( third_party/abseil-cpp/absl/functional/internal/any_invocable.h )
  s.files += %w( third_party/abseil-cpp/absl/functional/internal/front_binder.h )
  s.files += %w( third_party/abseil-cpp/absl/functional/internal/function_ref.h )
  s.files += %w( third_party/abseil-cpp/absl/hash/hash.h )
  s.files += %w( third_party/abseil-cpp/absl/hash/internal/city.cc )
  s.files += %w( third_party/abseil-cpp/absl/hash/internal/city.h )
  s.files += %w( third_party/abseil-cpp/absl/hash/internal/hash.cc )
  s.files += %w( third_party/abseil-cpp/absl/hash/internal/hash.h )
  s.files += %w( third_party/abseil-cpp/absl/hash/internal/low_level_hash.cc )
  s.files += %w( third_party/abseil-cpp/absl/hash/internal/low_level_hash.h )
  s.files += %w( third_party/abseil-cpp/absl/memory/memory.h )
  s.files += %w( third_party/abseil-cpp/absl/meta/type_traits.h )
  s.files += %w( third_party/abseil-cpp/absl/numeric/bits.h )
  s.files += %w( third_party/abseil-cpp/absl/numeric/int128.cc )
  s.files += %w( third_party/abseil-cpp/absl/numeric/int128.h )
  s.files += %w( third_party/abseil-cpp/absl/numeric/int128_have_intrinsic.inc )
  s.files += %w( third_party/abseil-cpp/absl/numeric/int128_no_intrinsic.inc )
  s.files += %w( third_party/abseil-cpp/absl/numeric/internal/bits.h )
  s.files += %w( third_party/abseil-cpp/absl/numeric/internal/representation.h )
  s.files += %w( third_party/abseil-cpp/absl/profiling/internal/exponential_biased.cc )
  s.files += %w( third_party/abseil-cpp/absl/profiling/internal/exponential_biased.h )
  s.files += %w( third_party/abseil-cpp/absl/profiling/internal/sample_recorder.h )
  s.files += %w( third_party/abseil-cpp/absl/random/bernoulli_distribution.h )
  s.files += %w( third_party/abseil-cpp/absl/random/beta_distribution.h )
  s.files += %w( third_party/abseil-cpp/absl/random/discrete_distribution.cc )
  s.files += %w( third_party/abseil-cpp/absl/random/discrete_distribution.h )
  s.files += %w( third_party/abseil-cpp/absl/random/distributions.h )
  s.files += %w( third_party/abseil-cpp/absl/random/exponential_distribution.h )
  s.files += %w( third_party/abseil-cpp/absl/random/gaussian_distribution.cc )
  s.files += %w( third_party/abseil-cpp/absl/random/gaussian_distribution.h )
  s.files += %w( third_party/abseil-cpp/absl/random/internal/distribution_caller.h )
  s.files += %w( third_party/abseil-cpp/absl/random/internal/fast_uniform_bits.h )
  s.files += %w( third_party/abseil-cpp/absl/random/internal/fastmath.h )
  s.files += %w( third_party/abseil-cpp/absl/random/internal/generate_real.h )
  s.files += %w( third_party/abseil-cpp/absl/random/internal/iostream_state_saver.h )
  s.files += %w( third_party/abseil-cpp/absl/random/internal/nonsecure_base.h )
  s.files += %w( third_party/abseil-cpp/absl/random/internal/pcg_engine.h )
  s.files += %w( third_party/abseil-cpp/absl/random/internal/platform.h )
  s.files += %w( third_party/abseil-cpp/absl/random/internal/pool_urbg.cc )
  s.files += %w( third_party/abseil-cpp/absl/random/internal/pool_urbg.h )
  s.files += %w( third_party/abseil-cpp/absl/random/internal/randen.cc )
  s.files += %w( third_party/abseil-cpp/absl/random/internal/randen.h )
  s.files += %w( third_party/abseil-cpp/absl/random/internal/randen_detect.cc )
  s.files += %w( third_party/abseil-cpp/absl/random/internal/randen_detect.h )
  s.files += %w( third_party/abseil-cpp/absl/random/internal/randen_engine.h )
  s.files += %w( third_party/abseil-cpp/absl/random/internal/randen_hwaes.cc )
  s.files += %w( third_party/abseil-cpp/absl/random/internal/randen_hwaes.h )
  s.files += %w( third_party/abseil-cpp/absl/random/internal/randen_round_keys.cc )
  s.files += %w( third_party/abseil-cpp/absl/random/internal/randen_slow.cc )
  s.files += %w( third_party/abseil-cpp/absl/random/internal/randen_slow.h )
  s.files += %w( third_party/abseil-cpp/absl/random/internal/randen_traits.h )
  s.files += %w( third_party/abseil-cpp/absl/random/internal/salted_seed_seq.h )
  s.files += %w( third_party/abseil-cpp/absl/random/internal/seed_material.cc )
  s.files += %w( third_party/abseil-cpp/absl/random/internal/seed_material.h )
  s.files += %w( third_party/abseil-cpp/absl/random/internal/traits.h )
  s.files += %w( third_party/abseil-cpp/absl/random/internal/uniform_helper.h )
  s.files += %w( third_party/abseil-cpp/absl/random/internal/wide_multiply.h )
  s.files += %w( third_party/abseil-cpp/absl/random/log_uniform_int_distribution.h )
  s.files += %w( third_party/abseil-cpp/absl/random/poisson_distribution.h )
  s.files += %w( third_party/abseil-cpp/absl/random/random.h )
  s.files += %w( third_party/abseil-cpp/absl/random/seed_gen_exception.cc )
  s.files += %w( third_party/abseil-cpp/absl/random/seed_gen_exception.h )
  s.files += %w( third_party/abseil-cpp/absl/random/seed_sequences.cc )
  s.files += %w( third_party/abseil-cpp/absl/random/seed_sequences.h )
  s.files += %w( third_party/abseil-cpp/absl/random/uniform_int_distribution.h )
  s.files += %w( third_party/abseil-cpp/absl/random/uniform_real_distribution.h )
  s.files += %w( third_party/abseil-cpp/absl/random/zipf_distribution.h )
  s.files += %w( third_party/abseil-cpp/absl/status/internal/status_internal.h )
  s.files += %w( third_party/abseil-cpp/absl/status/internal/statusor_internal.h )
  s.files += %w( third_party/abseil-cpp/absl/status/status.cc )
  s.files += %w( third_party/abseil-cpp/absl/status/status.h )
  s.files += %w( third_party/abseil-cpp/absl/status/status_payload_printer.cc )
  s.files += %w( third_party/abseil-cpp/absl/status/status_payload_printer.h )
  s.files += %w( third_party/abseil-cpp/absl/status/statusor.cc )
  s.files += %w( third_party/abseil-cpp/absl/status/statusor.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/ascii.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/ascii.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/charconv.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/charconv.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/cord.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/cord.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/cord_analysis.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/cord_analysis.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/cord_buffer.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/cord_buffer.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/escaping.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/escaping.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/char_map.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/charconv_bigint.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/charconv_bigint.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/charconv_parse.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/charconv_parse.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/cord_data_edge.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/cord_internal.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/cord_internal.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/cord_rep_btree.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/cord_rep_btree.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/cord_rep_btree_navigator.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/cord_rep_btree_navigator.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/cord_rep_btree_reader.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/cord_rep_btree_reader.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/cord_rep_consume.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/cord_rep_consume.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/cord_rep_crc.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/cord_rep_crc.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/cord_rep_flat.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/cord_rep_ring.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/cord_rep_ring.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/cord_rep_ring_reader.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/cordz_functions.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/cordz_functions.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/cordz_handle.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/cordz_handle.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/cordz_info.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/cordz_info.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/cordz_statistics.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/cordz_update_scope.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/cordz_update_tracker.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/escaping.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/escaping.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/memutil.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/memutil.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/ostringstream.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/ostringstream.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/resize_uninitialized.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/stl_type_traits.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/str_format/arg.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/str_format/arg.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/str_format/bind.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/str_format/bind.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/str_format/checker.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/str_format/extension.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/str_format/extension.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/str_format/float_conversion.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/str_format/float_conversion.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/str_format/output.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/str_format/output.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/str_format/parser.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/str_format/parser.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/str_join_internal.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/str_split_internal.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/string_constant.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/utf8.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/utf8.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/match.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/match.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/numbers.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/numbers.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/str_cat.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/str_cat.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/str_format.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/str_join.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/str_replace.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/str_replace.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/str_split.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/str_split.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/string_view.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/string_view.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/strip.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/substitute.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/substitute.h )
  s.files += %w( third_party/abseil-cpp/absl/synchronization/barrier.cc )
  s.files += %w( third_party/abseil-cpp/absl/synchronization/barrier.h )
  s.files += %w( third_party/abseil-cpp/absl/synchronization/blocking_counter.cc )
  s.files += %w( third_party/abseil-cpp/absl/synchronization/blocking_counter.h )
  s.files += %w( third_party/abseil-cpp/absl/synchronization/internal/create_thread_identity.cc )
  s.files += %w( third_party/abseil-cpp/absl/synchronization/internal/create_thread_identity.h )
  s.files += %w( third_party/abseil-cpp/absl/synchronization/internal/futex.h )
  s.files += %w( third_party/abseil-cpp/absl/synchronization/internal/graphcycles.cc )
  s.files += %w( third_party/abseil-cpp/absl/synchronization/internal/graphcycles.h )
  s.files += %w( third_party/abseil-cpp/absl/synchronization/internal/kernel_timeout.h )
  s.files += %w( third_party/abseil-cpp/absl/synchronization/internal/per_thread_sem.cc )
  s.files += %w( third_party/abseil-cpp/absl/synchronization/internal/per_thread_sem.h )
  s.files += %w( third_party/abseil-cpp/absl/synchronization/internal/waiter.cc )
  s.files += %w( third_party/abseil-cpp/absl/synchronization/internal/waiter.h )
  s.files += %w( third_party/abseil-cpp/absl/synchronization/mutex.cc )
  s.files += %w( third_party/abseil-cpp/absl/synchronization/mutex.h )
  s.files += %w( third_party/abseil-cpp/absl/synchronization/notification.cc )
  s.files += %w( third_party/abseil-cpp/absl/synchronization/notification.h )
  s.files += %w( third_party/abseil-cpp/absl/time/civil_time.cc )
  s.files += %w( third_party/abseil-cpp/absl/time/civil_time.h )
  s.files += %w( third_party/abseil-cpp/absl/time/clock.cc )
  s.files += %w( third_party/abseil-cpp/absl/time/clock.h )
  s.files += %w( third_party/abseil-cpp/absl/time/duration.cc )
  s.files += %w( third_party/abseil-cpp/absl/time/format.cc )
  s.files += %w( third_party/abseil-cpp/absl/time/internal/cctz/include/cctz/civil_time.h )
  s.files += %w( third_party/abseil-cpp/absl/time/internal/cctz/include/cctz/civil_time_detail.h )
  s.files += %w( third_party/abseil-cpp/absl/time/internal/cctz/include/cctz/time_zone.h )
  s.files += %w( third_party/abseil-cpp/absl/time/internal/cctz/include/cctz/zone_info_source.h )
  s.files += %w( third_party/abseil-cpp/absl/time/internal/cctz/src/civil_time_detail.cc )
  s.files += %w( third_party/abseil-cpp/absl/time/internal/cctz/src/time_zone_fixed.cc )
  s.files += %w( third_party/abseil-cpp/absl/time/internal/cctz/src/time_zone_fixed.h )
  s.files += %w( third_party/abseil-cpp/absl/time/internal/cctz/src/time_zone_format.cc )
  s.files += %w( third_party/abseil-cpp/absl/time/internal/cctz/src/time_zone_if.cc )
  s.files += %w( third_party/abseil-cpp/absl/time/internal/cctz/src/time_zone_if.h )
  s.files += %w( third_party/abseil-cpp/absl/time/internal/cctz/src/time_zone_impl.cc )
  s.files += %w( third_party/abseil-cpp/absl/time/internal/cctz/src/time_zone_impl.h )
  s.files += %w( third_party/abseil-cpp/absl/time/internal/cctz/src/time_zone_info.cc )
  s.files += %w( third_party/abseil-cpp/absl/time/internal/cctz/src/time_zone_info.h )
  s.files += %w( third_party/abseil-cpp/absl/time/internal/cctz/src/time_zone_libc.cc )
  s.files += %w( third_party/abseil-cpp/absl/time/internal/cctz/src/time_zone_libc.h )
  s.files += %w( third_party/abseil-cpp/absl/time/internal/cctz/src/time_zone_lookup.cc )
  s.files += %w( third_party/abseil-cpp/absl/time/internal/cctz/src/time_zone_posix.cc )
  s.files += %w( third_party/abseil-cpp/absl/time/internal/cctz/src/time_zone_posix.h )
  s.files += %w( third_party/abseil-cpp/absl/time/internal/cctz/src/tzfile.h )
  s.files += %w( third_party/abseil-cpp/absl/time/internal/cctz/src/zone_info_source.cc )
  s.files += %w( third_party/abseil-cpp/absl/time/internal/get_current_time_chrono.inc )
  s.files += %w( third_party/abseil-cpp/absl/time/internal/get_current_time_posix.inc )
  s.files += %w( third_party/abseil-cpp/absl/time/time.cc )
  s.files += %w( third_party/abseil-cpp/absl/time/time.h )
  s.files += %w( third_party/abseil-cpp/absl/types/bad_optional_access.cc )
  s.files += %w( third_party/abseil-cpp/absl/types/bad_optional_access.h )
  s.files += %w( third_party/abseil-cpp/absl/types/bad_variant_access.cc )
  s.files += %w( third_party/abseil-cpp/absl/types/bad_variant_access.h )
  s.files += %w( third_party/abseil-cpp/absl/types/internal/optional.h )
  s.files += %w( third_party/abseil-cpp/absl/types/internal/span.h )
  s.files += %w( third_party/abseil-cpp/absl/types/internal/variant.h )
  s.files += %w( third_party/abseil-cpp/absl/types/optional.h )
  s.files += %w( third_party/abseil-cpp/absl/types/span.h )
  s.files += %w( third_party/abseil-cpp/absl/types/variant.h )
  s.files += %w( third_party/abseil-cpp/absl/utility/utility.h )
  s.files += %w( third_party/address_sorting/address_sorting.c )
  s.files += %w( third_party/address_sorting/address_sorting_internal.h )
  s.files += %w( third_party/address_sorting/address_sorting_posix.c )
  s.files += %w( third_party/address_sorting/address_sorting_windows.c )
  s.files += %w( third_party/address_sorting/include/address_sorting/address_sorting.h )
  s.files += %w( third_party/boringssl-with-bazel/err_data.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/a_bitstr.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/a_bool.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/a_d2i_fp.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/a_dup.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/a_enum.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/a_gentm.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/a_i2d_fp.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/a_int.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/a_mbstr.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/a_object.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/a_octet.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/a_print.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/a_strex.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/a_strnid.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/a_time.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/a_type.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/a_utctm.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/a_utf8.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/asn1_lib.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/asn1_par.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/asn_pack.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/charmap.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/f_int.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/f_string.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/tasn_dec.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/tasn_enc.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/tasn_fre.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/tasn_new.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/tasn_typ.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/tasn_utl.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/time_support.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/base64/base64.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/bio/bio.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/bio/bio_mem.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/bio/connect.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/bio/fd.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/bio/file.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/bio/hexdump.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/bio/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/bio/pair.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/bio/printf.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/bio/socket.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/bio/socket_helper.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/blake2/blake2.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/bn_extra/bn_asn1.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/bn_extra/convert.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/buf/buf.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/bytestring/asn1_compat.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/bytestring/ber.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/bytestring/cbb.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/bytestring/cbs.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/bytestring/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/bytestring/unicode.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/chacha/chacha.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/chacha/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/cipher_extra/cipher_extra.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/cipher_extra/derive_key.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/cipher_extra/e_aesccm.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/cipher_extra/e_aesctrhmac.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/cipher_extra/e_aesgcmsiv.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/cipher_extra/e_chacha20poly1305.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/cipher_extra/e_null.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/cipher_extra/e_rc2.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/cipher_extra/e_rc4.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/cipher_extra/e_tls.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/cipher_extra/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/cipher_extra/tls_cbc.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/cmac/cmac.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/conf/conf.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/conf/conf_def.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/conf/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/cpu-aarch64-fuchsia.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/cpu-aarch64-linux.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/cpu-aarch64-win.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/cpu-arm-linux.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/cpu-arm-linux.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/cpu-arm.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/cpu-intel.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/cpu-ppc64le.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/crypto.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/curve25519/curve25519.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/curve25519/curve25519_tables.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/curve25519/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/curve25519/spake25519.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/dh_extra/dh_asn1.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/dh_extra/params.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/digest_extra/digest_extra.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/dsa/dsa.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/dsa/dsa_asn1.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/dsa/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/ec_extra/ec_asn1.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/ec_extra/ec_derive.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/ec_extra/hash_to_curve.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/ec_extra/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/ecdh_extra/ecdh_extra.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/ecdsa_extra/ecdsa_asn1.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/engine/engine.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/err/err.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/err/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/evp/digestsign.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/evp/evp.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/evp/evp_asn1.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/evp/evp_ctx.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/evp/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/evp/p_dsa_asn1.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/evp/p_ec.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/evp/p_ec_asn1.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/evp/p_ed25519.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/evp/p_ed25519_asn1.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/evp/p_rsa.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/evp/p_rsa_asn1.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/evp/p_x25519.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/evp/p_x25519_asn1.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/evp/pbkdf.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/evp/print.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/evp/scrypt.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/evp/sign.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/ex_data.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/aes/aes.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/aes/aes_nohw.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/aes/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/aes/key_wrap.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/aes/mode_wrappers.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/bcm.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/bn/add.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/bn/asm/x86_64-gcc.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/bn/bn.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/bn/bytes.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/bn/cmp.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/bn/ctx.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/bn/div.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/bn/div_extra.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/bn/exponentiation.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/bn/gcd.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/bn/gcd_extra.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/bn/generic.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/bn/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/bn/jacobi.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/bn/montgomery.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/bn/montgomery_inv.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/bn/mul.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/bn/prime.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/bn/random.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/bn/rsaz_exp.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/bn/rsaz_exp.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/bn/shift.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/bn/sqrt.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/cipher/aead.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/cipher/cipher.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/cipher/e_aes.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/cipher/e_des.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/cipher/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/delocate.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/des/des.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/des/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/dh/check.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/dh/dh.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/digest/digest.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/digest/digests.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/digest/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/digest/md32_common.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/ec/ec.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/ec/ec_key.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/ec/ec_montgomery.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/ec/felem.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/ec/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/ec/oct.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/ec/p224-64.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/ec/p256-x86_64-table.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/ec/p256-x86_64.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/ec/p256-x86_64.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/ec/p256.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/ec/p256_table.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/ec/scalar.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/ec/simple.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/ec/simple_mul.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/ec/util.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/ec/wnaf.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/ecdh/ecdh.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/ecdsa/ecdsa.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/ecdsa/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/fips_shared_support.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/hmac/hmac.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/md4/md4.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/md5/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/md5/md5.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/modes/cbc.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/modes/cfb.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/modes/ctr.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/modes/gcm.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/modes/gcm_nohw.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/modes/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/modes/ofb.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/modes/polyval.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/rand/ctrdrbg.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/rand/fork_detect.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/rand/fork_detect.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/rand/getrandom_fillin.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/rand/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/rand/rand.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/rand/urandom.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/rsa/blinding.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/rsa/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/rsa/padding.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/rsa/rsa.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/rsa/rsa_impl.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/self_check/fips.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/self_check/self_check.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/sha/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/sha/sha1-altivec.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/sha/sha1.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/sha/sha256.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/sha/sha512.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/tls/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/tls/kdf.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/hkdf/hkdf.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/hpke/hpke.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/hrss/hrss.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/hrss/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/lhash/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/lhash/lhash.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/mem.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/obj/obj.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/obj/obj_dat.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/obj/obj_xref.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/pem/pem_all.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/pem/pem_info.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/pem/pem_lib.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/pem/pem_oth.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/pem/pem_pk8.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/pem/pem_pkey.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/pem/pem_x509.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/pem/pem_xaux.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/pkcs7/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/pkcs7/pkcs7.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/pkcs7/pkcs7_x509.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/pkcs8/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/pkcs8/p5_pbev2.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/pkcs8/pkcs8.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/pkcs8/pkcs8_x509.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/poly1305/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/poly1305/poly1305.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/poly1305/poly1305_arm.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/poly1305/poly1305_vec.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/pool/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/pool/pool.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/rand_extra/deterministic.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/rand_extra/forkunsafe.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/rand_extra/fuchsia.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/rand_extra/passive.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/rand_extra/rand_extra.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/rand_extra/windows.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/rc4/rc4.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/refcount_c11.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/refcount_lock.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/rsa_extra/rsa_asn1.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/rsa_extra/rsa_print.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/siphash/siphash.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/stack/stack.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/thread.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/thread_none.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/thread_pthread.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/thread_win.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/trust_token/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/trust_token/pmbtoken.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/trust_token/trust_token.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/trust_token/voprf.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/a_digest.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/a_sign.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/a_verify.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/algorithm.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/asn1_gen.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/by_dir.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/by_file.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/i2d_pr.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/name_print.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/rsa_pss.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/t_crl.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/t_req.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/t_x509.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/t_x509a.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x509.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x509_att.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x509_cmp.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x509_d2.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x509_def.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x509_ext.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x509_lu.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x509_obj.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x509_req.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x509_set.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x509_trs.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x509_txt.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x509_v3.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x509_vfy.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x509_vpm.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x509cset.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x509name.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x509rset.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x509spki.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x_algor.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x_all.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x_attrib.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x_crl.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x_exten.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x_info.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x_name.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x_pkey.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x_pubkey.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x_req.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x_sig.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x_spki.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x_val.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x_x509.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x_x509a.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509v3/ext_dat.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509v3/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509v3/pcy_cache.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509v3/pcy_data.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509v3/pcy_lib.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509v3/pcy_map.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509v3/pcy_node.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509v3/pcy_tree.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509v3/v3_akey.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509v3/v3_akeya.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509v3/v3_alt.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509v3/v3_bcons.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509v3/v3_bitst.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509v3/v3_conf.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509v3/v3_cpols.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509v3/v3_crld.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509v3/v3_enum.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509v3/v3_extku.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509v3/v3_genn.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509v3/v3_ia5.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509v3/v3_info.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509v3/v3_int.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509v3/v3_lib.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509v3/v3_ncons.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509v3/v3_ocsp.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509v3/v3_pci.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509v3/v3_pcia.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509v3/v3_pcons.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509v3/v3_pmaps.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509v3/v3_prn.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509v3/v3_purp.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509v3/v3_skey.c )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509v3/v3_utl.c )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/aead.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/aes.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/arm_arch.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/asn1.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/asn1_mac.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/asn1t.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/base.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/base64.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/bio.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/blake2.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/blowfish.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/bn.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/buf.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/buffer.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/bytestring.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/cast.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/chacha.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/cipher.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/cmac.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/conf.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/cpu.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/crypto.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/curve25519.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/des.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/dh.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/digest.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/dsa.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/dtls1.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/e_os2.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/ec.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/ec_key.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/ecdh.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/ecdsa.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/engine.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/err.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/evp.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/evp_errors.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/ex_data.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/hkdf.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/hmac.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/hpke.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/hrss.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/is_boringssl.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/lhash.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/md4.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/md5.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/mem.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/nid.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/obj.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/obj_mac.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/objects.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/opensslconf.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/opensslv.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/ossl_typ.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/pem.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/pkcs12.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/pkcs7.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/pkcs8.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/poly1305.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/pool.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/rand.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/rc4.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/ripemd.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/rsa.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/safestack.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/sha.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/siphash.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/span.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/srtp.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/ssl.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/ssl3.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/stack.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/thread.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/tls1.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/trust_token.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/type_check.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/x509.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/x509_vfy.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/x509v3.h )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/bio_ssl.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/d1_both.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/d1_lib.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/d1_pkt.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/d1_srtp.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/dtls_method.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/dtls_record.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/encrypted_client_hello.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/extensions.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/handoff.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/handshake.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/handshake_client.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/handshake_server.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/s3_both.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/s3_lib.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/s3_pkt.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/ssl_aead_ctx.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/ssl_asn1.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/ssl_buffer.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/ssl_cert.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/ssl_cipher.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/ssl_file.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/ssl_key_share.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/ssl_lib.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/ssl_privkey.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/ssl_session.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/ssl_stat.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/ssl_transcript.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/ssl_versions.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/ssl_x509.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/t1_enc.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/tls13_both.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/tls13_client.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/tls13_enc.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/tls13_server.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/tls_method.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/tls_record.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/third_party/fiat/curve25519_32.h )
  s.files += %w( third_party/boringssl-with-bazel/src/third_party/fiat/curve25519_64.h )
  s.files += %w( third_party/boringssl-with-bazel/src/third_party/fiat/p256_32.h )
  s.files += %w( third_party/boringssl-with-bazel/src/third_party/fiat/p256_64.h )
  s.files += %w( third_party/cares/ares_build.h )
  s.files += %w( third_party/cares/cares/include/ares.h )
  s.files += %w( third_party/cares/cares/include/ares_dns.h )
  s.files += %w( third_party/cares/cares/include/ares_rules.h )
  s.files += %w( third_party/cares/cares/include/ares_version.h )
  s.files += %w( third_party/cares/cares/src/lib/ares__close_sockets.c )
  s.files += %w( third_party/cares/cares/src/lib/ares__get_hostent.c )
  s.files += %w( third_party/cares/cares/src/lib/ares__parse_into_addrinfo.c )
  s.files += %w( third_party/cares/cares/src/lib/ares__read_line.c )
  s.files += %w( third_party/cares/cares/src/lib/ares__readaddrinfo.c )
  s.files += %w( third_party/cares/cares/src/lib/ares__sortaddrinfo.c )
  s.files += %w( third_party/cares/cares/src/lib/ares__timeval.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_android.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_android.h )
  s.files += %w( third_party/cares/cares/src/lib/ares_cancel.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_create_query.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_data.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_data.h )
  s.files += %w( third_party/cares/cares/src/lib/ares_destroy.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_expand_name.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_expand_string.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_fds.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_free_hostent.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_free_string.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_freeaddrinfo.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_getaddrinfo.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_getenv.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_getenv.h )
  s.files += %w( third_party/cares/cares/src/lib/ares_gethostbyaddr.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_gethostbyname.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_getnameinfo.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_getsock.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_inet_net_pton.h )
  s.files += %w( third_party/cares/cares/src/lib/ares_init.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_iphlpapi.h )
  s.files += %w( third_party/cares/cares/src/lib/ares_ipv6.h )
  s.files += %w( third_party/cares/cares/src/lib/ares_library_init.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_library_init.h )
  s.files += %w( third_party/cares/cares/src/lib/ares_llist.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_llist.h )
  s.files += %w( third_party/cares/cares/src/lib/ares_mkquery.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_nameser.h )
  s.files += %w( third_party/cares/cares/src/lib/ares_nowarn.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_nowarn.h )
  s.files += %w( third_party/cares/cares/src/lib/ares_options.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_parse_a_reply.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_parse_aaaa_reply.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_parse_caa_reply.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_parse_mx_reply.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_parse_naptr_reply.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_parse_ns_reply.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_parse_ptr_reply.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_parse_soa_reply.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_parse_srv_reply.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_parse_txt_reply.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_platform.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_platform.h )
  s.files += %w( third_party/cares/cares/src/lib/ares_private.h )
  s.files += %w( third_party/cares/cares/src/lib/ares_process.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_query.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_search.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_send.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_setup.h )
  s.files += %w( third_party/cares/cares/src/lib/ares_strcasecmp.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_strcasecmp.h )
  s.files += %w( third_party/cares/cares/src/lib/ares_strdup.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_strdup.h )
  s.files += %w( third_party/cares/cares/src/lib/ares_strerror.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_strsplit.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_strsplit.h )
  s.files += %w( third_party/cares/cares/src/lib/ares_timeout.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_version.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_writev.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_writev.h )
  s.files += %w( third_party/cares/cares/src/lib/bitncmp.c )
  s.files += %w( third_party/cares/cares/src/lib/bitncmp.h )
  s.files += %w( third_party/cares/cares/src/lib/config-dos.h )
  s.files += %w( third_party/cares/cares/src/lib/config-win32.h )
  s.files += %w( third_party/cares/cares/src/lib/inet_net_pton.c )
  s.files += %w( third_party/cares/cares/src/lib/inet_ntop.c )
  s.files += %w( third_party/cares/cares/src/lib/setup_once.h )
  s.files += %w( third_party/cares/cares/src/lib/windows_port.c )
  s.files += %w( third_party/cares/config_darwin/ares_config.h )
  s.files += %w( third_party/cares/config_freebsd/ares_config.h )
  s.files += %w( third_party/cares/config_linux/ares_config.h )
  s.files += %w( third_party/cares/config_openbsd/ares_config.h )
  s.files += %w( third_party/re2/re2/bitmap256.h )
  s.files += %w( third_party/re2/re2/bitstate.cc )
  s.files += %w( third_party/re2/re2/compile.cc )
  s.files += %w( third_party/re2/re2/dfa.cc )
  s.files += %w( third_party/re2/re2/filtered_re2.cc )
  s.files += %w( third_party/re2/re2/filtered_re2.h )
  s.files += %w( third_party/re2/re2/mimics_pcre.cc )
  s.files += %w( third_party/re2/re2/nfa.cc )
  s.files += %w( third_party/re2/re2/onepass.cc )
  s.files += %w( third_party/re2/re2/parse.cc )
  s.files += %w( third_party/re2/re2/perl_groups.cc )
  s.files += %w( third_party/re2/re2/pod_array.h )
  s.files += %w( third_party/re2/re2/prefilter.cc )
  s.files += %w( third_party/re2/re2/prefilter.h )
  s.files += %w( third_party/re2/re2/prefilter_tree.cc )
  s.files += %w( third_party/re2/re2/prefilter_tree.h )
  s.files += %w( third_party/re2/re2/prog.cc )
  s.files += %w( third_party/re2/re2/prog.h )
  s.files += %w( third_party/re2/re2/re2.cc )
  s.files += %w( third_party/re2/re2/re2.h )
  s.files += %w( third_party/re2/re2/regexp.cc )
  s.files += %w( third_party/re2/re2/regexp.h )
  s.files += %w( third_party/re2/re2/set.cc )
  s.files += %w( third_party/re2/re2/set.h )
  s.files += %w( third_party/re2/re2/simplify.cc )
  s.files += %w( third_party/re2/re2/sparse_array.h )
  s.files += %w( third_party/re2/re2/sparse_set.h )
  s.files += %w( third_party/re2/re2/stringpiece.cc )
  s.files += %w( third_party/re2/re2/stringpiece.h )
  s.files += %w( third_party/re2/re2/tostring.cc )
  s.files += %w( third_party/re2/re2/unicode_casefold.cc )
  s.files += %w( third_party/re2/re2/unicode_casefold.h )
  s.files += %w( third_party/re2/re2/unicode_groups.cc )
  s.files += %w( third_party/re2/re2/unicode_groups.h )
  s.files += %w( third_party/re2/re2/walker-inl.h )
  s.files += %w( third_party/re2/util/benchmark.h )
  s.files += %w( third_party/re2/util/flags.h )
  s.files += %w( third_party/re2/util/logging.h )
  s.files += %w( third_party/re2/util/malloc_counter.h )
  s.files += %w( third_party/re2/util/mix.h )
  s.files += %w( third_party/re2/util/mutex.h )
  s.files += %w( third_party/re2/util/pcre.cc )
  s.files += %w( third_party/re2/util/pcre.h )
  s.files += %w( third_party/re2/util/rune.cc )
  s.files += %w( third_party/re2/util/strutil.cc )
  s.files += %w( third_party/re2/util/strutil.h )
  s.files += %w( third_party/re2/util/test.h )
  s.files += %w( third_party/re2/util/utf.h )
  s.files += %w( third_party/re2/util/util.h )
  s.files += %w( third_party/upb/third_party/utf8_range/naive.c )
  s.files += %w( third_party/upb/third_party/utf8_range/range2-neon.c )
  s.files += %w( third_party/upb/third_party/utf8_range/range2-sse.c )
  s.files += %w( third_party/upb/third_party/utf8_range/utf8_range.h )
  s.files += %w( third_party/upb/upb/arena.c )
  s.files += %w( third_party/upb/upb/arena.h )
  s.files += %w( third_party/upb/upb/array.c )
  s.files += %w( third_party/upb/upb/array.h )
  s.files += %w( third_party/upb/upb/collections.h )
  s.files += %w( third_party/upb/upb/decode.c )
  s.files += %w( third_party/upb/upb/decode.h )
  s.files += %w( third_party/upb/upb/decode_fast.c )
  s.files += %w( third_party/upb/upb/decode_fast.h )
  s.files += %w( third_party/upb/upb/def.c )
  s.files += %w( third_party/upb/upb/def.h )
  s.files += %w( third_party/upb/upb/def.hpp )
  s.files += %w( third_party/upb/upb/encode.c )
  s.files += %w( third_party/upb/upb/encode.h )
  s.files += %w( third_party/upb/upb/extension_registry.c )
  s.files += %w( third_party/upb/upb/extension_registry.h )
  s.files += %w( third_party/upb/upb/internal/decode.h )
  s.files += %w( third_party/upb/upb/internal/table.h )
  s.files += %w( third_party/upb/upb/internal/upb.h )
  s.files += %w( third_party/upb/upb/internal/vsnprintf_compat.h )
  s.files += %w( third_party/upb/upb/json_decode.c )
  s.files += %w( third_party/upb/upb/json_decode.h )
  s.files += %w( third_party/upb/upb/json_encode.c )
  s.files += %w( third_party/upb/upb/json_encode.h )
  s.files += %w( third_party/upb/upb/map.c )
  s.files += %w( third_party/upb/upb/map.h )
  s.files += %w( third_party/upb/upb/message_value.h )
  s.files += %w( third_party/upb/upb/mini_table.c )
  s.files += %w( third_party/upb/upb/mini_table.h )
  s.files += %w( third_party/upb/upb/mini_table.hpp )
  s.files += %w( third_party/upb/upb/msg.c )
  s.files += %w( third_party/upb/upb/msg.h )
  s.files += %w( third_party/upb/upb/msg_internal.h )
  s.files += %w( third_party/upb/upb/port_def.inc )
  s.files += %w( third_party/upb/upb/port_undef.inc )
  s.files += %w( third_party/upb/upb/reflection.c )
  s.files += %w( third_party/upb/upb/reflection.h )
  s.files += %w( third_party/upb/upb/reflection.hpp )
  s.files += %w( third_party/upb/upb/status.c )
  s.files += %w( third_party/upb/upb/status.h )
  s.files += %w( third_party/upb/upb/table.c )
  s.files += %w( third_party/upb/upb/table_internal.h )
  s.files += %w( third_party/upb/upb/text_encode.c )
  s.files += %w( third_party/upb/upb/text_encode.h )
  s.files += %w( third_party/upb/upb/upb.c )
  s.files += %w( third_party/upb/upb/upb.h )
  s.files += %w( third_party/upb/upb/upb.hpp )
  s.files += %w( third_party/xxhash/xxhash.h )
  s.files += %w( third_party/zlib/adler32.c )
  s.files += %w( third_party/zlib/compress.c )
  s.files += %w( third_party/zlib/crc32.c )
  s.files += %w( third_party/zlib/crc32.h )
  s.files += %w( third_party/zlib/deflate.c )
  s.files += %w( third_party/zlib/deflate.h )
  s.files += %w( third_party/zlib/gzclose.c )
  s.files += %w( third_party/zlib/gzguts.h )
  s.files += %w( third_party/zlib/gzlib.c )
  s.files += %w( third_party/zlib/gzread.c )
  s.files += %w( third_party/zlib/gzwrite.c )
  s.files += %w( third_party/zlib/infback.c )
  s.files += %w( third_party/zlib/inffast.c )
  s.files += %w( third_party/zlib/inffast.h )
  s.files += %w( third_party/zlib/inffixed.h )
  s.files += %w( third_party/zlib/inflate.c )
  s.files += %w( third_party/zlib/inflate.h )
  s.files += %w( third_party/zlib/inftrees.c )
  s.files += %w( third_party/zlib/inftrees.h )
  s.files += %w( third_party/zlib/trees.c )
  s.files += %w( third_party/zlib/trees.h )
  s.files += %w( third_party/zlib/uncompr.c )
  s.files += %w( third_party/zlib/zconf.h )
  s.files += %w( third_party/zlib/zlib.h )
  s.files += %w( third_party/zlib/zutil.c )
  s.files += %w( third_party/zlib/zutil.h )
end
