package trafficmanager

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AllowedEndpointRecordType enumerates the values for allowed endpoint record type.
type AllowedEndpointRecordType string

const (
	// AllowedEndpointRecordTypeAny ...
	AllowedEndpointRecordTypeAny AllowedEndpointRecordType = "Any"
	// AllowedEndpointRecordTypeDomainName ...
	AllowedEndpointRecordTypeDomainName AllowedEndpointRecordType = "DomainName"
	// AllowedEndpointRecordTypeIPv4Address ...
	AllowedEndpointRecordTypeIPv4Address AllowedEndpointRecordType = "IPv4Address"
	// AllowedEndpointRecordTypeIPv6Address ...
	AllowedEndpointRecordTypeIPv6Address AllowedEndpointRecordType = "IPv6Address"
)

// PossibleAllowedEndpointRecordTypeValues returns an array of possible values for the AllowedEndpointRecordType const type.
func PossibleAllowedEndpointRecordTypeValues() []AllowedEndpointRecordType {
	return []AllowedEndpointRecordType{AllowedEndpointRecordTypeAny, AllowedEndpointRecordTypeDomainName, AllowedEndpointRecordTypeIPv4Address, AllowedEndpointRecordTypeIPv6Address}
}

// EndpointMonitorStatus enumerates the values for endpoint monitor status.
type EndpointMonitorStatus string

const (
	// EndpointMonitorStatusCheckingEndpoint ...
	EndpointMonitorStatusCheckingEndpoint EndpointMonitorStatus = "CheckingEndpoint"
	// EndpointMonitorStatusDegraded ...
	EndpointMonitorStatusDegraded EndpointMonitorStatus = "Degraded"
	// EndpointMonitorStatusDisabled ...
	EndpointMonitorStatusDisabled EndpointMonitorStatus = "Disabled"
	// EndpointMonitorStatusInactive ...
	EndpointMonitorStatusInactive EndpointMonitorStatus = "Inactive"
	// EndpointMonitorStatusOnline ...
	EndpointMonitorStatusOnline EndpointMonitorStatus = "Online"
	// EndpointMonitorStatusStopped ...
	EndpointMonitorStatusStopped EndpointMonitorStatus = "Stopped"
)

// PossibleEndpointMonitorStatusValues returns an array of possible values for the EndpointMonitorStatus const type.
func PossibleEndpointMonitorStatusValues() []EndpointMonitorStatus {
	return []EndpointMonitorStatus{EndpointMonitorStatusCheckingEndpoint, EndpointMonitorStatusDegraded, EndpointMonitorStatusDisabled, EndpointMonitorStatusInactive, EndpointMonitorStatusOnline, EndpointMonitorStatusStopped}
}

// EndpointStatus enumerates the values for endpoint status.
type EndpointStatus string

const (
	// EndpointStatusDisabled ...
	EndpointStatusDisabled EndpointStatus = "Disabled"
	// EndpointStatusEnabled ...
	EndpointStatusEnabled EndpointStatus = "Enabled"
)

// PossibleEndpointStatusValues returns an array of possible values for the EndpointStatus const type.
func PossibleEndpointStatusValues() []EndpointStatus {
	return []EndpointStatus{EndpointStatusDisabled, EndpointStatusEnabled}
}

// MonitorProtocol enumerates the values for monitor protocol.
type MonitorProtocol string

const (
	// MonitorProtocolHTTP ...
	MonitorProtocolHTTP MonitorProtocol = "HTTP"
	// MonitorProtocolHTTPS ...
	MonitorProtocolHTTPS MonitorProtocol = "HTTPS"
	// MonitorProtocolTCP ...
	MonitorProtocolTCP MonitorProtocol = "TCP"
)

// PossibleMonitorProtocolValues returns an array of possible values for the MonitorProtocol const type.
func PossibleMonitorProtocolValues() []MonitorProtocol {
	return []MonitorProtocol{MonitorProtocolHTTP, MonitorProtocolHTTPS, MonitorProtocolTCP}
}

// ProfileMonitorStatus enumerates the values for profile monitor status.
type ProfileMonitorStatus string

const (
	// ProfileMonitorStatusCheckingEndpoints ...
	ProfileMonitorStatusCheckingEndpoints ProfileMonitorStatus = "CheckingEndpoints"
	// ProfileMonitorStatusDegraded ...
	ProfileMonitorStatusDegraded ProfileMonitorStatus = "Degraded"
	// ProfileMonitorStatusDisabled ...
	ProfileMonitorStatusDisabled ProfileMonitorStatus = "Disabled"
	// ProfileMonitorStatusInactive ...
	ProfileMonitorStatusInactive ProfileMonitorStatus = "Inactive"
	// ProfileMonitorStatusOnline ...
	ProfileMonitorStatusOnline ProfileMonitorStatus = "Online"
)

// PossibleProfileMonitorStatusValues returns an array of possible values for the ProfileMonitorStatus const type.
func PossibleProfileMonitorStatusValues() []ProfileMonitorStatus {
	return []ProfileMonitorStatus{ProfileMonitorStatusCheckingEndpoints, ProfileMonitorStatusDegraded, ProfileMonitorStatusDisabled, ProfileMonitorStatusInactive, ProfileMonitorStatusOnline}
}

// ProfileStatus enumerates the values for profile status.
type ProfileStatus string

const (
	// ProfileStatusDisabled ...
	ProfileStatusDisabled ProfileStatus = "Disabled"
	// ProfileStatusEnabled ...
	ProfileStatusEnabled ProfileStatus = "Enabled"
)

// PossibleProfileStatusValues returns an array of possible values for the ProfileStatus const type.
func PossibleProfileStatusValues() []ProfileStatus {
	return []ProfileStatus{ProfileStatusDisabled, ProfileStatusEnabled}
}

// TrafficRoutingMethod enumerates the values for traffic routing method.
type TrafficRoutingMethod string

const (
	// TrafficRoutingMethodGeographic ...
	TrafficRoutingMethodGeographic TrafficRoutingMethod = "Geographic"
	// TrafficRoutingMethodMultiValue ...
	TrafficRoutingMethodMultiValue TrafficRoutingMethod = "MultiValue"
	// TrafficRoutingMethodPerformance ...
	TrafficRoutingMethodPerformance TrafficRoutingMethod = "Performance"
	// TrafficRoutingMethodPriority ...
	TrafficRoutingMethodPriority TrafficRoutingMethod = "Priority"
	// TrafficRoutingMethodSubnet ...
	TrafficRoutingMethodSubnet TrafficRoutingMethod = "Subnet"
	// TrafficRoutingMethodWeighted ...
	TrafficRoutingMethodWeighted TrafficRoutingMethod = "Weighted"
)

// PossibleTrafficRoutingMethodValues returns an array of possible values for the TrafficRoutingMethod const type.
func PossibleTrafficRoutingMethodValues() []TrafficRoutingMethod {
	return []TrafficRoutingMethod{TrafficRoutingMethodGeographic, TrafficRoutingMethodMultiValue, TrafficRoutingMethodPerformance, TrafficRoutingMethodPriority, TrafficRoutingMethodSubnet, TrafficRoutingMethodWeighted}
}

// TrafficViewEnrollmentStatus enumerates the values for traffic view enrollment status.
type TrafficViewEnrollmentStatus string

const (
	// TrafficViewEnrollmentStatusDisabled ...
	TrafficViewEnrollmentStatusDisabled TrafficViewEnrollmentStatus = "Disabled"
	// TrafficViewEnrollmentStatusEnabled ...
	TrafficViewEnrollmentStatusEnabled TrafficViewEnrollmentStatus = "Enabled"
)

// PossibleTrafficViewEnrollmentStatusValues returns an array of possible values for the TrafficViewEnrollmentStatus const type.
func PossibleTrafficViewEnrollmentStatusValues() []TrafficViewEnrollmentStatus {
	return []TrafficViewEnrollmentStatus{TrafficViewEnrollmentStatusDisabled, TrafficViewEnrollmentStatusEnabled}
}
