package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchSaveApPosition invokes the cloudwf.BatchSaveApPosition API synchronously
// api document: https://help.aliyun.com/api/cloudwf/batchsaveapposition.html
func (client *Client) BatchSaveApPosition(request *BatchSaveApPositionRequest) (response *BatchSaveApPositionResponse, err error) {
	response = CreateBatchSaveApPositionResponse()
	err = client.DoAction(request, response)
	return
}

// BatchSaveApPositionWithChan invokes the cloudwf.BatchSaveApPosition API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/batchsaveapposition.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) BatchSaveApPositionWithChan(request *BatchSaveApPositionRequest) (<-chan *BatchSaveApPositionResponse, <-chan error) {
	responseChan := make(chan *BatchSaveApPositionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchSaveApPosition(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchSaveApPositionWithCallback invokes the cloudwf.BatchSaveApPosition API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/batchsaveapposition.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) BatchSaveApPositionWithCallback(request *BatchSaveApPositionRequest, callback func(response *BatchSaveApPositionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchSaveApPositionResponse
		var err error
		defer close(result)
		response, err = client.BatchSaveApPosition(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchSaveApPositionRequest is the request struct for api BatchSaveApPosition
type BatchSaveApPositionRequest struct {
	*requests.RpcRequest
	JsonData string `position:"Query" name:"JsonData"`
}

// BatchSaveApPositionResponse is the response struct for api BatchSaveApPosition
type BatchSaveApPositionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateBatchSaveApPositionRequest creates a request to invoke BatchSaveApPosition API
func CreateBatchSaveApPositionRequest() (request *BatchSaveApPositionRequest) {
	request = &BatchSaveApPositionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "BatchSaveApPosition", "cloudwf", "openAPI")
	return
}

// CreateBatchSaveApPositionResponse creates a response to parse from BatchSaveApPosition response
func CreateBatchSaveApPositionResponse() (response *BatchSaveApPositionResponse) {
	response = &BatchSaveApPositionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
