package cr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteRepoBuildRule invokes the cr.DeleteRepoBuildRule API synchronously
func (client *Client) DeleteRepoBuildRule(request *DeleteRepoBuildRuleRequest) (response *DeleteRepoBuildRuleResponse, err error) {
	response = CreateDeleteRepoBuildRuleResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteRepoBuildRuleWithChan invokes the cr.DeleteRepoBuildRule API asynchronously
func (client *Client) DeleteRepoBuildRuleWithChan(request *DeleteRepoBuildRuleRequest) (<-chan *DeleteRepoBuildRuleResponse, <-chan error) {
	responseChan := make(chan *DeleteRepoBuildRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteRepoBuildRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteRepoBuildRuleWithCallback invokes the cr.DeleteRepoBuildRule API asynchronously
func (client *Client) DeleteRepoBuildRuleWithCallback(request *DeleteRepoBuildRuleRequest, callback func(response *DeleteRepoBuildRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteRepoBuildRuleResponse
		var err error
		defer close(result)
		response, err = client.DeleteRepoBuildRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteRepoBuildRuleRequest is the request struct for api DeleteRepoBuildRule
type DeleteRepoBuildRuleRequest struct {
	*requests.RoaRequest
	BuildRuleId   requests.Integer `position:"Path" name:"BuildRuleId"`
	RepoNamespace string           `position:"Path" name:"RepoNamespace"`
	RepoName      string           `position:"Path" name:"RepoName"`
}

// DeleteRepoBuildRuleResponse is the response struct for api DeleteRepoBuildRule
type DeleteRepoBuildRuleResponse struct {
	*responses.BaseResponse
}

// CreateDeleteRepoBuildRuleRequest creates a request to invoke DeleteRepoBuildRule API
func CreateDeleteRepoBuildRuleRequest() (request *DeleteRepoBuildRuleRequest) {
	request = &DeleteRepoBuildRuleRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("cr", "2016-06-07", "DeleteRepoBuildRule", "/repos/[RepoNamespace]/[RepoName]/rules/[BuildRuleId]", "acr", "openAPI")
	request.Method = requests.DELETE
	return
}

// CreateDeleteRepoBuildRuleResponse creates a response to parse from DeleteRepoBuildRule response
func CreateDeleteRepoBuildRuleResponse() (response *DeleteRepoBuildRuleResponse) {
	response = &DeleteRepoBuildRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
