package das

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCloudbenchTask invokes the das.DescribeCloudbenchTask API synchronously
func (client *Client) DescribeCloudbenchTask(request *DescribeCloudbenchTaskRequest) (response *DescribeCloudbenchTaskResponse, err error) {
	response = CreateDescribeCloudbenchTaskResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCloudbenchTaskWithChan invokes the das.DescribeCloudbenchTask API asynchronously
func (client *Client) DescribeCloudbenchTaskWithChan(request *DescribeCloudbenchTaskRequest) (<-chan *DescribeCloudbenchTaskResponse, <-chan error) {
	responseChan := make(chan *DescribeCloudbenchTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCloudbenchTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCloudbenchTaskWithCallback invokes the das.DescribeCloudbenchTask API asynchronously
func (client *Client) DescribeCloudbenchTaskWithCallback(request *DescribeCloudbenchTaskRequest, callback func(response *DescribeCloudbenchTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCloudbenchTaskResponse
		var err error
		defer close(result)
		response, err = client.DescribeCloudbenchTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCloudbenchTaskRequest is the request struct for api DescribeCloudbenchTask
type DescribeCloudbenchTaskRequest struct {
	*requests.RpcRequest
	TaskId string `position:"Query" name:"TaskId"`
}

// DescribeCloudbenchTaskResponse is the response struct for api DescribeCloudbenchTask
type DescribeCloudbenchTaskResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   string `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribeCloudbenchTaskRequest creates a request to invoke DescribeCloudbenchTask API
func CreateDescribeCloudbenchTaskRequest() (request *DescribeCloudbenchTaskRequest) {
	request = &DescribeCloudbenchTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DAS", "2020-01-16", "DescribeCloudbenchTask", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeCloudbenchTaskResponse creates a response to parse from DescribeCloudbenchTask response
func CreateDescribeCloudbenchTaskResponse() (response *DescribeCloudbenchTaskResponse) {
	response = &DescribeCloudbenchTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
