package devops_rdc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateServiceConnection invokes the devops_rdc.CreateServiceConnection API synchronously
func (client *Client) CreateServiceConnection(request *CreateServiceConnectionRequest) (response *CreateServiceConnectionResponse, err error) {
	response = CreateCreateServiceConnectionResponse()
	err = client.DoAction(request, response)
	return
}

// CreateServiceConnectionWithChan invokes the devops_rdc.CreateServiceConnection API asynchronously
func (client *Client) CreateServiceConnectionWithChan(request *CreateServiceConnectionRequest) (<-chan *CreateServiceConnectionResponse, <-chan error) {
	responseChan := make(chan *CreateServiceConnectionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateServiceConnection(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateServiceConnectionWithCallback invokes the devops_rdc.CreateServiceConnection API asynchronously
func (client *Client) CreateServiceConnectionWithCallback(request *CreateServiceConnectionRequest, callback func(response *CreateServiceConnectionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateServiceConnectionResponse
		var err error
		defer close(result)
		response, err = client.CreateServiceConnection(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateServiceConnectionRequest is the request struct for api CreateServiceConnection
type CreateServiceConnectionRequest struct {
	*requests.RpcRequest
	ServiceConnectionType string `position:"Body" name:"ServiceConnectionType"`
	UserPk                string `position:"Body" name:"UserPk"`
	OrgId                 string `position:"Body" name:"OrgId"`
}

// CreateServiceConnectionResponse is the response struct for api CreateServiceConnection
type CreateServiceConnectionResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
	Object       int64  `json:"Object" xml:"Object"`
}

// CreateCreateServiceConnectionRequest creates a request to invoke CreateServiceConnection API
func CreateCreateServiceConnectionRequest() (request *CreateServiceConnectionRequest) {
	request = &CreateServiceConnectionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("devops-rdc", "2020-03-03", "CreateServiceConnection", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateServiceConnectionResponse creates a response to parse from CreateServiceConnection response
func CreateCreateServiceConnectionResponse() (response *CreateServiceConnectionResponse) {
	response = &CreateServiceConnectionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
