package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryMessageInfo invokes the iot.QueryMessageInfo API synchronously
func (client *Client) QueryMessageInfo(request *QueryMessageInfoRequest) (response *QueryMessageInfoResponse, err error) {
	response = CreateQueryMessageInfoResponse()
	err = client.DoAction(request, response)
	return
}

// QueryMessageInfoWithChan invokes the iot.QueryMessageInfo API asynchronously
func (client *Client) QueryMessageInfoWithChan(request *QueryMessageInfoRequest) (<-chan *QueryMessageInfoResponse, <-chan error) {
	responseChan := make(chan *QueryMessageInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryMessageInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryMessageInfoWithCallback invokes the iot.QueryMessageInfo API asynchronously
func (client *Client) QueryMessageInfoWithCallback(request *QueryMessageInfoRequest, callback func(response *QueryMessageInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryMessageInfoResponse
		var err error
		defer close(result)
		response, err = client.QueryMessageInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryMessageInfoRequest is the request struct for api QueryMessageInfo
type QueryMessageInfoRequest struct {
	*requests.RpcRequest
	UniMsgId      string `position:"Query" name:"UniMsgId"`
	IotInstanceId string `position:"Query" name:"IotInstanceId"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
}

// QueryMessageInfoResponse is the response struct for api QueryMessageInfo
type QueryMessageInfoResponse struct {
	*responses.BaseResponse
	RequestId    string  `json:"RequestId" xml:"RequestId"`
	Success      bool    `json:"Success" xml:"Success"`
	ErrorMessage string  `json:"ErrorMessage" xml:"ErrorMessage"`
	Code         string  `json:"Code" xml:"Code"`
	Message      Message `json:"Message" xml:"Message"`
}

// CreateQueryMessageInfoRequest creates a request to invoke QueryMessageInfo API
func CreateQueryMessageInfoRequest() (request *QueryMessageInfoRequest) {
	request = &QueryMessageInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "QueryMessageInfo", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryMessageInfoResponse creates a response to parse from QueryMessageInfo response
func CreateQueryMessageInfoResponse() (response *QueryMessageInfoResponse) {
	response = &QueryMessageInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
