// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/aiplatform/v1beta1/explanation_metadata.proto

package aiplatform

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Defines how the feature is encoded to [encoded_tensor][]. Defaults to
// IDENTITY.
type ExplanationMetadata_InputMetadata_Encoding int32

const (
	// Default value. This is the same as IDENTITY.
	ExplanationMetadata_InputMetadata_ENCODING_UNSPECIFIED ExplanationMetadata_InputMetadata_Encoding = 0
	// The tensor represents one feature.
	ExplanationMetadata_InputMetadata_IDENTITY ExplanationMetadata_InputMetadata_Encoding = 1
	// The tensor represents a bag of features where each index maps to
	// a feature. [InputMetadata.index_feature_mapping][google.cloud.aiplatform.v1beta1.ExplanationMetadata.InputMetadata.index_feature_mapping] must be provided for
	// this encoding. For example:
	// ```
	// input = [27, 6.0, 150]
	// index_feature_mapping = ["age", "height", "weight"]
	// ```
	ExplanationMetadata_InputMetadata_BAG_OF_FEATURES ExplanationMetadata_InputMetadata_Encoding = 2
	// The tensor represents a bag of features where each index maps to a
	// feature. Zero values in the tensor indicates feature being
	// non-existent. [InputMetadata.index_feature_mapping][google.cloud.aiplatform.v1beta1.ExplanationMetadata.InputMetadata.index_feature_mapping] must be provided
	// for this encoding. For example:
	// ```
	// input = [2, 0, 5, 0, 1]
	// index_feature_mapping = ["a", "b", "c", "d", "e"]
	// ```
	ExplanationMetadata_InputMetadata_BAG_OF_FEATURES_SPARSE ExplanationMetadata_InputMetadata_Encoding = 3
	// The tensor is a list of binaries representing whether a feature exists
	// or not (1 indicates existence). [InputMetadata.index_feature_mapping][google.cloud.aiplatform.v1beta1.ExplanationMetadata.InputMetadata.index_feature_mapping]
	// must be provided for this encoding. For example:
	// ```
	// input = [1, 0, 1, 0, 1]
	// index_feature_mapping = ["a", "b", "c", "d", "e"]
	// ```
	ExplanationMetadata_InputMetadata_INDICATOR ExplanationMetadata_InputMetadata_Encoding = 4
	// The tensor is encoded into a 1-dimensional array represented by an
	// encoded tensor. [InputMetadata.encoded_tensor_name][google.cloud.aiplatform.v1beta1.ExplanationMetadata.InputMetadata.encoded_tensor_name] must be provided
	// for this encoding. For example:
	// ```
	// input = ["This", "is", "a", "test", "."]
	// encoded = [0.1, 0.2, 0.3, 0.4, 0.5]
	// ```
	ExplanationMetadata_InputMetadata_COMBINED_EMBEDDING ExplanationMetadata_InputMetadata_Encoding = 5
	// Select this encoding when the input tensor is encoded into a
	// 2-dimensional array represented by an encoded tensor.
	// [InputMetadata.encoded_tensor_name][google.cloud.aiplatform.v1beta1.ExplanationMetadata.InputMetadata.encoded_tensor_name] must be provided for this
	// encoding. The first dimension of the encoded tensor's shape is the same
	// as the input tensor's shape. For example:
	// ```
	// input = ["This", "is", "a", "test", "."]
	// encoded = [[0.1, 0.2, 0.3, 0.4, 0.5],
	//            [0.2, 0.1, 0.4, 0.3, 0.5],
	//            [0.5, 0.1, 0.3, 0.5, 0.4],
	//            [0.5, 0.3, 0.1, 0.2, 0.4],
	//            [0.4, 0.3, 0.2, 0.5, 0.1]]
	// ```
	ExplanationMetadata_InputMetadata_CONCAT_EMBEDDING ExplanationMetadata_InputMetadata_Encoding = 6
)

// Enum value maps for ExplanationMetadata_InputMetadata_Encoding.
var (
	ExplanationMetadata_InputMetadata_Encoding_name = map[int32]string{
		0: "ENCODING_UNSPECIFIED",
		1: "IDENTITY",
		2: "BAG_OF_FEATURES",
		3: "BAG_OF_FEATURES_SPARSE",
		4: "INDICATOR",
		5: "COMBINED_EMBEDDING",
		6: "CONCAT_EMBEDDING",
	}
	ExplanationMetadata_InputMetadata_Encoding_value = map[string]int32{
		"ENCODING_UNSPECIFIED":   0,
		"IDENTITY":               1,
		"BAG_OF_FEATURES":        2,
		"BAG_OF_FEATURES_SPARSE": 3,
		"INDICATOR":              4,
		"COMBINED_EMBEDDING":     5,
		"CONCAT_EMBEDDING":       6,
	}
)

func (x ExplanationMetadata_InputMetadata_Encoding) Enum() *ExplanationMetadata_InputMetadata_Encoding {
	p := new(ExplanationMetadata_InputMetadata_Encoding)
	*p = x
	return p
}

func (x ExplanationMetadata_InputMetadata_Encoding) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ExplanationMetadata_InputMetadata_Encoding) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_enumTypes[0].Descriptor()
}

func (ExplanationMetadata_InputMetadata_Encoding) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_enumTypes[0]
}

func (x ExplanationMetadata_InputMetadata_Encoding) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ExplanationMetadata_InputMetadata_Encoding.Descriptor instead.
func (ExplanationMetadata_InputMetadata_Encoding) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_rawDescGZIP(), []int{0, 0, 0}
}

// Type of the image visualization. Only applicable to [Integrated
// Gradients attribution]
// [ExplanationParameters.integrated_gradients_attribution].
type ExplanationMetadata_InputMetadata_Visualization_Type int32

const (
	// Should not be used.
	ExplanationMetadata_InputMetadata_Visualization_TYPE_UNSPECIFIED ExplanationMetadata_InputMetadata_Visualization_Type = 0
	// Shows which pixel contributed to the image prediction.
	ExplanationMetadata_InputMetadata_Visualization_PIXELS ExplanationMetadata_InputMetadata_Visualization_Type = 1
	// Shows which region contributed to the image prediction by outlining
	// the region.
	ExplanationMetadata_InputMetadata_Visualization_OUTLINES ExplanationMetadata_InputMetadata_Visualization_Type = 2
)

// Enum value maps for ExplanationMetadata_InputMetadata_Visualization_Type.
var (
	ExplanationMetadata_InputMetadata_Visualization_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "PIXELS",
		2: "OUTLINES",
	}
	ExplanationMetadata_InputMetadata_Visualization_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"PIXELS":           1,
		"OUTLINES":         2,
	}
)

func (x ExplanationMetadata_InputMetadata_Visualization_Type) Enum() *ExplanationMetadata_InputMetadata_Visualization_Type {
	p := new(ExplanationMetadata_InputMetadata_Visualization_Type)
	*p = x
	return p
}

func (x ExplanationMetadata_InputMetadata_Visualization_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ExplanationMetadata_InputMetadata_Visualization_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_enumTypes[1].Descriptor()
}

func (ExplanationMetadata_InputMetadata_Visualization_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_enumTypes[1]
}

func (x ExplanationMetadata_InputMetadata_Visualization_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ExplanationMetadata_InputMetadata_Visualization_Type.Descriptor instead.
func (ExplanationMetadata_InputMetadata_Visualization_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_rawDescGZIP(), []int{0, 0, 1, 0}
}

// Whether to only highlight pixels with positive contributions, negative
// or both. Defaults to POSITIVE.
type ExplanationMetadata_InputMetadata_Visualization_Polarity int32

const (
	// Default value. This is the same as POSITIVE.
	ExplanationMetadata_InputMetadata_Visualization_POLARITY_UNSPECIFIED ExplanationMetadata_InputMetadata_Visualization_Polarity = 0
	// Highlights the pixels/outlines that were most influential to the
	// model's prediction.
	ExplanationMetadata_InputMetadata_Visualization_POSITIVE ExplanationMetadata_InputMetadata_Visualization_Polarity = 1
	// Setting polarity to negative highlights areas that does not lead to
	// the models's current prediction.
	ExplanationMetadata_InputMetadata_Visualization_NEGATIVE ExplanationMetadata_InputMetadata_Visualization_Polarity = 2
	// Shows both positive and negative attributions.
	ExplanationMetadata_InputMetadata_Visualization_BOTH ExplanationMetadata_InputMetadata_Visualization_Polarity = 3
)

// Enum value maps for ExplanationMetadata_InputMetadata_Visualization_Polarity.
var (
	ExplanationMetadata_InputMetadata_Visualization_Polarity_name = map[int32]string{
		0: "POLARITY_UNSPECIFIED",
		1: "POSITIVE",
		2: "NEGATIVE",
		3: "BOTH",
	}
	ExplanationMetadata_InputMetadata_Visualization_Polarity_value = map[string]int32{
		"POLARITY_UNSPECIFIED": 0,
		"POSITIVE":             1,
		"NEGATIVE":             2,
		"BOTH":                 3,
	}
)

func (x ExplanationMetadata_InputMetadata_Visualization_Polarity) Enum() *ExplanationMetadata_InputMetadata_Visualization_Polarity {
	p := new(ExplanationMetadata_InputMetadata_Visualization_Polarity)
	*p = x
	return p
}

func (x ExplanationMetadata_InputMetadata_Visualization_Polarity) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ExplanationMetadata_InputMetadata_Visualization_Polarity) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_enumTypes[2].Descriptor()
}

func (ExplanationMetadata_InputMetadata_Visualization_Polarity) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_enumTypes[2]
}

func (x ExplanationMetadata_InputMetadata_Visualization_Polarity) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ExplanationMetadata_InputMetadata_Visualization_Polarity.Descriptor instead.
func (ExplanationMetadata_InputMetadata_Visualization_Polarity) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_rawDescGZIP(), []int{0, 0, 1, 1}
}

// The color scheme used for highlighting areas.
type ExplanationMetadata_InputMetadata_Visualization_ColorMap int32

const (
	// Should not be used.
	ExplanationMetadata_InputMetadata_Visualization_COLOR_MAP_UNSPECIFIED ExplanationMetadata_InputMetadata_Visualization_ColorMap = 0
	// Positive: green. Negative: pink.
	ExplanationMetadata_InputMetadata_Visualization_PINK_GREEN ExplanationMetadata_InputMetadata_Visualization_ColorMap = 1
	// Viridis color map: A perceptually uniform color mapping which is
	// easier to see by those with colorblindness and progresses from yellow
	// to green to blue. Positive: yellow. Negative: blue.
	ExplanationMetadata_InputMetadata_Visualization_VIRIDIS ExplanationMetadata_InputMetadata_Visualization_ColorMap = 2
	// Positive: red. Negative: red.
	ExplanationMetadata_InputMetadata_Visualization_RED ExplanationMetadata_InputMetadata_Visualization_ColorMap = 3
	// Positive: green. Negative: green.
	ExplanationMetadata_InputMetadata_Visualization_GREEN ExplanationMetadata_InputMetadata_Visualization_ColorMap = 4
	// Positive: green. Negative: red.
	ExplanationMetadata_InputMetadata_Visualization_RED_GREEN ExplanationMetadata_InputMetadata_Visualization_ColorMap = 6
	// PiYG palette.
	ExplanationMetadata_InputMetadata_Visualization_PINK_WHITE_GREEN ExplanationMetadata_InputMetadata_Visualization_ColorMap = 5
)

// Enum value maps for ExplanationMetadata_InputMetadata_Visualization_ColorMap.
var (
	ExplanationMetadata_InputMetadata_Visualization_ColorMap_name = map[int32]string{
		0: "COLOR_MAP_UNSPECIFIED",
		1: "PINK_GREEN",
		2: "VIRIDIS",
		3: "RED",
		4: "GREEN",
		6: "RED_GREEN",
		5: "PINK_WHITE_GREEN",
	}
	ExplanationMetadata_InputMetadata_Visualization_ColorMap_value = map[string]int32{
		"COLOR_MAP_UNSPECIFIED": 0,
		"PINK_GREEN":            1,
		"VIRIDIS":               2,
		"RED":                   3,
		"GREEN":                 4,
		"RED_GREEN":             6,
		"PINK_WHITE_GREEN":      5,
	}
)

func (x ExplanationMetadata_InputMetadata_Visualization_ColorMap) Enum() *ExplanationMetadata_InputMetadata_Visualization_ColorMap {
	p := new(ExplanationMetadata_InputMetadata_Visualization_ColorMap)
	*p = x
	return p
}

func (x ExplanationMetadata_InputMetadata_Visualization_ColorMap) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ExplanationMetadata_InputMetadata_Visualization_ColorMap) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_enumTypes[3].Descriptor()
}

func (ExplanationMetadata_InputMetadata_Visualization_ColorMap) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_enumTypes[3]
}

func (x ExplanationMetadata_InputMetadata_Visualization_ColorMap) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ExplanationMetadata_InputMetadata_Visualization_ColorMap.Descriptor instead.
func (ExplanationMetadata_InputMetadata_Visualization_ColorMap) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_rawDescGZIP(), []int{0, 0, 1, 2}
}

// How the original image is displayed in the visualization.
type ExplanationMetadata_InputMetadata_Visualization_OverlayType int32

const (
	// Default value. This is the same as NONE.
	ExplanationMetadata_InputMetadata_Visualization_OVERLAY_TYPE_UNSPECIFIED ExplanationMetadata_InputMetadata_Visualization_OverlayType = 0
	// No overlay.
	ExplanationMetadata_InputMetadata_Visualization_NONE ExplanationMetadata_InputMetadata_Visualization_OverlayType = 1
	// The attributions are shown on top of the original image.
	ExplanationMetadata_InputMetadata_Visualization_ORIGINAL ExplanationMetadata_InputMetadata_Visualization_OverlayType = 2
	// The attributions are shown on top of grayscaled version of the
	// original image.
	ExplanationMetadata_InputMetadata_Visualization_GRAYSCALE ExplanationMetadata_InputMetadata_Visualization_OverlayType = 3
	// The attributions are used as a mask to reveal predictive parts of
	// the image and hide the un-predictive parts.
	ExplanationMetadata_InputMetadata_Visualization_MASK_BLACK ExplanationMetadata_InputMetadata_Visualization_OverlayType = 4
)

// Enum value maps for ExplanationMetadata_InputMetadata_Visualization_OverlayType.
var (
	ExplanationMetadata_InputMetadata_Visualization_OverlayType_name = map[int32]string{
		0: "OVERLAY_TYPE_UNSPECIFIED",
		1: "NONE",
		2: "ORIGINAL",
		3: "GRAYSCALE",
		4: "MASK_BLACK",
	}
	ExplanationMetadata_InputMetadata_Visualization_OverlayType_value = map[string]int32{
		"OVERLAY_TYPE_UNSPECIFIED": 0,
		"NONE":                     1,
		"ORIGINAL":                 2,
		"GRAYSCALE":                3,
		"MASK_BLACK":               4,
	}
)

func (x ExplanationMetadata_InputMetadata_Visualization_OverlayType) Enum() *ExplanationMetadata_InputMetadata_Visualization_OverlayType {
	p := new(ExplanationMetadata_InputMetadata_Visualization_OverlayType)
	*p = x
	return p
}

func (x ExplanationMetadata_InputMetadata_Visualization_OverlayType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ExplanationMetadata_InputMetadata_Visualization_OverlayType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_enumTypes[4].Descriptor()
}

func (ExplanationMetadata_InputMetadata_Visualization_OverlayType) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_enumTypes[4]
}

func (x ExplanationMetadata_InputMetadata_Visualization_OverlayType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ExplanationMetadata_InputMetadata_Visualization_OverlayType.Descriptor instead.
func (ExplanationMetadata_InputMetadata_Visualization_OverlayType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_rawDescGZIP(), []int{0, 0, 1, 3}
}

// Metadata describing the Model's input and output for explanation.
type ExplanationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Map from feature names to feature input metadata. Keys are the name of the
	// features. Values are the specification of the feature.
	//
	// An empty InputMetadata is valid. It describes a text feature which has the
	// name specified as the key in [ExplanationMetadata.inputs][google.cloud.aiplatform.v1beta1.ExplanationMetadata.inputs]. The baseline
	// of the empty feature is chosen by Vertex AI.
	//
	// For Vertex AI-provided Tensorflow images, the key can be any friendly
	// name of the feature. Once specified,
	// [featureAttributions][google.cloud.aiplatform.v1beta1.Attribution.feature_attributions] are keyed by
	// this key (if not grouped with another feature).
	//
	// For custom images, the key must match with the key in
	// [instance][google.cloud.aiplatform.v1beta1.ExplainRequest.instances].
	Inputs map[string]*ExplanationMetadata_InputMetadata `protobuf:"bytes,1,rep,name=inputs,proto3" json:"inputs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. Map from output names to output metadata.
	//
	// For Vertex AI-provided Tensorflow images, keys can be any user defined
	// string that consists of any UTF-8 characters.
	//
	// For custom images, keys are the name of the output field in the prediction
	// to be explained.
	//
	// Currently only one key is allowed.
	Outputs map[string]*ExplanationMetadata_OutputMetadata `protobuf:"bytes,2,rep,name=outputs,proto3" json:"outputs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Points to a YAML file stored on Google Cloud Storage describing the format
	// of the [feature attributions][google.cloud.aiplatform.v1beta1.Attribution.feature_attributions].
	// The schema is defined as an OpenAPI 3.0.2 [Schema
	// Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
	// AutoML tabular Models always have this field populated by Vertex AI.
	// Note: The URI given on output may be different, including the URI scheme,
	// than the one given on input. The output URI will point to a location where
	// the user only has a read access.
	FeatureAttributionsSchemaUri string `protobuf:"bytes,3,opt,name=feature_attributions_schema_uri,json=featureAttributionsSchemaUri,proto3" json:"feature_attributions_schema_uri,omitempty"`
}

func (x *ExplanationMetadata) Reset() {
	*x = ExplanationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExplanationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExplanationMetadata) ProtoMessage() {}

func (x *ExplanationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExplanationMetadata.ProtoReflect.Descriptor instead.
func (*ExplanationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_rawDescGZIP(), []int{0}
}

func (x *ExplanationMetadata) GetInputs() map[string]*ExplanationMetadata_InputMetadata {
	if x != nil {
		return x.Inputs
	}
	return nil
}

func (x *ExplanationMetadata) GetOutputs() map[string]*ExplanationMetadata_OutputMetadata {
	if x != nil {
		return x.Outputs
	}
	return nil
}

func (x *ExplanationMetadata) GetFeatureAttributionsSchemaUri() string {
	if x != nil {
		return x.FeatureAttributionsSchemaUri
	}
	return ""
}

// Metadata of the input of a feature.
//
// Fields other than [InputMetadata.input_baselines][google.cloud.aiplatform.v1beta1.ExplanationMetadata.InputMetadata.input_baselines] are applicable only
// for Models that are using Vertex AI-provided images for Tensorflow.
type ExplanationMetadata_InputMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Baseline inputs for this feature.
	//
	// If no baseline is specified, Vertex AI chooses the baseline for this
	// feature. If multiple baselines are specified, Vertex AI returns the
	// average attributions across them in
	// [Attributions.baseline_attribution][].
	//
	// For Vertex AI-provided Tensorflow images (both 1.x and 2.x), the shape
	// of each baseline must match the shape of the input tensor. If a scalar is
	// provided, we broadcast to the same shape as the input tensor.
	//
	// For custom images, the element of the baselines must be in the same
	// format as the feature's input in the
	// [instance][google.cloud.aiplatform.v1beta1.ExplainRequest.instances][]. The schema of any single instance
	// may be specified via Endpoint's DeployedModels'
	// [Model's][google.cloud.aiplatform.v1beta1.DeployedModel.model]
	// [PredictSchemata's][google.cloud.aiplatform.v1beta1.Model.predict_schemata]
	// [instance_schema_uri][google.cloud.aiplatform.v1beta1.PredictSchemata.instance_schema_uri].
	InputBaselines []*structpb.Value `protobuf:"bytes,1,rep,name=input_baselines,json=inputBaselines,proto3" json:"input_baselines,omitempty"`
	// Name of the input tensor for this feature. Required and is only
	// applicable to Vertex AI-provided images for Tensorflow.
	InputTensorName string `protobuf:"bytes,2,opt,name=input_tensor_name,json=inputTensorName,proto3" json:"input_tensor_name,omitempty"`
	// Defines how the feature is encoded into the input tensor. Defaults to
	// IDENTITY.
	Encoding ExplanationMetadata_InputMetadata_Encoding `protobuf:"varint,3,opt,name=encoding,proto3,enum=google.cloud.aiplatform.v1beta1.ExplanationMetadata_InputMetadata_Encoding" json:"encoding,omitempty"`
	// Modality of the feature. Valid values are: numeric, image. Defaults to
	// numeric.
	Modality string `protobuf:"bytes,4,opt,name=modality,proto3" json:"modality,omitempty"`
	// The domain details of the input feature value. Like min/max, original
	// mean or standard deviation if normalized.
	FeatureValueDomain *ExplanationMetadata_InputMetadata_FeatureValueDomain `protobuf:"bytes,5,opt,name=feature_value_domain,json=featureValueDomain,proto3" json:"feature_value_domain,omitempty"`
	// Specifies the index of the values of the input tensor.
	// Required when the input tensor is a sparse representation. Refer to
	// Tensorflow documentation for more details:
	// https://www.tensorflow.org/api_docs/python/tf/sparse/SparseTensor.
	IndicesTensorName string `protobuf:"bytes,6,opt,name=indices_tensor_name,json=indicesTensorName,proto3" json:"indices_tensor_name,omitempty"`
	// Specifies the shape of the values of the input if the input is a sparse
	// representation. Refer to Tensorflow documentation for more details:
	// https://www.tensorflow.org/api_docs/python/tf/sparse/SparseTensor.
	DenseShapeTensorName string `protobuf:"bytes,7,opt,name=dense_shape_tensor_name,json=denseShapeTensorName,proto3" json:"dense_shape_tensor_name,omitempty"`
	// A list of feature names for each index in the input tensor.
	// Required when the input [InputMetadata.encoding][google.cloud.aiplatform.v1beta1.ExplanationMetadata.InputMetadata.encoding] is BAG_OF_FEATURES,
	// BAG_OF_FEATURES_SPARSE, INDICATOR.
	IndexFeatureMapping []string `protobuf:"bytes,8,rep,name=index_feature_mapping,json=indexFeatureMapping,proto3" json:"index_feature_mapping,omitempty"`
	// Encoded tensor is a transformation of the input tensor. Must be provided
	// if choosing [Integrated Gradients
	// attribution][ExplanationParameters.integrated_gradients_attribution] or
	// [XRAI attribution][google.cloud.aiplatform.v1beta1.ExplanationParameters.xrai_attribution]
	// and the input tensor is not differentiable.
	//
	// An encoded tensor is generated if the input tensor is encoded by a lookup
	// table.
	EncodedTensorName string `protobuf:"bytes,9,opt,name=encoded_tensor_name,json=encodedTensorName,proto3" json:"encoded_tensor_name,omitempty"`
	// A list of baselines for the encoded tensor.
	//
	// The shape of each baseline should match the shape of the encoded tensor.
	// If a scalar is provided, Vertex AI broadcasts to the same shape as the
	// encoded tensor.
	EncodedBaselines []*structpb.Value `protobuf:"bytes,10,rep,name=encoded_baselines,json=encodedBaselines,proto3" json:"encoded_baselines,omitempty"`
	// Visualization configurations for image explanation.
	Visualization *ExplanationMetadata_InputMetadata_Visualization `protobuf:"bytes,11,opt,name=visualization,proto3" json:"visualization,omitempty"`
	// Name of the group that the input belongs to. Features with the same group
	// name will be treated as one feature when computing attributions. Features
	// grouped together can have different shapes in value. If provided, there
	// will be one single attribution generated in [
	// featureAttributions][Attribution.feature_attributions], keyed by the
	// group name.
	GroupName string `protobuf:"bytes,12,opt,name=group_name,json=groupName,proto3" json:"group_name,omitempty"`
}

func (x *ExplanationMetadata_InputMetadata) Reset() {
	*x = ExplanationMetadata_InputMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExplanationMetadata_InputMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExplanationMetadata_InputMetadata) ProtoMessage() {}

func (x *ExplanationMetadata_InputMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExplanationMetadata_InputMetadata.ProtoReflect.Descriptor instead.
func (*ExplanationMetadata_InputMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_rawDescGZIP(), []int{0, 0}
}

func (x *ExplanationMetadata_InputMetadata) GetInputBaselines() []*structpb.Value {
	if x != nil {
		return x.InputBaselines
	}
	return nil
}

func (x *ExplanationMetadata_InputMetadata) GetInputTensorName() string {
	if x != nil {
		return x.InputTensorName
	}
	return ""
}

func (x *ExplanationMetadata_InputMetadata) GetEncoding() ExplanationMetadata_InputMetadata_Encoding {
	if x != nil {
		return x.Encoding
	}
	return ExplanationMetadata_InputMetadata_ENCODING_UNSPECIFIED
}

func (x *ExplanationMetadata_InputMetadata) GetModality() string {
	if x != nil {
		return x.Modality
	}
	return ""
}

func (x *ExplanationMetadata_InputMetadata) GetFeatureValueDomain() *ExplanationMetadata_InputMetadata_FeatureValueDomain {
	if x != nil {
		return x.FeatureValueDomain
	}
	return nil
}

func (x *ExplanationMetadata_InputMetadata) GetIndicesTensorName() string {
	if x != nil {
		return x.IndicesTensorName
	}
	return ""
}

func (x *ExplanationMetadata_InputMetadata) GetDenseShapeTensorName() string {
	if x != nil {
		return x.DenseShapeTensorName
	}
	return ""
}

func (x *ExplanationMetadata_InputMetadata) GetIndexFeatureMapping() []string {
	if x != nil {
		return x.IndexFeatureMapping
	}
	return nil
}

func (x *ExplanationMetadata_InputMetadata) GetEncodedTensorName() string {
	if x != nil {
		return x.EncodedTensorName
	}
	return ""
}

func (x *ExplanationMetadata_InputMetadata) GetEncodedBaselines() []*structpb.Value {
	if x != nil {
		return x.EncodedBaselines
	}
	return nil
}

func (x *ExplanationMetadata_InputMetadata) GetVisualization() *ExplanationMetadata_InputMetadata_Visualization {
	if x != nil {
		return x.Visualization
	}
	return nil
}

func (x *ExplanationMetadata_InputMetadata) GetGroupName() string {
	if x != nil {
		return x.GroupName
	}
	return ""
}

// Metadata of the prediction output to be explained.
type ExplanationMetadata_OutputMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Defines how to map [Attribution.output_index][google.cloud.aiplatform.v1beta1.Attribution.output_index] to
	// [Attribution.output_display_name][google.cloud.aiplatform.v1beta1.Attribution.output_display_name].
	//
	// If neither of the fields are specified,
	// [Attribution.output_display_name][google.cloud.aiplatform.v1beta1.Attribution.output_display_name] will not be populated.
	//
	// Types that are assignable to DisplayNameMapping:
	//	*ExplanationMetadata_OutputMetadata_IndexDisplayNameMapping
	//	*ExplanationMetadata_OutputMetadata_DisplayNameMappingKey
	DisplayNameMapping isExplanationMetadata_OutputMetadata_DisplayNameMapping `protobuf_oneof:"display_name_mapping"`
	// Name of the output tensor. Required and is only applicable to AI
	// Platform provided images for Tensorflow.
	OutputTensorName string `protobuf:"bytes,3,opt,name=output_tensor_name,json=outputTensorName,proto3" json:"output_tensor_name,omitempty"`
}

func (x *ExplanationMetadata_OutputMetadata) Reset() {
	*x = ExplanationMetadata_OutputMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExplanationMetadata_OutputMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExplanationMetadata_OutputMetadata) ProtoMessage() {}

func (x *ExplanationMetadata_OutputMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExplanationMetadata_OutputMetadata.ProtoReflect.Descriptor instead.
func (*ExplanationMetadata_OutputMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_rawDescGZIP(), []int{0, 1}
}

func (m *ExplanationMetadata_OutputMetadata) GetDisplayNameMapping() isExplanationMetadata_OutputMetadata_DisplayNameMapping {
	if m != nil {
		return m.DisplayNameMapping
	}
	return nil
}

func (x *ExplanationMetadata_OutputMetadata) GetIndexDisplayNameMapping() *structpb.Value {
	if x, ok := x.GetDisplayNameMapping().(*ExplanationMetadata_OutputMetadata_IndexDisplayNameMapping); ok {
		return x.IndexDisplayNameMapping
	}
	return nil
}

func (x *ExplanationMetadata_OutputMetadata) GetDisplayNameMappingKey() string {
	if x, ok := x.GetDisplayNameMapping().(*ExplanationMetadata_OutputMetadata_DisplayNameMappingKey); ok {
		return x.DisplayNameMappingKey
	}
	return ""
}

func (x *ExplanationMetadata_OutputMetadata) GetOutputTensorName() string {
	if x != nil {
		return x.OutputTensorName
	}
	return ""
}

type isExplanationMetadata_OutputMetadata_DisplayNameMapping interface {
	isExplanationMetadata_OutputMetadata_DisplayNameMapping()
}

type ExplanationMetadata_OutputMetadata_IndexDisplayNameMapping struct {
	// Static mapping between the index and display name.
	//
	// Use this if the outputs are a deterministic n-dimensional array, e.g. a
	// list of scores of all the classes in a pre-defined order for a
	// multi-classification Model. It's not feasible if the outputs are
	// non-deterministic, e.g. the Model produces top-k classes or sort the
	// outputs by their values.
	//
	// The shape of the value must be an n-dimensional array of strings. The
	// number of dimensions must match that of the outputs to be explained.
	// The [Attribution.output_display_name][google.cloud.aiplatform.v1beta1.Attribution.output_display_name] is populated by locating in the
	// mapping with [Attribution.output_index][google.cloud.aiplatform.v1beta1.Attribution.output_index].
	IndexDisplayNameMapping *structpb.Value `protobuf:"bytes,1,opt,name=index_display_name_mapping,json=indexDisplayNameMapping,proto3,oneof"`
}

type ExplanationMetadata_OutputMetadata_DisplayNameMappingKey struct {
	// Specify a field name in the prediction to look for the display name.
	//
	// Use this if the prediction contains the display names for the outputs.
	//
	// The display names in the prediction must have the same shape of the
	// outputs, so that it can be located by [Attribution.output_index][google.cloud.aiplatform.v1beta1.Attribution.output_index] for
	// a specific output.
	DisplayNameMappingKey string `protobuf:"bytes,2,opt,name=display_name_mapping_key,json=displayNameMappingKey,proto3,oneof"`
}

func (*ExplanationMetadata_OutputMetadata_IndexDisplayNameMapping) isExplanationMetadata_OutputMetadata_DisplayNameMapping() {
}

func (*ExplanationMetadata_OutputMetadata_DisplayNameMappingKey) isExplanationMetadata_OutputMetadata_DisplayNameMapping() {
}

// Domain details of the input feature value. Provides numeric information
// about the feature, such as its range (min, max). If the feature has been
// pre-processed, for example with z-scoring, then it provides information
// about how to recover the original feature. For example, if the input
// feature is an image and it has been pre-processed to obtain 0-mean and
// stddev = 1 values, then original_mean, and original_stddev refer to the
// mean and stddev of the original feature (e.g. image tensor) from which
// input feature (with mean = 0 and stddev = 1) was obtained.
type ExplanationMetadata_InputMetadata_FeatureValueDomain struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The minimum permissible value for this feature.
	MinValue float32 `protobuf:"fixed32,1,opt,name=min_value,json=minValue,proto3" json:"min_value,omitempty"`
	// The maximum permissible value for this feature.
	MaxValue float32 `protobuf:"fixed32,2,opt,name=max_value,json=maxValue,proto3" json:"max_value,omitempty"`
	// If this input feature has been normalized to a mean value of 0,
	// the original_mean specifies the mean value of the domain prior to
	// normalization.
	OriginalMean float32 `protobuf:"fixed32,3,opt,name=original_mean,json=originalMean,proto3" json:"original_mean,omitempty"`
	// If this input feature has been normalized to a standard deviation of
	// 1.0, the original_stddev specifies the standard deviation of the domain
	// prior to normalization.
	OriginalStddev float32 `protobuf:"fixed32,4,opt,name=original_stddev,json=originalStddev,proto3" json:"original_stddev,omitempty"`
}

func (x *ExplanationMetadata_InputMetadata_FeatureValueDomain) Reset() {
	*x = ExplanationMetadata_InputMetadata_FeatureValueDomain{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExplanationMetadata_InputMetadata_FeatureValueDomain) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExplanationMetadata_InputMetadata_FeatureValueDomain) ProtoMessage() {}

func (x *ExplanationMetadata_InputMetadata_FeatureValueDomain) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExplanationMetadata_InputMetadata_FeatureValueDomain.ProtoReflect.Descriptor instead.
func (*ExplanationMetadata_InputMetadata_FeatureValueDomain) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_rawDescGZIP(), []int{0, 0, 0}
}

func (x *ExplanationMetadata_InputMetadata_FeatureValueDomain) GetMinValue() float32 {
	if x != nil {
		return x.MinValue
	}
	return 0
}

func (x *ExplanationMetadata_InputMetadata_FeatureValueDomain) GetMaxValue() float32 {
	if x != nil {
		return x.MaxValue
	}
	return 0
}

func (x *ExplanationMetadata_InputMetadata_FeatureValueDomain) GetOriginalMean() float32 {
	if x != nil {
		return x.OriginalMean
	}
	return 0
}

func (x *ExplanationMetadata_InputMetadata_FeatureValueDomain) GetOriginalStddev() float32 {
	if x != nil {
		return x.OriginalStddev
	}
	return 0
}

// Visualization configurations for image explanation.
type ExplanationMetadata_InputMetadata_Visualization struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of the image visualization. Only applicable to [Integrated
	// Gradients attribution]
	// [ExplanationParameters.integrated_gradients_attribution]. OUTLINES
	// shows regions of attribution, while PIXELS shows per-pixel attribution.
	// Defaults to OUTLINES.
	Type ExplanationMetadata_InputMetadata_Visualization_Type `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.aiplatform.v1beta1.ExplanationMetadata_InputMetadata_Visualization_Type" json:"type,omitempty"`
	// Whether to only highlight pixels with positive contributions, negative
	// or both. Defaults to POSITIVE.
	Polarity ExplanationMetadata_InputMetadata_Visualization_Polarity `protobuf:"varint,2,opt,name=polarity,proto3,enum=google.cloud.aiplatform.v1beta1.ExplanationMetadata_InputMetadata_Visualization_Polarity" json:"polarity,omitempty"`
	// The color scheme used for the highlighted areas.
	//
	// Defaults to PINK_GREEN for [Integrated Gradients
	// attribution][ExplanationParameters.integrated_gradients_attribution],
	// which shows positive attributions in green and negative in pink.
	//
	// Defaults to VIRIDIS for
	// [XRAI attribution][google.cloud.aiplatform.v1beta1.ExplanationParameters.xrai_attribution], which
	// highlights the most influential regions in yellow and the least
	// influential in blue.
	ColorMap ExplanationMetadata_InputMetadata_Visualization_ColorMap `protobuf:"varint,3,opt,name=color_map,json=colorMap,proto3,enum=google.cloud.aiplatform.v1beta1.ExplanationMetadata_InputMetadata_Visualization_ColorMap" json:"color_map,omitempty"`
	// Excludes attributions above the specified percentile from the
	// highlighted areas. Using the clip_percent_upperbound and
	// clip_percent_lowerbound together can be useful for filtering out noise
	// and making it easier to see areas of strong attribution. Defaults to
	// 99.9.
	ClipPercentUpperbound float32 `protobuf:"fixed32,4,opt,name=clip_percent_upperbound,json=clipPercentUpperbound,proto3" json:"clip_percent_upperbound,omitempty"`
	// Excludes attributions below the specified percentile, from the
	// highlighted areas. Defaults to 62.
	ClipPercentLowerbound float32 `protobuf:"fixed32,5,opt,name=clip_percent_lowerbound,json=clipPercentLowerbound,proto3" json:"clip_percent_lowerbound,omitempty"`
	// How the original image is displayed in the visualization.
	// Adjusting the overlay can help increase visual clarity if the original
	// image makes it difficult to view the visualization. Defaults to NONE.
	OverlayType ExplanationMetadata_InputMetadata_Visualization_OverlayType `protobuf:"varint,6,opt,name=overlay_type,json=overlayType,proto3,enum=google.cloud.aiplatform.v1beta1.ExplanationMetadata_InputMetadata_Visualization_OverlayType" json:"overlay_type,omitempty"`
}

func (x *ExplanationMetadata_InputMetadata_Visualization) Reset() {
	*x = ExplanationMetadata_InputMetadata_Visualization{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExplanationMetadata_InputMetadata_Visualization) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExplanationMetadata_InputMetadata_Visualization) ProtoMessage() {}

func (x *ExplanationMetadata_InputMetadata_Visualization) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExplanationMetadata_InputMetadata_Visualization.ProtoReflect.Descriptor instead.
func (*ExplanationMetadata_InputMetadata_Visualization) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_rawDescGZIP(), []int{0, 0, 1}
}

func (x *ExplanationMetadata_InputMetadata_Visualization) GetType() ExplanationMetadata_InputMetadata_Visualization_Type {
	if x != nil {
		return x.Type
	}
	return ExplanationMetadata_InputMetadata_Visualization_TYPE_UNSPECIFIED
}

func (x *ExplanationMetadata_InputMetadata_Visualization) GetPolarity() ExplanationMetadata_InputMetadata_Visualization_Polarity {
	if x != nil {
		return x.Polarity
	}
	return ExplanationMetadata_InputMetadata_Visualization_POLARITY_UNSPECIFIED
}

func (x *ExplanationMetadata_InputMetadata_Visualization) GetColorMap() ExplanationMetadata_InputMetadata_Visualization_ColorMap {
	if x != nil {
		return x.ColorMap
	}
	return ExplanationMetadata_InputMetadata_Visualization_COLOR_MAP_UNSPECIFIED
}

func (x *ExplanationMetadata_InputMetadata_Visualization) GetClipPercentUpperbound() float32 {
	if x != nil {
		return x.ClipPercentUpperbound
	}
	return 0
}

func (x *ExplanationMetadata_InputMetadata_Visualization) GetClipPercentLowerbound() float32 {
	if x != nil {
		return x.ClipPercentLowerbound
	}
	return 0
}

func (x *ExplanationMetadata_InputMetadata_Visualization) GetOverlayType() ExplanationMetadata_InputMetadata_Visualization_OverlayType {
	if x != nil {
		return x.OverlayType
	}
	return ExplanationMetadata_InputMetadata_Visualization_OVERLAY_TYPE_UNSPECIFIED
}

var File_google_cloud_aiplatform_v1beta1_explanation_metadata_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_rawDesc = []byte{
	0x0a, 0x3a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc1, 0x16, 0x0a, 0x13, 0x45,
	0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x5d, 0x0a, 0x06, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x69, 0x6e, 0x70, 0x75, 0x74,
	0x73, 0x12, 0x60, 0x0a, 0x07, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x6f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x73, 0x12, 0x45, 0x0a, 0x1f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x61,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x73, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x1c, 0x66, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x55, 0x72, 0x69, 0x1a, 0xb6, 0x10, 0x0a, 0x0d, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x3f, 0x0a, 0x0f,
	0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x62, 0x61, 0x73, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0e, 0x69,
	0x6e, 0x70, 0x75, 0x74, 0x42, 0x61, 0x73, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x12, 0x2a, 0x0a,
	0x11, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x54,
	0x65, 0x6e, 0x73, 0x6f, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x67, 0x0a, 0x08, 0x65, 0x6e, 0x63,
	0x6f, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x78,
	0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e,
	0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x08, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69,
	0x6e, 0x67, 0x12, 0x1a, 0x0a, 0x08, 0x6d, 0x6f, 0x64, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6d, 0x6f, 0x64, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x87,
	0x01, 0x0a, 0x14, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x5f, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x55, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x44, 0x6f,
	0x6d, 0x61, 0x69, 0x6e, 0x52, 0x12, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x12, 0x2e, 0x0a, 0x13, 0x69, 0x6e, 0x64, 0x69,
	0x63, 0x65, 0x73, 0x5f, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x69, 0x6e, 0x64, 0x69, 0x63, 0x65, 0x73, 0x54, 0x65,
	0x6e, 0x73, 0x6f, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x17, 0x64, 0x65, 0x6e, 0x73,
	0x65, 0x5f, 0x73, 0x68, 0x61, 0x70, 0x65, 0x5f, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x64, 0x65, 0x6e, 0x73, 0x65,
	0x53, 0x68, 0x61, 0x70, 0x65, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x32, 0x0a, 0x15, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x5f, 0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x18, 0x08, 0x20, 0x03, 0x28, 0x09, 0x52, 0x13,
	0x69, 0x6e, 0x64, 0x65, 0x78, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4d, 0x61, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x12, 0x2e, 0x0a, 0x13, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x64, 0x5f, 0x74,
	0x65, 0x6e, 0x73, 0x6f, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x11, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x64, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x43, 0x0a, 0x11, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x64, 0x5f, 0x62,
	0x61, 0x73, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x16,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x10, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x64, 0x42,
	0x61, 0x73, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x12, 0x76, 0x0a, 0x0d, 0x76, 0x69, 0x73, 0x75,
	0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x2e, 0x56, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x0d, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x1d, 0x0a, 0x0a, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0c,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4e, 0x61, 0x6d, 0x65, 0x1a,
	0x9c, 0x01, 0x0a, 0x12, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x6d, 0x69, 0x6e, 0x5f, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x52, 0x08, 0x6d, 0x69, 0x6e, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x6d, 0x61, 0x78, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x08, 0x6d, 0x61, 0x78, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x12, 0x23, 0x0a, 0x0d, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x6d, 0x65, 0x61,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0c, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61,
	0x6c, 0x4d, 0x65, 0x61, 0x6e, 0x12, 0x27, 0x0a, 0x0f, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61,
	0x6c, 0x5f, 0x73, 0x74, 0x64, 0x64, 0x65, 0x76, 0x18, 0x04, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0e,
	0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x53, 0x74, 0x64, 0x64, 0x65, 0x76, 0x1a, 0xbf,
	0x07, 0x0a, 0x0d, 0x56, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x69, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x55,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x2e, 0x56, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x75, 0x0a, 0x08, 0x70,
	0x6f, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x59, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x2e, 0x56, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x50, 0x6f, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x52, 0x08, 0x70, 0x6f, 0x6c, 0x61, 0x72, 0x69,
	0x74, 0x79, 0x12, 0x76, 0x0a, 0x09, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x5f, 0x6d, 0x61, 0x70, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x59, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x49, 0x6e, 0x70, 0x75,
	0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x56, 0x69, 0x73, 0x75, 0x61, 0x6c,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x4d, 0x61, 0x70,
	0x52, 0x08, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x4d, 0x61, 0x70, 0x12, 0x36, 0x0a, 0x17, 0x63, 0x6c,
	0x69, 0x70, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x5f, 0x75, 0x70, 0x70, 0x65, 0x72,
	0x62, 0x6f, 0x75, 0x6e, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x02, 0x52, 0x15, 0x63, 0x6c, 0x69,
	0x70, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x55, 0x70, 0x70, 0x65, 0x72, 0x62, 0x6f, 0x75,
	0x6e, 0x64, 0x12, 0x36, 0x0a, 0x17, 0x63, 0x6c, 0x69, 0x70, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65,
	0x6e, 0x74, 0x5f, 0x6c, 0x6f, 0x77, 0x65, 0x72, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x02, 0x52, 0x15, 0x63, 0x6c, 0x69, 0x70, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74,
	0x4c, 0x6f, 0x77, 0x65, 0x72, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x12, 0x7f, 0x0a, 0x0c, 0x6f, 0x76,
	0x65, 0x72, 0x6c, 0x61, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x5c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x2e, 0x56, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x4f, 0x76, 0x65, 0x72, 0x6c, 0x61, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0b,
	0x6f, 0x76, 0x65, 0x72, 0x6c, 0x61, 0x79, 0x54, 0x79, 0x70, 0x65, 0x22, 0x36, 0x0a, 0x04, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x50, 0x49, 0x58,
	0x45, 0x4c, 0x53, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x4f, 0x55, 0x54, 0x4c, 0x49, 0x4e, 0x45,
	0x53, 0x10, 0x02, 0x22, 0x4a, 0x0a, 0x08, 0x50, 0x6f, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x12,
	0x18, 0x0a, 0x14, 0x50, 0x4f, 0x4c, 0x41, 0x52, 0x49, 0x54, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x50, 0x4f, 0x53,
	0x49, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x4e, 0x45, 0x47, 0x41, 0x54,
	0x49, 0x56, 0x45, 0x10, 0x02, 0x12, 0x08, 0x0a, 0x04, 0x42, 0x4f, 0x54, 0x48, 0x10, 0x03, 0x22,
	0x7b, 0x0a, 0x08, 0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x4d, 0x61, 0x70, 0x12, 0x19, 0x0a, 0x15, 0x43,
	0x4f, 0x4c, 0x4f, 0x52, 0x5f, 0x4d, 0x41, 0x50, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x50, 0x49, 0x4e, 0x4b, 0x5f, 0x47,
	0x52, 0x45, 0x45, 0x4e, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x56, 0x49, 0x52, 0x49, 0x44, 0x49,
	0x53, 0x10, 0x02, 0x12, 0x07, 0x0a, 0x03, 0x52, 0x45, 0x44, 0x10, 0x03, 0x12, 0x09, 0x0a, 0x05,
	0x47, 0x52, 0x45, 0x45, 0x4e, 0x10, 0x04, 0x12, 0x0d, 0x0a, 0x09, 0x52, 0x45, 0x44, 0x5f, 0x47,
	0x52, 0x45, 0x45, 0x4e, 0x10, 0x06, 0x12, 0x14, 0x0a, 0x10, 0x50, 0x49, 0x4e, 0x4b, 0x5f, 0x57,
	0x48, 0x49, 0x54, 0x45, 0x5f, 0x47, 0x52, 0x45, 0x45, 0x4e, 0x10, 0x05, 0x22, 0x62, 0x0a, 0x0b,
	0x4f, 0x76, 0x65, 0x72, 0x6c, 0x61, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x4f,
	0x56, 0x45, 0x52, 0x4c, 0x41, 0x59, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x4e, 0x4f, 0x4e,
	0x45, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x4f, 0x52, 0x49, 0x47, 0x49, 0x4e, 0x41, 0x4c, 0x10,
	0x02, 0x12, 0x0d, 0x0a, 0x09, 0x47, 0x52, 0x41, 0x59, 0x53, 0x43, 0x41, 0x4c, 0x45, 0x10, 0x03,
	0x12, 0x0e, 0x0a, 0x0a, 0x4d, 0x41, 0x53, 0x4b, 0x5f, 0x42, 0x4c, 0x41, 0x43, 0x4b, 0x10, 0x04,
	0x22, 0xa0, 0x01, 0x0a, 0x08, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x18, 0x0a,
	0x14, 0x45, 0x4e, 0x43, 0x4f, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x49, 0x44, 0x45, 0x4e, 0x54,
	0x49, 0x54, 0x59, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x42, 0x41, 0x47, 0x5f, 0x4f, 0x46, 0x5f,
	0x46, 0x45, 0x41, 0x54, 0x55, 0x52, 0x45, 0x53, 0x10, 0x02, 0x12, 0x1a, 0x0a, 0x16, 0x42, 0x41,
	0x47, 0x5f, 0x4f, 0x46, 0x5f, 0x46, 0x45, 0x41, 0x54, 0x55, 0x52, 0x45, 0x53, 0x5f, 0x53, 0x50,
	0x41, 0x52, 0x53, 0x45, 0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09, 0x49, 0x4e, 0x44, 0x49, 0x43, 0x41,
	0x54, 0x4f, 0x52, 0x10, 0x04, 0x12, 0x16, 0x0a, 0x12, 0x43, 0x4f, 0x4d, 0x42, 0x49, 0x4e, 0x45,
	0x44, 0x5f, 0x45, 0x4d, 0x42, 0x45, 0x44, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x05, 0x12, 0x14, 0x0a,
	0x10, 0x43, 0x4f, 0x4e, 0x43, 0x41, 0x54, 0x5f, 0x45, 0x4d, 0x42, 0x45, 0x44, 0x44, 0x49, 0x4e,
	0x47, 0x10, 0x06, 0x1a, 0xe8, 0x01, 0x0a, 0x0e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x55, 0x0a, 0x1a, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x6d, 0x61, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x48, 0x00, 0x52, 0x17, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x44, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x12, 0x39, 0x0a,
	0x18, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x6d, 0x61,
	0x70, 0x70, 0x69, 0x6e, 0x67, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x00, 0x52, 0x15, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x4d, 0x61,
	0x70, 0x70, 0x69, 0x6e, 0x67, 0x4b, 0x65, 0x79, 0x12, 0x2c, 0x0a, 0x12, 0x6f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x5f, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x54, 0x65, 0x6e, 0x73,
	0x6f, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x42, 0x16, 0x0a, 0x14, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x1a, 0x7d,
	0x0a, 0x0b, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x58, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x7f, 0x0a,
	0x0c, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x59, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x42, 0x8c,
	0x01, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x18, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x50, 0x01, 0x5a, 0x49, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e,
	0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x3b, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_rawDescData = file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_rawDesc
)

func file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_rawDescData
}

var file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_goTypes = []interface{}{
	(ExplanationMetadata_InputMetadata_Encoding)(0),                  // 0: google.cloud.aiplatform.v1beta1.ExplanationMetadata.InputMetadata.Encoding
	(ExplanationMetadata_InputMetadata_Visualization_Type)(0),        // 1: google.cloud.aiplatform.v1beta1.ExplanationMetadata.InputMetadata.Visualization.Type
	(ExplanationMetadata_InputMetadata_Visualization_Polarity)(0),    // 2: google.cloud.aiplatform.v1beta1.ExplanationMetadata.InputMetadata.Visualization.Polarity
	(ExplanationMetadata_InputMetadata_Visualization_ColorMap)(0),    // 3: google.cloud.aiplatform.v1beta1.ExplanationMetadata.InputMetadata.Visualization.ColorMap
	(ExplanationMetadata_InputMetadata_Visualization_OverlayType)(0), // 4: google.cloud.aiplatform.v1beta1.ExplanationMetadata.InputMetadata.Visualization.OverlayType
	(*ExplanationMetadata)(nil),                                      // 5: google.cloud.aiplatform.v1beta1.ExplanationMetadata
	(*ExplanationMetadata_InputMetadata)(nil),                        // 6: google.cloud.aiplatform.v1beta1.ExplanationMetadata.InputMetadata
	(*ExplanationMetadata_OutputMetadata)(nil),                       // 7: google.cloud.aiplatform.v1beta1.ExplanationMetadata.OutputMetadata
	nil, // 8: google.cloud.aiplatform.v1beta1.ExplanationMetadata.InputsEntry
	nil, // 9: google.cloud.aiplatform.v1beta1.ExplanationMetadata.OutputsEntry
	(*ExplanationMetadata_InputMetadata_FeatureValueDomain)(nil), // 10: google.cloud.aiplatform.v1beta1.ExplanationMetadata.InputMetadata.FeatureValueDomain
	(*ExplanationMetadata_InputMetadata_Visualization)(nil),      // 11: google.cloud.aiplatform.v1beta1.ExplanationMetadata.InputMetadata.Visualization
	(*structpb.Value)(nil), // 12: google.protobuf.Value
}
var file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_depIdxs = []int32{
	8,  // 0: google.cloud.aiplatform.v1beta1.ExplanationMetadata.inputs:type_name -> google.cloud.aiplatform.v1beta1.ExplanationMetadata.InputsEntry
	9,  // 1: google.cloud.aiplatform.v1beta1.ExplanationMetadata.outputs:type_name -> google.cloud.aiplatform.v1beta1.ExplanationMetadata.OutputsEntry
	12, // 2: google.cloud.aiplatform.v1beta1.ExplanationMetadata.InputMetadata.input_baselines:type_name -> google.protobuf.Value
	0,  // 3: google.cloud.aiplatform.v1beta1.ExplanationMetadata.InputMetadata.encoding:type_name -> google.cloud.aiplatform.v1beta1.ExplanationMetadata.InputMetadata.Encoding
	10, // 4: google.cloud.aiplatform.v1beta1.ExplanationMetadata.InputMetadata.feature_value_domain:type_name -> google.cloud.aiplatform.v1beta1.ExplanationMetadata.InputMetadata.FeatureValueDomain
	12, // 5: google.cloud.aiplatform.v1beta1.ExplanationMetadata.InputMetadata.encoded_baselines:type_name -> google.protobuf.Value
	11, // 6: google.cloud.aiplatform.v1beta1.ExplanationMetadata.InputMetadata.visualization:type_name -> google.cloud.aiplatform.v1beta1.ExplanationMetadata.InputMetadata.Visualization
	12, // 7: google.cloud.aiplatform.v1beta1.ExplanationMetadata.OutputMetadata.index_display_name_mapping:type_name -> google.protobuf.Value
	6,  // 8: google.cloud.aiplatform.v1beta1.ExplanationMetadata.InputsEntry.value:type_name -> google.cloud.aiplatform.v1beta1.ExplanationMetadata.InputMetadata
	7,  // 9: google.cloud.aiplatform.v1beta1.ExplanationMetadata.OutputsEntry.value:type_name -> google.cloud.aiplatform.v1beta1.ExplanationMetadata.OutputMetadata
	1,  // 10: google.cloud.aiplatform.v1beta1.ExplanationMetadata.InputMetadata.Visualization.type:type_name -> google.cloud.aiplatform.v1beta1.ExplanationMetadata.InputMetadata.Visualization.Type
	2,  // 11: google.cloud.aiplatform.v1beta1.ExplanationMetadata.InputMetadata.Visualization.polarity:type_name -> google.cloud.aiplatform.v1beta1.ExplanationMetadata.InputMetadata.Visualization.Polarity
	3,  // 12: google.cloud.aiplatform.v1beta1.ExplanationMetadata.InputMetadata.Visualization.color_map:type_name -> google.cloud.aiplatform.v1beta1.ExplanationMetadata.InputMetadata.Visualization.ColorMap
	4,  // 13: google.cloud.aiplatform.v1beta1.ExplanationMetadata.InputMetadata.Visualization.overlay_type:type_name -> google.cloud.aiplatform.v1beta1.ExplanationMetadata.InputMetadata.Visualization.OverlayType
	14, // [14:14] is the sub-list for method output_type
	14, // [14:14] is the sub-list for method input_type
	14, // [14:14] is the sub-list for extension type_name
	14, // [14:14] is the sub-list for extension extendee
	0,  // [0:14] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_init() }
func file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_init() {
	if File_google_cloud_aiplatform_v1beta1_explanation_metadata_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExplanationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExplanationMetadata_InputMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExplanationMetadata_OutputMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExplanationMetadata_InputMetadata_FeatureValueDomain); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExplanationMetadata_InputMetadata_Visualization); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*ExplanationMetadata_OutputMetadata_IndexDisplayNameMapping)(nil),
		(*ExplanationMetadata_OutputMetadata_DisplayNameMappingKey)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_rawDesc,
			NumEnums:      5,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_depIdxs,
		EnumInfos:         file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_enumTypes,
		MessageInfos:      file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1beta1_explanation_metadata_proto = out.File
	file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_goTypes = nil
	file_google_cloud_aiplatform_v1beta1_explanation_metadata_proto_depIdxs = nil
}
