// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0-devel
// 	protoc        v3.13.0
// source: google/cloud/aiplatform/v1/schema/predict/prediction/video_classification.proto

package prediction

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Prediction output format for Video Classification.
type VideoClassificationPredictionResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource ID of the AnnotationSpec that had been identified.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The display name of the AnnotationSpec that had been identified.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The type of the prediction. The requested types can be configured
	// via parameters. This will be one of
	// - segment-classification
	// - shot-classification
	// - one-sec-interval-classification
	Type string `protobuf:"bytes,3,opt,name=type,proto3" json:"type,omitempty"`
	// The beginning, inclusive, of the video's time segment in which the
	// AnnotationSpec has been identified. Expressed as a number of seconds as
	// measured from the start of the video, with fractions up to a microsecond
	// precision, and with "s" appended at the end. Note that for
	// 'segment-classification' prediction type, this equals the original
	// 'timeSegmentStart' from the input instance, for other types it is the
	// start of a shot or a 1 second interval respectively.
	TimeSegmentStart *durationpb.Duration `protobuf:"bytes,4,opt,name=time_segment_start,json=timeSegmentStart,proto3" json:"time_segment_start,omitempty"`
	// The end, exclusive, of the video's time segment in which the
	// AnnotationSpec has been identified. Expressed as a number of seconds as
	// measured from the start of the video, with fractions up to a microsecond
	// precision, and with "s" appended at the end. Note that for
	// 'segment-classification' prediction type, this equals the original
	// 'timeSegmentEnd' from the input instance, for other types it is the end
	// of a shot or a 1 second interval respectively.
	TimeSegmentEnd *durationpb.Duration `protobuf:"bytes,5,opt,name=time_segment_end,json=timeSegmentEnd,proto3" json:"time_segment_end,omitempty"`
	// The Model's confidence in correction of this prediction, higher
	// value means higher confidence.
	Confidence *wrapperspb.FloatValue `protobuf:"bytes,6,opt,name=confidence,proto3" json:"confidence,omitempty"`
}

func (x *VideoClassificationPredictionResult) Reset() {
	*x = VideoClassificationPredictionResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1_schema_predict_prediction_video_classification_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VideoClassificationPredictionResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoClassificationPredictionResult) ProtoMessage() {}

func (x *VideoClassificationPredictionResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_schema_predict_prediction_video_classification_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoClassificationPredictionResult.ProtoReflect.Descriptor instead.
func (*VideoClassificationPredictionResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_schema_predict_prediction_video_classification_proto_rawDescGZIP(), []int{0}
}

func (x *VideoClassificationPredictionResult) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *VideoClassificationPredictionResult) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *VideoClassificationPredictionResult) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *VideoClassificationPredictionResult) GetTimeSegmentStart() *durationpb.Duration {
	if x != nil {
		return x.TimeSegmentStart
	}
	return nil
}

func (x *VideoClassificationPredictionResult) GetTimeSegmentEnd() *durationpb.Duration {
	if x != nil {
		return x.TimeSegmentEnd
	}
	return nil
}

func (x *VideoClassificationPredictionResult) GetConfidence() *wrapperspb.FloatValue {
	if x != nil {
		return x.Confidence
	}
	return nil
}

var File_google_cloud_aiplatform_v1_schema_predict_prediction_video_classification_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1_schema_predict_prediction_video_classification_proto_rawDesc = []byte{
	0x0a, 0x4f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x2f, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x2f, 0x70, 0x72, 0x65, 0x64,
	0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x63, 0x6c, 0x61,
	0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x73, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x2e, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x65,
	0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xb7, 0x02, 0x0a, 0x23, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x43,
	0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x65,
	0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x0e, 0x0a,
	0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x21, 0x0a,
	0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x12, 0x47, 0x0a, 0x12, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x67,
	0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x74, 0x69, 0x6d,
	0x65, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x72, 0x74, 0x12, 0x43, 0x0a,
	0x10, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x65, 0x6e,
	0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x0e, 0x74, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x45,
	0x6e, 0x64, 0x12, 0x3b, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x6c, 0x6f, 0x61, 0x74, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x42,
	0xc6, 0x01, 0x0a, 0x38, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x2e, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63,
	0x74, 0x2e, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x28, 0x56, 0x69,
	0x64, 0x65, 0x6f, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x5e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2f, 0x76, 0x31, 0x2f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2f, 0x70, 0x72, 0x65, 0x64, 0x69,
	0x63, 0x74, 0x2f, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x3b, 0x70, 0x72,
	0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1_schema_predict_prediction_video_classification_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1_schema_predict_prediction_video_classification_proto_rawDescData = file_google_cloud_aiplatform_v1_schema_predict_prediction_video_classification_proto_rawDesc
)

func file_google_cloud_aiplatform_v1_schema_predict_prediction_video_classification_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1_schema_predict_prediction_video_classification_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1_schema_predict_prediction_video_classification_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1_schema_predict_prediction_video_classification_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1_schema_predict_prediction_video_classification_proto_rawDescData
}

var file_google_cloud_aiplatform_v1_schema_predict_prediction_video_classification_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_google_cloud_aiplatform_v1_schema_predict_prediction_video_classification_proto_goTypes = []interface{}{
	(*VideoClassificationPredictionResult)(nil), // 0: google.cloud.aiplatform.v1.schema.predict.prediction.VideoClassificationPredictionResult
	(*durationpb.Duration)(nil),                 // 1: google.protobuf.Duration
	(*wrapperspb.FloatValue)(nil),               // 2: google.protobuf.FloatValue
}
var file_google_cloud_aiplatform_v1_schema_predict_prediction_video_classification_proto_depIdxs = []int32{
	1, // 0: google.cloud.aiplatform.v1.schema.predict.prediction.VideoClassificationPredictionResult.time_segment_start:type_name -> google.protobuf.Duration
	1, // 1: google.cloud.aiplatform.v1.schema.predict.prediction.VideoClassificationPredictionResult.time_segment_end:type_name -> google.protobuf.Duration
	2, // 2: google.cloud.aiplatform.v1.schema.predict.prediction.VideoClassificationPredictionResult.confidence:type_name -> google.protobuf.FloatValue
	3, // [3:3] is the sub-list for method output_type
	3, // [3:3] is the sub-list for method input_type
	3, // [3:3] is the sub-list for extension type_name
	3, // [3:3] is the sub-list for extension extendee
	0, // [0:3] is the sub-list for field type_name
}

func init() {
	file_google_cloud_aiplatform_v1_schema_predict_prediction_video_classification_proto_init()
}
func file_google_cloud_aiplatform_v1_schema_predict_prediction_video_classification_proto_init() {
	if File_google_cloud_aiplatform_v1_schema_predict_prediction_video_classification_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_aiplatform_v1_schema_predict_prediction_video_classification_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VideoClassificationPredictionResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1_schema_predict_prediction_video_classification_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_aiplatform_v1_schema_predict_prediction_video_classification_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1_schema_predict_prediction_video_classification_proto_depIdxs,
		MessageInfos:      file_google_cloud_aiplatform_v1_schema_predict_prediction_video_classification_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1_schema_predict_prediction_video_classification_proto = out.File
	file_google_cloud_aiplatform_v1_schema_predict_prediction_video_classification_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1_schema_predict_prediction_video_classification_proto_goTypes = nil
	file_google_cloud_aiplatform_v1_schema_predict_prediction_video_classification_proto_depIdxs = nil
}
