#undef	DEBUG
#define	HAVE_LONGLONG
#define	HAVE_LITTLE_ENDIAN

#ifdef	OS_TYPE_IRIX
#undef	HAVE_LONGLONG
#undef	HAVE_LITTLE_ENDIAN
#endif

#ifdef	OS_TYPE_AIX
#undef	HAVE_LONGLONG
#endif


#include <stdio.h>
#include <errno.h>	/* errno */
#include <limits.h>	/* LONG_MAX */
#include <stdlib.h>	/* malloc(), lseek64() */
#include <unistd.h>	/* getopt(), read() */
#include <sys/types.h>	/* open() */
#include <sys/stat.h>	/* open() */
#include <fcntl.h>	/* open(), O_RDONLY */
#include <ctype.h>	/* tolower() */
#include <string.h>	/* strcmp() */

#define	VERBOSE_CHANNEL	stderr
#define	ERROR_CHANNEL	stderr
#define	DEBUG_CHANNEL	stderr
#define	HELP_CHANNEL	stdout
#define	VERSION_CHANNEL	stdout

#define	RETVAL_OK		0
#define	RETVAL_ERROR		2
#define	RETVAL_BUG		1

#define	FLIP( A )	( (A)=(A)==0?1:0 )
#define	MIN(A,B)	( (A) < (B) ? (A) : (B) )
#define	MAX(A,B)	( (A) > (B) ? (A) : (B) )
#define	LOW_UCHAR(A)	(((A)&0x0f) < 0x0a ? 0x30+((A)&0x0f) : 0x57+((A)&0x0f))
#define	HIG_UCHAR(A)	(((A) >> 4) < 0x0a ? 0x30+((A) >> 4) : 0x57+((A) >> 4))
#define IS_HEX_DIGIT(X) ( ((X)>='0'&&(X)<='9')||((X)>='a'&&(X)<='f')||((X)>='A'&&(X)<='F') ? 1 : 0 )
#define	CHAR2BYTE(A)	( (A)&0x40 ? ((A)&0x0f)+0x09 : (A)&0x0f )

#define	PERMISSIONS	( S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP | S_IROTH | S_IWOTH )

#define	BEGIN_CHAR	':'	/* begin char for numbers */
#define	END_CHAR	'|'	/* end char for numbers */
#define	REMARKER	'#'	/* comment char */


#define	LSEEK(A,B,C)	lseek((A),(B),(C))
#define	STRTOL(A,B,C)	strtol((A),(B),(C))
#define SIZE_MIN	( (off_t) 0 )
#define SIZE_MAX	( LONG_MAX - 1 )
#define	OFF_T		off_t

#ifdef	HAVE_LONGLONG
loff_t	lseek64( int fd, loff_t offset, int whence );
#define	LLONG_MAX	0x7fffffffffffffffll
#undef	LSEEK
#define	LSEEK(A,B,C)	lseek64((A),(B),(C))
#undef  STRTOL
#define	STRTOL(A,B,C)	strtoq((A),(B),(C))
#undef	SIZE_MIN
#define	SIZE_MIN	( (loff_t) 0 )
#undef	SIZE_MAX
#define	SIZE_MAX	( LLONG_MAX - 1 )
#undef	OFF_T
#define	OFF_T		loff_t
#endif

#define	VERSION_NUMBER		"0.70.02"
#define	DATE_OF_LAST_MOD	"2004-04-08"
#define	MY_EMAIL_ADDRESS	"Steffen Solyga <solyga@absinth.net>"
