/** VSys:$handlers.h:0.0.2a8$ **/
/*
 *  Transfered by VSys script on   11 17:05:08 MSK 2003
 *  Project: ndsad; Project version: 0.0.3-025;
 *  Branch: ;
 *  File: handlers.h; File version: 0.0.2a8
 */
#ifndef __HANDLERS_H__
#define __HANDLERS_H__

#include <sys/types.h>
#include <pthread.h>
#include "pcap.local.h"
#include "eth-hndl.h"
#include "ppp-hndl.h"
//#include "lo-hndl.h"
#include "nfc.h"
#include "mempool.h"

#include <vector>
#include <string>

#if OS_CODE == OS_SOLARIS
#define u_int16_t uint16_t
#define u_int32_t uint32_t
#define u_int8_t uint8_t
#endif


#ifdef WIN32
#define IFN_SIZE 512 // on windows iface names are VEERY long
#else
#define IFN_SIZE 32 // iface name size. As in linux/sockios.h
#endif

#define MPH_IFLIST 0x2 // iface type - for mempool

struct  if_list;
struct iff_list;

/*
 * IFace families list
 */
struct iff_list {
	char          iff_name[IFN_SIZE]; // Interface family name (eth, tun, ...)
	u_int16_t     iff_len;            // Name length
	pcap_handler  iff_h;              // Iface handler
	nfc          *iff_nfc;            // IFace family NFlow collection
	if_list      *iff_if;             // Up faces of current family
	u_int16_t     iff_mask;           // Internal index mask for family
	u_int8_t      iff_dummy;          // Flag - if family is dummy or not
	u_int8_t      iff_force;          // Flag - if family is forced or not
	u_int16_t     iff_hash;           // Hash size for current family
};

#define __IFF(a,b,c,d) { (a), (b), (c), 0, 0, (d), 0, 0, 0 }

/*
 * Structure with mempool_hdr
 */
struct if_list {
	int        ifl_type;               // First three fields are used by mempool
	int        ifl_size;               // Don't change their order and offset!
	if_list  * ifl_next;               // Next device
	char       ifl_name[ IFN_SIZE ];   // IFace name (fxp0, eth3, ...)
	u_int16_t  ifl_len;                // Name length
	u_int16_t  ifl_ind;                // Iface index number
	u_int16_t  ifl_ppp_offset;         // Used for PPP only! Use with caution
	nfc      * ifl_nfc;                // IFace NFlow collection
	                                   // May be shared with other faces
	pthread_t* ifl_pid;                // PThread ID of worker
	u_int8_t   ifl_dummy;              // Flag - if face is dummy or not
	void     * ifl_user;               // User data - unimplemented
};


extern iff_list  faces[];
extern mempool * ifl_pool;

#endif//__HANDLERS_H__
