/** VSys:$nfc.cc:0.0.3-013$ **/
/*
 *  Transfered by VSys script on   11 17:05:08 MSK 2003
 *  Project: ndsad; Project version: 0.0.3-025;
 *  Branch: ;
 *  File: nfc.cc; File version: 0.0.3-013
 */
#ifdef WIN32
#include <winsock2.h>
#else
#include <sys/types.h>
#include <unistd.h>
#endif
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "mempool.h"
#include "logger.h"
#include "nfc.h"

#include "debug.h"
#include "config_ndsad.h"
u_int16_t __hs_default = __PRE_DEFAULT_HASH_SIZE;

#if 0
void check_list( _nf_list * head, char * caller ) {
/*	if( !head ) return;
	_nf_list * tmp;
//	for( int i; head && i < 200; i++, head=head->nfl_next );
	for( ; head; head=head->nfl_next ) {
		for( tmp = head->nfl_next; tmp; tmp = tmp->nfl_next )
			if( tmp == head )
				goto detected;
	}
*/	return;/*
detected:
	printf( "Loop detected in `%s'!\nSleeping...", caller );
	sleep( 10 );*/
}
#endif

_nf_list * nfc::alloc_nfl() {
//	return (_nf_list *) malloc( sizeof( _nf_list ));
	if( nfpool ) {
		return (nf_list * ) nfpool->get();
	} else
		return new _nf_list;
}

void nfc::free_nfl( _nf_list * ptr ) {
//	free( ptr );
	if( nfpool ) {
		nfpool->put( MPH( ptr ) );
	} else
		delete ptr;
}

nfc::nfc( const u_int16_t hs ) : hsize( ((hs)?hs:__hs_default) ) {
//	head = 0;
	static int flag = 1;
	__LOCK_INIT(  sq );
	nf_list templ;
	templ.nfl_type = MPH_NFLIST;
	templ.nfl_size = sizeof( nf_list );
	if( nfpool && flag ) {
		nfpool->init( MPH( &templ ) );
		flag = 0;
	}
	hash = new pnf_list[hsize];
	memset( hash, 0, sizeof( nf_list * )*hsize);
	hml = new pthread_mutex_t[ hsize ];
	for( u_int16_t i = 0; i < hsize; i++ )
		pthread_mutex_init( hml+i, 0 );
	sq.header.count = 0;
	sq.header.seq = 0;
	DEB(printf( "NFC with %d buckets created.\n", hsize));
}

nfc::~nfc() {
	nf_list *tmp, *head;
	for( u_int16_t i = 0; i<hsize; i++ ) {
		head = hash[i];
		while( head ) {
			tmp = head->nfl_next;
			this->free_nfl( head );
			head = tmp;
		}
	}
	delete hash;
	delete hml;
}

/*
 * List is sorted by saddr from larger to smaller.
 */

nf5 * nfc::lookup( const nf5 * p ) {
	if( !p ) return 0;
	u_int16_t nfh = (nf_hash( p ) & (hsize - 1));
	nf_list * tmp = hash[nfh];
	nf_list	* bptr = 0;
	for(;tmp && tmp->nfl_nf.saddr  > p->saddr; bptr = tmp, tmp=tmp->nfl_next );
	for(;tmp && tmp->nfl_nf.saddr == p->saddr; bptr = tmp, tmp=tmp->nfl_next )
		if( __NF5_EQUAL( NF5(tmp), p )) return NF5(tmp);
	// Not found
	tmp = this->alloc_nfl();
	if( bptr ) {
		 tmp->nfl_next = bptr->nfl_next;
		bptr->nfl_next = tmp;
	} else {
		tmp->nfl_next = hash[nfh];
		hash[nfh] = tmp;
	}
	memset( NF5(tmp), 0, sizeof(nf5));
	tmp->nfl_nf.saddr = p->saddr;
	tmp->nfl_nf.daddr = p->daddr;
	tmp->nfl_nf.sport = p->sport;
	tmp->nfl_nf.dport = p->dport;
	tmp->nfl_nf.proto = p->proto;
	tmp->nfl_nf.iface = p->iface;
	tmp->nfl_nf.tos   = p->tos;
//	DEB(printf( "New entry added in [%d] bucket\n", nfh ));
	return NF5(tmp); // offset of `nf' field is 0, so we may return `tmp'
}

nf5 * nfc :: apply( const nf5 * p ) {
	u_int16_t nfh = nf_hash(p) & ( hsize - 1 );
	pthread_mutex_lock( hml+nfh );
	nf5 * tmp = lookup( p );
	if( !tmp ) {pthread_mutex_unlock( hml+nfh ); return 0; };
	if( !tmp->ts_first ) tmp->ts_first = p->ts_last;
	tmp->ts_last    = p->ts_last;
	tmp->tcp_flags |= p->tcp_flags;
	tmp->d_pkt     += p->d_pkt;
	tmp->d_oct     += p->d_oct;
	pthread_mutex_unlock( hml+nfh );
#if 0 
	//def __CHECK_ON_APPLY 
	if( nf_valid( tmp ) ) return tmp;
	if( !crop( tmp ) ) return 0;
	__LOCK( sq );
	nf_queue( tmp, &sq );
	__UNLOCK( sq );
	free_nfl( (_nf_list *) tmp );
	
	return 0;
#else
	return tmp;
#endif
}

int nfc :: remove( const nf5 * p ) {
	nf_list * tmp = crop( p );
	if( !tmp ) return 0;
	free_nfl( tmp );
	return 1;
}

int nfc :: send( const nf5 * p ) {
	nf_list * tmp = crop( p );
	if( !tmp ) return 0;
	nf_send( p );
	free_nfl( tmp );
	return 1;
}

/*
 * nfc :: crop
 *     crops node from the list and returns pointer to it.
 *     Methods like send and remove are working with `crop' return
 *     value.
 */

_nf_list * nfc :: crop( const nf5 * p ) {
	if( !p ) return 0;
	u_int16_t nfh = (nf_hash( p ) & (hsize - 1));
	nf_list *  tmp = hash[nfh];
	nf_list * bptr = 0;
	if( !tmp ) return 0;
	pthread_mutex_lock( hml+nfh );
	for(;tmp && tmp->nfl_nf.saddr  > p->saddr; bptr = tmp, tmp=tmp->nfl_next );
	for(;tmp && tmp->nfl_nf.saddr == p->saddr; bptr = tmp, tmp=tmp->nfl_next )
		if( NF5(tmp) == p ) {
			if( !bptr ) {
				hash[nfh] = 0;
			} else
				bptr->nfl_next = tmp->nfl_next;
			goto done;
		}
	tmp = 0;
done:
	pthread_mutex_unlock( hml+nfh );
	return tmp;
}

void nfc :: update( time_t ts, int dump, const char * name ) {
	int cnt = 0, dcnt = 0, hn = 0, hs = 0;
	char buf[256];
//	u_int32_t ts = tm*1000;
	
	nf_list *tmp, *ptr = 0;
	for( u_int16_t i = 0; i<hsize; i++ ) {
		tmp = hash[i];
		if( !tmp ) continue;
		pthread_mutex_lock( hml+i );
//		DEB(printf( "Hash[%d]:", i ));
//		DEB(fflush(stdout));
		hs = 0;
		ptr = 0;
		tmp = hash[i];
		while( tmp ) {
			cnt++;
			hs++;
			if( nf_valid_ts( NF5( tmp ), ts ) ) {
				ptr = tmp;
				tmp = tmp->nfl_next;
				continue;
			}
			__LOCK( sq );
			nf_queue( NF5(tmp), &sq );
			__UNLOCK( sq );
			if( ptr ) {
				ptr->nfl_next = tmp->nfl_next;
				free_nfl( tmp );
				tmp = ptr->nfl_next;
			} else {
				hash[i] = tmp->nfl_next;
				free_nfl( tmp );
				tmp = hash[i];
			}
			dcnt++;
		} // Loop for each hash node
//		DEB(printf( "%d\n", hs ));
		pthread_mutex_unlock( hml+i );
		hn++;
	} // Loop for entire hash
	__LOCK( sq );
	if( dump ) {
		snprintf(buf, 256, "NFC<%s> status on %s\t%d/%d messages ready, %d flows seen...\n\t%d/%d (%.2f%%) hash usage, %d entries scaned, %d dropped", 
	      name, ctime(&ts), sq.header.count, V5MSG_SIZE, ntohl(sq.header.seq), 
		  hn, hsize, 100.*hn/(1.*hsize), cnt, dcnt );
		writelog( buf );
	}
	nfm_send( &sq );
	sq.header.count = 0;
	__UNLOCK( sq );
}
