/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.io.File;
import java.io.IOException;
import org.fest.assertions.Condition;
import org.fest.assertions.Description;
import org.fest.assertions.FileContentComparator;
import org.fest.assertions.Formatting;
import org.fest.assertions.GenericAssert;
import org.fest.util.Arrays;
import org.fest.util.Strings;
import org.fest.util.Systems;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileAssert
extends GenericAssert<File> {
    private final FileContentComparator comparator;

    protected FileAssert(File actual) {
        this(actual, new FileContentComparator());
    }

    FileAssert(File actual, FileContentComparator comparator) {
        super(actual);
        this.comparator = comparator;
    }

    public FileAssert as(String description) {
        this.description(description);
        return this;
    }

    public FileAssert describedAs(String description) {
        return this.as(description);
    }

    public FileAssert as(Description description) {
        this.description(description);
        return this;
    }

    public FileAssert describedAs(Description description) {
        return this.as(description);
    }

    public FileAssert doesNotExist() {
        this.isNotNull();
        if (!((File)this.actual).exists()) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Strings.concat((Object[])new Object[]{"file:", Formatting.inBrackets(this.actual), " should not exist"}));
    }

    public FileAssert exists() {
        this.isNotNull();
        this.assertExists((File)this.actual);
        return this;
    }

    public FileAssert hasSize(long expected) {
        this.isNotNull();
        long size = ((File)this.actual).length();
        if (size == expected) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Strings.concat((Object[])new Object[]{"size of file:", Formatting.inBrackets(this.actual), " expected:", Formatting.inBrackets(expected), " but was:", Formatting.inBrackets(size)}));
    }

    public FileAssert isDirectory() {
        this.isNotNull();
        if (((File)this.actual).isDirectory()) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Strings.concat((Object[])new Object[]{"file:", Formatting.inBrackets(this.actual), " should be a directory"}));
    }

    public FileAssert isEqualTo(File expected) {
        this.assertEqualTo(expected);
        return this;
    }

    public FileAssert isFile() {
        this.isNotNull();
        if (((File)this.actual).isFile()) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Strings.concat((Object[])new Object[]{"file:", Formatting.inBrackets(this.actual), " should be a file"}));
    }

    public FileAssert isNotEqualTo(File other) {
        this.assertNotEqualTo(other);
        return this;
    }

    public FileAssert isNotNull() {
        this.assertNotNull();
        return this;
    }

    public FileAssert isNotSameAs(File other) {
        this.assertNotSameAs(other);
        return this;
    }

    public FileAssert isSameAs(File expected) {
        this.assertSameAs(expected);
        return this;
    }

    public FileAssert satisfies(Condition<File> condition) {
        this.assertSatisfies(condition);
        return this;
    }

    public FileAssert doesNotSatisfy(Condition<File> condition) {
        this.assertDoesNotSatisfy(condition);
        return this;
    }

    public FileAssert is(Condition<File> condition) {
        this.assertIs(condition);
        return this;
    }

    public FileAssert isNot(Condition<File> condition) {
        this.assertIsNot(condition);
        return this;
    }

    public FileAssert hasSameContentAs(File expected) {
        if (expected == null) {
            throw new NullPointerException(this.formattedErrorMessage("File to compare to should not be null"));
        }
        this.isNotNull();
        this.assertExists((File)this.actual).assertExists(expected);
        try {
            Object[] diffs = this.comparator.compareContents((File)this.actual, expected);
            if (!Arrays.isEmpty((Object[])diffs)) {
                this.fail(expected, (FileContentComparator.LineDiff[])diffs);
            }
        }
        catch (IOException e) {
            this.cannotCompareToExpectedFile(expected, e);
        }
        return this;
    }

    private void fail(File expected, FileContentComparator.LineDiff[] diffs) {
        this.failIfCustomMessageIsSet();
        StringBuilder b = new StringBuilder();
        b.append("file:").append(Formatting.inBrackets(this.actual)).append(" and file:").append(Formatting.inBrackets(expected)).append(" do not have same contents:");
        for (FileContentComparator.LineDiff diff : diffs) {
            b.append(Systems.LINE_SEPARATOR).append("line:").append(Formatting.inBrackets(diff.lineNumber)).append(", expected:").append(Formatting.inBrackets(diff.expected)).append(" but was:").append(Formatting.inBrackets(diff.actual));
        }
        this.fail(b.toString());
    }

    private void cannotCompareToExpectedFile(File expected, Exception e) {
        this.failIfCustomMessageIsSet(e);
        String message = Strings.concat((Object[])new Object[]{"unable to compare contents of files:", Formatting.inBrackets(this.actual), " and ", Formatting.inBrackets(expected)});
        this.fail(message, e);
    }

    private FileAssert assertExists(File file) {
        if (file.exists()) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Strings.concat((Object[])new Object[]{"file:", Formatting.inBrackets(file), " should exist"}));
    }

    public FileAssert isRelative() {
        this.isNotNull();
        if (!((File)this.actual).isAbsolute()) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Strings.concat((Object[])new Object[]{"file:", Formatting.inBrackets(this.actual), " should be a relative path"}));
    }

    public FileAssert isAbsolute() {
        this.isNotNull();
        if (((File)this.actual).isAbsolute()) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Strings.concat((Object[])new Object[]{"file:", Formatting.inBrackets(this.actual), " should be an absolute path"}));
    }

    public FileAssert overridingErrorMessage(String message) {
        this.replaceDefaultErrorMessagesWith(message);
        return this;
    }
}

