/***************************************************************************
 *   Copyright (C) 2004 by EVER Sp. z o.o.                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "map.h"

/* 
 * user configuration map 
 */
config_map user_config_map[] = 
{
	{ "smtp_server_address", 0, (void*)&g_usrcfg.szSMTPServer, "" },
	{ "smtp_auth_username", 0, (void*)&g_usrcfg.szSMTPAuth_Name, "" },
	{ "smtp_auth_password", 0, (void*)&g_usrcfg.szSMTPAuth_Password, "" },
	{ "email_sender_address", 0, (void*)&g_usrcfg.szSenderAddress, "" },
	{ "auto_ups_shutdown", 1, (void*)&g_usrcfg.ulUpsShutdown, "1" },
	{ "system_shutdown_command", 0, (void*)&g_usrcfg.szShutdownCmd, "init 0" },
	{ NULL, 0, NULL, NULL }
};

/* 
 * application configuration map 
 */
config_map app_config_map[] = 
{
	{ "interface", 0, (void*)&g_appcfg.sdrvcfg.szName, "" },
	{ NULL, 0, NULL, NULL }
};

int compile_main_config_map(CConf &pconf)
{
	int ic=0;
	
	while(app_config_map[ic].cfgitem_addr!=NULL) {
		if (app_config_map[ic].integraltype) {
			char *lval=pconf.getcfgitemvalue(app_config_map[ic].cfgitem_name);
			unsigned long ulval;
			if (lval!="" && lval!=NULL)
				ulval=strtoul(lval, NULL, 10);
			else
				ulval=strtoul(app_config_map[ic].defValue, NULL, 10);
			memcpy(app_config_map[ic].cfgitem_addr, &ulval, sizeof(unsigned long));
		} else {
			char *sval=pconf.getcfgitemvalue(app_config_map[ic].cfgitem_name);
			if (sval!="" && sval!=NULL)
				memcpy(app_config_map[ic].cfgitem_addr, sval, strlen(sval)*sizeof(char));
			else
				memcpy(app_config_map[ic].cfgitem_addr, app_config_map[ic].defValue, 
					strlen(app_config_map[ic].defValue)*sizeof(char));
		}
		ic++;
	}
	
	return 0; // success
}

int compile_user_config_map(CConf &pconf)
{
	int ic=0;
	
	while(user_config_map[ic].cfgitem_addr!=NULL) {
		if (user_config_map[ic].integraltype) {
			char *lval=pconf.getcfgitemvalue(user_config_map[ic].cfgitem_name);
			unsigned long ulval;
			if (lval!="" && lval!=NULL)
				ulval=strtoul(lval, NULL, 10);
			else
				ulval=strtoul(user_config_map[ic].defValue, NULL, 10);
			memcpy(user_config_map[ic].cfgitem_addr, &ulval, sizeof(unsigned long));
		} else {
			char *sval=pconf.getcfgitemvalue(user_config_map[ic].cfgitem_name);
			if (sval!="" && sval!=NULL)
				memcpy(user_config_map[ic].cfgitem_addr, sval, strlen(sval)*sizeof(char));
			else
				memcpy(user_config_map[ic].cfgitem_addr, user_config_map[ic].defValue, 
					strlen(user_config_map[ic].defValue)*sizeof(char));
		}
		ic++;
	}
	
	return 0; // success
}

