// The initial version of this file was autogenerated from the official AS3 reference at 
// https://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flash/events/NetDataEvent.html
// by https://github.com/golfinq/ActionScript_Event_Builder
// It won't be regenerated in the future, so feel free to edit and/or fix
package flash.events
{
    
    public class NetDataEvent extends Event
    {
        // The NetDataEvent.MEDIA_TYPE_DATA constant defines the value of the type property of the NetDataEvent object
        // dispatched when a data message in the media stream is encountered by the NetStream object.
        public static const MEDIA_TYPE_DATA:String = "mediaTypeData";

        // The timestamp of the data message in the media stream.
        private var _timestamp: Number;

        // A data object describing the message.
        private var _info: Object;

        public function NetDataEvent(type:String, bubbles:Boolean = false, cancelable:Boolean = false, timestamp:Number = 0, info:Object = null)
        {
            super(type,bubbles,cancelable);
            this._timestamp = timestamp;
            this._info = info;
        }
        

        // Creates a copy of an NetDataEvent object and sets the value of each property to match that of the original.
        override public function clone():Event
        {
            return new NetDataEvent(this.type, this.bubbles, this.cancelable, this.timestamp, this.info);
        }

        // Returns a string that contains all the properties of the NetDataEvent object.
        override public function toString():String
        {
            return this.formatToString("NetDataEvent","type","bubbles","cancelable","eventPhase","timestamp");
        }

        public function get timestamp() : Number
        {
            return this._timestamp;
        }
        

        public function get info() : Object
        {
            return this._info;
        }
        
    }
}

