# ruffle-extension

ruffle-extension is all of the power of Ruffle, in your browser.

Without needing websites to do anything, the browser extension automatically replaces any Flash content on websites with the Ruffle player.

It automatically negotiates with websites that do have Ruffle installed, to ensure that there is no conflict between the versions. Newer version of ruffle, either from the website or extension, will always take precedence and disable the other.

## Using ruffle-extension

The browser extension works in Chrome, Firefox, and Safari 14+. It can be installed directly from the [Chrome Web Store](https://chromewebstore.google.com/detail/ruffle-flash-emulator/donbcfbmhbcapadipfkeojnmajbakjdc) or [Firefox Add-ons site](https://addons.mozilla.org/firefox/addon/ruffle_rs). 
Or to install it manually, you can either download the [latest release](https://github.com/ruffle-rs/ruffle/releases) or [build it yourself](../../README.md), then follow the instructions below.

### Chrome

These instructions also apply to Chromium-based browsers such as Edge, Opera and Brave.

- Navigate to `chrome://extensions/`.
- Turn on Developer mode in the top-right corner.
- Drag and drop the `*-extension.zip` file into the page.

Alternatively, loading unpacked can save time during development:

- Navigate to `chrome://extensions/`.
- Turn on Developer mode in the top-right corner.
- Click "Load unpacked".
- Select the `assets/` folder.
- Each time after making changes, click the reload icon.

### Firefox (Developer Edition or Nightly)

- Navigate to `about:addons`.
- Click the gear and select "Install Add-on From File...".
- Select the `.xpi` file.

### Safari

- Unzip the `*-extension.zip` file.
- Run `xcrun safari-web-extension-converter path/to/unzipped_folder/`
- Click "Run on Xcode".
- Enable `Safari > Preferences > Advanced > Show Develop menu in menu bar`.
- Enable `Develop > Allow Unsigned Extensions`.
- Enable the extension by checking the box in `Safari > Preferences > Extensions`.

## Building, testing or contributing

Please see the [ruffle-web README](../../README.md).
