//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: cAction.hpp
// Project: Shooting Star
// Author: 
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================
#ifndef cAction_hpp
#define cAction_hpp
//==============================================================================
// Includes
//------------------------------------------------------------------------------
// Namespaces
using namespace std;
namespace ShootingStar {
//------------------------------------------------------------------------------
// Forward declarations
//==============================================================================
	
//! Action
class cAction
{
	// Constructor & Destructor
	public:
		//! Constructor
		cAction (void):
		mType (0),
		mAction (0)
		{
		};
		
		//! Constructor
		cAction (int type, int action):
		mType (type),
		mAction (action)
		{ 
		};
		
		//! Destructor
		~cAction (void)
		{
		};
	
	// Public methods
	public:
	
		bool IsValid (void) const { return (mType != 0 && mAction != 0); };
	
		int GetType (void) const { return mType; };
		int GetAction (void) const { return mAction; };	
	// Member variables
	private:
		int mType;
		int mAction;
};

//==============================================================================
}		// End of the ShootingStar namespace
#endif // cAction_hpp
//------------------------------------------------------------------------------
// EOF
//==============================================================================
