//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: cPointer.hpp
// Project: Shooting Star
// Author: 
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================
#ifndef cPointer_hpp
#define cPointer_hpp
//==============================================================================
// Includes
#include "Debug.hpp"
//------------------------------------------------------------------------------
// Namespaces
using namespace std;
namespace ShootingStar {
//------------------------------------------------------------------------------
// Forward declarations
//==============================================================================

template <class T>
//! Pointer
class cPointer
{
	// Constructor & Destructor
	public:
		//! Constructor
		cPointer (void):
		mpObject (NULL)
		{
		};
		//! Constructor
		cPointer (T *pObject):
		mpObject (NULL)
		{
			*this = pObject;
		}
		//! Constructor
		cPointer (const cPointer<T> &pointer):
		mpObject (NULL)
		{
			*this = pointer;
		};
		//! Destructor
		~cPointer (void)
		{
			if ( mpObject != NULL )
				mpObject->ReleaseReference ();
		};
		
		void operator= (T *pObject)
		{
			if ( mpObject != NULL )
				mpObject->ReleaseReference ();
			mpObject = pObject;
			if ( mpObject != NULL )
				mpObject->AddReference ();
		};
		void operator= (const cPointer<T> &pointer)
		{
			*this = pointer.mpObject;
		};
		
		T &operator* (void)
		{
			dbg::check_ptr (dbg::error, mpObject, DBG_HERE);
			return *mpObject;
		};
		T *operator-> (void)
		{
			dbg::check_ptr (dbg::error, mpObject, DBG_HERE);
			return mpObject;
		};
		operator T* (void)
		{
			return mpObject;
		};
	
	// Public methods
	public:
		bool IsValid (void) const { return mpObject != NULL; };
	
	// Member variables
	protected:
		T *mpObject;
};

//==============================================================================
}		// End of the ShootingStar namespace
#endif // cPointer_hpp
//------------------------------------------------------------------------------
// EOF
//==============================================================================
