//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: cBullet.hpp
// Project: Shooting Star
// Author: Jarmo Hekkanen <jarski@2ndpoint.fi>
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================
#ifndef cBullet_hpp
#define cBullet_hpp
//==============================================================================
// Includes
#include "cRenderable.hpp"
#include "cHarmful.hpp"
#include "cOwnable.hpp"
//------------------------------------------------------------------------------
// Namespaces
using namespace std;
namespace ShootingStar {
//------------------------------------------------------------------------------
// Forward declarations
//==============================================================================
	
//==============================================================================
//! Bullet
//------------------------------------------------------------------------------
class cBullet : public cHarmful, public cRenderable, public cOwnable
{
	// Constructor & Destructor
	public:
		//! Constructor
		cBullet (void);
		//! Destructor
		virtual ~cBullet (void);
	
	// Public methods
	public:
		//! Rendering interface
		virtual void Render (Uint32 deltaTime);
		//! Updating interface
		virtual void Update (Uint32 deltaTime);
	
		virtual void OnMapCollision (	const cVector2f &begin, 
										const cVector2f &end)
		{
			Kill ();
		};
		virtual void OnObjectCollision (cCollidable *pOther)
		{
			if ( pOther->GetID () != GetOwner () )
				cHarmful::OnObjectCollision (pOther);
		}
		virtual void OnDamage (cHurtable *pOther)
		{
			Kill ();
		};

	// Member variables
	private:
		Uint32 mTTL;		//!< Time to live
		float mLenght;
};
//==============================================================================

//==============================================================================
}		// End of the ShootingStar namespace
#endif // cBullet_hpp
//------------------------------------------------------------------------------
// EOF
//==============================================================================
