//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: cBurnable.cpp
// Project: Shooting Star
// Author: 
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================

//==============================================================================
// Includes
#include "cBurnable.hpp"
#include "cWorld.hpp"
//------------------------------------------------------------------------------
// Namespaces
using namespace ShootingStar;
//==============================================================================


//! Constructor
cBurnable::cBurnable (void)
{
	// Empty
};

//! Destructor
cBurnable::~cBurnable (void)
{
	// Empty
};

void 
cBurnable::Update (Uint32 deltaTime)
{
	if ( mEffect.IsValid () )
	{
		if ( !mEffect->IsAlive () )
			mEffect = NULL;
	}
}

void 
cBurnable::Burn (Uint32 time, ObjectID burner)
{
	// Spawn new effect
	if ( !mEffect.IsValid () )
	{
		mEffect = new cBurningEffect (this);
		cWorld::GetInstance ().SpawnObject (mEffect);
	}
	mEffect->AddTime (time);
	
	// TEMP (causes enemies to attack)
	DoDamage (0, cVector2f (0.0f, 0.0f), burner);
}

//==============================================================================
// EOF
//==============================================================================
