//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: cHud.hpp
// Project: Shooting Star
// Author: Tuomas Peippo
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================
#ifndef cHud_hpp
#define cHud_hpp
//==============================================================================
// Includes
#include <string>
#include "Types.hpp"
#include "cPlayer.hpp"
#include "cPointer.hpp"
//------------------------------------------------------------------------------
// Namespaces
using namespace std;
namespace ShootingStar {
//------------------------------------------------------------------------------
// Forward declarations
class cDisplayManager;
class cTextureManager;
class cTextureFont;
class cWorld;
//==============================================================================
	
//==============================================================================
//! Hud
//------------------------------------------------------------------------------
class cHud
{
	// Constructor & Destructor
	public:
		//! Constructor
		cHud (cPointer<cPlayer> &player1, cPointer<cPlayer> &player2);
		//! Destructor
		~cHud (void);
		
	public:
		void Render (void);
		void LoadTextures(void);
	
	
	// Private methods
	private:
		void RenderWeaponLogo (string name);
	
	// Member variables
	private:
		cDisplayManager &mDisplayManager;
		cTextureManager &mTexManager;
		cWorld &mWorld;
		Uint32 mHudP1;
		Uint32 mHudP2;
		Uint32 mWeaponLogos;
		cTextureFont *mpFont;
	
		cPointer<cPlayer> &mPlayer1;
		cPointer<cPlayer> &mPlayer2;
};
//==============================================================================

//==============================================================================
}		// End of the ShootingStar namespace
#endif // cHud_hpp
//------------------------------------------------------------------------------
// EOF
//==============================================================================
