
<!-- markdownlint-disable MD041 -->
<p align="left"><img src="https://vulkan.lunarg.com/img/NewLunarGLogoBlack.png" alt="LunarG" width=263 height=113 /></p>
<p align="left">Copyright (c) 2021-2024 LunarG, Inc.</p>

<p align="center"><img src="./images/logo.png" width=400 /></p>

[![Creative Commons][3]][4]

[3]: https://i.creativecommons.org/l/by-nd/4.0/88x31.png "Creative Commons License"
[4]: https://creativecommons.org/licenses/by-nd/4.0/

# Vulkan Profiles Definitions

## Vulkan Profiles List

| Profiles | VP_D3D12_FL_11_0_baseline | VP_D3D12_FL_11_1_baseline | VP_D3D12_FL_12_0_baseline | VP_D3D12_FL_12_0_optimal | VP_D3D12_FL_12_1_baseline | VP_D3D12_FL_12_2_baseline | VP_D3D12_FL_12_2_optimal | VP_D3D12_maximum_nv | VP_D3D12_maximum_radv |
|----------|---------------------------|---------------------------|---------------------------|--------------------------|---------------------------|---------------------------|--------------------------|---------------------|-----------------------|
| Label | Minimum baseline (FL 11.0) | FL 11.1 baseline | FL 12.0 baseline | FL 12.0 optimal configuration | FL 12.1 baseline | FL 12.2 baseline | FL 12.2 optimal | NVIDIA latest | RADV latest |
| Description | Minimum baseline to create a device at all. | Minimum baseline to create a device with FL 11.1. | Minimum baseline to create a device with FL 12.0. | Requirement to create a FL 12.0 device with optimal performance. Shader model 6.6 and optimal descriptor model. | Minimum baseline to create a device with FL 12.1. | Minimum baseline to create a device with FL 12.2 (TODO: missing sampler feedback). | Requirement to create a FL 12.2 device with optimal performance (TODO: missing sampler feedback). Shader model 6.6 and optimal descriptor model. | Represents the maximum feature set vkd3d-proton takes advantage of on NVIDIA. Expected to be supported on latest beta drivers on Turing+. | Represents the maximum feature set vkd3d-proton takes advantage of on RADV. Expected to be supported on latest Mesa Git on RDNA2+. |
| Version | 1 | 1 | 1 | 1 | 1 | 1 | 1 | 1 | 1 |
| Required API version | 1.3.204 | 1.3.204 | 1.3.204 | 1.3.204 | 1.3.204 | 1.3.204 | 1.3.204 | 1.3.204 | 1.3.204 |
| Required profiles |  |  |  |  |  |  |  |  |  |
| Fallback profiles | - | - | - | - | - | - | - | - | - |

## Vulkan Profiles Extensions

* :heavy_check_mark: indicates that the extension is defined in the profile
* "X.X Core" indicates that the extension is not defined in the profile but the extension is promoted to the specified core API version that is smaller than or equal to the minimum required API version of the profile
* :x: indicates that the extension is neither defined in the profile nor it is promoted to a core API version that is smaller than or equal to the minimum required API version of the profile

| Profiles | VP_D3D12_FL_11_0_baseline | VP_D3D12_FL_11_1_baseline | VP_D3D12_FL_12_0_baseline | VP_D3D12_FL_12_0_optimal | VP_D3D12_FL_12_1_baseline | VP_D3D12_FL_12_2_baseline | VP_D3D12_FL_12_2_optimal | VP_D3D12_maximum_nv | VP_D3D12_maximum_radv |
|----------|---------------------------|---------------------------|---------------------------|--------------------------|---------------------------|---------------------------|--------------------------|---------------------|-----------------------|
| **Instance extensions** |
| [VK_KHR_device_group_creation](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_device_group_creation.html) | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core |
| [VK_KHR_external_fence_capabilities](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_external_fence_capabilities.html) | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core |
| [VK_KHR_external_memory_capabilities](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_external_memory_capabilities.html) | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core |
| [VK_KHR_external_semaphore_capabilities](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_external_semaphore_capabilities.html) | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core |
| [VK_KHR_get_physical_device_properties2](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_get_physical_device_properties2.html) | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core |
| **Device extensions** |
| [VK_KHR_16bit_storage](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_16bit_storage.html) | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core |
| [VK_KHR_8bit_storage](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_8bit_storage.html) | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core |
| [VK_KHR_acceleration_structure](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_acceleration_structure.html) | :x: | :x: | :x: | :x: | :x: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: |
| [VK_KHR_bind_memory2](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_bind_memory2.html) | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core |
| [VK_KHR_buffer_device_address](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_buffer_device_address.html) | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core |
| [VK_KHR_copy_commands2](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_copy_commands2.html) | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core |
| [VK_KHR_create_renderpass2](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_create_renderpass2.html) | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core |
| [VK_KHR_dedicated_allocation](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_dedicated_allocation.html) | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core |
| [VK_KHR_deferred_host_operations](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_deferred_host_operations.html) | :x: | :x: | :x: | :x: | :x: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: |
| [VK_KHR_depth_stencil_resolve](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_depth_stencil_resolve.html) | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core |
| [VK_KHR_descriptor_update_template](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_descriptor_update_template.html) | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core |
| [VK_KHR_device_group](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_device_group.html) | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core |
| [VK_KHR_draw_indirect_count](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_draw_indirect_count.html) | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core |
| [VK_KHR_driver_properties](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_driver_properties.html) | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core |
| [VK_KHR_dynamic_rendering](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_dynamic_rendering.html) | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core |
| [VK_KHR_external_fence](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_external_fence.html) | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core |
| [VK_KHR_external_memory](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_external_memory.html) | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core |
| [VK_KHR_external_semaphore](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_external_semaphore.html) | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core |
| [VK_KHR_format_feature_flags2](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_format_feature_flags2.html) | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core |
| [VK_KHR_fragment_shader_barycentric](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_fragment_shader_barycentric.html) | :x: | :x: | :x: | :x: | :x: | :x: | :x: | :heavy_check_mark: | :heavy_check_mark: |
| [VK_KHR_fragment_shading_rate](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_fragment_shading_rate.html) | :x: | :x: | :x: | :x: | :x: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: |
| [VK_KHR_get_memory_requirements2](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_get_memory_requirements2.html) | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core |
| [VK_KHR_image_format_list](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_image_format_list.html) | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core |
| [VK_KHR_imageless_framebuffer](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_imageless_framebuffer.html) | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core |
| [VK_KHR_maintenance1](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_maintenance1.html) | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core |
| [VK_KHR_maintenance2](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_maintenance2.html) | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core |
| [VK_KHR_maintenance3](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_maintenance3.html) | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core |
| [VK_KHR_maintenance4](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_maintenance4.html) | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core |
| [VK_KHR_maintenance5](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_maintenance5.html) | :x: | :x: | :x: | :x: | :x: | :x: | :x: | :heavy_check_mark: | :heavy_check_mark: |
| [VK_KHR_maintenance6](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_maintenance6.html) | :x: | :x: | :x: | :x: | :x: | :x: | :x: | :heavy_check_mark: | :heavy_check_mark: |
| [VK_KHR_multiview](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_multiview.html) | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core |
| [VK_KHR_pipeline_library](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_pipeline_library.html) | :x: | :x: | :x: | :heavy_check_mark: | :x: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: |
| [VK_KHR_present_id](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_present_id.html) | :x: | :x: | :x: | :heavy_check_mark: | :x: | :x: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: |
| [VK_KHR_present_wait](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_present_wait.html) | :x: | :x: | :x: | :heavy_check_mark: | :x: | :x: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: |
| [VK_KHR_push_descriptor](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_push_descriptor.html) | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: |
| [VK_KHR_ray_query](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_ray_query.html) | :x: | :x: | :x: | :x: | :x: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: |
| [VK_KHR_ray_tracing_maintenance1](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_ray_tracing_maintenance1.html) | :x: | :x: | :x: | :x: | :x: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: |
| [VK_KHR_ray_tracing_pipeline](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_ray_tracing_pipeline.html) | :x: | :x: | :x: | :x: | :x: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: |
| [VK_KHR_relaxed_block_layout](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_relaxed_block_layout.html) | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core |
| [VK_KHR_sampler_mirror_clamp_to_edge](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_sampler_mirror_clamp_to_edge.html) | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core |
| [VK_KHR_sampler_ycbcr_conversion](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_sampler_ycbcr_conversion.html) | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core |
| [VK_KHR_separate_depth_stencil_layouts](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_separate_depth_stencil_layouts.html) | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core |
| [VK_KHR_shader_atomic_int64](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_shader_atomic_int64.html) | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core |
| [VK_KHR_shader_draw_parameters](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_shader_draw_parameters.html) | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core |
| [VK_KHR_shader_float16_int8](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_shader_float16_int8.html) | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core |
| [VK_KHR_shader_float_controls](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_shader_float_controls.html) | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core |
| [VK_KHR_shader_integer_dot_product](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_shader_integer_dot_product.html) | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core |
| [VK_KHR_shader_maximal_reconvergence](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_shader_maximal_reconvergence.html) | :x: | :x: | :x: | :x: | :x: | :x: | :x: | :heavy_check_mark: | :heavy_check_mark: |
| [VK_KHR_shader_non_semantic_info](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_shader_non_semantic_info.html) | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core |
| [VK_KHR_shader_quad_control](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_shader_quad_control.html) | :x: | :x: | :x: | :x: | :x: | :x: | :x: | :heavy_check_mark: | :heavy_check_mark: |
| [VK_KHR_shader_subgroup_extended_types](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_shader_subgroup_extended_types.html) | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core |
| [VK_KHR_shader_terminate_invocation](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_shader_terminate_invocation.html) | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core |
| [VK_KHR_spirv_1_4](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_spirv_1_4.html) | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core |
| [VK_KHR_storage_buffer_storage_class](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_storage_buffer_storage_class.html) | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core |
| [VK_KHR_swapchain](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_swapchain.html) | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: |
| [VK_KHR_synchronization2](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_synchronization2.html) | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core |
| [VK_KHR_timeline_semaphore](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_timeline_semaphore.html) | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core |
| [VK_KHR_uniform_buffer_standard_layout](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_uniform_buffer_standard_layout.html) | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core |
| [VK_KHR_variable_pointers](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_variable_pointers.html) | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core | 1.1 Core |
| [VK_KHR_vulkan_memory_model](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_vulkan_memory_model.html) | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core |
| [VK_KHR_zero_initialize_workgroup_memory](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_KHR_zero_initialize_workgroup_memory.html) | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core |
| [VK_EXT_4444_formats](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_EXT_4444_formats.html) | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core |
| [VK_EXT_calibrated_timestamps](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_EXT_calibrated_timestamps.html) | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: |
| [VK_EXT_conditional_rendering](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_EXT_conditional_rendering.html) | :x: | :x: | :x: | :x: | :x: | :x: | :x: | :heavy_check_mark: | :heavy_check_mark: |
| [VK_EXT_conservative_rasterization](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_EXT_conservative_rasterization.html) | :x: | :x: | :x: | :x: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: |
| [VK_EXT_custom_border_color](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_EXT_custom_border_color.html) | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: |
| [VK_EXT_depth_clip_enable](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_EXT_depth_clip_enable.html) | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: |
| [VK_EXT_descriptor_buffer](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_EXT_descriptor_buffer.html) | :x: | :x: | :x: | :heavy_check_mark: | :x: | :x: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: |
| [VK_EXT_descriptor_indexing](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_EXT_descriptor_indexing.html) | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core |
| [VK_EXT_dynamic_rendering_unused_attachments](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_EXT_dynamic_rendering_unused_attachments.html) | :x: | :x: | :x: | :x: | :x: | :x: | :x: | :x: | :heavy_check_mark: |
| [VK_EXT_extended_dynamic_state](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_EXT_extended_dynamic_state.html) | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core |
| [VK_EXT_extended_dynamic_state2](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_EXT_extended_dynamic_state2.html) | 1.3 Core | 1.3 Core | 1.3 Core | :heavy_check_mark: | 1.3 Core | 1.3 Core | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: |
| [VK_EXT_external_memory_host](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_EXT_external_memory_host.html) | :x: | :x: | :x: | :x: | :x: | :x: | :x: | :heavy_check_mark: | :heavy_check_mark: |
| [VK_EXT_fragment_shader_interlock](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_EXT_fragment_shader_interlock.html) | :x: | :x: | :x: | :x: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :x: |
| [VK_EXT_graphics_pipeline_library](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_EXT_graphics_pipeline_library.html) | :x: | :x: | :x: | :heavy_check_mark: | :x: | :x: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: |
| [VK_EXT_host_query_reset](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_EXT_host_query_reset.html) | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core |
| [VK_EXT_image_compression_control](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_EXT_image_compression_control.html) | :x: | :x: | :x: | :x: | :x: | :x: | :x: | :x: | :heavy_check_mark: |
| [VK_EXT_image_robustness](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_EXT_image_robustness.html) | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core |
| [VK_EXT_image_sliced_view_of_3d](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_EXT_image_sliced_view_of_3d.html) | :x: | :x: | :x: | :x: | :x: | :x: | :x: | :heavy_check_mark: | :heavy_check_mark: |
| [VK_EXT_image_view_min_lod](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_EXT_image_view_min_lod.html) | :x: | :x: | :x: | :x: | :x: | :x: | :x: | :heavy_check_mark: | :heavy_check_mark: |
| [VK_EXT_inline_uniform_block](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_EXT_inline_uniform_block.html) | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core |
| [VK_EXT_memory_priority](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_EXT_memory_priority.html) | :x: | :x: | :x: | :x: | :x: | :x: | :x: | :heavy_check_mark: | :heavy_check_mark: |
| [VK_EXT_mesh_shader](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_EXT_mesh_shader.html) | :x: | :x: | :x: | :x: | :x: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: |
| [VK_EXT_mutable_descriptor_type](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_EXT_mutable_descriptor_type.html) | :x: | :x: | :x: | :heavy_check_mark: | :x: | :x: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: |
| [VK_EXT_pageable_device_local_memory](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_EXT_pageable_device_local_memory.html) | :x: | :x: | :x: | :x: | :x: | :x: | :x: | :heavy_check_mark: | :x: |
| [VK_EXT_pipeline_creation_cache_control](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_EXT_pipeline_creation_cache_control.html) | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core |
| [VK_EXT_pipeline_creation_feedback](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_EXT_pipeline_creation_feedback.html) | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core |
| [VK_EXT_pipeline_library_group_handles](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_EXT_pipeline_library_group_handles.html) | :x: | :x: | :x: | :x: | :x: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: |
| [VK_EXT_private_data](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_EXT_private_data.html) | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core |
| [VK_EXT_robustness2](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_EXT_robustness2.html) | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: |
| [VK_EXT_sampler_filter_minmax](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_EXT_sampler_filter_minmax.html) | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core |
| [VK_EXT_scalar_block_layout](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_EXT_scalar_block_layout.html) | 1.2 Core | 1.2 Core | 1.2 Core | :heavy_check_mark: | 1.2 Core | 1.2 Core | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: |
| [VK_EXT_separate_stencil_usage](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_EXT_separate_stencil_usage.html) | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core |
| [VK_EXT_shader_demote_to_helper_invocation](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_EXT_shader_demote_to_helper_invocation.html) | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core |
| [VK_EXT_shader_image_atomic_int64](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_EXT_shader_image_atomic_int64.html) | :x: | :x: | :x: | :heavy_check_mark: | :x: | :x: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: |
| [VK_EXT_shader_module_identifier](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_EXT_shader_module_identifier.html) | :x: | :x: | :x: | :heavy_check_mark: | :x: | :x: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: |
| [VK_EXT_shader_stencil_export](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_EXT_shader_stencil_export.html) | :x: | :x: | :x: | :x: | :x: | :x: | :x: | :x: | :heavy_check_mark: |
| [VK_EXT_shader_viewport_index_layer](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_EXT_shader_viewport_index_layer.html) | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core |
| [VK_EXT_subgroup_size_control](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_EXT_subgroup_size_control.html) | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core |
| [VK_EXT_swapchain_maintenance1](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_EXT_swapchain_maintenance1.html) | :x: | :x: | :x: | :heavy_check_mark: | :x: | :x: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: |
| [VK_EXT_texel_buffer_alignment](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_EXT_texel_buffer_alignment.html) | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core |
| [VK_EXT_texture_compression_astc_hdr](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_EXT_texture_compression_astc_hdr.html) | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core |
| [VK_EXT_tooling_info](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_EXT_tooling_info.html) | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core |
| [VK_EXT_transform_feedback](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_EXT_transform_feedback.html) | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: |
| [VK_EXT_vertex_attribute_divisor](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_EXT_vertex_attribute_divisor.html) | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: |
| [VK_EXT_ycbcr_2plane_444_formats](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_EXT_ycbcr_2plane_444_formats.html) | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core | 1.3 Core |
| [VK_AMD_buffer_marker](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_AMD_buffer_marker.html) | :x: | :x: | :x: | :heavy_check_mark: | :x: | :x: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: |
| [VK_AMD_device_coherent_memory](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_AMD_device_coherent_memory.html) | :x: | :x: | :x: | :x: | :x: | :x: | :x: | :x: | :heavy_check_mark: |
| [VK_AMD_draw_indirect_count](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_AMD_draw_indirect_count.html) | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core | 1.2 Core |
| [VK_AMD_shader_core_properties](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_AMD_shader_core_properties.html) | :x: | :x: | :x: | :x: | :x: | :x: | :x: | :x: | :heavy_check_mark: |
| [VK_AMD_shader_core_properties2](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_AMD_shader_core_properties2.html) | :x: | :x: | :x: | :x: | :x: | :x: | :x: | :x: | :heavy_check_mark: |
| [VK_MESA_image_alignment_control](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_MESA_image_alignment_control.html) | :x: | :x: | :x: | :x: | :x: | :x: | :x: | :x: | :heavy_check_mark: |
| [VK_NVX_binary_import](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_NVX_binary_import.html) | :x: | :x: | :x: | :x: | :x: | :x: | :x: | :heavy_check_mark: | :x: |
| [VK_NVX_image_view_handle](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_NVX_image_view_handle.html) | :x: | :x: | :x: | :x: | :x: | :x: | :x: | :heavy_check_mark: | :x: |
| [VK_NV_compute_shader_derivatives](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_NV_compute_shader_derivatives.html) | :x: | :x: | :x: | :heavy_check_mark: | :x: | :x: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: |
| [VK_NV_device_diagnostic_checkpoints](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_NV_device_diagnostic_checkpoints.html) | :x: | :x: | :x: | :x: | :x: | :x: | :x: | :heavy_check_mark: | :x: |
| [VK_NV_device_generated_commands](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_NV_device_generated_commands.html) | :x: | :x: | :x: | :x: | :x: | :x: | :x: | :heavy_check_mark: | :heavy_check_mark: |
| [VK_NV_device_generated_commands_compute](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_NV_device_generated_commands_compute.html) | :x: | :x: | :x: | :x: | :x: | :x: | :x: | :heavy_check_mark: | :heavy_check_mark: |
| [VK_NV_raw_access_chains](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_NV_raw_access_chains.html) | :x: | :x: | :x: | :x: | :x: | :x: | :x: | :heavy_check_mark: | :x: |
| [VK_NV_shader_sm_builtins](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VK_NV_shader_sm_builtins.html) | :x: | :x: | :x: | :x: | :x: | :x: | :x: | :heavy_check_mark: | :x: |

## Vulkan Profile Features

> **NOTE**: The table below only contains features explicitly defined by the corresponding profile. Further features may be supported by the profiles in accordance to the requirements defined in the "Feature Requirements" section of the appropriate version of the Vulkan API Specification.

* :heavy_check_mark: indicates that the feature is defined in the profile (hover over the symbol to view the structure and corresponding extension or core API version where the feature is defined in the profile)
* :warning: indicates that the feature is not defined in the profile but an equivalent feature is (hover over the symbol to view the structure and corresponding extension or core API version where the feature is defined in the profile)
* :x: indicates that neither the feature nor an equivalent feature is defined in the profile

| Profiles | VP_D3D12_FL_11_0_baseline | VP_D3D12_FL_11_1_baseline | VP_D3D12_FL_12_0_baseline | VP_D3D12_FL_12_0_optimal | VP_D3D12_FL_12_1_baseline | VP_D3D12_FL_12_2_baseline | VP_D3D12_FL_12_2_optimal | VP_D3D12_maximum_nv | VP_D3D12_maximum_radv |
|----------|---------------------------|---------------------------|---------------------------|--------------------------|---------------------------|---------------------------|--------------------------|---------------------|-----------------------|
| **Vulkan 1.0** |
| [depthBiasClamp](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFeatures.html) | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> |
| [depthBounds](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFeatures.html) | :x: | :x: | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> |
| [depthClamp](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFeatures.html) | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> |
| [drawIndirectFirstInstance](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFeatures.html) | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> |
| [dualSrcBlend](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFeatures.html) | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> |
| [fillModeNonSolid](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFeatures.html) | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> |
| [fragmentStoresAndAtomics](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFeatures.html) | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> |
| [fullDrawIndexUint32](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFeatures.html) | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> |
| [geometryShader](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFeatures.html) | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> |
| [imageCubeArray](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFeatures.html) | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> |
| [independentBlend](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFeatures.html) | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> |
| [logicOp](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFeatures.html) | :x: | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> |
| [multiDrawIndirect](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFeatures.html) | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> |
| [multiViewport](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFeatures.html) | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> |
| [occlusionQueryPrecise](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFeatures.html) | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> |
| [pipelineStatisticsQuery](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFeatures.html) | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> |
| [robustBufferAccess](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFeatures.html) | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> |
| [sampleRateShading](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFeatures.html) | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> |
| [samplerAnisotropy](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFeatures.html) | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> |
| [shaderClipDistance](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFeatures.html) | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> |
| [shaderCullDistance](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFeatures.html) | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> |
| [shaderFloat64](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFeatures.html) | :x: | :x: | :x: | :x: | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> |
| [shaderImageGatherExtended](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFeatures.html) | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> |
| [shaderInt16](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFeatures.html) | :x: | :x: | :x: | :x: | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> |
| [shaderInt64](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFeatures.html) | :x: | :x: | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> |
| [shaderResourceMinLod](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFeatures.html) | :x: | :x: | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> |
| [shaderResourceResidency](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFeatures.html) | :x: | :x: | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> |
| [shaderSampledImageArrayDynamicIndexing](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFeatures.html) | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> |
| [shaderStorageBufferArrayDynamicIndexing](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFeatures.html) | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> |
| [shaderStorageImageArrayDynamicIndexing](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFeatures.html) | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> |
| [shaderStorageImageExtendedFormats](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFeatures.html) | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> |
| [shaderStorageImageWriteWithoutFormat](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFeatures.html) | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> |
| [shaderUniformBufferArrayDynamicIndexing](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFeatures.html) | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> |
| [sparseBinding](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFeatures.html) | :x: | :x: | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> |
| [sparseResidencyAliased](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFeatures.html) | :x: | :x: | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> |
| [sparseResidencyBuffer](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFeatures.html) | :x: | :x: | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> |
| [sparseResidencyImage2D](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFeatures.html) | :x: | :x: | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> |
| [sparseResidencyImage3D](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFeatures.html) | :x: | :x: | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> |
| [tessellationShader](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFeatures.html) | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> |
| [textureCompressionBC](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFeatures.html) | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> |
| [vertexPipelineStoresAndAtomics](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFeatures.html) | :x: | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFeatures (Vulkan 1.0)">:heavy_check_mark:</span> |
| **Vulkan 1.1** |
| [shaderDrawParameters](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceShaderDrawParametersFeatures.html) | <span title="defined in VkPhysicalDeviceVulkan11Features (Vulkan 1.1)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan11Features (Vulkan 1.1)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan11Features (Vulkan 1.1)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan11Features (Vulkan 1.1)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan11Features (Vulkan 1.1)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan11Features (Vulkan 1.1)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan11Features (Vulkan 1.1)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan11Features (Vulkan 1.1)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan11Features (Vulkan 1.1)">:heavy_check_mark:</span> |
| **Vulkan 1.2** |
| [bufferDeviceAddress](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceBufferDeviceAddressFeatures.html) | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> |
| [descriptorBindingPartiallyBound](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceDescriptorIndexingFeatures.html) | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> |
| [descriptorBindingSampledImageUpdateAfterBind](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceDescriptorIndexingFeatures.html) | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> |
| [descriptorBindingStorageBufferUpdateAfterBind](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceDescriptorIndexingFeatures.html) | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> |
| [descriptorBindingStorageImageUpdateAfterBind](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceDescriptorIndexingFeatures.html) | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> |
| [descriptorBindingStorageTexelBufferUpdateAfterBind](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceDescriptorIndexingFeatures.html) | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> |
| [descriptorBindingUniformTexelBufferUpdateAfterBind](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceDescriptorIndexingFeatures.html) | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> |
| [descriptorBindingUpdateUnusedWhilePending](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceDescriptorIndexingFeatures.html) | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> |
| [descriptorBindingVariableDescriptorCount](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceDescriptorIndexingFeatures.html) | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> |
| [descriptorIndexing](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceVulkan12Features.html) | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> |
| [drawIndirectCount](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceVulkan12Features.html) | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> |
| [hostQueryReset](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceHostQueryResetFeatures.html) | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> |
| [runtimeDescriptorArray](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceDescriptorIndexingFeatures.html) | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> |
| [samplerFilterMinmax](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceVulkan12Features.html) | :x: | :x: | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> |
| [samplerMirrorClampToEdge](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceVulkan12Features.html) | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> |
| [scalarBlockLayout](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceScalarBlockLayoutFeatures.html) | :x: | :x: | :x: | <span title="equivalent defined in VkPhysicalDeviceScalarBlockLayoutFeaturesEXT (VK_EXT_scalar_block_layout)">:warning:</span> | :x: | :x: | <span title="equivalent defined in VkPhysicalDeviceScalarBlockLayoutFeaturesEXT (VK_EXT_scalar_block_layout)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceScalarBlockLayoutFeaturesEXT (VK_EXT_scalar_block_layout)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceScalarBlockLayoutFeaturesEXT (VK_EXT_scalar_block_layout)">:warning:</span> |
| [separateDepthStencilLayouts](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures.html) | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> |
| [shaderBufferInt64Atomics](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceShaderAtomicInt64Features.html) | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | :x: | :x: | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> |
| [shaderFloat16](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceShaderFloat16Int8Features.html) | :x: | :x: | :x: | :x: | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> |
| [shaderInt8](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceShaderFloat16Int8Features.html) | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | :x: | :x: | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> |
| [shaderOutputLayer](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceVulkan12Features.html) | :x: | :x: | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> |
| [shaderOutputViewportIndex](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceVulkan12Features.html) | :x: | :x: | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> |
| [shaderSampledImageArrayNonUniformIndexing](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceDescriptorIndexingFeatures.html) | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> |
| [shaderSharedInt64Atomics](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceShaderAtomicInt64Features.html) | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | :x: | :x: | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> |
| [shaderStorageBufferArrayNonUniformIndexing](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceDescriptorIndexingFeatures.html) | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> |
| [shaderStorageImageArrayNonUniformIndexing](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceDescriptorIndexingFeatures.html) | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> |
| [shaderStorageTexelBufferArrayDynamicIndexing](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceDescriptorIndexingFeatures.html) | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> |
| [shaderStorageTexelBufferArrayNonUniformIndexing](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceDescriptorIndexingFeatures.html) | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> |
| [shaderSubgroupExtendedTypes](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures.html) | :x: | :x: | :x: | :x: | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> |
| [shaderUniformTexelBufferArrayDynamicIndexing](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceDescriptorIndexingFeatures.html) | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> |
| [shaderUniformTexelBufferArrayNonUniformIndexing](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceDescriptorIndexingFeatures.html) | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> |
| [timelineSemaphore](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceTimelineSemaphoreFeatures.html) | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> |
| [uniformBufferStandardLayout](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceUniformBufferStandardLayoutFeatures.html) | :x: | :x: | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> |
| [vulkanMemoryModel](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceVulkanMemoryModelFeatures.html) | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> |
| [vulkanMemoryModelDeviceScope](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceVulkanMemoryModelFeatures.html) | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:heavy_check_mark:</span> |
| **Vulkan 1.3** |
| [computeFullSubgroups](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceSubgroupSizeControlFeatures.html) | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:heavy_check_mark:</span> | :x: | :x: | <span title="defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:heavy_check_mark:</span> |
| [dynamicRendering](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceDynamicRenderingFeatures.html) | <span title="defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:heavy_check_mark:</span> |
| [maintenance4](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceMaintenance4Features.html) | <span title="defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:heavy_check_mark:</span> |
| [pipelineCreationCacheControl](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDevicePipelineCreationCacheControlFeatures.html) | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:heavy_check_mark:</span> | :x: | :x: | <span title="defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:heavy_check_mark:</span> |
| [shaderDemoteToHelperInvocation](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures.html) | <span title="defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:heavy_check_mark:</span> |
| [shaderIntegerDotProduct](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceShaderIntegerDotProductFeatures.html) | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:heavy_check_mark:</span> | :x: | :x: | <span title="defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:heavy_check_mark:</span> |
| [subgroupSizeControl](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceSubgroupSizeControlFeatures.html) | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:heavy_check_mark:</span> | :x: | :x: | <span title="defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:heavy_check_mark:</span> |
| [synchronization2](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceSynchronization2Features.html) | <span title="defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:heavy_check_mark:</span> |
| **VK_KHR_acceleration_structure** |
| [accelerationStructure](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceAccelerationStructureFeaturesKHR.html) | :x: | :x: | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceAccelerationStructureFeaturesKHR (VK_KHR_acceleration_structure)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceAccelerationStructureFeaturesKHR (VK_KHR_acceleration_structure)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceAccelerationStructureFeaturesKHR (VK_KHR_acceleration_structure)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceAccelerationStructureFeaturesKHR (VK_KHR_acceleration_structure)">:heavy_check_mark:</span> |
| **VK_KHR_buffer_device_address** |
| [bufferDeviceAddress](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceBufferDeviceAddressFeatures.html) | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> |
| **VK_KHR_dynamic_rendering** |
| [dynamicRendering](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceDynamicRenderingFeatures.html) | <span title="equivalent defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:warning:</span> |
| **VK_KHR_fragment_shader_barycentric** |
| [fragmentShaderBarycentric](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR.html) | :x: | :x: | :x: | :x: | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR (VK_KHR_fragment_shader_barycentric)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR (VK_KHR_fragment_shader_barycentric)">:heavy_check_mark:</span> |
| **VK_KHR_fragment_shading_rate** |
| [attachmentFragmentShadingRate](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFragmentShadingRateFeaturesKHR.html) | :x: | :x: | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceFragmentShadingRateFeaturesKHR (VK_KHR_fragment_shading_rate)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFragmentShadingRateFeaturesKHR (VK_KHR_fragment_shading_rate)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFragmentShadingRateFeaturesKHR (VK_KHR_fragment_shading_rate)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFragmentShadingRateFeaturesKHR (VK_KHR_fragment_shading_rate)">:heavy_check_mark:</span> |
| [pipelineFragmentShadingRate](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFragmentShadingRateFeaturesKHR.html) | :x: | :x: | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceFragmentShadingRateFeaturesKHR (VK_KHR_fragment_shading_rate)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFragmentShadingRateFeaturesKHR (VK_KHR_fragment_shading_rate)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFragmentShadingRateFeaturesKHR (VK_KHR_fragment_shading_rate)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFragmentShadingRateFeaturesKHR (VK_KHR_fragment_shading_rate)">:heavy_check_mark:</span> |
| [primitiveFragmentShadingRate](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFragmentShadingRateFeaturesKHR.html) | :x: | :x: | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceFragmentShadingRateFeaturesKHR (VK_KHR_fragment_shading_rate)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFragmentShadingRateFeaturesKHR (VK_KHR_fragment_shading_rate)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFragmentShadingRateFeaturesKHR (VK_KHR_fragment_shading_rate)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFragmentShadingRateFeaturesKHR (VK_KHR_fragment_shading_rate)">:heavy_check_mark:</span> |
| **VK_KHR_maintenance4** |
| [maintenance4](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceMaintenance4Features.html) | <span title="equivalent defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:warning:</span> |
| **VK_KHR_maintenance5** |
| [maintenance5](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceMaintenance5FeaturesKHR.html) | :x: | :x: | :x: | :x: | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceMaintenance5FeaturesKHR (VK_KHR_maintenance5)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceMaintenance5FeaturesKHR (VK_KHR_maintenance5)">:heavy_check_mark:</span> |
| **VK_KHR_maintenance6** |
| [maintenance6](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceMaintenance6FeaturesKHR.html) | :x: | :x: | :x: | :x: | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceMaintenance6FeaturesKHR (VK_KHR_maintenance6)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceMaintenance6FeaturesKHR (VK_KHR_maintenance6)">:heavy_check_mark:</span> |
| **VK_KHR_present_id** |
| [presentId](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDevicePresentIdFeaturesKHR.html) | :x: | :x: | :x: | <span title="defined in VkPhysicalDevicePresentIdFeaturesKHR (VK_KHR_present_id)">:heavy_check_mark:</span> | :x: | :x: | <span title="defined in VkPhysicalDevicePresentIdFeaturesKHR (VK_KHR_present_id)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDevicePresentIdFeaturesKHR (VK_KHR_present_id)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDevicePresentIdFeaturesKHR (VK_KHR_present_id)">:heavy_check_mark:</span> |
| **VK_KHR_present_wait** |
| [presentWait](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDevicePresentWaitFeaturesKHR.html) | :x: | :x: | :x: | <span title="defined in VkPhysicalDevicePresentWaitFeaturesKHR (VK_KHR_present_wait)">:heavy_check_mark:</span> | :x: | :x: | <span title="defined in VkPhysicalDevicePresentWaitFeaturesKHR (VK_KHR_present_wait)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDevicePresentWaitFeaturesKHR (VK_KHR_present_wait)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDevicePresentWaitFeaturesKHR (VK_KHR_present_wait)">:heavy_check_mark:</span> |
| **VK_KHR_ray_query** |
| [rayQuery](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceRayQueryFeaturesKHR.html) | :x: | :x: | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceRayQueryFeaturesKHR (VK_KHR_ray_query)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceRayQueryFeaturesKHR (VK_KHR_ray_query)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceRayQueryFeaturesKHR (VK_KHR_ray_query)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceRayQueryFeaturesKHR (VK_KHR_ray_query)">:heavy_check_mark:</span> |
| **VK_KHR_ray_tracing_maintenance1** |
| [rayTracingMaintenance1](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR.html) | :x: | :x: | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR (VK_KHR_ray_tracing_maintenance1)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR (VK_KHR_ray_tracing_maintenance1)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR (VK_KHR_ray_tracing_maintenance1)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR (VK_KHR_ray_tracing_maintenance1)">:heavy_check_mark:</span> |
| [rayTracingPipelineTraceRaysIndirect2](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR.html) | :x: | :x: | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR (VK_KHR_ray_tracing_maintenance1)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR (VK_KHR_ray_tracing_maintenance1)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR (VK_KHR_ray_tracing_maintenance1)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR (VK_KHR_ray_tracing_maintenance1)">:heavy_check_mark:</span> |
| **VK_KHR_ray_tracing_pipeline** |
| [rayTracingPipeline](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceRayTracingPipelineFeaturesKHR.html) | :x: | :x: | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceRayTracingPipelineFeaturesKHR (VK_KHR_ray_tracing_pipeline)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceRayTracingPipelineFeaturesKHR (VK_KHR_ray_tracing_pipeline)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceRayTracingPipelineFeaturesKHR (VK_KHR_ray_tracing_pipeline)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceRayTracingPipelineFeaturesKHR (VK_KHR_ray_tracing_pipeline)">:heavy_check_mark:</span> |
| [rayTracingPipelineTraceRaysIndirect](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceRayTracingPipelineFeaturesKHR.html) | :x: | :x: | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceRayTracingPipelineFeaturesKHR (VK_KHR_ray_tracing_pipeline)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceRayTracingPipelineFeaturesKHR (VK_KHR_ray_tracing_pipeline)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceRayTracingPipelineFeaturesKHR (VK_KHR_ray_tracing_pipeline)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceRayTracingPipelineFeaturesKHR (VK_KHR_ray_tracing_pipeline)">:heavy_check_mark:</span> |
| [rayTraversalPrimitiveCulling](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceRayTracingPipelineFeaturesKHR.html) | :x: | :x: | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceRayTracingPipelineFeaturesKHR (VK_KHR_ray_tracing_pipeline)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceRayTracingPipelineFeaturesKHR (VK_KHR_ray_tracing_pipeline)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceRayTracingPipelineFeaturesKHR (VK_KHR_ray_tracing_pipeline)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceRayTracingPipelineFeaturesKHR (VK_KHR_ray_tracing_pipeline)">:heavy_check_mark:</span> |
| **VK_KHR_separate_depth_stencil_layouts** |
| [separateDepthStencilLayouts](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures.html) | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> |
| **VK_KHR_shader_atomic_int64** |
| [shaderBufferInt64Atomics](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceShaderAtomicInt64Features.html) | :x: | :x: | :x: | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | :x: | :x: | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> |
| [shaderSharedInt64Atomics](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceShaderAtomicInt64Features.html) | :x: | :x: | :x: | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | :x: | :x: | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> |
| **VK_KHR_shader_float16_int8** |
| [shaderFloat16](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceShaderFloat16Int8Features.html) | :x: | :x: | :x: | :x: | :x: | :x: | :x: | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> |
| [shaderInt8](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceShaderFloat16Int8Features.html) | :x: | :x: | :x: | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | :x: | :x: | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> |
| **VK_KHR_shader_integer_dot_product** |
| [shaderIntegerDotProduct](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceShaderIntegerDotProductFeatures.html) | :x: | :x: | :x: | <span title="equivalent defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:warning:</span> | :x: | :x: | <span title="equivalent defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:warning:</span> |
| **VK_KHR_shader_maximal_reconvergence** |
| [shaderMaximalReconvergence](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR.html) | :x: | :x: | :x: | :x: | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR (VK_KHR_shader_maximal_reconvergence)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR (VK_KHR_shader_maximal_reconvergence)">:heavy_check_mark:</span> |
| **VK_KHR_shader_quad_control** |
| [shaderQuadControl](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceShaderQuadControlFeaturesKHR.html) | :x: | :x: | :x: | :x: | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceShaderQuadControlFeaturesKHR (VK_KHR_shader_quad_control)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceShaderQuadControlFeaturesKHR (VK_KHR_shader_quad_control)">:heavy_check_mark:</span> |
| **VK_KHR_shader_subgroup_extended_types** |
| [shaderSubgroupExtendedTypes](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures.html) | :x: | :x: | :x: | :x: | :x: | :x: | :x: | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> |
| **VK_KHR_synchronization2** |
| [synchronization2](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceSynchronization2Features.html) | <span title="equivalent defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:warning:</span> |
| **VK_KHR_timeline_semaphore** |
| [timelineSemaphore](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceTimelineSemaphoreFeatures.html) | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> |
| **VK_KHR_uniform_buffer_standard_layout** |
| [uniformBufferStandardLayout](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceUniformBufferStandardLayoutFeatures.html) | :x: | :x: | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> |
| **VK_KHR_vertex_attribute_divisor** |
| [vertexAttributeInstanceRateDivisor](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceVertexAttributeDivisorFeaturesKHR.html) | <span title="equivalent defined in VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT (VK_EXT_vertex_attribute_divisor)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT (VK_EXT_vertex_attribute_divisor)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT (VK_EXT_vertex_attribute_divisor)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT (VK_EXT_vertex_attribute_divisor)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT (VK_EXT_vertex_attribute_divisor)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT (VK_EXT_vertex_attribute_divisor)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT (VK_EXT_vertex_attribute_divisor)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT (VK_EXT_vertex_attribute_divisor)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT (VK_EXT_vertex_attribute_divisor)">:warning:</span> |
| [vertexAttributeInstanceRateZeroDivisor](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceVertexAttributeDivisorFeaturesKHR.html) | <span title="equivalent defined in VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT (VK_EXT_vertex_attribute_divisor)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT (VK_EXT_vertex_attribute_divisor)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT (VK_EXT_vertex_attribute_divisor)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT (VK_EXT_vertex_attribute_divisor)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT (VK_EXT_vertex_attribute_divisor)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT (VK_EXT_vertex_attribute_divisor)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT (VK_EXT_vertex_attribute_divisor)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT (VK_EXT_vertex_attribute_divisor)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT (VK_EXT_vertex_attribute_divisor)">:warning:</span> |
| **VK_KHR_vulkan_memory_model** |
| [vulkanMemoryModel](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceVulkanMemoryModelFeatures.html) | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> |
| [vulkanMemoryModelDeviceScope](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceVulkanMemoryModelFeatures.html) | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> |
| **VK_EXT_conditional_rendering** |
| [conditionalRendering](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceConditionalRenderingFeaturesEXT.html) | :x: | :x: | :x: | :x: | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceConditionalRenderingFeaturesEXT (VK_EXT_conditional_rendering)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceConditionalRenderingFeaturesEXT (VK_EXT_conditional_rendering)">:heavy_check_mark:</span> |
| **VK_EXT_custom_border_color** |
| [customBorderColorWithoutFormat](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceCustomBorderColorFeaturesEXT.html) | <span title="defined in VkPhysicalDeviceCustomBorderColorFeaturesEXT (VK_EXT_custom_border_color)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceCustomBorderColorFeaturesEXT (VK_EXT_custom_border_color)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceCustomBorderColorFeaturesEXT (VK_EXT_custom_border_color)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceCustomBorderColorFeaturesEXT (VK_EXT_custom_border_color)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceCustomBorderColorFeaturesEXT (VK_EXT_custom_border_color)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceCustomBorderColorFeaturesEXT (VK_EXT_custom_border_color)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceCustomBorderColorFeaturesEXT (VK_EXT_custom_border_color)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceCustomBorderColorFeaturesEXT (VK_EXT_custom_border_color)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceCustomBorderColorFeaturesEXT (VK_EXT_custom_border_color)">:heavy_check_mark:</span> |
| [customBorderColors](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceCustomBorderColorFeaturesEXT.html) | <span title="defined in VkPhysicalDeviceCustomBorderColorFeaturesEXT (VK_EXT_custom_border_color)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceCustomBorderColorFeaturesEXT (VK_EXT_custom_border_color)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceCustomBorderColorFeaturesEXT (VK_EXT_custom_border_color)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceCustomBorderColorFeaturesEXT (VK_EXT_custom_border_color)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceCustomBorderColorFeaturesEXT (VK_EXT_custom_border_color)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceCustomBorderColorFeaturesEXT (VK_EXT_custom_border_color)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceCustomBorderColorFeaturesEXT (VK_EXT_custom_border_color)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceCustomBorderColorFeaturesEXT (VK_EXT_custom_border_color)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceCustomBorderColorFeaturesEXT (VK_EXT_custom_border_color)">:heavy_check_mark:</span> |
| **VK_EXT_depth_clip_enable** |
| [depthClipEnable](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceDepthClipEnableFeaturesEXT.html) | <span title="defined in VkPhysicalDeviceDepthClipEnableFeaturesEXT (VK_EXT_depth_clip_enable)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceDepthClipEnableFeaturesEXT (VK_EXT_depth_clip_enable)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceDepthClipEnableFeaturesEXT (VK_EXT_depth_clip_enable)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceDepthClipEnableFeaturesEXT (VK_EXT_depth_clip_enable)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceDepthClipEnableFeaturesEXT (VK_EXT_depth_clip_enable)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceDepthClipEnableFeaturesEXT (VK_EXT_depth_clip_enable)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceDepthClipEnableFeaturesEXT (VK_EXT_depth_clip_enable)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceDepthClipEnableFeaturesEXT (VK_EXT_depth_clip_enable)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceDepthClipEnableFeaturesEXT (VK_EXT_depth_clip_enable)">:heavy_check_mark:</span> |
| **VK_EXT_descriptor_buffer** |
| [descriptorBuffer](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceDescriptorBufferFeaturesEXT.html) | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceDescriptorBufferFeaturesEXT (VK_EXT_descriptor_buffer)">:heavy_check_mark:</span> | :x: | :x: | <span title="defined in VkPhysicalDeviceDescriptorBufferFeaturesEXT (VK_EXT_descriptor_buffer)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceDescriptorBufferFeaturesEXT (VK_EXT_descriptor_buffer)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceDescriptorBufferFeaturesEXT (VK_EXT_descriptor_buffer)">:heavy_check_mark:</span> |
| [descriptorBufferPushDescriptors](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceDescriptorBufferFeaturesEXT.html) | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceDescriptorBufferFeaturesEXT (VK_EXT_descriptor_buffer)">:heavy_check_mark:</span> | :x: | :x: | <span title="defined in VkPhysicalDeviceDescriptorBufferFeaturesEXT (VK_EXT_descriptor_buffer)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceDescriptorBufferFeaturesEXT (VK_EXT_descriptor_buffer)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceDescriptorBufferFeaturesEXT (VK_EXT_descriptor_buffer)">:heavy_check_mark:</span> |
| **VK_EXT_descriptor_indexing** |
| [descriptorBindingPartiallyBound](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceDescriptorIndexingFeatures.html) | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> |
| [descriptorBindingSampledImageUpdateAfterBind](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceDescriptorIndexingFeatures.html) | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> |
| [descriptorBindingStorageBufferUpdateAfterBind](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceDescriptorIndexingFeatures.html) | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> |
| [descriptorBindingStorageImageUpdateAfterBind](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceDescriptorIndexingFeatures.html) | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> |
| [descriptorBindingStorageTexelBufferUpdateAfterBind](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceDescriptorIndexingFeatures.html) | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> |
| [descriptorBindingUniformTexelBufferUpdateAfterBind](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceDescriptorIndexingFeatures.html) | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> |
| [descriptorBindingUpdateUnusedWhilePending](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceDescriptorIndexingFeatures.html) | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> |
| [descriptorBindingVariableDescriptorCount](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceDescriptorIndexingFeatures.html) | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> |
| [runtimeDescriptorArray](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceDescriptorIndexingFeatures.html) | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> |
| [shaderSampledImageArrayNonUniformIndexing](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceDescriptorIndexingFeatures.html) | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> |
| [shaderStorageBufferArrayNonUniformIndexing](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceDescriptorIndexingFeatures.html) | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> |
| [shaderStorageImageArrayNonUniformIndexing](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceDescriptorIndexingFeatures.html) | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> |
| [shaderStorageTexelBufferArrayDynamicIndexing](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceDescriptorIndexingFeatures.html) | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> |
| [shaderStorageTexelBufferArrayNonUniformIndexing](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceDescriptorIndexingFeatures.html) | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> |
| [shaderUniformTexelBufferArrayDynamicIndexing](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceDescriptorIndexingFeatures.html) | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> |
| [shaderUniformTexelBufferArrayNonUniformIndexing](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceDescriptorIndexingFeatures.html) | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> |
| **VK_EXT_dynamic_rendering_unused_attachments** |
| [dynamicRenderingUnusedAttachments](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT.html) | :x: | :x: | :x: | :x: | :x: | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT (VK_EXT_dynamic_rendering_unused_attachments)">:heavy_check_mark:</span> |
| **VK_EXT_extended_dynamic_state2** |
| [extendedDynamicState2](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceExtendedDynamicState2FeaturesEXT.html) | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceExtendedDynamicState2FeaturesEXT (VK_EXT_extended_dynamic_state2)">:heavy_check_mark:</span> | :x: | :x: | <span title="defined in VkPhysicalDeviceExtendedDynamicState2FeaturesEXT (VK_EXT_extended_dynamic_state2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceExtendedDynamicState2FeaturesEXT (VK_EXT_extended_dynamic_state2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceExtendedDynamicState2FeaturesEXT (VK_EXT_extended_dynamic_state2)">:heavy_check_mark:</span> |
| [extendedDynamicState2PatchControlPoints](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceExtendedDynamicState2FeaturesEXT.html) | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceExtendedDynamicState2FeaturesEXT (VK_EXT_extended_dynamic_state2)">:heavy_check_mark:</span> | :x: | :x: | <span title="defined in VkPhysicalDeviceExtendedDynamicState2FeaturesEXT (VK_EXT_extended_dynamic_state2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceExtendedDynamicState2FeaturesEXT (VK_EXT_extended_dynamic_state2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceExtendedDynamicState2FeaturesEXT (VK_EXT_extended_dynamic_state2)">:heavy_check_mark:</span> |
| **VK_EXT_fragment_shader_interlock** |
| [fragmentShaderPixelInterlock](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT.html) | :x: | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT (VK_EXT_fragment_shader_interlock)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT (VK_EXT_fragment_shader_interlock)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT (VK_EXT_fragment_shader_interlock)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT (VK_EXT_fragment_shader_interlock)">:heavy_check_mark:</span> | :x: |
| [fragmentShaderSampleInterlock](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT.html) | :x: | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT (VK_EXT_fragment_shader_interlock)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT (VK_EXT_fragment_shader_interlock)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT (VK_EXT_fragment_shader_interlock)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT (VK_EXT_fragment_shader_interlock)">:heavy_check_mark:</span> | :x: |
| **VK_EXT_graphics_pipeline_library** |
| [graphicsPipelineLibrary](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT.html) | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT (VK_EXT_graphics_pipeline_library)">:heavy_check_mark:</span> | :x: | :x: | <span title="defined in VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT (VK_EXT_graphics_pipeline_library)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT (VK_EXT_graphics_pipeline_library)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT (VK_EXT_graphics_pipeline_library)">:heavy_check_mark:</span> |
| **VK_EXT_host_query_reset** |
| [hostQueryReset](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceHostQueryResetFeatures.html) | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Features (Vulkan 1.2)">:warning:</span> |
| **VK_EXT_image_compression_control** |
| [imageCompressionControl](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceImageCompressionControlFeaturesEXT.html) | :x: | :x: | :x: | :x: | :x: | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceImageCompressionControlFeaturesEXT (VK_EXT_image_compression_control)">:heavy_check_mark:</span> |
| **VK_EXT_image_sliced_view_of_3d** |
| [imageSlicedViewOf3D](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT.html) | :x: | :x: | :x: | :x: | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT (VK_EXT_image_sliced_view_of_3d)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT (VK_EXT_image_sliced_view_of_3d)">:heavy_check_mark:</span> |
| **VK_EXT_image_view_min_lod** |
| [minLod](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceImageViewMinLodFeaturesEXT.html) | :x: | :x: | :x: | :x: | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceImageViewMinLodFeaturesEXT (VK_EXT_image_view_min_lod)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceImageViewMinLodFeaturesEXT (VK_EXT_image_view_min_lod)">:heavy_check_mark:</span> |
| **VK_EXT_memory_priority** |
| [memoryPriority](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceMemoryPriorityFeaturesEXT.html) | :x: | :x: | :x: | :x: | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceMemoryPriorityFeaturesEXT (VK_EXT_memory_priority)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceMemoryPriorityFeaturesEXT (VK_EXT_memory_priority)">:heavy_check_mark:</span> |
| **VK_EXT_mesh_shader** |
| [meshShader](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceMeshShaderFeaturesEXT.html) | :x: | :x: | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceMeshShaderFeaturesEXT (VK_EXT_mesh_shader)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceMeshShaderFeaturesEXT (VK_EXT_mesh_shader)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceMeshShaderFeaturesEXT (VK_EXT_mesh_shader)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceMeshShaderFeaturesEXT (VK_EXT_mesh_shader)">:heavy_check_mark:</span> |
| [primitiveFragmentShadingRateMeshShader](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceMeshShaderFeaturesEXT.html) | :x: | :x: | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceMeshShaderFeaturesEXT (VK_EXT_mesh_shader)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceMeshShaderFeaturesEXT (VK_EXT_mesh_shader)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceMeshShaderFeaturesEXT (VK_EXT_mesh_shader)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceMeshShaderFeaturesEXT (VK_EXT_mesh_shader)">:heavy_check_mark:</span> |
| [taskShader](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceMeshShaderFeaturesEXT.html) | :x: | :x: | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceMeshShaderFeaturesEXT (VK_EXT_mesh_shader)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceMeshShaderFeaturesEXT (VK_EXT_mesh_shader)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceMeshShaderFeaturesEXT (VK_EXT_mesh_shader)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceMeshShaderFeaturesEXT (VK_EXT_mesh_shader)">:heavy_check_mark:</span> |
| **VK_EXT_mutable_descriptor_type** |
| [mutableDescriptorType](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT.html) | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT (VK_EXT_mutable_descriptor_type)">:heavy_check_mark:</span> | :x: | :x: | <span title="defined in VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT (VK_EXT_mutable_descriptor_type)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT (VK_EXT_mutable_descriptor_type)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT (VK_EXT_mutable_descriptor_type)">:heavy_check_mark:</span> |
| **VK_EXT_pageable_device_local_memory** |
| [pageableDeviceLocalMemory](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDevicePageableDeviceLocalMemoryFeaturesEXT.html) | :x: | :x: | :x: | :x: | :x: | :x: | :x: | <span title="defined in VkPhysicalDevicePageableDeviceLocalMemoryFeaturesEXT (VK_EXT_pageable_device_local_memory)">:heavy_check_mark:</span> | :x: |
| **VK_EXT_pipeline_creation_cache_control** |
| [pipelineCreationCacheControl](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDevicePipelineCreationCacheControlFeatures.html) | :x: | :x: | :x: | <span title="equivalent defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:warning:</span> | :x: | :x: | <span title="equivalent defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:warning:</span> |
| **VK_EXT_pipeline_library_group_handles** |
| [pipelineLibraryGroupHandles](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT.html) | :x: | :x: | :x: | :x: | :x: | <span title="defined in VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT (VK_EXT_pipeline_library_group_handles)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT (VK_EXT_pipeline_library_group_handles)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT (VK_EXT_pipeline_library_group_handles)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT (VK_EXT_pipeline_library_group_handles)">:heavy_check_mark:</span> |
| **VK_EXT_robustness2** |
| [nullDescriptor](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceRobustness2FeaturesEXT.html) | <span title="defined in VkPhysicalDeviceRobustness2FeaturesEXT (VK_EXT_robustness2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceRobustness2FeaturesEXT (VK_EXT_robustness2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceRobustness2FeaturesEXT (VK_EXT_robustness2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceRobustness2FeaturesEXT (VK_EXT_robustness2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceRobustness2FeaturesEXT (VK_EXT_robustness2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceRobustness2FeaturesEXT (VK_EXT_robustness2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceRobustness2FeaturesEXT (VK_EXT_robustness2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceRobustness2FeaturesEXT (VK_EXT_robustness2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceRobustness2FeaturesEXT (VK_EXT_robustness2)">:heavy_check_mark:</span> |
| [robustBufferAccess2](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceRobustness2FeaturesEXT.html) | <span title="defined in VkPhysicalDeviceRobustness2FeaturesEXT (VK_EXT_robustness2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceRobustness2FeaturesEXT (VK_EXT_robustness2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceRobustness2FeaturesEXT (VK_EXT_robustness2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceRobustness2FeaturesEXT (VK_EXT_robustness2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceRobustness2FeaturesEXT (VK_EXT_robustness2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceRobustness2FeaturesEXT (VK_EXT_robustness2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceRobustness2FeaturesEXT (VK_EXT_robustness2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceRobustness2FeaturesEXT (VK_EXT_robustness2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceRobustness2FeaturesEXT (VK_EXT_robustness2)">:heavy_check_mark:</span> |
| [robustImageAccess2](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceRobustness2FeaturesEXT.html) | <span title="defined in VkPhysicalDeviceRobustness2FeaturesEXT (VK_EXT_robustness2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceRobustness2FeaturesEXT (VK_EXT_robustness2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceRobustness2FeaturesEXT (VK_EXT_robustness2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceRobustness2FeaturesEXT (VK_EXT_robustness2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceRobustness2FeaturesEXT (VK_EXT_robustness2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceRobustness2FeaturesEXT (VK_EXT_robustness2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceRobustness2FeaturesEXT (VK_EXT_robustness2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceRobustness2FeaturesEXT (VK_EXT_robustness2)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceRobustness2FeaturesEXT (VK_EXT_robustness2)">:heavy_check_mark:</span> |
| **VK_EXT_scalar_block_layout** |
| [scalarBlockLayout](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceScalarBlockLayoutFeatures.html) | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceScalarBlockLayoutFeaturesEXT (VK_EXT_scalar_block_layout)">:heavy_check_mark:</span> | :x: | :x: | <span title="defined in VkPhysicalDeviceScalarBlockLayoutFeaturesEXT (VK_EXT_scalar_block_layout)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceScalarBlockLayoutFeaturesEXT (VK_EXT_scalar_block_layout)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceScalarBlockLayoutFeaturesEXT (VK_EXT_scalar_block_layout)">:heavy_check_mark:</span> |
| **VK_EXT_shader_demote_to_helper_invocation** |
| [shaderDemoteToHelperInvocation](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures.html) | <span title="equivalent defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:warning:</span> |
| **VK_EXT_shader_image_atomic_int64** |
| [shaderImageInt64Atomics](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT.html) | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT (VK_EXT_shader_image_atomic_int64)">:heavy_check_mark:</span> | :x: | :x: | <span title="defined in VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT (VK_EXT_shader_image_atomic_int64)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT (VK_EXT_shader_image_atomic_int64)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT (VK_EXT_shader_image_atomic_int64)">:heavy_check_mark:</span> |
| **VK_EXT_shader_module_identifier** |
| [shaderModuleIdentifier](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceShaderModuleIdentifierFeaturesEXT.html) | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceShaderModuleIdentifierFeaturesEXT (VK_EXT_shader_module_identifier)">:heavy_check_mark:</span> | :x: | :x: | <span title="defined in VkPhysicalDeviceShaderModuleIdentifierFeaturesEXT (VK_EXT_shader_module_identifier)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceShaderModuleIdentifierFeaturesEXT (VK_EXT_shader_module_identifier)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceShaderModuleIdentifierFeaturesEXT (VK_EXT_shader_module_identifier)">:heavy_check_mark:</span> |
| **VK_EXT_subgroup_size_control** |
| [computeFullSubgroups](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceSubgroupSizeControlFeatures.html) | :x: | :x: | :x: | <span title="equivalent defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:warning:</span> | :x: | :x: | <span title="equivalent defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:warning:</span> |
| [subgroupSizeControl](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceSubgroupSizeControlFeatures.html) | :x: | :x: | :x: | <span title="equivalent defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:warning:</span> | :x: | :x: | <span title="equivalent defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Features (Vulkan 1.3)">:warning:</span> |
| **VK_EXT_swapchain_maintenance1** |
| [swapchainMaintenance1](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceSwapchainMaintenance1FeaturesEXT.html) | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceSwapchainMaintenance1FeaturesEXT (VK_EXT_swapchain_maintenance1)">:heavy_check_mark:</span> | :x: | :x: | <span title="defined in VkPhysicalDeviceSwapchainMaintenance1FeaturesEXT (VK_EXT_swapchain_maintenance1)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceSwapchainMaintenance1FeaturesEXT (VK_EXT_swapchain_maintenance1)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceSwapchainMaintenance1FeaturesEXT (VK_EXT_swapchain_maintenance1)">:heavy_check_mark:</span> |
| **VK_EXT_transform_feedback** |
| [geometryStreams](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceTransformFeedbackFeaturesEXT.html) | <span title="defined in VkPhysicalDeviceTransformFeedbackFeaturesEXT (VK_EXT_transform_feedback)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceTransformFeedbackFeaturesEXT (VK_EXT_transform_feedback)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceTransformFeedbackFeaturesEXT (VK_EXT_transform_feedback)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceTransformFeedbackFeaturesEXT (VK_EXT_transform_feedback)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceTransformFeedbackFeaturesEXT (VK_EXT_transform_feedback)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceTransformFeedbackFeaturesEXT (VK_EXT_transform_feedback)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceTransformFeedbackFeaturesEXT (VK_EXT_transform_feedback)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceTransformFeedbackFeaturesEXT (VK_EXT_transform_feedback)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceTransformFeedbackFeaturesEXT (VK_EXT_transform_feedback)">:heavy_check_mark:</span> |
| [transformFeedback](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceTransformFeedbackFeaturesEXT.html) | <span title="defined in VkPhysicalDeviceTransformFeedbackFeaturesEXT (VK_EXT_transform_feedback)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceTransformFeedbackFeaturesEXT (VK_EXT_transform_feedback)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceTransformFeedbackFeaturesEXT (VK_EXT_transform_feedback)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceTransformFeedbackFeaturesEXT (VK_EXT_transform_feedback)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceTransformFeedbackFeaturesEXT (VK_EXT_transform_feedback)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceTransformFeedbackFeaturesEXT (VK_EXT_transform_feedback)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceTransformFeedbackFeaturesEXT (VK_EXT_transform_feedback)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceTransformFeedbackFeaturesEXT (VK_EXT_transform_feedback)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceTransformFeedbackFeaturesEXT (VK_EXT_transform_feedback)">:heavy_check_mark:</span> |
| **VK_EXT_vertex_attribute_divisor** |
| [vertexAttributeInstanceRateDivisor](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceVertexAttributeDivisorFeaturesKHR.html) | <span title="defined in VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT (VK_EXT_vertex_attribute_divisor)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT (VK_EXT_vertex_attribute_divisor)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT (VK_EXT_vertex_attribute_divisor)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT (VK_EXT_vertex_attribute_divisor)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT (VK_EXT_vertex_attribute_divisor)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT (VK_EXT_vertex_attribute_divisor)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT (VK_EXT_vertex_attribute_divisor)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT (VK_EXT_vertex_attribute_divisor)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT (VK_EXT_vertex_attribute_divisor)">:heavy_check_mark:</span> |
| [vertexAttributeInstanceRateZeroDivisor](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceVertexAttributeDivisorFeaturesKHR.html) | <span title="defined in VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT (VK_EXT_vertex_attribute_divisor)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT (VK_EXT_vertex_attribute_divisor)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT (VK_EXT_vertex_attribute_divisor)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT (VK_EXT_vertex_attribute_divisor)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT (VK_EXT_vertex_attribute_divisor)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT (VK_EXT_vertex_attribute_divisor)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT (VK_EXT_vertex_attribute_divisor)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT (VK_EXT_vertex_attribute_divisor)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT (VK_EXT_vertex_attribute_divisor)">:heavy_check_mark:</span> |
| **VK_AMD_device_coherent_memory** |
| [deviceCoherentMemory](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceCoherentMemoryFeaturesAMD.html) | :x: | :x: | :x: | :x: | :x: | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceCoherentMemoryFeaturesAMD (VK_AMD_device_coherent_memory)">:heavy_check_mark:</span> |
| **VK_MESA_image_alignment_control** |
| [imageAlignmentControl](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceImageAlignmentControlFeaturesMESA.html) | :x: | :x: | :x: | :x: | :x: | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceImageAlignmentControlFeaturesMESA (VK_MESA_image_alignment_control)">:heavy_check_mark:</span> |
| **VK_NV_compute_shader_derivatives** |
| [computeDerivativeGroupLinear](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceComputeShaderDerivativesFeaturesNV.html) | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceComputeShaderDerivativesFeaturesNV (VK_NV_compute_shader_derivatives)">:heavy_check_mark:</span> | :x: | :x: | <span title="defined in VkPhysicalDeviceComputeShaderDerivativesFeaturesNV (VK_NV_compute_shader_derivatives)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceComputeShaderDerivativesFeaturesNV (VK_NV_compute_shader_derivatives)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceComputeShaderDerivativesFeaturesNV (VK_NV_compute_shader_derivatives)">:heavy_check_mark:</span> |
| **VK_NV_device_generated_commands** |
| [deviceGeneratedCommands](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceDeviceGeneratedCommandsFeaturesNV.html) | :x: | :x: | :x: | :x: | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceDeviceGeneratedCommandsFeaturesNV (VK_NV_device_generated_commands)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceDeviceGeneratedCommandsFeaturesNV (VK_NV_device_generated_commands)">:heavy_check_mark:</span> |
| **VK_NV_device_generated_commands_compute** |
| [deviceGeneratedCompute](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceDeviceGeneratedCommandsComputeFeaturesNV.html) | :x: | :x: | :x: | :x: | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceDeviceGeneratedCommandsComputeFeaturesNV (VK_NV_device_generated_commands_compute)">:heavy_check_mark:</span> | <span title="defined in VkPhysicalDeviceDeviceGeneratedCommandsComputeFeaturesNV (VK_NV_device_generated_commands_compute)">:heavy_check_mark:</span> |
| **VK_NV_fragment_shader_barycentric** |
| [fragmentShaderBarycentric](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR.html) | :x: | :x: | :x: | :x: | :x: | :x: | :x: | <span title="equivalent defined in VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR (VK_KHR_fragment_shader_barycentric)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR (VK_KHR_fragment_shader_barycentric)">:warning:</span> |
| **VK_NV_raw_access_chains** |
| [shaderRawAccessChains](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceRawAccessChainsFeaturesNV.html) | :x: | :x: | :x: | :x: | :x: | :x: | :x: | <span title="defined in VkPhysicalDeviceRawAccessChainsFeaturesNV (VK_NV_raw_access_chains)">:heavy_check_mark:</span> | :x: |
| **VK_VALVE_mutable_descriptor_type** |
| [mutableDescriptorType](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT.html) | :x: | :x: | :x: | <span title="equivalent defined in VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT (VK_EXT_mutable_descriptor_type)">:warning:</span> | :x: | :x: | <span title="equivalent defined in VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT (VK_EXT_mutable_descriptor_type)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT (VK_EXT_mutable_descriptor_type)">:warning:</span> | <span title="equivalent defined in VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT (VK_EXT_mutable_descriptor_type)">:warning:</span> |

## Vulkan Profile Limits (Properties)

> **NOTE**: The table below only contains properties/limits explicitly defined by the corresponding profile. Further properties/limits may be supported by the profiles in accordance to the requirements defined in the "Limit Requirements" section of the appropriate version of the Vulkan API Specification.

* "valueWithRegularFont" indicates that the limit/property is defined in the profile (hover over the value to view the structure and corresponding extension or core API version where the limit/property is defined in the profile)
* "_valueWithItalicFont_" indicates that the limit/property is not defined in the profile but an equivalent limit/property is (hover over the symbol to view the structure and corresponding extension or core API version where the limit/property is defined in the profile)
* "-" indicates that neither the limit/property nor an equivalent limit/property is defined in the profile

| Profiles | VP_D3D12_FL_11_0_baseline | VP_D3D12_FL_11_1_baseline | VP_D3D12_FL_12_0_baseline | VP_D3D12_FL_12_0_optimal | VP_D3D12_FL_12_1_baseline | VP_D3D12_FL_12_2_baseline | VP_D3D12_FL_12_2_optimal | VP_D3D12_maximum_nv | VP_D3D12_maximum_radv |
|----------|---------------------------|---------------------------|---------------------------|--------------------------|---------------------------|---------------------------|--------------------------|---------------------|-----------------------|
| **Vulkan 1.0** |
| [bufferImageGranularity (min,mul)](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceLimits.html) | <span title="defined in VkPhysicalDeviceProperties (Vulkan 1.0)">65536</span> | <span title="defined in VkPhysicalDeviceProperties (Vulkan 1.0)">65536</span> | <span title="defined in VkPhysicalDeviceProperties (Vulkan 1.0)">65536</span> | <span title="defined in VkPhysicalDeviceProperties (Vulkan 1.0)">65536</span> | <span title="defined in VkPhysicalDeviceProperties (Vulkan 1.0)">65536</span> | <span title="defined in VkPhysicalDeviceProperties (Vulkan 1.0)">65536</span> | <span title="defined in VkPhysicalDeviceProperties (Vulkan 1.0)">65536</span> | <span title="defined in VkPhysicalDeviceProperties (Vulkan 1.0)">65536</span> | <span title="defined in VkPhysicalDeviceProperties (Vulkan 1.0)">65536</span> |
| [maxPushConstantsSize (max)](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceLimits.html) | - | - | - | <span title="defined in VkPhysicalDeviceProperties (Vulkan 1.0)">256</span> | - | - | - | - | - |
| [residencyAlignedMipSize (not)](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceSparseProperties.html) | - | - | <span title="defined in VkPhysicalDeviceProperties (Vulkan 1.0)">VK_FALSE</span> | <span title="defined in VkPhysicalDeviceProperties (Vulkan 1.0)">VK_FALSE</span> | <span title="defined in VkPhysicalDeviceProperties (Vulkan 1.0)">VK_FALSE</span> | <span title="defined in VkPhysicalDeviceProperties (Vulkan 1.0)">VK_FALSE</span> | <span title="defined in VkPhysicalDeviceProperties (Vulkan 1.0)">VK_FALSE</span> | <span title="defined in VkPhysicalDeviceProperties (Vulkan 1.0)">VK_FALSE</span> | <span title="defined in VkPhysicalDeviceProperties (Vulkan 1.0)">VK_FALSE</span> |
| [residencyNonResidentStrict](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceSparseProperties.html) | - | - | <span title="defined in VkPhysicalDeviceProperties (Vulkan 1.0)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceProperties (Vulkan 1.0)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceProperties (Vulkan 1.0)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceProperties (Vulkan 1.0)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceProperties (Vulkan 1.0)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceProperties (Vulkan 1.0)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceProperties (Vulkan 1.0)">VK_TRUE</span> |
| [residencyStandard2DBlockShape](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceSparseProperties.html) | - | - | <span title="defined in VkPhysicalDeviceProperties (Vulkan 1.0)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceProperties (Vulkan 1.0)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceProperties (Vulkan 1.0)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceProperties (Vulkan 1.0)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceProperties (Vulkan 1.0)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceProperties (Vulkan 1.0)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceProperties (Vulkan 1.0)">VK_TRUE</span> |
| [residencyStandard3DBlockShape](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceSparseProperties.html) | - | - | - | - | - | <span title="defined in VkPhysicalDeviceProperties (Vulkan 1.0)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceProperties (Vulkan 1.0)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceProperties (Vulkan 1.0)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceProperties (Vulkan 1.0)">VK_TRUE</span> |
| **Vulkan 1.1** |
| [subgroupSize (max,pot)](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceSubgroupProperties.html) | <span title="defined in VkPhysicalDeviceVulkan11Properties (Vulkan 1.1)">1</span> | <span title="defined in VkPhysicalDeviceVulkan11Properties (Vulkan 1.1)">1</span> | - | - | - | - | - | - | - |
| [subgroupSupportedOperations](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceVulkan11Properties.html) | <span title="defined in VkPhysicalDeviceVulkan11Properties (Vulkan 1.1)">(VK_SUBGROUP_FEATURE_BASIC_BIT)</span> | <span title="defined in VkPhysicalDeviceVulkan11Properties (Vulkan 1.1)">(VK_SUBGROUP_FEATURE_BASIC_BIT)</span> | <span title="defined in VkPhysicalDeviceVulkan11Properties (Vulkan 1.1)">(VK_SUBGROUP_FEATURE_BALLOT_BIT | VK_SUBGROUP_FEATURE_BASIC_BIT | VK_SUBGROUP_FEATURE_VOTE_BIT | VK_SUBGROUP_FEATURE_SHUFFLE_BIT | VK_SUBGROUP_FEATURE_QUAD_BIT | VK_SUBGROUP_FEATURE_ARITHMETIC_BIT)</span> | - | <span title="defined in VkPhysicalDeviceVulkan11Properties (Vulkan 1.1)">(VK_SUBGROUP_FEATURE_BALLOT_BIT | VK_SUBGROUP_FEATURE_BASIC_BIT | VK_SUBGROUP_FEATURE_VOTE_BIT | VK_SUBGROUP_FEATURE_SHUFFLE_BIT | VK_SUBGROUP_FEATURE_QUAD_BIT | VK_SUBGROUP_FEATURE_ARITHMETIC_BIT)</span> | <span title="defined in VkPhysicalDeviceVulkan11Properties (Vulkan 1.1)">(VK_SUBGROUP_FEATURE_BALLOT_BIT | VK_SUBGROUP_FEATURE_BASIC_BIT | VK_SUBGROUP_FEATURE_VOTE_BIT | VK_SUBGROUP_FEATURE_SHUFFLE_BIT | VK_SUBGROUP_FEATURE_QUAD_BIT | VK_SUBGROUP_FEATURE_ARITHMETIC_BIT)</span> | - | - | - |
| [subgroupSupportedStages](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceVulkan11Properties.html) | - | - | <span title="defined in VkPhysicalDeviceVulkan11Properties (Vulkan 1.1)">(VK_SHADER_STAGE_COMPUTE_BIT | VK_SHADER_STAGE_FRAGMENT_BIT)</span> | - | <span title="defined in VkPhysicalDeviceVulkan11Properties (Vulkan 1.1)">(VK_SHADER_STAGE_COMPUTE_BIT | VK_SHADER_STAGE_FRAGMENT_BIT)</span> | <span title="defined in VkPhysicalDeviceVulkan11Properties (Vulkan 1.1)">(VK_SHADER_STAGE_COMPUTE_BIT | VK_SHADER_STAGE_FRAGMENT_BIT)</span> | - | - | - |
| **Vulkan 1.2** |
| [denormBehaviorIndependence (exact)](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFloatControlsProperties.html) | - | - | - | - | - | - | - | - | <span title="defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_32_BIT_ONLY</span> |
| [filterMinmaxSingleComponentFormats](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceSamplerFilterMinmaxProperties.html) | - | - | <span title="defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">VK_TRUE</span> |
| [maxPerStageDescriptorUpdateAfterBindSampledImages (max)](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceDescriptorIndexingProperties.html) | <span title="defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">1000000</span> | <span title="defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">1000000</span> | <span title="defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">1000000</span> | <span title="defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">1000000</span> | <span title="defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">1000000</span> | <span title="defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">1000000</span> | <span title="defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">1000000</span> | <span title="defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">1000000</span> | <span title="defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">1000000</span> |
| [maxPerStageDescriptorUpdateAfterBindStorageBuffers (max)](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceDescriptorIndexingProperties.html) | <span title="defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">1000000</span> | <span title="defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">1000000</span> | <span title="defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">1000000</span> | <span title="defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">1000000</span> | <span title="defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">1000000</span> | <span title="defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">1000000</span> | <span title="defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">1000000</span> | <span title="defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">1000000</span> | <span title="defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">1000000</span> |
| [maxPerStageDescriptorUpdateAfterBindStorageImages (max)](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceDescriptorIndexingProperties.html) | <span title="defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">1000000</span> | <span title="defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">1000000</span> | <span title="defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">1000000</span> | <span title="defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">1000000</span> | <span title="defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">1000000</span> | <span title="defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">1000000</span> | <span title="defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">1000000</span> | <span title="defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">1000000</span> | <span title="defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">1000000</span> |
| [robustBufferAccessUpdateAfterBind](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceDescriptorIndexingProperties.html) | <span title="defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">VK_TRUE</span> |
| [shaderDenormFlushToZeroFloat32](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFloatControlsProperties.html) | - | - | - | - | - | - | - | - | <span title="defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">VK_TRUE</span> |
| [shaderDenormPreserveFloat16](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFloatControlsProperties.html) | - | - | - | - | - | - | - | - | <span title="defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">VK_TRUE</span> |
| [shaderDenormPreserveFloat32](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFloatControlsProperties.html) | - | - | - | - | - | - | - | - | <span title="defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">VK_TRUE</span> |
| [shaderDenormPreserveFloat64](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFloatControlsProperties.html) | - | - | - | - | - | - | - | - | <span title="defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">VK_TRUE</span> |
| **Vulkan 1.3** |
| [requiredSubgroupSizeStages](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceSubgroupSizeControlProperties.html) | - | - | - | <span title="defined in VkPhysicalDeviceVulkan13Properties (Vulkan 1.3)">(VK_SHADER_STAGE_COMPUTE_BIT)</span> | - | - | <span title="defined in VkPhysicalDeviceVulkan13Properties (Vulkan 1.3)">(VK_SHADER_STAGE_COMPUTE_BIT)</span> | <span title="defined in VkPhysicalDeviceVulkan13Properties (Vulkan 1.3)">(VK_SHADER_STAGE_COMPUTE_BIT)</span> | <span title="defined in VkPhysicalDeviceVulkan13Properties (Vulkan 1.3)">(VK_SHADER_STAGE_COMPUTE_BIT)</span> |
| [storageTexelBufferOffsetSingleTexelAlignment (exact)](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceTexelBufferAlignmentProperties.html) | <span title="defined in VkPhysicalDeviceVulkan13Properties (Vulkan 1.3)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceVulkan13Properties (Vulkan 1.3)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceVulkan13Properties (Vulkan 1.3)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceVulkan13Properties (Vulkan 1.3)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceVulkan13Properties (Vulkan 1.3)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceVulkan13Properties (Vulkan 1.3)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceVulkan13Properties (Vulkan 1.3)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceVulkan13Properties (Vulkan 1.3)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceVulkan13Properties (Vulkan 1.3)">VK_TRUE</span> |
| [uniformTexelBufferOffsetSingleTexelAlignment (exact)](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceTexelBufferAlignmentProperties.html) | <span title="defined in VkPhysicalDeviceVulkan13Properties (Vulkan 1.3)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceVulkan13Properties (Vulkan 1.3)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceVulkan13Properties (Vulkan 1.3)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceVulkan13Properties (Vulkan 1.3)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceVulkan13Properties (Vulkan 1.3)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceVulkan13Properties (Vulkan 1.3)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceVulkan13Properties (Vulkan 1.3)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceVulkan13Properties (Vulkan 1.3)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceVulkan13Properties (Vulkan 1.3)">VK_TRUE</span> |
| **VK_KHR_fragment_shading_rate** |
| [fragmentShadingRateNonTrivialCombinerOps](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFragmentShadingRatePropertiesKHR.html) | - | - | - | - | - | <span title="defined in VkPhysicalDeviceFragmentShadingRatePropertiesKHR (VK_KHR_fragment_shading_rate)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceFragmentShadingRatePropertiesKHR (VK_KHR_fragment_shading_rate)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceFragmentShadingRatePropertiesKHR (VK_KHR_fragment_shading_rate)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceFragmentShadingRatePropertiesKHR (VK_KHR_fragment_shading_rate)">VK_TRUE</span> |
| **VK_KHR_push_descriptor** |
| [maxPushDescriptors (max)](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDevicePushDescriptorPropertiesKHR.html) | <span title="defined in VkPhysicalDevicePushDescriptorPropertiesKHR (VK_KHR_push_descriptor)">32</span> | <span title="defined in VkPhysicalDevicePushDescriptorPropertiesKHR (VK_KHR_push_descriptor)">32</span> | <span title="defined in VkPhysicalDevicePushDescriptorPropertiesKHR (VK_KHR_push_descriptor)">32</span> | <span title="defined in VkPhysicalDevicePushDescriptorPropertiesKHR (VK_KHR_push_descriptor)">32</span> | <span title="defined in VkPhysicalDevicePushDescriptorPropertiesKHR (VK_KHR_push_descriptor)">32</span> | <span title="defined in VkPhysicalDevicePushDescriptorPropertiesKHR (VK_KHR_push_descriptor)">32</span> | <span title="defined in VkPhysicalDevicePushDescriptorPropertiesKHR (VK_KHR_push_descriptor)">32</span> | <span title="defined in VkPhysicalDevicePushDescriptorPropertiesKHR (VK_KHR_push_descriptor)">32</span> | <span title="defined in VkPhysicalDevicePushDescriptorPropertiesKHR (VK_KHR_push_descriptor)">32</span> |
| **VK_KHR_shader_float_controls** |
| [denormBehaviorIndependence (exact)](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFloatControlsProperties.html) | - | - | - | - | - | - | - | - | <span title="equivalent defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">_VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_32_BIT_ONLY_</span> |
| [shaderDenormFlushToZeroFloat32](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFloatControlsProperties.html) | - | - | - | - | - | - | - | - | <span title="equivalent defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">_VK_TRUE_</span> |
| [shaderDenormPreserveFloat16](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFloatControlsProperties.html) | - | - | - | - | - | - | - | - | <span title="equivalent defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">_VK_TRUE_</span> |
| [shaderDenormPreserveFloat32](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFloatControlsProperties.html) | - | - | - | - | - | - | - | - | <span title="equivalent defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">_VK_TRUE_</span> |
| [shaderDenormPreserveFloat64](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceFloatControlsProperties.html) | - | - | - | - | - | - | - | - | <span title="equivalent defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">_VK_TRUE_</span> |
| **VK_EXT_conservative_rasterization** |
| [degenerateTrianglesRasterized (exact)](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceConservativeRasterizationPropertiesEXT.html) | - | - | - | - | - | <span title="defined in VkPhysicalDeviceConservativeRasterizationPropertiesEXT (VK_EXT_conservative_rasterization)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceConservativeRasterizationPropertiesEXT (VK_EXT_conservative_rasterization)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceConservativeRasterizationPropertiesEXT (VK_EXT_conservative_rasterization)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceConservativeRasterizationPropertiesEXT (VK_EXT_conservative_rasterization)">VK_TRUE</span> |
| [fullyCoveredFragmentShaderInputVariable](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceConservativeRasterizationPropertiesEXT.html) | - | - | - | - | - | <span title="defined in VkPhysicalDeviceConservativeRasterizationPropertiesEXT (VK_EXT_conservative_rasterization)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceConservativeRasterizationPropertiesEXT (VK_EXT_conservative_rasterization)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceConservativeRasterizationPropertiesEXT (VK_EXT_conservative_rasterization)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceConservativeRasterizationPropertiesEXT (VK_EXT_conservative_rasterization)">VK_TRUE</span> |
| **VK_EXT_custom_border_color** |
| [maxCustomBorderColorSamplers (max)](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceCustomBorderColorPropertiesEXT.html) | <span title="defined in VkPhysicalDeviceCustomBorderColorPropertiesEXT (VK_EXT_custom_border_color)">2048</span> | <span title="defined in VkPhysicalDeviceCustomBorderColorPropertiesEXT (VK_EXT_custom_border_color)">2048</span> | <span title="defined in VkPhysicalDeviceCustomBorderColorPropertiesEXT (VK_EXT_custom_border_color)">2048</span> | <span title="defined in VkPhysicalDeviceCustomBorderColorPropertiesEXT (VK_EXT_custom_border_color)">2048</span> | <span title="defined in VkPhysicalDeviceCustomBorderColorPropertiesEXT (VK_EXT_custom_border_color)">2048</span> | <span title="defined in VkPhysicalDeviceCustomBorderColorPropertiesEXT (VK_EXT_custom_border_color)">2048</span> | <span title="defined in VkPhysicalDeviceCustomBorderColorPropertiesEXT (VK_EXT_custom_border_color)">2048</span> | <span title="defined in VkPhysicalDeviceCustomBorderColorPropertiesEXT (VK_EXT_custom_border_color)">2048</span> | <span title="defined in VkPhysicalDeviceCustomBorderColorPropertiesEXT (VK_EXT_custom_border_color)">2048</span> |
| **VK_EXT_descriptor_indexing** |
| [maxPerStageDescriptorUpdateAfterBindSampledImages (max)](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceDescriptorIndexingProperties.html) | <span title="equivalent defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">_1000000_</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">_1000000_</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">_1000000_</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">_1000000_</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">_1000000_</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">_1000000_</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">_1000000_</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">_1000000_</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">_1000000_</span> |
| [maxPerStageDescriptorUpdateAfterBindStorageBuffers (max)](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceDescriptorIndexingProperties.html) | <span title="equivalent defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">_1000000_</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">_1000000_</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">_1000000_</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">_1000000_</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">_1000000_</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">_1000000_</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">_1000000_</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">_1000000_</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">_1000000_</span> |
| [maxPerStageDescriptorUpdateAfterBindStorageImages (max)](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceDescriptorIndexingProperties.html) | <span title="equivalent defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">_1000000_</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">_1000000_</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">_1000000_</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">_1000000_</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">_1000000_</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">_1000000_</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">_1000000_</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">_1000000_</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">_1000000_</span> |
| [robustBufferAccessUpdateAfterBind](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceDescriptorIndexingProperties.html) | <span title="equivalent defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">_VK_TRUE_</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">_VK_TRUE_</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">_VK_TRUE_</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">_VK_TRUE_</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">_VK_TRUE_</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">_VK_TRUE_</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">_VK_TRUE_</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">_VK_TRUE_</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">_VK_TRUE_</span> |
| **VK_EXT_graphics_pipeline_library** |
| [graphicsPipelineLibraryFastLinking](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT.html) | - | - | - | <span title="defined in VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT (VK_EXT_graphics_pipeline_library)">VK_TRUE</span> | - | - | <span title="defined in VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT (VK_EXT_graphics_pipeline_library)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT (VK_EXT_graphics_pipeline_library)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT (VK_EXT_graphics_pipeline_library)">VK_TRUE</span> |
| [graphicsPipelineLibraryIndependentInterpolationDecoration](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT.html) | - | - | - | <span title="defined in VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT (VK_EXT_graphics_pipeline_library)">VK_TRUE</span> | - | - | <span title="defined in VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT (VK_EXT_graphics_pipeline_library)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT (VK_EXT_graphics_pipeline_library)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT (VK_EXT_graphics_pipeline_library)">VK_TRUE</span> |
| **VK_EXT_sampler_filter_minmax** |
| [filterMinmaxSingleComponentFormats](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceSamplerFilterMinmaxProperties.html) | - | - | <span title="equivalent defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">_VK_TRUE_</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">_VK_TRUE_</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">_VK_TRUE_</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">_VK_TRUE_</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">_VK_TRUE_</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">_VK_TRUE_</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan12Properties (Vulkan 1.2)">_VK_TRUE_</span> |
| **VK_EXT_subgroup_size_control** |
| [requiredSubgroupSizeStages](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceSubgroupSizeControlProperties.html) | - | - | - | <span title="equivalent defined in VkPhysicalDeviceVulkan13Properties (Vulkan 1.3)">_(VK_SHADER_STAGE_COMPUTE_BIT)_</span> | - | - | <span title="equivalent defined in VkPhysicalDeviceVulkan13Properties (Vulkan 1.3)">_(VK_SHADER_STAGE_COMPUTE_BIT)_</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Properties (Vulkan 1.3)">_(VK_SHADER_STAGE_COMPUTE_BIT)_</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Properties (Vulkan 1.3)">_(VK_SHADER_STAGE_COMPUTE_BIT)_</span> |
| **VK_EXT_texel_buffer_alignment** |
| [storageTexelBufferOffsetSingleTexelAlignment (exact)](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceTexelBufferAlignmentProperties.html) | <span title="equivalent defined in VkPhysicalDeviceVulkan13Properties (Vulkan 1.3)">_VK_TRUE_</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Properties (Vulkan 1.3)">_VK_TRUE_</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Properties (Vulkan 1.3)">_VK_TRUE_</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Properties (Vulkan 1.3)">_VK_TRUE_</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Properties (Vulkan 1.3)">_VK_TRUE_</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Properties (Vulkan 1.3)">_VK_TRUE_</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Properties (Vulkan 1.3)">_VK_TRUE_</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Properties (Vulkan 1.3)">_VK_TRUE_</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Properties (Vulkan 1.3)">_VK_TRUE_</span> |
| [uniformTexelBufferOffsetSingleTexelAlignment (exact)](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceTexelBufferAlignmentProperties.html) | <span title="equivalent defined in VkPhysicalDeviceVulkan13Properties (Vulkan 1.3)">_VK_TRUE_</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Properties (Vulkan 1.3)">_VK_TRUE_</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Properties (Vulkan 1.3)">_VK_TRUE_</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Properties (Vulkan 1.3)">_VK_TRUE_</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Properties (Vulkan 1.3)">_VK_TRUE_</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Properties (Vulkan 1.3)">_VK_TRUE_</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Properties (Vulkan 1.3)">_VK_TRUE_</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Properties (Vulkan 1.3)">_VK_TRUE_</span> | <span title="equivalent defined in VkPhysicalDeviceVulkan13Properties (Vulkan 1.3)">_VK_TRUE_</span> |
| **VK_EXT_transform_feedback** |
| [transformFeedbackDraw](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceTransformFeedbackPropertiesEXT.html) | <span title="defined in VkPhysicalDeviceTransformFeedbackPropertiesEXT (VK_EXT_transform_feedback)">VK_FALSE</span> | <span title="defined in VkPhysicalDeviceTransformFeedbackPropertiesEXT (VK_EXT_transform_feedback)">VK_FALSE</span> | <span title="defined in VkPhysicalDeviceTransformFeedbackPropertiesEXT (VK_EXT_transform_feedback)">VK_FALSE</span> | <span title="defined in VkPhysicalDeviceTransformFeedbackPropertiesEXT (VK_EXT_transform_feedback)">VK_FALSE</span> | <span title="defined in VkPhysicalDeviceTransformFeedbackPropertiesEXT (VK_EXT_transform_feedback)">VK_FALSE</span> | <span title="defined in VkPhysicalDeviceTransformFeedbackPropertiesEXT (VK_EXT_transform_feedback)">VK_FALSE</span> | <span title="defined in VkPhysicalDeviceTransformFeedbackPropertiesEXT (VK_EXT_transform_feedback)">VK_FALSE</span> | <span title="defined in VkPhysicalDeviceTransformFeedbackPropertiesEXT (VK_EXT_transform_feedback)">VK_FALSE</span> | <span title="defined in VkPhysicalDeviceTransformFeedbackPropertiesEXT (VK_EXT_transform_feedback)">VK_FALSE</span> |
| [transformFeedbackQueries](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceTransformFeedbackPropertiesEXT.html) | <span title="defined in VkPhysicalDeviceTransformFeedbackPropertiesEXT (VK_EXT_transform_feedback)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceTransformFeedbackPropertiesEXT (VK_EXT_transform_feedback)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceTransformFeedbackPropertiesEXT (VK_EXT_transform_feedback)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceTransformFeedbackPropertiesEXT (VK_EXT_transform_feedback)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceTransformFeedbackPropertiesEXT (VK_EXT_transform_feedback)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceTransformFeedbackPropertiesEXT (VK_EXT_transform_feedback)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceTransformFeedbackPropertiesEXT (VK_EXT_transform_feedback)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceTransformFeedbackPropertiesEXT (VK_EXT_transform_feedback)">VK_TRUE</span> | <span title="defined in VkPhysicalDeviceTransformFeedbackPropertiesEXT (VK_EXT_transform_feedback)">VK_TRUE</span> |
| [transformFeedbackRasterizationStreamSelect](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceTransformFeedbackPropertiesEXT.html) | <span title="defined in VkPhysicalDeviceTransformFeedbackPropertiesEXT (VK_EXT_transform_feedback)">VK_FALSE</span> | <span title="defined in VkPhysicalDeviceTransformFeedbackPropertiesEXT (VK_EXT_transform_feedback)">VK_FALSE</span> | <span title="defined in VkPhysicalDeviceTransformFeedbackPropertiesEXT (VK_EXT_transform_feedback)">VK_FALSE</span> | <span title="defined in VkPhysicalDeviceTransformFeedbackPropertiesEXT (VK_EXT_transform_feedback)">VK_FALSE</span> | <span title="defined in VkPhysicalDeviceTransformFeedbackPropertiesEXT (VK_EXT_transform_feedback)">VK_FALSE</span> | <span title="defined in VkPhysicalDeviceTransformFeedbackPropertiesEXT (VK_EXT_transform_feedback)">VK_FALSE</span> | <span title="defined in VkPhysicalDeviceTransformFeedbackPropertiesEXT (VK_EXT_transform_feedback)">VK_FALSE</span> | <span title="defined in VkPhysicalDeviceTransformFeedbackPropertiesEXT (VK_EXT_transform_feedback)">VK_FALSE</span> | <span title="defined in VkPhysicalDeviceTransformFeedbackPropertiesEXT (VK_EXT_transform_feedback)">VK_FALSE</span> |
| [transformFeedbackStreamsLinesTriangles](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkPhysicalDeviceTransformFeedbackPropertiesEXT.html) | <span title="defined in VkPhysicalDeviceTransformFeedbackPropertiesEXT (VK_EXT_transform_feedback)">VK_FALSE</span> | <span title="defined in VkPhysicalDeviceTransformFeedbackPropertiesEXT (VK_EXT_transform_feedback)">VK_FALSE</span> | <span title="defined in VkPhysicalDeviceTransformFeedbackPropertiesEXT (VK_EXT_transform_feedback)">VK_FALSE</span> | <span title="defined in VkPhysicalDeviceTransformFeedbackPropertiesEXT (VK_EXT_transform_feedback)">VK_FALSE</span> | <span title="defined in VkPhysicalDeviceTransformFeedbackPropertiesEXT (VK_EXT_transform_feedback)">VK_FALSE</span> | <span title="defined in VkPhysicalDeviceTransformFeedbackPropertiesEXT (VK_EXT_transform_feedback)">VK_FALSE</span> | <span title="defined in VkPhysicalDeviceTransformFeedbackPropertiesEXT (VK_EXT_transform_feedback)">VK_FALSE</span> | <span title="defined in VkPhysicalDeviceTransformFeedbackPropertiesEXT (VK_EXT_transform_feedback)">VK_FALSE</span> | <span title="defined in VkPhysicalDeviceTransformFeedbackPropertiesEXT (VK_EXT_transform_feedback)">VK_FALSE</span> |

## Vulkan Profile Queue Families

* "valueWithRegularFont" indicates that the queue family property is defined in the profile (hover over the value to view the structure and corresponding extension or core API version where the queue family property is defined in the profile)
* "_valueWithItalicFont_" indicates that the queue family property is not defined in the profile but an equivalent queue family property is (hover over the symbol to view the structure and corresponding extension or core API version where the queue family property is defined in the profile)
* "-" indicates that neither the queue family property nor an equivalent queue family property is defined in the profile
* Empty cells next to the properties of a particular queue family definition section indicate that the profile does not have a corresponding queue family definition

| Profiles | VP_D3D12_FL_11_0_baseline | VP_D3D12_FL_11_1_baseline | VP_D3D12_FL_12_0_baseline | VP_D3D12_FL_12_0_optimal | VP_D3D12_FL_12_1_baseline | VP_D3D12_FL_12_2_baseline | VP_D3D12_FL_12_2_optimal | VP_D3D12_maximum_nv | VP_D3D12_maximum_radv |
|----------|---------------------------|---------------------------|---------------------------|--------------------------|---------------------------|---------------------------|--------------------------|---------------------|-----------------------|
| **Queue family #0** |
| [queueCount (max)](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkQueueFamilyProperties.html) |  |  | <span title="defined in VkQueueFamilyProperties (Vulkan 1.0)">1</span> | <span title="defined in VkQueueFamilyProperties (Vulkan 1.0)">1</span> | <span title="defined in VkQueueFamilyProperties (Vulkan 1.0)">1</span> | <span title="defined in VkQueueFamilyProperties (Vulkan 1.0)">1</span> | <span title="defined in VkQueueFamilyProperties (Vulkan 1.0)">1</span> | <span title="defined in VkQueueFamilyProperties (Vulkan 1.0)">1</span> | <span title="defined in VkQueueFamilyProperties (Vulkan 1.0)">1</span> |
| [queueFlags](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkQueueFamilyProperties.html) |  |  | <span title="defined in VkQueueFamilyProperties (Vulkan 1.0)">(VK_QUEUE_SPARSE_BINDING_BIT)</span> | <span title="defined in VkQueueFamilyProperties (Vulkan 1.0)">(VK_QUEUE_SPARSE_BINDING_BIT)</span> | <span title="defined in VkQueueFamilyProperties (Vulkan 1.0)">(VK_QUEUE_SPARSE_BINDING_BIT)</span> | <span title="defined in VkQueueFamilyProperties (Vulkan 1.0)">(VK_QUEUE_SPARSE_BINDING_BIT)</span> | <span title="defined in VkQueueFamilyProperties (Vulkan 1.0)">(VK_QUEUE_SPARSE_BINDING_BIT)</span> | <span title="defined in VkQueueFamilyProperties (Vulkan 1.0)">(VK_QUEUE_SPARSE_BINDING_BIT)</span> | <span title="defined in VkQueueFamilyProperties (Vulkan 1.0)">(VK_QUEUE_SPARSE_BINDING_BIT)</span> |
| **Queue family #1** |
| [queueFlags](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkQueueFamilyProperties.html) |  |  |  |  |  | <span title="defined in VkQueueFamilyProperties (Vulkan 1.0)">(VK_QUEUE_TRANSFER_BIT)</span> | <span title="defined in VkQueueFamilyProperties (Vulkan 1.0)">(VK_QUEUE_TRANSFER_BIT)</span> | <span title="defined in VkQueueFamilyProperties (Vulkan 1.0)">(VK_QUEUE_TRANSFER_BIT)</span> | <span title="defined in VkQueueFamilyProperties (Vulkan 1.0)">(VK_QUEUE_TRANSFER_BIT)</span> |
| [timestampValidBits (bits)](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkQueueFamilyProperties.html) |  |  |  |  |  | <span title="defined in VkQueueFamilyProperties (Vulkan 1.0)">1</span> | <span title="defined in VkQueueFamilyProperties (Vulkan 1.0)">1</span> | <span title="defined in VkQueueFamilyProperties (Vulkan 1.0)">1</span> | <span title="defined in VkQueueFamilyProperties (Vulkan 1.0)">1</span> |

## Vulkan Profile Formats

> **NOTE**: The table below only contains formats and properties explicitly defined by the corresponding profile. Further formats and properties may be supported by the profiles in accordance to the requirements defined in the "Required Format Support" section of the appropriate version of the Vulkan API Specification.

* "valueWithRegularFont" indicates that the format property is defined in the profile (hover over the value to view the structure and corresponding extension or core API version where the format property is defined in the profile)
* "_valueWithItalicFont_" indicates that the format property is not defined in the profile but an equivalent format property is (hover over the symbol to view the structure and corresponding extension or core API version where the format property is defined in the profile)
* "-" indicates that neither the format property nor an equivalent format property is defined in the profile
* Empty cells next to the properties of a particular format definition section indicate that the profile does not have a corresponding format definition

| Profiles | VP_D3D12_FL_11_0_baseline | VP_D3D12_FL_11_1_baseline | VP_D3D12_FL_12_0_baseline | VP_D3D12_FL_12_0_optimal | VP_D3D12_FL_12_1_baseline | VP_D3D12_FL_12_2_baseline | VP_D3D12_FL_12_2_optimal | VP_D3D12_maximum_nv | VP_D3D12_maximum_radv |
|----------|---------------------------|---------------------------|---------------------------|--------------------------|---------------------------|---------------------------|--------------------------|---------------------|-----------------------|
| **VK_FORMAT_A2B10G10R10_UNORM_PACK32** |
| [bufferFeatures](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkFormatProperties3.html) |  |  |  |  |  | <span title="defined in VkFormatProperties (Vulkan 1.0)">(VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR)</span> | <span title="defined in VkFormatProperties (Vulkan 1.0)">(VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR)</span> | <span title="defined in VkFormatProperties (Vulkan 1.0)">(VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR)</span> | <span title="defined in VkFormatProperties (Vulkan 1.0)">(VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR)</span> |
| **VK_FORMAT_R16G16B16A16_SFLOAT** |
| [bufferFeatures](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkFormatProperties3.html) |  |  |  |  |  | <span title="defined in VkFormatProperties (Vulkan 1.0)">(VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR)</span> | <span title="defined in VkFormatProperties (Vulkan 1.0)">(VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR)</span> | <span title="defined in VkFormatProperties (Vulkan 1.0)">(VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR)</span> | <span title="defined in VkFormatProperties (Vulkan 1.0)">(VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR)</span> |
| **VK_FORMAT_R16G16B16A16_SNORM** |
| [bufferFeatures](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkFormatProperties3.html) |  |  |  |  |  | <span title="defined in VkFormatProperties (Vulkan 1.0)">(VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR)</span> | <span title="defined in VkFormatProperties (Vulkan 1.0)">(VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR)</span> | <span title="defined in VkFormatProperties (Vulkan 1.0)">(VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR)</span> | <span title="defined in VkFormatProperties (Vulkan 1.0)">(VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR)</span> |
| **VK_FORMAT_R16G16B16A16_UNORM** |
| [bufferFeatures](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkFormatProperties3.html) |  |  |  |  |  | <span title="defined in VkFormatProperties (Vulkan 1.0)">(VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR)</span> | <span title="defined in VkFormatProperties (Vulkan 1.0)">(VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR)</span> | <span title="defined in VkFormatProperties (Vulkan 1.0)">(VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR)</span> | <span title="defined in VkFormatProperties (Vulkan 1.0)">(VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR)</span> |
| **VK_FORMAT_R16G16_SFLOAT** |
| [bufferFeatures](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkFormatProperties3.html) |  |  |  |  |  | <span title="defined in VkFormatProperties (Vulkan 1.0)">(VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR)</span> | <span title="defined in VkFormatProperties (Vulkan 1.0)">(VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR)</span> | <span title="defined in VkFormatProperties (Vulkan 1.0)">(VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR)</span> | <span title="defined in VkFormatProperties (Vulkan 1.0)">(VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR)</span> |
| **VK_FORMAT_R16G16_SNORM** |
| [bufferFeatures](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkFormatProperties3.html) |  |  |  |  |  | <span title="defined in VkFormatProperties (Vulkan 1.0)">(VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR)</span> | <span title="defined in VkFormatProperties (Vulkan 1.0)">(VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR)</span> | <span title="defined in VkFormatProperties (Vulkan 1.0)">(VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR)</span> | <span title="defined in VkFormatProperties (Vulkan 1.0)">(VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR)</span> |
| **VK_FORMAT_R16G16_UNORM** |
| [bufferFeatures](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkFormatProperties3.html) |  |  |  |  |  | <span title="defined in VkFormatProperties (Vulkan 1.0)">(VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR)</span> | <span title="defined in VkFormatProperties (Vulkan 1.0)">(VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR)</span> | <span title="defined in VkFormatProperties (Vulkan 1.0)">(VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR)</span> | <span title="defined in VkFormatProperties (Vulkan 1.0)">(VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR)</span> |
| **VK_FORMAT_R32G32B32_SFLOAT** |
| [bufferFeatures](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkFormatProperties3.html) |  |  |  |  |  | <span title="defined in VkFormatProperties (Vulkan 1.0)">(VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR)</span> | <span title="defined in VkFormatProperties (Vulkan 1.0)">(VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR)</span> | <span title="defined in VkFormatProperties (Vulkan 1.0)">(VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR)</span> | <span title="defined in VkFormatProperties (Vulkan 1.0)">(VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR)</span> |
| **VK_FORMAT_R32G32_SFLOAT** |
| [bufferFeatures](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkFormatProperties3.html) |  |  |  |  |  | <span title="defined in VkFormatProperties (Vulkan 1.0)">(VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR)</span> | <span title="defined in VkFormatProperties (Vulkan 1.0)">(VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR)</span> | <span title="defined in VkFormatProperties (Vulkan 1.0)">(VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR)</span> | <span title="defined in VkFormatProperties (Vulkan 1.0)">(VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR)</span> |
| **VK_FORMAT_R8G8B8A8_SNORM** |
| [bufferFeatures](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkFormatProperties3.html) |  |  |  |  |  | <span title="defined in VkFormatProperties (Vulkan 1.0)">(VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR)</span> | <span title="defined in VkFormatProperties (Vulkan 1.0)">(VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR)</span> | <span title="defined in VkFormatProperties (Vulkan 1.0)">(VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR)</span> | <span title="defined in VkFormatProperties (Vulkan 1.0)">(VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR)</span> |
| **VK_FORMAT_R8G8B8A8_UNORM** |
| [bufferFeatures](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkFormatProperties3.html) |  |  |  |  |  | <span title="defined in VkFormatProperties (Vulkan 1.0)">(VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR)</span> | <span title="defined in VkFormatProperties (Vulkan 1.0)">(VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR)</span> | <span title="defined in VkFormatProperties (Vulkan 1.0)">(VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR)</span> | <span title="defined in VkFormatProperties (Vulkan 1.0)">(VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR)</span> |
| **VK_FORMAT_R8G8_SNORM** |
| [bufferFeatures](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkFormatProperties3.html) |  |  |  |  |  | <span title="defined in VkFormatProperties (Vulkan 1.0)">(VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR)</span> | <span title="defined in VkFormatProperties (Vulkan 1.0)">(VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR)</span> | <span title="defined in VkFormatProperties (Vulkan 1.0)">(VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR)</span> | <span title="defined in VkFormatProperties (Vulkan 1.0)">(VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR)</span> |
| **VK_FORMAT_R8G8_UNORM** |
| [bufferFeatures](https://www.khronos.org/registry/vulkan/specs/1.1-extensions/man/html/VkFormatProperties3.html) |  |  |  |  |  | <span title="defined in VkFormatProperties (Vulkan 1.0)">(VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR)</span> | <span title="defined in VkFormatProperties (Vulkan 1.0)">(VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR)</span> | <span title="defined in VkFormatProperties (Vulkan 1.0)">(VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR)</span> | <span title="defined in VkFormatProperties (Vulkan 1.0)">(VK_FORMAT_FEATURE_ACCELERATION_STRUCTURE_VERTEX_BUFFER_BIT_KHR)</span> |
