/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.logging.HeaderWarning;
import org.elasticsearch.http.HttpPipelinedRequest;
import org.elasticsearch.http.HttpPreRequest;
import org.elasticsearch.http.HttpRequest;
import org.elasticsearch.http.netty4.Netty4HttpRequest;
import org.elasticsearch.http.nio.NioHttpRequest;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.FilterRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestRequestFilter;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.support.SecondaryAuthentication;
import org.elasticsearch.xpack.security.audit.AuditTrailService;
import org.elasticsearch.xpack.security.authc.AuthenticationService;
import org.elasticsearch.xpack.security.authc.support.SecondaryAuthenticator;

public class SecurityRestFilter
extends FilterRestHandler
implements RestHandler {
    private static final Logger logger = LogManager.getLogger(SecurityRestFilter.class);
    private final AuthenticationService authenticationService;
    private final SecondaryAuthenticator secondaryAuthenticator;
    private final XPackLicenseState licenseState;
    private final AuditTrailService auditTrailService;

    public SecurityRestFilter(XPackLicenseState licenseState, AuthenticationService authenticationService, SecondaryAuthenticator secondaryAuthenticator, AuditTrailService auditTrailService, RestHandler restHandler) {
        super(restHandler);
        this.licenseState = licenseState;
        this.authenticationService = authenticationService;
        this.secondaryAuthenticator = secondaryAuthenticator;
        this.auditTrailService = auditTrailService;
    }

    public void handleRequest(RestRequest request, RestChannel channel, NodeClient client) throws Exception {
        if (this.licenseState.isSecurityEnabled() && request.method() != RestRequest.Method.OPTIONS) {
            String requestUri = request.uri();
            RestRequest wrappedRequest = this.maybeWrapRestRequest(request);
            this.authenticateOnlyNioHttpRequests(wrappedRequest.getHttpRequest(), (ActionListener<Void>)ActionListener.wrap(ignored -> {
                this.auditTrailService.get().authenticationSuccess(wrappedRequest);
                this.secondaryAuthenticator.authenticateAndAttachToContext(wrappedRequest, (ActionListener<SecondaryAuthentication>)ActionListener.wrap(secondaryAuthentication -> {
                    if (secondaryAuthentication != null) {
                        logger.trace("Found secondary authentication {} in REST request [{}]", secondaryAuthentication, (Object)requestUri);
                    }
                    this.getDelegate().handleRequest(request, channel, client);
                }, e -> this.handleException("Secondary authentication", request, channel, (Exception)e)));
            }, e -> this.handleException("Authentication", request, channel, (Exception)e)));
        } else {
            if (this.licenseState.isSecurityEnabled()) {
                this.handleException("Options with body", request, channel, (Exception)((Object)new ElasticsearchSecurityException("Cannot dispatch OPTIONS request, as they are not authenticated", new Object[0])));
                return;
            }
            if (request.method() != RestRequest.Method.OPTIONS) {
                HeaderWarning.addWarning((String)("Elasticsearch built-in security features are not enabled. Without authentication, your cluster could be accessible to anyone. See https://www.elastic.co/guide/en/elasticsearch/reference/" + Version.CURRENT.major + "." + Version.CURRENT.minor + "/security-minimal-setup.html to enable security."), (Object[])new Object[0]);
            }
            this.getDelegate().handleRequest(request, channel, client);
        }
    }

    private void authenticateOnlyNioHttpRequests(HttpRequest request, ActionListener<Void> listener) {
        if (request instanceof HttpPipelinedRequest) {
            request = ((HttpPipelinedRequest)request).getDelegateRequest();
        }
        if (request instanceof NioHttpRequest) {
            this.authenticationService.authenticate((HttpPreRequest)request, (ActionListener<Authentication>)ActionListener.wrap(ignored -> listener.onResponse(null), arg_0 -> listener.onFailure(arg_0)));
        } else {
            assert (request instanceof Netty4HttpRequest);
            listener.onResponse(null);
        }
    }

    private void handleException(String actionType, RestRequest request, RestChannel channel, Exception e) {
        logger.debug((Message)new ParameterizedMessage("{} failed for REST request [{}]", (Object)actionType, (Object)request.uri()), (Throwable)e);
        try {
            channel.sendResponse((RestResponse)new BytesRestResponse(channel, e));
        }
        catch (Exception inner) {
            inner.addSuppressed(e);
            logger.error(() -> new ParameterizedMessage("failed to send failure response for uri [{}]", (Object)request.uri()), (Throwable)inner);
        }
    }

    private RestRequest maybeWrapRestRequest(RestRequest restRequest) throws IOException {
        RestHandler handler = this.getConcreteRestHandler();
        if (handler instanceof RestRequestFilter) {
            return ((RestRequestFilter)handler).getFilteredRequest(restRequest);
        }
        return restRequest;
    }
}

