/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.deprecation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.action.support.ThreadedActionListener;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.OriginSettingClient;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.deprecation.DeprecationIssue;
import org.elasticsearch.xpack.deprecation.CcrAutoFollowedSystemIndicesChecker;
import org.elasticsearch.xpack.deprecation.DeprecationChecker;
import org.elasticsearch.xpack.deprecation.DeprecationChecks;
import org.elasticsearch.xpack.deprecation.DeprecationInfoAction;
import org.elasticsearch.xpack.deprecation.MlDeprecationChecker;
import org.elasticsearch.xpack.deprecation.NodesDeprecationCheckAction;
import org.elasticsearch.xpack.deprecation.NodesDeprecationCheckRequest;
import org.elasticsearch.xpack.deprecation.TransformDeprecationChecker;

public class TransportDeprecationInfoAction
extends TransportMasterNodeReadAction<DeprecationInfoAction.Request, DeprecationInfoAction.Response> {
    private static final List<DeprecationChecker> PLUGIN_CHECKERS = Arrays.asList(new MlDeprecationChecker(), new CcrAutoFollowedSystemIndicesChecker(), new TransformDeprecationChecker());
    private static final Logger logger = LogManager.getLogger(TransportDeprecationInfoAction.class);
    private final NodeClient client;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final Settings settings;
    private final NamedXContentRegistry xContentRegistry;
    private volatile List<String> skipTheseDeprecations;

    @Inject
    public TransportDeprecationInfoAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, NodeClient client, NamedXContentRegistry xContentRegistry) {
        super("cluster:admin/xpack/deprecation/info", transportService, clusterService, threadPool, actionFilters, DeprecationInfoAction.Request::new, indexNameExpressionResolver, DeprecationInfoAction.Response::new, "generic");
        this.client = client;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.settings = settings;
        this.xContentRegistry = xContentRegistry;
        this.skipTheseDeprecations = (List)DeprecationChecks.SKIP_DEPRECATIONS_SETTING.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(DeprecationChecks.SKIP_DEPRECATIONS_SETTING, this::setSkipDeprecations);
    }

    private <T> void setSkipDeprecations(List<String> skipDeprecations) {
        this.skipTheseDeprecations = Collections.unmodifiableList(skipDeprecations);
    }

    protected ClusterBlockException checkBlock(DeprecationInfoAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    protected final void masterOperation(DeprecationInfoAction.Request request, ClusterState state, ActionListener<DeprecationInfoAction.Response> listener) {
        NodesDeprecationCheckRequest nodeDepReq = new NodesDeprecationCheckRequest("_all");
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"deprecation", (ActionType)NodesDeprecationCheckAction.INSTANCE, (ActionRequest)nodeDepReq, (ActionListener)ActionListener.wrap(response -> {
            if (response.hasFailures()) {
                List failedNodeIds = response.failures().stream().map(failure -> failure.nodeId() + ": " + failure.getMessage()).collect(Collectors.toList());
                logger.warn("nodes failed to run deprecation checks: {}", failedNodeIds);
                for (FailedNodeException failure2 : response.failures()) {
                    logger.debug("node {} failed to run deprecation checks: {}", (Object)failure2.nodeId(), (Object)failure2);
                }
            }
            DeprecationChecker.Components components = new DeprecationChecker.Components(this.xContentRegistry, this.settings, new OriginSettingClient((Client)this.client, "deprecation", true), state);
            TransportDeprecationInfoAction.pluginSettingIssues(PLUGIN_CHECKERS, components, (ActionListener<Map<String, List<DeprecationIssue>>>)new ThreadedActionListener(logger, this.client.threadPool(), "generic", listener.map(deprecationIssues -> DeprecationInfoAction.Response.from(state, this.indexNameExpressionResolver, request, response, DeprecationChecks.INDEX_SETTINGS_CHECKS, DeprecationChecks.CLUSTER_SETTINGS_CHECKS, deprecationIssues, this.skipTheseDeprecations)), false));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    static void pluginSettingIssues(List<DeprecationChecker> checkers, DeprecationChecker.Components components, ActionListener<Map<String, List<DeprecationIssue>>> listener) {
        List enabledCheckers = checkers.stream().filter(c -> c.enabled(components.settings())).collect(Collectors.toList());
        if (enabledCheckers.isEmpty()) {
            listener.onResponse(Collections.emptyMap());
            return;
        }
        GroupedActionListener groupedActionListener = new GroupedActionListener(ActionListener.wrap(checkResults -> listener.onResponse(checkResults.stream().collect(Collectors.toMap(DeprecationChecker.CheckResult::getCheckerName, DeprecationChecker.CheckResult::getIssues))), arg_0 -> listener.onFailure(arg_0)), enabledCheckers.size());
        for (DeprecationChecker checker : checkers) {
            checker.check(components, (ActionListener<DeprecationChecker.CheckResult>)groupedActionListener);
        }
    }
}

