/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.plan.logical;

import java.util.Objects;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;

public class Filter
extends UnaryPlan {
    private final Expression condition;

    public Filter(Source source, LogicalPlan child, Expression condition) {
        super(source, child);
        this.condition = condition;
    }

    @Override
    protected NodeInfo<Filter> info() {
        return NodeInfo.create(this, Filter::new, this.child(), this.condition);
    }

    @Override
    public Filter replaceChild(LogicalPlan newChild) {
        return new Filter(this.source(), newChild, this.condition);
    }

    public Expression condition() {
        return this.condition;
    }

    @Override
    public boolean expressionsResolved() {
        return this.condition.resolved();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.condition, this.child());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Filter other = (Filter)obj;
        return Objects.equals(this.condition, other.condition) && Objects.equals(this.child(), other.child());
    }

    public Filter with(Expression conditionExpr) {
        return new Filter(this.source(), this.child(), conditionExpr);
    }

    public Filter with(LogicalPlan child, Expression conditionExpr) {
        return new Filter(this.source(), child, conditionExpr);
    }
}

