/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.text;

import java.io.StringWriter;
import java.util.Locale;

public class SizeLimitingStringWriter
extends StringWriter {
    private final int sizeLimit;

    public SizeLimitingStringWriter(int sizeLimit) {
        this.sizeLimit = sizeLimit;
    }

    private void checkSizeLimit(int additionalChars) {
        int bufLen = this.getBuffer().length();
        if (bufLen + additionalChars > this.sizeLimit) {
            String substring = this.getBuffer().substring(0, Math.min(bufLen, 20));
            throw new SizeLimitExceededException(String.format(Locale.ROOT, "String [%s...] has exceeded the size limit [%s]", substring, this.sizeLimit));
        }
    }

    @Override
    public void write(int c) {
        this.checkSizeLimit(1);
        super.write(c);
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        this.checkSizeLimit(len);
        super.write(cbuf, off, len);
    }

    @Override
    public void write(String str) {
        this.checkSizeLimit(str.length());
        super.write(str);
    }

    @Override
    public void write(String str, int off, int len) {
        this.checkSizeLimit(len);
        super.write(str, off, len);
    }

    public static class SizeLimitExceededException
    extends IllegalStateException {
        public SizeLimitExceededException(String message) {
            super(message);
        }
    }
}

