/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots.upgrade;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.StreamSupport;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.indices.ShardLimitValidator;
import org.elasticsearch.snapshots.SearchableSnapshotsSettings;
import org.elasticsearch.threadpool.ThreadPool;

public class SearchableSnapshotIndexMetadataUpgrader {
    private static final Logger logger = LogManager.getLogger(SearchableSnapshotIndexMetadataUpgrader.class);
    private final ClusterService clusterService;
    private final ThreadPool threadPool;
    private final AtomicBoolean upgraded = new AtomicBoolean();
    private final ClusterStateListener listener = this::clusterChanged;

    public SearchableSnapshotIndexMetadataUpgrader(ClusterService clusterService, ThreadPool threadPool) {
        this.clusterService = clusterService;
        this.threadPool = threadPool;
    }

    public void initialize() {
        this.clusterService.addListener(this.listener);
    }

    private void clusterChanged(ClusterChangedEvent event) {
        if (this.upgraded.get()) {
            return;
        }
        if (event.localNodeMaster() && event.state().nodes().getMinNodeVersion().onOrAfter(Version.V_7_13_0) && this.upgraded.compareAndSet(false, true)) {
            ExecutorService executor = this.threadPool.generic();
            executor.execute(() -> this.maybeUpgradeIndices(event.state()));
        }
    }

    private void maybeUpgradeIndices(ClusterState state) {
        if (SearchableSnapshotIndexMetadataUpgrader.needsUpgrade(state)) {
            logger.info((Object)"Upgrading partial searchable snapshots to use frozen shard limit group");
            this.clusterService.submitStateUpdateTask("searchable-snapshot-index-upgrader", (ClusterStateTaskConfig)new ClusterStateUpdateTask(){

                public ClusterState execute(ClusterState currentState) throws Exception {
                    return SearchableSnapshotIndexMetadataUpgrader.upgradeIndices(currentState);
                }

                public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                    SearchableSnapshotIndexMetadataUpgrader.this.clusterService.removeListener(SearchableSnapshotIndexMetadataUpgrader.this.listener);
                }

                public void onFailure(String source, Exception e) {
                    logger.warn((Object)"upgrading frozen indices to have frozen shard limit group failed, will retry on the next cluster state update", (Throwable)e);
                    SearchableSnapshotIndexMetadataUpgrader.this.upgraded.set(false);
                }
            });
        } else {
            this.clusterService.removeListener(this.listener);
        }
    }

    static boolean needsUpgrade(ClusterState state) {
        return StreamSupport.stream(state.metadata().spliterator(), false).filter(imd -> imd.getCreationVersion().onOrAfter(Version.V_7_12_0)).map(IndexMetadata::getSettings).filter(SearchableSnapshotsSettings::isPartialSearchableSnapshotIndex).anyMatch(SearchableSnapshotIndexMetadataUpgrader::notFrozenShardLimitGroup);
    }

    static ClusterState upgradeIndices(ClusterState currentState) {
        if (!SearchableSnapshotIndexMetadataUpgrader.needsUpgrade(currentState)) {
            return currentState;
        }
        Metadata.Builder builder = Metadata.builder((Metadata)currentState.metadata());
        StreamSupport.stream(currentState.metadata().spliterator(), false).filter(imd -> imd.getCreationVersion().onOrAfter(Version.V_7_12_0)).filter(imd -> SearchableSnapshotsSettings.isPartialSearchableSnapshotIndex((Settings)imd.getSettings()) && SearchableSnapshotIndexMetadataUpgrader.notFrozenShardLimitGroup(imd.getSettings())).map(SearchableSnapshotIndexMetadataUpgrader::setShardLimitGroupFrozen).forEach(imd -> builder.put(imd, true));
        return ClusterState.builder((ClusterState)currentState).metadata(builder).build();
    }

    private static boolean notFrozenShardLimitGroup(Settings settings) {
        return !"frozen".equals(ShardLimitValidator.INDEX_SETTING_SHARD_LIMIT_GROUP.get(settings));
    }

    private static IndexMetadata setShardLimitGroupFrozen(IndexMetadata indexMetadata) {
        return IndexMetadata.builder((IndexMetadata)indexMetadata).settings(Settings.builder().put(indexMetadata.getSettings()).put(ShardLimitValidator.INDEX_SETTING_SHARD_LIMIT_GROUP.getKey(), "frozen")).settingsVersion(indexMetadata.getSettingsVersion() + 1L).build();
    }
}

