/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ccr.client;

import java.util.Objects;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.xpack.core.ccr.action.CcrStatsAction;
import org.elasticsearch.xpack.core.ccr.action.DeleteAutoFollowPatternAction;
import org.elasticsearch.xpack.core.ccr.action.FollowStatsAction;
import org.elasticsearch.xpack.core.ccr.action.ForgetFollowerAction;
import org.elasticsearch.xpack.core.ccr.action.GetAutoFollowPatternAction;
import org.elasticsearch.xpack.core.ccr.action.PauseFollowAction;
import org.elasticsearch.xpack.core.ccr.action.PutAutoFollowPatternAction;
import org.elasticsearch.xpack.core.ccr.action.PutFollowAction;
import org.elasticsearch.xpack.core.ccr.action.ResumeFollowAction;
import org.elasticsearch.xpack.core.ccr.action.UnfollowAction;

public class CcrClient {
    private final ElasticsearchClient client;

    public CcrClient(ElasticsearchClient client) {
        this.client = Objects.requireNonNull(client, "client");
    }

    public void putFollow(PutFollowAction.Request request, ActionListener<PutFollowAction.Response> listener) {
        this.client.execute((ActionType)PutFollowAction.INSTANCE, (ActionRequest)request, listener);
    }

    public ActionFuture<PutFollowAction.Response> putFollow(PutFollowAction.Request request) {
        PlainActionFuture listener = PlainActionFuture.newFuture();
        this.client.execute((ActionType)PutFollowAction.INSTANCE, (ActionRequest)request, (ActionListener)listener);
        return listener;
    }

    public void resumeFollow(ResumeFollowAction.Request request, ActionListener<AcknowledgedResponse> listener) {
        this.client.execute((ActionType)ResumeFollowAction.INSTANCE, (ActionRequest)request, listener);
    }

    public ActionFuture<AcknowledgedResponse> resumeFollow(ResumeFollowAction.Request request) {
        PlainActionFuture listener = PlainActionFuture.newFuture();
        this.client.execute((ActionType)ResumeFollowAction.INSTANCE, (ActionRequest)request, (ActionListener)listener);
        return listener;
    }

    public void followStats(FollowStatsAction.StatsRequest request, ActionListener<FollowStatsAction.StatsResponses> listener) {
        this.client.execute((ActionType)FollowStatsAction.INSTANCE, (ActionRequest)request, listener);
    }

    public ActionFuture<FollowStatsAction.StatsResponses> followStats(FollowStatsAction.StatsRequest request) {
        PlainActionFuture listener = PlainActionFuture.newFuture();
        this.client.execute((ActionType)FollowStatsAction.INSTANCE, (ActionRequest)request, (ActionListener)listener);
        return listener;
    }

    public void stats(CcrStatsAction.Request request, ActionListener<CcrStatsAction.Response> listener) {
        this.client.execute((ActionType)CcrStatsAction.INSTANCE, (ActionRequest)request, listener);
    }

    public ActionFuture<CcrStatsAction.Response> stats(CcrStatsAction.Request request) {
        PlainActionFuture listener = PlainActionFuture.newFuture();
        this.stats(request, (ActionListener<CcrStatsAction.Response>)listener);
        return listener;
    }

    public void pauseFollow(PauseFollowAction.Request request, ActionListener<AcknowledgedResponse> listener) {
        this.client.execute((ActionType)PauseFollowAction.INSTANCE, (ActionRequest)request, listener);
    }

    public ActionFuture<AcknowledgedResponse> pauseFollow(PauseFollowAction.Request request) {
        PlainActionFuture listener = PlainActionFuture.newFuture();
        this.client.execute((ActionType)PauseFollowAction.INSTANCE, (ActionRequest)request, (ActionListener)listener);
        return listener;
    }

    public void unfollow(UnfollowAction.Request request, ActionListener<AcknowledgedResponse> listener) {
        this.client.execute((ActionType)UnfollowAction.INSTANCE, (ActionRequest)request, listener);
    }

    public ActionFuture<AcknowledgedResponse> unfollow(UnfollowAction.Request request) {
        PlainActionFuture listener = PlainActionFuture.newFuture();
        this.client.execute((ActionType)UnfollowAction.INSTANCE, (ActionRequest)request, (ActionListener)listener);
        return listener;
    }

    public void forgetFollower(ForgetFollowerAction.Request request, ActionListener<BroadcastResponse> listener) {
        this.client.execute((ActionType)ForgetFollowerAction.INSTANCE, (ActionRequest)request, listener);
    }

    public ActionFuture<BroadcastResponse> forgetFollower(ForgetFollowerAction.Request request) {
        PlainActionFuture listener = PlainActionFuture.newFuture();
        this.client.execute((ActionType)ForgetFollowerAction.INSTANCE, (ActionRequest)request, (ActionListener)listener);
        return listener;
    }

    public void putAutoFollowPattern(PutAutoFollowPatternAction.Request request, ActionListener<AcknowledgedResponse> listener) {
        this.client.execute((ActionType)PutAutoFollowPatternAction.INSTANCE, (ActionRequest)request, listener);
    }

    public ActionFuture<AcknowledgedResponse> putAutoFollowPattern(PutAutoFollowPatternAction.Request request) {
        PlainActionFuture listener = PlainActionFuture.newFuture();
        this.client.execute((ActionType)PutAutoFollowPatternAction.INSTANCE, (ActionRequest)request, (ActionListener)listener);
        return listener;
    }

    public void deleteAutoFollowPattern(DeleteAutoFollowPatternAction.Request request, ActionListener<AcknowledgedResponse> listener) {
        this.client.execute((ActionType)DeleteAutoFollowPatternAction.INSTANCE, (ActionRequest)request, listener);
    }

    public ActionFuture<AcknowledgedResponse> deleteAutoFollowPattern(DeleteAutoFollowPatternAction.Request request) {
        PlainActionFuture listener = PlainActionFuture.newFuture();
        this.client.execute((ActionType)DeleteAutoFollowPatternAction.INSTANCE, (ActionRequest)request, (ActionListener)listener);
        return listener;
    }

    public void getAutoFollowPattern(GetAutoFollowPatternAction.Request request, ActionListener<GetAutoFollowPatternAction.Response> listener) {
        this.client.execute((ActionType)GetAutoFollowPatternAction.INSTANCE, (ActionRequest)request, listener);
    }

    public ActionFuture<GetAutoFollowPatternAction.Response> getAutoFollowPattern(GetAutoFollowPatternAction.Request request) {
        PlainActionFuture listener = PlainActionFuture.newFuture();
        this.client.execute((ActionType)GetAutoFollowPatternAction.INSTANCE, (ActionRequest)request, (ActionListener)listener);
        return listener;
    }
}

