/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.annotations;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthAction;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.client.Requests;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.job.persistence.ElasticsearchMappings;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.template.TemplateUtils;

public class AnnotationIndex {
    public static final String READ_ALIAS_NAME = ".ml-annotations-read";
    public static final String WRITE_ALIAS_NAME = ".ml-annotations-write";
    public static final String INDEX_NAME = ".ml-annotations-6";
    private static final String MAPPINGS_VERSION_VARIABLE = "xpack.ml.version";
    private static final Version HIDDEN_INTRODUCED_VERSION = Version.V_7_7_0;

    public static void createAnnotationsIndexIfNecessaryAndWaitForYellow(Client client, ClusterState state, TimeValue masterNodeTimeout, ActionListener<Boolean> finalListener) {
        ActionListener annotationsIndexCreatedListener = ActionListener.wrap(success -> {
            ClusterHealthRequest request = (ClusterHealthRequest)Requests.clusterHealthRequest((String[])new String[]{READ_ALIAS_NAME}).waitForYellowStatus().masterNodeTimeout(masterNodeTimeout);
            ClientHelper.executeAsyncWithOrigin(client, "ml", ClusterHealthAction.INSTANCE, request, ActionListener.wrap(r -> finalListener.onResponse((Object)(!r.isTimedOut() ? 1 : 0)), arg_0 -> ((ActionListener)finalListener).onFailure(arg_0)));
        }, arg_0 -> finalListener.onFailure(arg_0));
        AnnotationIndex.createAnnotationsIndexIfNecessary(client, state, masterNodeTimeout, (ActionListener<Boolean>)annotationsIndexCreatedListener);
    }

    public static void createAnnotationsIndexIfNecessary(Client client, ClusterState state, TimeValue masterNodeTimeout, ActionListener<Boolean> finalListener) {
        boolean isHiddenAttributeAvailable = state.nodes().getMinNodeVersion().onOrAfter(HIDDEN_INTRODUCED_VERSION);
        ActionListener checkMappingsListener = ActionListener.wrap(success -> ElasticsearchMappings.addDocMappingIfMissing(WRITE_ALIAS_NAME, (CheckedFunction<String, String, IOException>)((CheckedFunction)AnnotationIndex::annotationsMapping), client, state, masterNodeTimeout, finalListener), arg_0 -> finalListener.onFailure(arg_0));
        ActionListener createAliasListener = ActionListener.wrap(currentIndexName -> {
            IndicesAliasesRequest.AliasActions addReadAliasAction = IndicesAliasesRequest.AliasActions.add().index(currentIndexName).alias(READ_ALIAS_NAME);
            IndicesAliasesRequest.AliasActions addWriteAliasAction = IndicesAliasesRequest.AliasActions.add().index(currentIndexName).alias(WRITE_ALIAS_NAME);
            if (isHiddenAttributeAvailable) {
                addReadAliasAction.isHidden(Boolean.valueOf(true));
                addWriteAliasAction.isHidden(Boolean.valueOf(true));
            }
            IndicesAliasesRequest request = (IndicesAliasesRequest)client.admin().indices().prepareAliases().addAliasAction(addReadAliasAction).addAliasAction(addWriteAliasAction).request();
            ClientHelper.executeAsyncWithOrigin(client.threadPool().getThreadContext(), "ml", request, ActionListener.wrap(r -> checkMappingsListener.onResponse((Object)r.isAcknowledged()), arg_0 -> ((ActionListener)finalListener).onFailure(arg_0)), (arg_0, arg_1) -> ((IndicesAdminClient)client.admin().indices()).aliases(arg_0, arg_1));
        }, arg_0 -> finalListener.onFailure(arg_0));
        MlMetadata mlMetadata = MlMetadata.getMlMetadata(state);
        SortedMap mlLookup = state.getMetadata().getIndicesLookup().tailMap(".ml");
        if (!mlMetadata.isResetMode() && !mlMetadata.isUpgradeMode() && !mlLookup.isEmpty() && mlLookup.firstKey().startsWith(".ml")) {
            IndexAbstraction currentIndexAbstraction = (IndexAbstraction)mlLookup.get(INDEX_NAME);
            if (currentIndexAbstraction == null) {
                Settings.Builder settingsBuilder = Settings.builder().put("index.auto_expand_replicas", "0-1").put("index.number_of_shards", "1");
                if (isHiddenAttributeAvailable) {
                    settingsBuilder.put("index.hidden", true);
                }
                CreateIndexRequest createIndexRequest = new CreateIndexRequest(INDEX_NAME).mapping("_doc", AnnotationIndex.annotationsMapping(), XContentType.JSON).settings(settingsBuilder);
                ClientHelper.executeAsyncWithOrigin(client.threadPool().getThreadContext(), "ml", createIndexRequest, ActionListener.wrap(r -> createAliasListener.onResponse((Object)INDEX_NAME), e -> {
                    if (ExceptionsHelper.unwrapCause(e) instanceof ResourceAlreadyExistsException) {
                        createAliasListener.onResponse((Object)INDEX_NAME);
                    } else {
                        finalListener.onFailure(e);
                    }
                }), (arg_0, arg_1) -> ((IndicesAdminClient)client.admin().indices()).create(arg_0, arg_1));
                return;
            }
            String currentIndexName2 = ((Index)currentIndexAbstraction.getIndices().get(0)).getName();
            IndexAbstraction writeAliasAbstraction = (IndexAbstraction)mlLookup.get(WRITE_ALIAS_NAME);
            if (!mlLookup.containsKey(READ_ALIAS_NAME) || writeAliasAbstraction == null) {
                createAliasListener.onResponse((Object)currentIndexName2);
                return;
            }
            List writeAliasIndices = writeAliasAbstraction.getIndices();
            if (writeAliasIndices.size() != 1 || !currentIndexName2.equals(((Index)writeAliasIndices.get(0)).getName())) {
                createAliasListener.onResponse((Object)currentIndexName2);
                return;
            }
            checkMappingsListener.onResponse((Object)false);
            return;
        }
        finalListener.onResponse((Object)false);
    }

    public static String annotationsMapping() {
        return AnnotationIndex.annotationsMapping("_doc");
    }

    private static String annotationsMapping(String mappingType) {
        return TemplateUtils.loadTemplate("/org/elasticsearch/xpack/core/ml/annotations_index_mappings.json", Version.CURRENT.toString(), MAPPINGS_VERSION_VARIABLE, Collections.singletonMap("xpack.ml.mapping_type", mappingType));
    }
}

