/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.rollup.action;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilities;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.MasterNodeOperationRequestBuilder;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.rollup.action.RollupActionRequestValidationException;
import org.elasticsearch.xpack.core.rollup.job.RollupJobConfig;

public class PutRollupJobAction
extends ActionType<AcknowledgedResponse> {
    public static final PutRollupJobAction INSTANCE = new PutRollupJobAction();
    public static final String NAME = "cluster:admin/xpack/rollup/put";

    private PutRollupJobAction() {
        super(NAME, AcknowledgedResponse::readFrom);
    }

    public static class RequestBuilder
    extends MasterNodeOperationRequestBuilder<Request, AcknowledgedResponse, RequestBuilder> {
        protected RequestBuilder(ElasticsearchClient client, PutRollupJobAction action) {
            super(client, (ActionType)action, (MasterNodeRequest)new Request());
        }
    }

    public static class Request
    extends AcknowledgedRequest<Request>
    implements IndicesRequest,
    ToXContentObject {
        private RollupJobConfig config;
        private IndicesOptions indicesOptions = IndicesOptions.fromOptions((boolean)false, (boolean)false, (boolean)true, (boolean)false);

        public Request(RollupJobConfig config) {
            this.config = config;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.config = new RollupJobConfig(in);
        }

        public Request() {
        }

        public static Request fromXContent(XContentParser parser, String id) throws IOException {
            return new Request(RollupJobConfig.fromXContent(parser, id));
        }

        public RollupJobConfig getConfig() {
            return this.config;
        }

        public void setConfig(RollupJobConfig config) {
            this.config = config;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.config.writeTo(out);
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public RollupActionRequestValidationException validateMappings(Map<String, Map<String, FieldCapabilities>> fieldCapsResponse) {
            RollupActionRequestValidationException validationException = new RollupActionRequestValidationException();
            if (fieldCapsResponse.size() == 0) {
                validationException.addValidationError("Could not find any fields in the index/index-pattern that were configured in job");
                return validationException;
            }
            this.config.validateMappings(fieldCapsResponse, validationException);
            if (validationException.validationErrors().size() > 0) {
                return validationException;
            }
            return null;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return this.config.toXContent(builder, params);
        }

        public String[] indices() {
            return new String[]{this.config.getIndexPattern()};
        }

        public IndicesOptions indicesOptions() {
            return this.indicesOptions;
        }

        public int hashCode() {
            return Objects.hash(this.config);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.config, other.config);
        }
    }
}

