/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid;

import java.io.IOException;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoTileUtils;
import org.elasticsearch.xpack.spatial.index.fielddata.GeoRelation;
import org.elasticsearch.xpack.spatial.index.fielddata.GeoShapeValues;
import org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid.GeoGridTiler;
import org.elasticsearch.xpack.spatial.search.aggregations.bucket.geogrid.GeoShapeCellValues;

abstract class AbstractGeoTileGridTiler
extends GeoGridTiler {
    protected final long tiles;

    AbstractGeoTileGridTiler(int precision) {
        super(precision);
        this.tiles = 1L << precision;
    }

    protected abstract boolean validTile(int var1, int var2, int var3);

    @Override
    public long encode(double x, double y) {
        return GeoTileUtils.longEncode((double)x, (double)y, (int)this.precision);
    }

    @Override
    public int setValues(GeoShapeCellValues values, GeoShapeValues.GeoShapeValue geoValue) throws IOException {
        int maxYTile;
        GeoShapeValues.BoundingBox bounds = geoValue.boundingBox();
        assert (bounds.minX() <= bounds.maxX());
        if (bounds.bottom > GeoTileUtils.NORMALIZED_LATITUDE_MASK || bounds.top < GeoTileUtils.NORMALIZED_NEGATIVE_LATITUDE_MASK) {
            return 0;
        }
        if (this.precision == 0) {
            return this.validTile(0, 0, 0) ? 1 : 0;
        }
        int minXTile = GeoTileUtils.getXTile((double)bounds.minX(), (long)this.tiles);
        int minYTile = GeoTileUtils.getYTile((double)bounds.maxY(), (long)this.tiles);
        int maxXTile = GeoTileUtils.getXTile((double)bounds.maxX(), (long)this.tiles);
        long count = (long)(maxXTile - minXTile + 1) * (long)((maxYTile = GeoTileUtils.getYTile((double)bounds.minY(), (long)this.tiles)) - minYTile + 1);
        if (count == 1L) {
            return this.setValue(values, minXTile, minYTile);
        }
        if (count <= (long)this.precision) {
            return this.setValuesByBruteForceScan(values, geoValue, minXTile, minYTile, maxXTile, maxYTile);
        }
        return this.setValuesByRasterization(0, 0, 0, values, 0, geoValue);
    }

    private GeoRelation relateTile(GeoShapeValues.GeoShapeValue geoValue, int xTile, int yTile, int precision) throws IOException {
        return this.validTile(xTile, yTile, precision) ? geoValue.relate(GeoTileUtils.toBoundingBox((int)xTile, (int)yTile, (int)precision)) : GeoRelation.QUERY_DISJOINT;
    }

    protected int setValue(GeoShapeCellValues docValues, int xTile, int yTile) {
        if (this.validTile(xTile, yTile, this.precision)) {
            docValues.resizeCell(1);
            docValues.add(0, GeoTileUtils.longEncodeTiles((int)this.precision, (long)xTile, (long)yTile));
            return 1;
        }
        return 0;
    }

    protected int setValuesByBruteForceScan(GeoShapeCellValues values, GeoShapeValues.GeoShapeValue geoValue, int minXTile, int minYTile, int maxXTile, int maxYTile) throws IOException {
        int idx = 0;
        for (int i = minXTile; i <= maxXTile; ++i) {
            for (int j = minYTile; j <= maxYTile; ++j) {
                GeoRelation relation = this.relateTile(geoValue, i, j, this.precision);
                if (relation == GeoRelation.QUERY_DISJOINT) continue;
                values.resizeCell(idx + 1);
                values.add(idx++, GeoTileUtils.longEncodeTiles((int)this.precision, (long)i, (long)j));
            }
        }
        return idx;
    }

    protected int setValuesByRasterization(int xTile, int yTile, int zTile, GeoShapeCellValues values, int valuesIndex, GeoShapeValues.GeoShapeValue geoValue) throws IOException {
        ++zTile;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                int nextX = 2 * xTile + i;
                int nextY = 2 * yTile + j;
                GeoRelation relation = this.relateTile(geoValue, nextX, nextY, zTile);
                if (GeoRelation.QUERY_INSIDE == relation) {
                    if (zTile == this.precision) {
                        values.resizeCell(this.getNewSize(valuesIndex, 1));
                        values.add(valuesIndex++, GeoTileUtils.longEncodeTiles((int)zTile, (long)nextX, (long)nextY));
                        continue;
                    }
                    int numTilesAtPrecision = this.getNumTilesAtPrecision(this.precision, zTile);
                    values.resizeCell(this.getNewSize(valuesIndex, numTilesAtPrecision + 1));
                    valuesIndex = this.setValuesForFullyContainedTile(nextX, nextY, zTile, values, valuesIndex);
                    continue;
                }
                if (GeoRelation.QUERY_CROSSES != relation) continue;
                if (zTile == this.precision) {
                    values.resizeCell(this.getNewSize(valuesIndex, 1));
                    values.add(valuesIndex++, GeoTileUtils.longEncodeTiles((int)zTile, (long)nextX, (long)nextY));
                    continue;
                }
                valuesIndex = this.setValuesByRasterization(nextX, nextY, zTile, values, valuesIndex, geoValue);
            }
        }
        return valuesIndex;
    }

    private int getNewSize(int valuesIndex, int increment) {
        long newSize = (long)valuesIndex + (long)increment;
        if (newSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Tile aggregation array overflow");
        }
        return (int)newSize;
    }

    private int getNumTilesAtPrecision(int finalPrecision, int currentPrecision) {
        long numTilesAtPrecision = Math.min(1L << 2 * (finalPrecision - currentPrecision), this.getMaxCells());
        if (numTilesAtPrecision > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Tile aggregation array overflow");
        }
        return (int)numTilesAtPrecision;
    }

    protected abstract int setValuesForFullyContainedTile(int var1, int var2, int var3, GeoShapeCellValues var4, int var5);
}

