﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/cognito-idp/model/AdminConfirmSignUpRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::CognitoIdentityProvider::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String AdminConfirmSignUpRequest::SerializePayload() const {
  JsonValue payload;

  if (m_userPoolIdHasBeenSet) {
    payload.WithString("UserPoolId", m_userPoolId);
  }

  if (m_usernameHasBeenSet) {
    payload.WithString("Username", m_username);
  }

  if (m_clientMetadataHasBeenSet) {
    JsonValue clientMetadataJsonMap;
    for (auto& clientMetadataItem : m_clientMetadata) {
      clientMetadataJsonMap.WithString(clientMetadataItem.first, clientMetadataItem.second);
    }
    payload.WithObject("ClientMetadata", std::move(clientMetadataJsonMap));
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection AdminConfirmSignUpRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "AWSCognitoIdentityProviderService.AdminConfirmSignUp"));
  return headers;
}
