/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.linalg;

import cern.colt.function.DoubleDoubleFunction;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.colt.matrix.linalg.Property;
import cern.jet.math.Functions;
import java.io.Serializable;

public class QRDecomposition
implements Serializable {
    static final long serialVersionUID = 1020L;
    private DoubleMatrix2D QR;
    private int m;
    private int n;
    private DoubleMatrix1D Rdiag;

    public QRDecomposition(DoubleMatrix2D doubleMatrix2D) {
        Property.DEFAULT.checkRectangular(doubleMatrix2D);
        Functions functions = Functions.functions;
        this.QR = doubleMatrix2D.copy();
        this.m = doubleMatrix2D.rows();
        this.n = doubleMatrix2D.columns();
        this.Rdiag = doubleMatrix2D.like1D(this.n);
        DoubleDoubleFunction doubleDoubleFunction = Algebra.hypotFunction();
        DoubleMatrix1D[] doubleMatrix1DArray = new DoubleMatrix1D[this.n];
        DoubleMatrix1D[] doubleMatrix1DArray2 = new DoubleMatrix1D[this.n];
        int n = 0;
        while (n < this.n) {
            doubleMatrix1DArray[n] = this.QR.viewColumn(n);
            doubleMatrix1DArray2[n] = this.QR.viewColumn(n).viewPart(n, this.m - n);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.n) {
            double d2 = 0.0;
            int n3 = n2;
            while (n3 < this.m) {
                d2 = Algebra.hypot(d2, this.QR.getQuick(n3, n2));
                ++n3;
            }
            if (d2 != 0.0) {
                if (this.QR.getQuick(n2, n2) < 0.0) {
                    d2 = -d2;
                }
                doubleMatrix1DArray2[n2].assign(Functions.div(d2));
                this.QR.setQuick(n2, n2, this.QR.getQuick(n2, n2) + 1.0);
                int n4 = n2 + 1;
                while (n4 < this.n) {
                    DoubleMatrix1D doubleMatrix1D = this.QR.viewColumn(n4).viewPart(n2, this.m - n2);
                    double d3 = doubleMatrix1DArray2[n2].zDotProduct(doubleMatrix1D);
                    d3 = -d3 / this.QR.getQuick(n2, n2);
                    int n5 = n2;
                    while (n5 < this.m) {
                        this.QR.setQuick(n5, n4, this.QR.getQuick(n5, n4) + d3 * this.QR.getQuick(n5, n2));
                        ++n5;
                    }
                    ++n4;
                }
            }
            this.Rdiag.setQuick(n2, -d2);
            ++n2;
        }
    }

    public DoubleMatrix2D getH() {
        return Algebra.DEFAULT.trapezoidalLower(this.QR.copy());
    }

    public DoubleMatrix2D getQ() {
        Functions functions = Functions.functions;
        DoubleMatrix2D doubleMatrix2D = this.QR.like();
        int n = this.n - 1;
        while (n >= 0) {
            DoubleMatrix1D doubleMatrix1D = this.QR.viewColumn(n).viewPart(n, this.m - n);
            doubleMatrix2D.setQuick(n, n, 1.0);
            int n2 = n;
            while (n2 < this.n) {
                if (this.QR.getQuick(n, n) != 0.0) {
                    DoubleMatrix1D doubleMatrix1D2 = doubleMatrix2D.viewColumn(n2).viewPart(n, this.m - n);
                    double d2 = doubleMatrix1D.zDotProduct(doubleMatrix1D2);
                    d2 = -d2 / this.QR.getQuick(n, n);
                    doubleMatrix1D2.assign(doubleMatrix1D, Functions.plusMult(d2));
                }
                ++n2;
            }
            --n;
        }
        return doubleMatrix2D;
    }

    public DoubleMatrix2D getR() {
        DoubleMatrix2D doubleMatrix2D = this.QR.like(this.n, this.n);
        int n = 0;
        while (n < this.n) {
            int n2 = 0;
            while (n2 < this.n) {
                if (n < n2) {
                    doubleMatrix2D.setQuick(n, n2, this.QR.getQuick(n, n2));
                } else if (n == n2) {
                    doubleMatrix2D.setQuick(n, n2, this.Rdiag.getQuick(n));
                } else {
                    doubleMatrix2D.setQuick(n, n2, 0.0);
                }
                ++n2;
            }
            ++n;
        }
        return doubleMatrix2D;
    }

    public boolean hasFullRank() {
        int n = 0;
        while (n < this.n) {
            if (this.Rdiag.getQuick(n) == 0.0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public DoubleMatrix2D solve(DoubleMatrix2D doubleMatrix2D) {
        int n;
        int n2;
        Functions functions = Functions.functions;
        if (doubleMatrix2D.rows() != this.m) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.hasFullRank()) {
            throw new IllegalArgumentException("Matrix is rank deficient.");
        }
        int n3 = doubleMatrix2D.columns();
        DoubleMatrix2D doubleMatrix2D2 = doubleMatrix2D.copy();
        int n4 = 0;
        while (n4 < this.n) {
            n2 = 0;
            while (n2 < n3) {
                double d2 = 0.0;
                n = n4;
                while (n < this.m) {
                    d2 += this.QR.getQuick(n, n4) * doubleMatrix2D2.getQuick(n, n2);
                    ++n;
                }
                d2 = -d2 / this.QR.getQuick(n4, n4);
                int n5 = n4;
                while (n5 < this.m) {
                    doubleMatrix2D2.setQuick(n5, n2, doubleMatrix2D2.getQuick(n5, n2) + d2 * this.QR.getQuick(n5, n4));
                    ++n5;
                }
                ++n2;
            }
            ++n4;
        }
        n2 = this.n - 1;
        while (n2 >= 0) {
            int n6 = 0;
            while (n6 < n3) {
                doubleMatrix2D2.setQuick(n2, n6, doubleMatrix2D2.getQuick(n2, n6) / this.Rdiag.getQuick(n2));
                ++n6;
            }
            int n7 = 0;
            while (n7 < n2) {
                n = 0;
                while (n < n3) {
                    doubleMatrix2D2.setQuick(n7, n, doubleMatrix2D2.getQuick(n7, n) - doubleMatrix2D2.getQuick(n2, n) * this.QR.getQuick(n7, n2));
                    ++n;
                }
                ++n7;
            }
            --n2;
        }
        return doubleMatrix2D2.viewPart(0, 0, this.n, n3);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "Illegal operation or error: ";
        stringBuffer.append("-----------------------------------------------------------------\n");
        stringBuffer.append("QRDecomposition(A) --> hasFullRank(A), H, Q, R, pseudo inverse(A)\n");
        stringBuffer.append("-----------------------------------------------------------------\n");
        stringBuffer.append("hasFullRank = ");
        try {
            stringBuffer.append(String.valueOf(this.hasFullRank()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\n\nH = ");
        try {
            stringBuffer.append(String.valueOf(this.getH()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\n\nQ = ");
        try {
            stringBuffer.append(String.valueOf(this.getQ()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\n\nR = ");
        try {
            stringBuffer.append(String.valueOf(this.getR()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\n\npseudo inverse(A) = ");
        try {
            stringBuffer.append(String.valueOf(this.solve(DoubleFactory2D.dense.identity(this.QR.rows()))));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        return stringBuffer.toString();
    }
}

