/*
 * Decompiled with CFR 0.152.
 */
package org.eso.cpl.test;

import java.io.File;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eso.cpl.Frame;
import org.eso.cpl.FrameGroup;
import org.eso.cpl.FrameLevel;
import org.eso.cpl.FrameList;
import org.eso.cpl.FrameType;

public class FrameListTest
extends TestCase {
    private Frame f1;
    private Frame f2;
    private Frame f3;
    private FrameList flist;

    public FrameListTest(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        this.f1 = new Frame(new File("f1.fits"));
        this.f2 = new Frame(new File("f2.fits"));
        this.f3 = new Frame(new File("f3.fits"));
        this.flist = new FrameList(new Frame[]{this.f1, this.f2, this.f3});
    }

    public void testEquality() {
        FrameList flb = new FrameList();
        FrameListTest.assertTrue(!this.flist.equals(flb));
        flb.add(this.f2);
        flb.add(0, this.f1);
        flb.add(new Frame(this.f3.getFile()));
        FrameListTest.assertEquals(this.flist, flb);
        this.f2.setLevel(FrameLevel.FINAL);
        FrameListTest.assertEquals(this.flist, flb);
        this.f3.setGroup(FrameGroup.PRODUCT);
        FrameListTest.assertTrue(!this.flist.equals(flb));
    }

    public void testSelections() {
        FrameListTest.assertEquals(0, this.flist.selectByGroup(FrameGroup.RAW).size());
        FrameListTest.assertEquals(0, this.flist.selectByLevel(FrameLevel.FINAL).size());
        FrameListTest.assertEquals(0, this.flist.selectByType(FrameType.IMAGE).size());
        FrameListTest.assertEquals(0, this.flist.selectByTag("GutenTag").size());
        FrameListTest.assertEquals(0, this.flist.selectByTag("").size());
        FrameListTest.assertEquals(this.flist, this.flist.selectByGroup(null));
        FrameListTest.assertEquals(this.flist, this.flist.selectByLevel(null));
        FrameListTest.assertEquals(this.flist, this.flist.selectByType(null));
        FrameListTest.assertEquals(this.flist, this.flist.selectByTag(null));
        FrameList some = new FrameList();
        this.exerciseSelections(this.flist, some);
        some.add(this.f1);
        this.exerciseSelections(this.flist, some);
        some.add(this.f2);
        this.exerciseSelections(this.flist, some);
        some.add(this.f3);
    }

    private void exerciseSelections(FrameList all, FrameList some) {
        for (Frame frm : some) {
            frm.setGroup(FrameGroup.RAW);
            frm.setLevel(FrameLevel.FINAL);
            frm.setType(FrameType.IMAGE);
            frm.setTag("GutenTag");
        }
        FrameListTest.assertEquals(some, all.selectByGroup(FrameGroup.RAW));
        FrameListTest.assertEquals(some, all.selectByLevel(FrameLevel.FINAL));
        FrameListTest.assertEquals(some, all.selectByType(FrameType.IMAGE));
        FrameListTest.assertEquals(some, all.selectByTag("GutenTag"));
    }

    public static TestSuite suite() {
        return new TestSuite(FrameListTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run(FrameListTest.suite());
    }
}

