/*
 * Decompiled with CFR 0.152.
 */
package org.eso.dfs.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;

public class UpgradingObjectInputStream
extends ObjectInputStream {
    private String oldPackage;
    private String newPackage;

    public UpgradingObjectInputStream(InputStream in, String oldpkg, String newpkg) throws IOException {
        super(in);
        this.oldPackage = oldpkg;
        this.newPackage = newpkg;
    }

    public UpgradingObjectInputStream() throws IOException, SecurityException {
    }

    @Override
    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        ObjectStreamClass osc = super.readClassDescriptor();
        if (this.oldPackage != null && this.newPackage != null && osc.getName().startsWith(this.oldPackage) && !osc.getName().startsWith(this.newPackage)) {
            String className = osc.getName().substring(this.oldPackage.length());
            System.out.println("Upgrading: " + osc.getName() + " to " + this.newPackage + className);
            osc = ObjectStreamClass.lookup(Class.forName(this.newPackage + className));
        }
        return osc;
    }

    public String getNewPackage() {
        return this.newPackage;
    }

    public String getOldPackage() {
        return this.oldPackage;
    }

    public void setNewPackage(String newPackage) {
        this.newPackage = newPackage;
    }

    public void setOldPackage(String oldPackage) {
        this.oldPackage = oldPackage;
    }
}

