/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.datamodel;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.eso.gasgano.properties.GasProp;
import org.eso.gasgano.properties.PropertyDB;

public class OBStatusDictionary
extends Hashtable {
    private Hashtable statusMapping = null;
    private Hashtable obDictionary = null;
    private String errorMessage = null;

    public static void main(String[] args) {
        String server = null;
        String user = null;
        String password = null;
        String progId1 = null;
        String progId2 = null;
        try {
            server = args[0];
            user = args[1];
            password = args[2];
            progId1 = args[3];
            progId2 = args[4];
        }
        catch (IndexOutOfBoundsException e2) {
            System.out.println("usage: server user pw progId1 progId2");
            System.out.println("     : server: jdbc:sybase:Tds:serv14.hq.eso.org:2025");
            System.out.println("     : progId: 58.B-0689\\(A\\)");
            System.exit(0);
        }
        OBStatusDictionary obMap = new OBStatusDictionary();
        System.err.println(obMap.convertProgId("60.A-9011(A)"));
        Vector<String> progs = new Vector<String>();
        progs.addElement(progId1);
        progs.addElement(progId2);
        if (!obMap.fillFromDatabase(server, user, password, "obrep..obs_blocks", "status", "run_id", "id", progs)) {
            System.out.println("Error: " + obMap.getErrorMessage());
        }
        Enumeration e3 = obMap.elements();
        int i = 0;
        while (e3.hasMoreElements()) {
            System.out.print((String)e3.nextElement() + " ");
            ++i;
        }
        System.out.println("\nFound: " + i + " entries.");
    }

    public OBStatusDictionary() {
        this.init();
    }

    private void init() {
        Vector values = GasProp.getProperties().obsStatus;
        Vector meanings = GasProp.getProperties().obsStatusMeaning;
        this.obDictionary = new Hashtable();
        this.statusMapping = new Hashtable();
        for (int i = 0; i < values.size(); ++i) {
            this.statusMapping.put(values.elementAt(i), meanings.elementAt(i));
        }
    }

    public boolean fillFromDatabase(String serverUrl, String user, String password, String dbTable, String dbStatusField, String dbPidField, String dbObIdField, Vector progIds) {
        boolean rc = true;
        try {
            Connection con = null;
            Statement stmt = null;
            Class.forName("com.sybase.jdbc.SybDriver");
            Properties props = new Properties();
            props.put("user", user);
            props.put("password", password);
            con = DriverManager.getConnection(serverUrl, props);
            stmt = con.createStatement();
            try {
                ResultSet rs = null;
                String query = this.buildSelectStatement(dbTable, dbStatusField, dbPidField, dbObIdField, progIds);
                if (query != null && PropertyDB.getInstance().isDebug(8)) {
                    System.out.println("Ex: " + query);
                }
                boolean results = stmt.execute(query);
                boolean rsnum = false;
                boolean rowsAffected = false;
                do {
                    if (!results) continue;
                    rs = stmt.getResultSet();
                    int rowNum = 1;
                    while (rs.next()) {
                        this.put(rs.getString(2), rs.getString(1));
                        ++rowNum;
                    }
                } while (results = stmt.getMoreResults());
                stmt.close();
                con.close();
            }
            catch (SQLException sqe) {
                this.errorMessage = new String(sqe.toString() + ", sqlstate = " + sqe.getSQLState());
                rc = false;
                stmt.cancel();
            }
        }
        catch (Exception e2) {
            this.errorMessage = e2.toString();
            rc = false;
        }
        return rc;
    }

    private String buildSelectStatement(String dbTable, String dbStatusField, String dbPidField, String dbObIdField, Vector progs) {
        StringBuffer rc = new StringBuffer("select " + dbStatusField + ", " + dbObIdField + " from " + dbTable);
        if (progs != null && progs.size() > 0) {
            Enumeration e2 = progs.elements();
            boolean addOr = false;
            rc.append(" where ");
            while (e2.hasMoreElements()) {
                if (addOr) {
                    rc.append(" or ");
                } else {
                    addOr = true;
                }
                rc.append(dbPidField + " = " + this.convertProgId((String)e2.nextElement()) + " ");
            }
        }
        return rc.toString();
    }

    private String convertProgId(String progId) {
        String rc = null;
        try {
            int dotIndex = progId.indexOf(46);
            int braceIndex = progId.indexOf(40);
            int subpanel = progId.charAt(braceIndex + 1) - 65;
            String start = progId.substring(0, dotIndex);
            String proposalId = progId.substring(dotIndex + 3, dotIndex + 7);
            if (start.startsWith("1") || start.startsWith("2")) {
                start = progId.substring(1, dotIndex);
            }
            rc = new String(start + proposalId + "0" + String.valueOf(subpanel));
        }
        catch (StringIndexOutOfBoundsException siobe) {
            System.err.println("Malformed Prog ID " + progId);
            rc = new String("00000");
        }
        return rc;
    }

    public String getStatusDescription(String status) {
        return (String)this.statusMapping.get(new Character(status.charAt(0)));
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

