/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.datamodel.gui;

import gnu.regexp.RE;
import gnu.regexp.REException;
import gnu.regexp.REMatch;
import gnu.regexp.RESyntax;
import java.awt.Font;
import java.io.File;
import java.util.Vector;
import javax.swing.JComponent;
import org.eso.gasgano.datamodel.DataModelChangeNotifier;
import org.eso.gasgano.datamodel.DataModelEvent;
import org.eso.gasgano.datamodel.FileDescription;
import org.eso.gasgano.datamodel.Observation;
import org.eso.gasgano.datamodel.ReductionBlockCommon;
import org.eso.gasgano.datamodel.filesystem.DFSDataModel;
import org.eso.gasgano.datamodel.filesystem.DFSFile;
import org.eso.gasgano.datamodel.gui.KeywordContainerOBComponent;
import org.eso.gasgano.properties.PropertyDB;

public abstract class OBComponent
extends DataModelChangeNotifier {
    private Observation[] obs = new Observation[3];
    protected String storeProgram = null;
    protected String storeObservation = null;
    protected String storeTelescope = null;
    private Vector associatedReductionBlocks = null;
    private static FileDescription descFactory = null;
    private static RESyntax theSyntax = new RESyntax(RESyntax.RE_SYNTAX_PERL5);
    private static String baseNamePure = "[^" + File.separator + "]*$";
    private static String baseNameWithDatum = "\\d{4}-\\d{2}-\\d{2}" + File.separator + "[^" + File.separator + "]*$";
    private static REMatch theMatch = null;
    public static RE baseNameRe = null;
    private static boolean shortenName = true;
    private boolean isPipelineProduct = false;
    private Font labelFont = null;

    public OBComponent() {
        if (baseNameRe == null) {
            try {
                baseNameRe = new RE(baseNamePure);
            }
            catch (REException ree) {
                shortenName = false;
            }
        }
    }

    public static void setShortName(boolean t) {
        shortenName = t;
    }

    public void setPipeProduct(boolean p) {
        this.isPipelineProduct = p;
    }

    public void addAssociatedReductionBlock(ReductionBlockCommon rb) {
        if (this.associatedReductionBlocks == null) {
            this.associatedReductionBlocks = new Vector();
        }
        boolean alreadyStored = false;
        for (int i = 0; i < this.associatedReductionBlocks.size(); ++i) {
            if (this.associatedReductionBlocks.elementAt(i) != rb) continue;
            alreadyStored = true;
            break;
        }
        if (!alreadyStored) {
            this.associatedReductionBlocks.addElement(rb);
        }
    }

    public void removeAssociatedReductionBlock(ReductionBlockCommon rb) {
        if (this.associatedReductionBlocks != null) {
            this.associatedReductionBlocks.removeElement(rb);
        }
    }

    public Vector getAssociatedReductionBlocks() {
        return this.associatedReductionBlocks;
    }

    public abstract int getStatus();

    public void setObservation(Observation o, int mode) {
        this.obs[mode] = o;
    }

    public Observation getObservation(int mode) {
        return this.obs[mode];
    }

    public boolean isPipeProduct() {
        return this.isPipelineProduct;
    }

    public abstract DFSFile getSourceFile();

    public abstract int update();

    public abstract JComponent getDisplayComponent();

    public abstract JComponent getTreeCellComponent();

    public abstract String getId();

    public String toString() {
        String rc = null;
        rc = shortenName ? this.getId().substring(this.getId().lastIndexOf(File.separator) + 1) : this.getId();
        return rc;
    }

    public static void setDefaultFileDescription(FileDescription d2) {
        descFactory = d2;
    }

    public static FileDescription getDefaultFileDescription() {
        return descFactory;
    }

    public void cleanup() {
        this.setObservation(null, 2);
        this.setObservation(null, 1);
        this.setObservation(null, 0);
        this.fireDataModelChangeEvent(new DataModelEvent(0, this));
    }

    public void removeFromDataModel() {
        DFSDataModel dm = DFSDataModel.getDataModel();
        dm.removeObComponent(this);
    }

    public void setLabelFont(Font f) {
        this.labelFont = f;
    }

    public Font getLabelFont() {
        if (this.labelFont == null) {
            DFSDataModel dm = DFSDataModel.getDataModel();
            String fontString = PropertyDB.getInstance().getProperty("COMPONENT_FONT");
            String fontName = fontString.substring(0, fontString.indexOf(":", 0));
            String fontSize = fontString.substring(fontString.indexOf(":", 0) + 1, fontString.length());
            this.labelFont = new Font(fontName, 0, Integer.parseInt(fontSize));
        }
        return this.labelFont;
    }

    public String getIntermediateGrouping() {
        String rc = null;
        if (this instanceof KeywordContainerOBComponent) {
            rc = ((KeywordContainerOBComponent)this).getIntermediateGrouping();
        }
        return rc;
    }
}

