/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.StandardClassMetadata;
import org.springframework.core.type.StandardMethodMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardAnnotationMetadata
extends StandardClassMetadata
implements AnnotationMetadata {
    private final boolean nestedAnnotationsAsMap;

    public StandardAnnotationMetadata(Class<?> introspectedClass) {
        this(introspectedClass, false);
    }

    public StandardAnnotationMetadata(Class<?> introspectedClass, boolean nestedAnnotationsAsMap) {
        super(introspectedClass);
        this.nestedAnnotationsAsMap = nestedAnnotationsAsMap;
    }

    @Override
    public Set<String> getAnnotationTypes() {
        Annotation[] anns;
        LinkedHashSet<String> types = new LinkedHashSet<String>();
        for (Annotation ann : anns = this.getIntrospectedClass().getAnnotations()) {
            types.add(ann.annotationType().getName());
        }
        return types;
    }

    @Override
    public Set<String> getMetaAnnotationTypes(String annotationType) {
        Annotation[] anns;
        for (Annotation ann : anns = this.getIntrospectedClass().getAnnotations()) {
            Annotation[] metaAnns;
            if (!ann.annotationType().getName().equals(annotationType)) continue;
            LinkedHashSet<String> types = new LinkedHashSet<String>();
            for (Annotation metaAnn : metaAnns = ann.annotationType().getAnnotations()) {
                types.add(metaAnn.annotationType().getName());
                for (Annotation metaMetaAnn : metaAnn.annotationType().getAnnotations()) {
                    types.add(metaMetaAnn.annotationType().getName());
                }
            }
            return types;
        }
        return null;
    }

    @Override
    public boolean hasAnnotation(String annotationType) {
        Annotation[] anns;
        for (Annotation ann : anns = this.getIntrospectedClass().getAnnotations()) {
            if (!ann.annotationType().getName().equals(annotationType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasMetaAnnotation(String annotationType) {
        Annotation[] anns;
        for (Annotation ann : anns = this.getIntrospectedClass().getAnnotations()) {
            Annotation[] metaAnns;
            for (Annotation metaAnn : metaAnns = ann.annotationType().getAnnotations()) {
                if (metaAnn.annotationType().getName().equals(annotationType)) {
                    return true;
                }
                for (Annotation metaMetaAnn : metaAnn.annotationType().getAnnotations()) {
                    if (!metaMetaAnn.annotationType().getName().equals(annotationType)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isAnnotated(String annotationType) {
        Annotation[] anns;
        for (Annotation ann : anns = this.getIntrospectedClass().getAnnotations()) {
            if (ann.annotationType().getName().equals(annotationType)) {
                return true;
            }
            for (Annotation metaAnn : ann.annotationType().getAnnotations()) {
                if (!metaAnn.annotationType().getName().equals(annotationType)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Map<String, Object> getAnnotationAttributes(String annotationType) {
        return this.getAnnotationAttributes(annotationType, false);
    }

    @Override
    public Map<String, Object> getAnnotationAttributes(String annotationType, boolean classValuesAsString) {
        Annotation[] anns;
        for (Annotation ann : anns = this.getIntrospectedClass().getAnnotations()) {
            if (!ann.annotationType().getName().equals(annotationType)) continue;
            return AnnotationUtils.getAnnotationAttributes(ann, classValuesAsString, this.nestedAnnotationsAsMap);
        }
        for (Annotation ann : anns) {
            for (Annotation metaAnn : ann.annotationType().getAnnotations()) {
                if (!metaAnn.annotationType().getName().equals(annotationType)) continue;
                return AnnotationUtils.getAnnotationAttributes(metaAnn, classValuesAsString, this.nestedAnnotationsAsMap);
            }
        }
        return null;
    }

    @Override
    public boolean hasAnnotatedMethods(String annotationType) {
        Method[] methods;
        for (Method method : methods = this.getIntrospectedClass().getDeclaredMethods()) {
            for (Annotation ann : method.getAnnotations()) {
                if (ann.annotationType().getName().equals(annotationType)) {
                    return true;
                }
                for (Annotation metaAnn : ann.annotationType().getAnnotations()) {
                    if (!metaAnn.annotationType().getName().equals(annotationType)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public Set<MethodMetadata> getAnnotatedMethods(String annotationType) {
        Method[] methods = this.getIntrospectedClass().getDeclaredMethods();
        LinkedHashSet<MethodMetadata> annotatedMethods = new LinkedHashSet<MethodMetadata>();
        block0: for (Method method : methods) {
            block1: for (Annotation ann : method.getAnnotations()) {
                if (ann.annotationType().getName().equals(annotationType)) {
                    annotatedMethods.add(new StandardMethodMetadata(method, this.nestedAnnotationsAsMap));
                    continue block0;
                }
                for (Annotation metaAnn : ann.annotationType().getAnnotations()) {
                    if (!metaAnn.annotationType().getName().equals(annotationType)) continue;
                    annotatedMethods.add(new StandardMethodMetadata(method, this.nestedAnnotationsAsMap));
                    continue block1;
                }
            }
        }
        return annotatedMethods;
    }
}

