// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: BUSL-1.1

//go:build !consulent

package resource

import (
	"google.golang.org/protobuf/proto"

	"github.com/hashicorp/consul/proto-public/pbresource"
)

type Registration struct {
	// Type is the GVK of the resource type.
	Type *pbresource.Type

	// Proto is the resource's protobuf message type.
	Proto proto.Message

	// ACLs are hooks called to perform authorization on RPCs.
	// The hooks can assume that Validate has been called.
	ACLs *ACLHooks

	// Validate is called to structurally validate the resource (e.g.
	// check for required fields). Validate can assume that Mutate
	// has been called.
	Validate ValidationHook

	// Mutate is called to fill out any autogenerated fields (e.g. UUIDs) or
	// apply defaults before validation. Mutate can assume that
	// Resource.ID is populated and has non-empty tenancy fields. This does
	// not mean those tenancy fields actually exist.
	Mutate MutationHook

	// Scope describes the tenancy scope of a resource.
	Scope Scope
}
