/*
 *  Copyright (C) 1999 Peter Amstutz
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of *the
 *  License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307 USA 
 */

#ifndef _TERRAIN_H_
#define _TERRAIN_H_

typedef struct TerrainSpans_ter
{
    int start;
    int height;
    double vy;
    struct TerrainSpans_ter *nextlower;
    struct TerrainSpans_ter *nexthigher;
}
TerrainSpans_ter;

#define MAXTERRAINSIZE 4000

#define TER_STARTPT(x) (x->start)
#define TER_ENDPT(x) (x->start + x->height)

extern int ter_table[9];
extern int ter_depth;
extern int ter_sizex, ter_sizey;
extern TerrainSpans_ter ter_data[MAXTERRAINSIZE];

void terGenerate(int x1, int y1, int x2, int y2, int depth,
		 int *terraintable, TerrainSpans_ter * output);
int terCheckPos(TerrainSpans_ter * ter, int x, int y);
int terGetHeight(TerrainSpans_ter * sp);
int terCheckSpan(TerrainSpans_ter * sp, int y, int h);
void terAddSpan(TerrainSpans_ter * sp, int s, int h);
void terDelSpan(TerrainSpans_ter * sp, int s, int h);
void terFreeCol(TerrainSpans_ter * sp);
void terClearCircle(int xo, int yo, int r);
void terAddCircle(int xo, int yo, int r);
int terCalcDirtFall();

#endif
