// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// SpoeAgent SPOE agent
//
// # SPOE agent configuration
//
// swagger:model spoe_agent
type SpoeAgent struct {
	// async
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	Async string `json:"async,omitempty"`

	// continue on error
	// Enum: ["enabled"]
	// +kubebuilder:validation:Enum=enabled;
	ContinueOnError string `json:"continue-on-error,omitempty"`

	// dontlog normal
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	DontlogNormal string `json:"dontlog-normal,omitempty"`

	// engine name
	EngineName string `json:"engine-name,omitempty"`

	// force set var
	// Enum: ["enabled"]
	// +kubebuilder:validation:Enum=enabled;
	ForceSetVar string `json:"force-set-var,omitempty"`

	// groups
	Groups string `json:"groups,omitempty"`

	// hello timeout
	HelloTimeout int64 `json:"hello_timeout,omitempty"`

	// idle timeout
	IdleTimeout int64 `json:"idle_timeout,omitempty"`

	// log
	Log LogTargets `json:"log,omitempty"`

	// max frame size
	MaxFrameSize int64 `json:"max-frame-size,omitempty"`

	// max waiting frames
	MaxWaitingFrames int64 `json:"max-waiting-frames,omitempty"`

	// maxconnrate
	Maxconnrate int64 `json:"maxconnrate,omitempty"`

	// maxerrrate
	Maxerrrate int64 `json:"maxerrrate,omitempty"`

	// messages
	Messages string `json:"messages,omitempty"`

	// name
	// Required: true
	Name *string `json:"name"`

	// option set on error
	// Pattern: ^[A-Za-z0-9-_.]+$
	// +kubebuilder:validation:Pattern=`^[A-Za-z0-9-_.]+$`
	OptionSetOnError string `json:"option_set-on-error,omitempty"`

	// option set process time
	// Pattern: ^[A-Za-z0-9-_.]+$
	// +kubebuilder:validation:Pattern=`^[A-Za-z0-9-_.]+$`
	OptionSetProcessTime string `json:"option_set-process-time,omitempty"`

	// option set total time
	// Pattern: ^[A-Za-z0-9-_.]+$
	// +kubebuilder:validation:Pattern=`^[A-Za-z0-9-_.]+$`
	OptionSetTotalTime string `json:"option_set-total-time,omitempty"`

	// option var prefix
	// Pattern: ^[A-Za-z0-9-_.]+$
	// +kubebuilder:validation:Pattern=`^[A-Za-z0-9-_.]+$`
	OptionVarPrefix string `json:"option_var-prefix,omitempty"`

	// pipelining
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	Pipelining string `json:"pipelining,omitempty"`

	// processing timeout
	ProcessingTimeout int64 `json:"processing_timeout,omitempty"`

	// register var names
	RegisterVarNames string `json:"register-var-names,omitempty"`

	// send frag payload
	// Enum: ["enabled","disabled"]
	// +kubebuilder:validation:Enum=enabled;disabled;
	SendFragPayload string `json:"send-frag-payload,omitempty"`

	// use backend
	UseBackend string `json:"use-backend,omitempty"`
}

// Validate validates this spoe agent
func (m *SpoeAgent) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAsync(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateContinueOnError(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDontlogNormal(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateForceSetVar(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLog(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOptionSetOnError(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOptionSetProcessTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOptionSetTotalTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOptionVarPrefix(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePipelining(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSendFragPayload(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var spoeAgentTypeAsyncPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		spoeAgentTypeAsyncPropEnum = append(spoeAgentTypeAsyncPropEnum, v)
	}
}

const (

	// SpoeAgentAsyncEnabled captures enum value "enabled"
	SpoeAgentAsyncEnabled string = "enabled"

	// SpoeAgentAsyncDisabled captures enum value "disabled"
	SpoeAgentAsyncDisabled string = "disabled"
)

// prop value enum
func (m *SpoeAgent) validateAsyncEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, spoeAgentTypeAsyncPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SpoeAgent) validateAsync(formats strfmt.Registry) error {
	if swag.IsZero(m.Async) { // not required
		return nil
	}

	// value enum
	if err := m.validateAsyncEnum("async", "body", m.Async); err != nil {
		return err
	}

	return nil
}

var spoeAgentTypeContinueOnErrorPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		spoeAgentTypeContinueOnErrorPropEnum = append(spoeAgentTypeContinueOnErrorPropEnum, v)
	}
}

const (

	// SpoeAgentContinueOnErrorEnabled captures enum value "enabled"
	SpoeAgentContinueOnErrorEnabled string = "enabled"
)

// prop value enum
func (m *SpoeAgent) validateContinueOnErrorEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, spoeAgentTypeContinueOnErrorPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SpoeAgent) validateContinueOnError(formats strfmt.Registry) error {
	if swag.IsZero(m.ContinueOnError) { // not required
		return nil
	}

	// value enum
	if err := m.validateContinueOnErrorEnum("continue-on-error", "body", m.ContinueOnError); err != nil {
		return err
	}

	return nil
}

var spoeAgentTypeDontlogNormalPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		spoeAgentTypeDontlogNormalPropEnum = append(spoeAgentTypeDontlogNormalPropEnum, v)
	}
}

const (

	// SpoeAgentDontlogNormalEnabled captures enum value "enabled"
	SpoeAgentDontlogNormalEnabled string = "enabled"

	// SpoeAgentDontlogNormalDisabled captures enum value "disabled"
	SpoeAgentDontlogNormalDisabled string = "disabled"
)

// prop value enum
func (m *SpoeAgent) validateDontlogNormalEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, spoeAgentTypeDontlogNormalPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SpoeAgent) validateDontlogNormal(formats strfmt.Registry) error {
	if swag.IsZero(m.DontlogNormal) { // not required
		return nil
	}

	// value enum
	if err := m.validateDontlogNormalEnum("dontlog-normal", "body", m.DontlogNormal); err != nil {
		return err
	}

	return nil
}

var spoeAgentTypeForceSetVarPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		spoeAgentTypeForceSetVarPropEnum = append(spoeAgentTypeForceSetVarPropEnum, v)
	}
}

const (

	// SpoeAgentForceSetVarEnabled captures enum value "enabled"
	SpoeAgentForceSetVarEnabled string = "enabled"
)

// prop value enum
func (m *SpoeAgent) validateForceSetVarEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, spoeAgentTypeForceSetVarPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SpoeAgent) validateForceSetVar(formats strfmt.Registry) error {
	if swag.IsZero(m.ForceSetVar) { // not required
		return nil
	}

	// value enum
	if err := m.validateForceSetVarEnum("force-set-var", "body", m.ForceSetVar); err != nil {
		return err
	}

	return nil
}

func (m *SpoeAgent) validateLog(formats strfmt.Registry) error {
	if swag.IsZero(m.Log) { // not required
		return nil
	}

	if err := m.Log.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("log")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("log")
		}
		return err
	}

	return nil
}

func (m *SpoeAgent) validateName(formats strfmt.Registry) error {

	if err := validate.Required("name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *SpoeAgent) validateOptionSetOnError(formats strfmt.Registry) error {
	if swag.IsZero(m.OptionSetOnError) { // not required
		return nil
	}

	if err := validate.Pattern("option_set-on-error", "body", m.OptionSetOnError, `^[A-Za-z0-9-_.]+$`); err != nil {
		return err
	}

	return nil
}

func (m *SpoeAgent) validateOptionSetProcessTime(formats strfmt.Registry) error {
	if swag.IsZero(m.OptionSetProcessTime) { // not required
		return nil
	}

	if err := validate.Pattern("option_set-process-time", "body", m.OptionSetProcessTime, `^[A-Za-z0-9-_.]+$`); err != nil {
		return err
	}

	return nil
}

func (m *SpoeAgent) validateOptionSetTotalTime(formats strfmt.Registry) error {
	if swag.IsZero(m.OptionSetTotalTime) { // not required
		return nil
	}

	if err := validate.Pattern("option_set-total-time", "body", m.OptionSetTotalTime, `^[A-Za-z0-9-_.]+$`); err != nil {
		return err
	}

	return nil
}

func (m *SpoeAgent) validateOptionVarPrefix(formats strfmt.Registry) error {
	if swag.IsZero(m.OptionVarPrefix) { // not required
		return nil
	}

	if err := validate.Pattern("option_var-prefix", "body", m.OptionVarPrefix, `^[A-Za-z0-9-_.]+$`); err != nil {
		return err
	}

	return nil
}

var spoeAgentTypePipeliningPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		spoeAgentTypePipeliningPropEnum = append(spoeAgentTypePipeliningPropEnum, v)
	}
}

const (

	// SpoeAgentPipeliningEnabled captures enum value "enabled"
	SpoeAgentPipeliningEnabled string = "enabled"

	// SpoeAgentPipeliningDisabled captures enum value "disabled"
	SpoeAgentPipeliningDisabled string = "disabled"
)

// prop value enum
func (m *SpoeAgent) validatePipeliningEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, spoeAgentTypePipeliningPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SpoeAgent) validatePipelining(formats strfmt.Registry) error {
	if swag.IsZero(m.Pipelining) { // not required
		return nil
	}

	// value enum
	if err := m.validatePipeliningEnum("pipelining", "body", m.Pipelining); err != nil {
		return err
	}

	return nil
}

var spoeAgentTypeSendFragPayloadPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		spoeAgentTypeSendFragPayloadPropEnum = append(spoeAgentTypeSendFragPayloadPropEnum, v)
	}
}

const (

	// SpoeAgentSendFragPayloadEnabled captures enum value "enabled"
	SpoeAgentSendFragPayloadEnabled string = "enabled"

	// SpoeAgentSendFragPayloadDisabled captures enum value "disabled"
	SpoeAgentSendFragPayloadDisabled string = "disabled"
)

// prop value enum
func (m *SpoeAgent) validateSendFragPayloadEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, spoeAgentTypeSendFragPayloadPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *SpoeAgent) validateSendFragPayload(formats strfmt.Registry) error {
	if swag.IsZero(m.SendFragPayload) { // not required
		return nil
	}

	// value enum
	if err := m.validateSendFragPayloadEnum("send-frag-payload", "body", m.SendFragPayload); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this spoe agent based on the context it is used
func (m *SpoeAgent) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLog(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SpoeAgent) contextValidateLog(ctx context.Context, formats strfmt.Registry) error {

	if err := m.Log.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("log")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("log")
		}
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SpoeAgent) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SpoeAgent) UnmarshalBinary(b []byte) error {
	var res SpoeAgent
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
